/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;

public final class InvocationPatternHelper {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final TraceComponent _tc = Tr.register(InvocationPatternHelper.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public static boolean isOneWayInvocation(MessageContext messageContext) {
        String string = InvocationPatternHelper.getMEP(messageContext);
        if (string != null && ("http://www.w3.org/2004/08/wsdl/out-only".equals(string) || "http://www.w3.org/2006/01/wsdl/out-only".equals(string))) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "One way invocation");
            }
            return true;
        }
        return false;
    }

    public static boolean isTwoWayInvocation(MessageContext messageContext) {
        String string = InvocationPatternHelper.getMEP(messageContext);
        if (string != null && ("http://www.w3.org/2004/08/wsdl/out-in".equals(string) || "http://www.w3.org/2006/01/wsdl/out-in".equals(string))) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Two way invocation");
            }
            return true;
        }
        return false;
    }

    public static String getMEP(MessageContext messageContext) {
        AxisOperation axisOperation;
        String string = null;
        if (messageContext.getAxisOperation() != null && (string = (axisOperation = messageContext.getAxisOperation()).getMessageExchangePattern()) != null && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "MEP : " + string);
        }
        return string;
    }

    public static boolean isTransportNonBlocking(MessageContext messageContext) {
        Object object = messageContext.getProperty("transportNonBlocking");
        if (object != null && ((Boolean)object).booleanValue()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "TransportNonBlocking is true");
            }
            return true;
        }
        return false;
    }

    public static boolean isAsyncRespSeparateChannel(MessageContext messageContext) {
        if (messageContext.getReplyTo() != null && messageContext.getReplyTo().getAddress() != null && messageContext.getReplyTo().getAddress().equals("http://www.w3.org/2005/08/addressing/none") && messageContext.getTo() != null && !messageContext.getTo().hasAnonymousAddress()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Async response over separate channel");
            }
            return true;
        }
        return false;
    }
}

