/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.common;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;

public final class ClassUtils {
    private static Hashtable classloaders = new Hashtable();
    private static HashMap loadClassMap = new HashMap();

    public static void setClassLoader(String string, ClassLoader classLoader) {
        if (string != null && classLoader != null) {
            classloaders.put(string, classLoader);
        }
    }

    public static ClassLoader getClassLoader(String string) {
        if (string == null) {
            return null;
        }
        return (ClassLoader)classloaders.get(string);
    }

    public static void removeClassLoader(String string) {
        classloaders.remove(string);
    }

    public static Class forName(String string) throws ClassNotFoundException {
        return ClassUtils.loadClass(string);
    }

    public static Class forName(final String string, final boolean bl, final ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Object object = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String string2 = JavaUtils.getLoadableClassName(string);
                        return Class.forName(string2, bl, classLoader);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.transport.common.ClassUtils.run", "159", this);
                        return throwable;
                    }
                }
            });
            if (object instanceof Class) {
                return (Class)object;
            }
            if (object instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)object;
            }
            throw new ClassNotFoundException(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.websvcs.transport.common.ClassUtils.forName", "173");
            return ClassUtils.loadClass(string);
        }
    }

    private static Class loadClass(final String string) throws ClassNotFoundException {
        Object object = null;
        try {
            object = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string2 = JavaUtils.getLoadableClassName(string);
                    ClassLoader classLoader = ClassUtils.getClassLoader(string2);
                    if (classLoader != null) {
                        try {
                            return Class.forName(string2, true, classLoader);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.websvcs.transport.common.ClassUtils.run", "222", this);
                        }
                    }
                    try {
                        return Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.websvcs.transport.common.ClassUtils.run", "233", this);
                        try {
                            return Class.forName(string2, true, ClassUtils.class.getClassLoader());
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            FFDCFilter.processException((Throwable)classNotFoundException2, "com.ibm.ws.websvcs.transport.common.ClassUtils.run", "258", this);
                            return classNotFoundException2;
                        }
                    }
                }
            });
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException(securityException, "com.ibm.ws.websvcs.transport.common.ClassUtils.loadClass", "268");
            throw new ClassNotFoundException(string);
        }
        if (object instanceof Class) {
            return (Class)object;
        }
        if (object instanceof ClassNotFoundException) {
            Class clazz = (Class)loadClassMap.get(string);
            if (clazz != null) {
                return clazz;
            }
            throw (ClassNotFoundException)object;
        }
        throw new ClassNotFoundException(string);
    }

    public static InputStream getResourceAsStream(Class clazz, String string) {
        InputStream inputStream = null;
        inputStream = clazz.getClassLoader() != null ? clazz.getClassLoader().getResourceAsStream(string) : ClassLoader.getSystemClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            inputStream = clazz.getResourceAsStream(string);
        }
        return inputStream;
    }

    public static URL getResource(Class clazz, String string) {
        URL uRL = null;
        uRL = clazz.getClassLoader() != null ? clazz.getClassLoader().getResource(string) : ClassLoader.getSystemClassLoader().getResource(string);
        if (uRL == null) {
            uRL = clazz.getResource(string);
        }
        return uRL;
    }

    static {
        loadClassMap.put("byte", Byte.TYPE);
        loadClassMap.put("int", Integer.TYPE);
        loadClassMap.put("short", Short.TYPE);
        loadClassMap.put("long", Long.TYPE);
        loadClassMap.put("float", Float.TYPE);
        loadClassMap.put("double", Double.TYPE);
        loadClassMap.put("boolean", Boolean.TYPE);
        loadClassMap.put("char", Character.TYPE);
        loadClassMap.put("void", Void.TYPE);
    }
}

