/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.channel.WSChannelConstants;
import com.ibm.ws.websvcs.transport.common.ClassUtils;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import com.ibm.ws.websvcs.transport.security.ConfigSSL;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.axis2.AxisFault;

public final class WSChannelManager {
    private static final TraceComponent _tc = Tr.register(WSChannelManager.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final String cfImplClass = "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl".intern();
    private static final String wbbpMgrImplClass = "com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl".intern();
    private static String tcpChannelFactoryName = "com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory";
    private static ChannelFramework cfS = null;
    private static WsByteBufferPoolManager wbbpMgr = null;
    private static WSChannelManager wMgr = null;
    private static Object o_RequestMapper = null;
    private static Object o_RequestFlowInfo = null;
    private static Method m_mapRequest = null;
    private static Method m_getClusterName = null;
    private static Method m_getVirtualHostName = null;
    private static Method m_getCellName = null;
    private static Method m_release = null;
    private static Class ac_UCFRoutingHelper = null;
    private static Method m_getHAClusterIdForDestinationEPR = null;
    private static Method m_getWLMClusterIdForDestinationEPR = null;
    private static Method m_getFragileClusterIdForDestinationEPR = null;
    private static Method m_isDestinationEPRFragile = null;
    private static Method m_getVirtualHostForDestinationEPR = null;
    private static boolean dwlmEnabled = true;
    public static int runtimeEnv = 3;

    private WSChannelManager() {
    }

    public static final synchronized WSChannelManager getInstance() {
        if (wMgr == null) {
            wMgr = new WSChannelManager();
        }
        return wMgr;
    }

    public int getRuntime() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getRuntime Runtime ENV : " + runtimeEnv);
        }
        return runtimeEnv;
    }

    public void setManagedRuntime(boolean bl) {
        if (bl) {
            runtimeEnv = 1;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setManagedRuntime Runtime ENV : " + runtimeEnv);
        }
    }

    public final void setChannelFramework(ChannelFrameworkService channelFrameworkService) {
        cfS = channelFrameworkService;
    }

    public final synchronized ChannelFramework getChannelFramework() throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (cfS == null) {
            cfS = (ChannelFramework)this.getRequiredService(cfImplClass);
        }
        return cfS;
    }

    public final void setWsByteBufferPoolManager(WsByteBufferPoolManager wsByteBufferPoolManager) {
        wbbpMgr = wsByteBufferPoolManager;
    }

    public final synchronized WsByteBufferPoolManager getWsByteBufferPoolManager() throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (wbbpMgr == null) {
            wbbpMgr = (WsByteBufferPoolManager)this.getRequiredService(wbbpMgrImplClass);
        }
        return wbbpMgr;
    }

    private Object getRequiredService(String string) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRequiredService() : " + string);
        }
        Object object = null;
        InitialContext initialContext = null;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Runtime ENV : " + runtimeEnv);
        }
        try {
            initialContext = new InitialContext();
            if (string == cfImplClass) {
                object = initialContext.lookup("services:websphere/ChannelFrameworkService");
            }
            if (string == wbbpMgrImplClass) {
                object = initialContext.lookup("services:websphere/WsByteBufferPoolManager");
            }
            if (object != null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found RequiredService in global namespace " + string + (object == null ? null : object.toString()));
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (object == null) {
            try {
                if (string == cfImplClass) {
                    object = initialContext.lookup("websphere/ChannelFrameworkService");
                }
                if (string == wbbpMgrImplClass) {
                    object = initialContext.lookup("websphere/WsByteBufferPoolManager");
                }
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.websvcs.transport.channel.WSChannelManager.getRequiredService", "344", this);
            }
            if (object != null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found RequiredService in local namespace " + string + (object == null ? null : object.toString()));
            }
        }
        if (object == null) {
            Class clazz;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "j2wLoadClass00 " + string);
            }
            if ((clazz = ClassUtils.forName(string)) != null) {
                Constructor constructor = null;
                try {
                    constructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws NoSuchMethodException {
                            return clazz.getConstructor(null);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.websvcs.transport.channel.WSChannelManager.getRequiredService", "399", this);
                    Tr.error(_tc, "getrequiredservice : ", privilegedActionException);
                    throw (NoSuchMethodException)privilegedActionException.getException();
                }
                object = constructor.newInstance(null);
            }
            if (object != null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "Created RequiredService " + string + (object == null ? null : object.toString()));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getRequiredService()");
        }
        return object;
    }

    private boolean createChannel(String string, boolean bl, ConfigSSL configSSL) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createChannel()...");
        }
        boolean bl2 = false;
        if (cfS.getChannel(string) == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "createChannel00 : " + string);
            }
            if (string.equals("httpclient-http-outbound")) {
                Class<?> clazz;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "doing HTTP_OUT class");
                }
                if ((clazz = Class.forName("com.ibm.ws.http.channel.outbound.impl.HttpOutboundChannelFactory")) != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using: " + clazz.toString());
                    }
                    cfS.addChannel("httpclient-http-outbound", clazz, null);
                    bl2 = true;
                }
            } else if (string.equals("httpclient-ssl-outbound")) {
                Class<?> clazz;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "doing SSL_OUT class");
                }
                if ((clazz = Class.forName(runtimeEnv == 3 ? "com.ibm.ws.ssl.channel.impl.SSLChannelFactory" : "com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory")) != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using: " + clazz.toString());
                    }
                    Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(configSSL);
                    cfS.addChannel("httpclient-ssl-outbound", clazz, hashtable);
                    bl2 = true;
                }
            } else if (string.equals("httpclient-tcp-outbound")) {
                Class<?> clazz = null;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "doing HTTP_TCP class");
                }
                try {
                    clazz = Class.forName(tcpChannelFactoryName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.websvcs.transport.channel.WSChannelManager.createChannel", "522", this);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "exception01 " + classNotFoundException.getLocalizedMessage());
                    }
                    tcpChannelFactoryName = "com.ibm.ws.tcp.channel.impl.TCPChannelFactory";
                    clazz = Class.forName(tcpChannelFactoryName);
                }
                if (clazz != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using: " + clazz.toString());
                    }
                    cfS.addChannel("httpclient-tcp-outbound", clazz, null);
                    bl2 = true;
                }
            }
        } else {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "createChannel01 " + string);
            }
            bl2 = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createChannel()...");
        }
        return bl2;
    }

    private void createChannelChain(String string, boolean bl, ConfigSSL configSSL) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createChannelChain()...");
        }
        if (cfS.getChain(string) == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "createChannelChain00 : " + string);
            }
            if (bl) {
                if (this.createChannel("httpclient-tcp-outbound", bl, configSSL) && this.createChannel("httpclient-ssl-outbound", bl, configSSL) && this.createChannel("httpclient-http-outbound", bl, configSSL)) {
                    cfS.addChain(string, FlowType.OUTBOUND, WSChannelConstants.HTTPS_CHAIN_ARRAY);
                }
            } else if (this.createChannel("httpclient-tcp-outbound", bl, configSSL) && this.createChannel("httpclient-http-outbound", bl, configSSL)) {
                cfS.addChain(string, FlowType.OUTBOUND, WSChannelConstants.HTTP_CHAIN_ARRAY);
            }
        } else if (_tc.isEventEnabled()) {
            Tr.event(_tc, "createChannelChain01 : " + string);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createChannelChain()...");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final VirtualConnectionFactory getVCFactory(WSAddress wSAddress) throws Exception {
        VirtualConnectionFactory virtualConnectionFactory;
        block15: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getVCFactory(): " + wSAddress.toString());
            }
            virtualConnectionFactory = null;
            try {
                CFEndPoint cFEndPoint;
                boolean bl = wSAddress.getSchema() == 2;
                ConfigSSL configSSL = null;
                if (bl) {
                    configSSL = (ConfigSSL)wSAddress.transportConfiguration();
                }
                if ((cFEndPoint = wSAddress.getCFEndPoint()) == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "CFEndPoint is null");
                    }
                    this.getChannelFramework();
                    if (cfS == null) {
                        Object[] objectArray = new Object[]{"null ChannelFramework Service"};
                        String string = NLSProvider.getNLS().getFormattedMessage("channelframework01", objectArray, "The following errors occurred on the channel framework service: {0}");
                        throw new AxisFault(string);
                    }
                    String string = wSAddress.keyValueforPool();
                    this.createChannelChain(string, bl, configSSL);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getVCFactory create channel done");
                    }
                    if ((virtualConnectionFactory = cfS.getOutboundVCFactory(string)) == null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "null VirtualConnectionFactory");
                        }
                        Object[] objectArray = new Object[]{"null VirtualConnectionFactory"};
                        String string2 = NLSProvider.getNLS().getFormattedMessage("channelframework01", objectArray, "The following errors occurred on the channel framework service: {0}");
                        throw new AxisFault(string2);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "VirtualConnectionFactory : " + virtualConnectionFactory.toString());
                    }
                    break block15;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "CFEndPoint : " + cFEndPoint.toString());
                }
                if (bl) {
                    String string = configSSL.configAliasProperty();
                    Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(configSSL);
                    virtualConnectionFactory = cFEndPoint.getOutboundVCFactory(hashtable, true);
                } else {
                    virtualConnectionFactory = cFEndPoint.getOutboundVCFactory();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.channel.WSChannelManager.getVCFactory", "740", this);
                Tr.error(_tc, "getVCFactory Exception: ", exception);
                throw exception;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getVCFactory(): " + wSAddress.toString());
        }
        return virtualConnectionFactory;
    }

    public final HTTPConnection getWSOutboundConnection(String string, WSAddress wSAddress, VirtualConnectionFactory virtualConnectionFactory) throws Exception {
        HTTPConnection hTTPConnection;
        block7: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getWSOutboundConnection(): " + wSAddress.toString());
            }
            hTTPConnection = null;
            try {
                OutboundVirtualConnection outboundVirtualConnection;
                if (virtualConnectionFactory != null) {
                    outboundVirtualConnection = (OutboundVirtualConnection)virtualConnectionFactory.createConnection();
                    if (outboundVirtualConnection == null) {
                        Object[] objectArray = new Object[]{"null OutboundVirtualConnection"};
                        String string2 = NLSProvider.getNLS().getFormattedMessage("channelframework01", objectArray, "The following errors occurred on the channel framework service: {0}");
                        throw new AxisFault(string2);
                    }
                } else {
                    Object[] objectArray = new Object[]{"null VirtualConnectionFactory"};
                    String string3 = NLSProvider.getNLS().getFormattedMessage("channelframework01", objectArray, "The following errors occurred on the channel framework service: {0}");
                    throw new AxisFault(string3);
                }
                hTTPConnection = new HTTPConnection(outboundVirtualConnection, wSAddress, string);
                int n = wSAddress.getSchema();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.channel.WSChannelManager.getWSOutboundConnection", "794", this);
                if (exception instanceof NamingException) break block7;
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.channel.WSChannelManager.getWSOutboundConnection", "840", this);
                throw exception;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getWSOutboundConnection(): " + wSAddress.toString());
        }
        return hTTPConnection;
    }
}

