/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.Config;
import com.ibm.ws.websvcs.transport.http.HttpChannelAddress;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.axis2.AxisFault;

public abstract class WSAddress
implements HttpAddress {
    protected int schemaType = 0;
    protected String keyforPool = null;
    protected CFEndPoint cfEndPt = null;
    protected Config cfg = null;
    protected static final String defaultOBChainName = "OutboundChain";
    protected int connTimeout = 180000;

    public abstract String keyValueforPool();

    public abstract int getPort();

    public abstract String getOutboundChainName();

    public String defaultOutboundChainName() {
        return defaultOBChainName;
    }

    public void setTransportConfiguration(Config config2) {
        this.cfg = config2;
    }

    public Config transportConfiguration() {
        return this.cfg;
    }

    public String getHostname() {
        return null;
    }

    public InetSocketAddress getLocalAddress() {
        return null;
    }

    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    public int getSchema() {
        return this.schemaType;
    }

    public String getSchemaInString() {
        String string = null;
        if (this.schemaType == 1) {
            string = "http";
        }
        if (this.schemaType == 2) {
            string = "https";
        }
        return string;
    }

    public int getConnectTimeout() {
        return this.connTimeout;
    }

    public abstract void setConnectTimeout(int var1);

    public CFEndPoint getCFEndPoint() {
        return this.cfEndPt;
    }

    public void setCFEndPoint(CFEndPoint cFEndPoint) {
        this.cfEndPt = cFEndPoint;
    }

    public boolean isInProcess() {
        return this.cfEndPt == null ? false : this.cfEndPt.isLocal();
    }

    public static WSAddress getAddress(URL uRL) throws URISyntaxException, AxisFault {
        if (uRL.getProtocol().compareToIgnoreCase("http") == 0 || uRL.getProtocol().compareToIgnoreCase("https") == 0) {
            return new HttpChannelAddress(uRL);
        }
        Object[] objectArray = new Object[]{uRL.getProtocol()};
        String string = NLSProvider.getNLS().getFormattedMessage("httpUnsupportedSchema", objectArray, "The following schema for HTTP is not supported: {0}");
        throw new AxisFault(string);
    }
}

