/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.channel.WSChannelManager;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.axis2.AxisFault;

public class OutboundConnectionGroup {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final TraceComponent _tc = Tr.register(OutboundConnectionGroup.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final Integer STATE_INVALID = new Integer(0);
    private static final Integer STATE_NOT_IN_USE = new Integer(1);
    private static final Integer STATE_IN_USE = new Integer(2);
    private static float ldFactor = 0.75f;
    private static int initSize = 131;
    private static WSChannelManager wMgr = null;
    private VirtualConnectionFactory vcf = null;
    private long idleTime = Long.getLong("com.ibm.websphere.webservices.http.connectionIdleTimeout", 5L) * 1000L;
    private HashMap thePool = new HashMap(initSize, ldFactor);
    private Vector Cleanup = new Vector();

    public OutboundConnectionGroup() {
        wMgr = WSChannelManager.getInstance();
    }

    public HTTPConnection createConnection(WSAddress wSAddress) throws AxisFault, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.createConnection()");
        }
        HTTPConnection hTTPConnection = null;
        String string = wSAddress.keyValueforPool();
        if (this.vcf == null) {
            this.vcf = wMgr.getVCFactory(wSAddress);
        }
        hTTPConnection = wMgr.getWSOutboundConnection(string, wSAddress, this.vcf);
        this.thePool.put(hTTPConnection, STATE_IN_USE);
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "createdOCobject " + hTTPConnection.toString() + " vcf : " + String.valueOf(this.vcf));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.createConnection()");
        }
        return hTTPConnection;
    }

    protected HTTPConnection invalidateConnection(WSAddress wSAddress) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.invalidateConnection()");
        }
        HTTPConnection hTTPConnection2 = null;
        if (this.thePool.size() > 0) {
            for (HTTPConnection hTTPConnection2 : this.thePool.keySet()) {
                if (!hTTPConnection2.getTargetAddress().equals(wSAddress)) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "invalidatedConnObject01 " + wSAddress.toString() + "  " + hTTPConnection2.toString());
                }
                this.thePool.put(hTTPConnection2, STATE_INVALID);
                break;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.invalidateConnection()");
        }
        return hTTPConnection2;
    }

    protected HTTPConnection getConnection(WSAddress wSAddress) throws AxisFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.getConnection()");
        }
        HTTPConnection hTTPConnection = null;
        boolean bl = false;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.connectionIdleTimeout: " + this.idleTime + " ms.");
        }
        if (this.thePool.size() > 0) {
            Iterator iterator = this.thePool.keySet().iterator();
            while (iterator.hasNext()) {
                hTTPConnection = (HTTPConnection)iterator.next();
                long l = hTTPConnection.timeFromLastAccess();
                int n = (Integer)this.thePool.get(hTTPConnection);
                if (n == STATE_INVALID) {
                    hTTPConnection = null;
                    continue;
                }
                if (l >= this.idleTime) {
                    if (n == STATE_NOT_IN_USE) {
                        this.Cleanup.add(hTTPConnection);
                        iterator.remove();
                        hTTPConnection.release(null);
                        if (_tc.isEventEnabled()) {
                            Object[] objectArray = new Object[]{hTTPConnection.toString(), String.valueOf(l)};
                            Tr.event(_tc, "expiredOCobject", objectArray);
                        }
                        bl = true;
                    }
                } else if (n == STATE_NOT_IN_USE) break;
                hTTPConnection = null;
            }
            if (hTTPConnection != null) {
                hTTPConnection.updateEndpoint(wSAddress);
                this.thePool.put(hTTPConnection, STATE_IN_USE);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "existedOCobject " + hTTPConnection.toString());
                }
            }
        }
        if (bl && hTTPConnection == null) {
            hTTPConnection = this.createConnection(wSAddress);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Found expired object, and now create a new one.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.getConnection()");
        }
        return hTTPConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnConnection(HTTPConnection hTTPConnection) {
        int n;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.returnConnection()");
        }
        if ((n = ((Integer)this.thePool.get(hTTPConnection)).intValue()) == STATE_INVALID) {
            this.thePool.remove(hTTPConnection);
        } else if (hTTPConnection.isClosed()) {
            this.thePool.remove(hTTPConnection);
        } else {
            this.thePool.put(hTTPConnection, STATE_NOT_IN_USE);
        }
        if (n == STATE_INVALID) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "returnInvalidOCobject " + hTTPConnection.toString());
            }
            hTTPConnection.release(null);
            Vector vector = this.Cleanup;
            synchronized (vector) {
                this.Cleanup.add(hTTPConnection);
            }
        } else if (hTTPConnection.isClosed() || n == STATE_INVALID) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "returnClosedOCobject " + hTTPConnection.toString());
            }
            hTTPConnection.release(null);
            Vector vector = this.Cleanup;
            synchronized (vector) {
                this.Cleanup.add(hTTPConnection);
            }
        } else if (_tc.isEventEnabled()) {
            Tr.event(_tc, "returnValidOCobject " + hTTPConnection.toString());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.returnConnection()");
        }
    }

    protected boolean isEmpty() {
        return this.thePool.isEmpty() && this.Cleanup.isEmpty();
    }

    protected int currPoolSize() {
        return this.thePool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ChannelException, ChainException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cleanup()");
        }
        HTTPConnection hTTPConnection2 = null;
        Vector vector = this.Cleanup;
        synchronized (vector) {
            for (HTTPConnection hTTPConnection2 : this.Cleanup) {
                hTTPConnection2.release(null);
                if (!_tc.isEventEnabled()) continue;
                Tr.event(_tc, "removeOCobject " + hTTPConnection2.toString());
            }
            this.Cleanup.clear();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cleanup()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws ChannelException, ChainException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "release()");
        }
        if (this.vcf != null) {
            VirtualConnectionFactory virtualConnectionFactory = this.vcf;
            synchronized (virtualConnectionFactory) {
                if (this.vcf != null) {
                    this.vcf.destroy();
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "objectReleased " + String.valueOf(this.vcf));
                    }
                    this.vcf = null;
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "release()");
        }
    }

    public int totalInUse() {
        int n = 0;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "totalInUse()");
        }
        Iterator iterator = this.thePool.values().iterator();
        while (iterator.hasNext()) {
            if (!((Integer)iterator.next()).equals(STATE_IN_USE)) continue;
            ++n;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "totalInUse()");
        }
        return n;
    }

    public boolean findUnused() {
        boolean bl = false;
        HTTPConnection hTTPConnection = null;
        if (this.thePool.size() > 1) {
            Iterator iterator = this.thePool.keySet().iterator();
            while (iterator.hasNext()) {
                hTTPConnection = (HTTPConnection)iterator.next();
                if (!((Integer)this.thePool.get(hTTPConnection)).equals(STATE_NOT_IN_USE)) continue;
                this.Cleanup.add(hTTPConnection);
                iterator.remove();
                hTTPConnection.release(null);
                bl = true;
                break;
            }
        }
        return bl;
    }
}

