/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.channel.OutboundConnectionGroup;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.axis2.AxisFault;

public final class OutboundConnectionCache {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final TraceComponent _tc = Tr.register(OutboundConnectionCache.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final TraceComponent _tc2 = Tr.register(CleanupTask.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static int REFRESHTIME = 0;
    private static final int DELAYTIME = 1000;
    private static int CONN_TIMEOUT = 0;
    private static int MAX_CONN = 0;
    private HashMap chainlist = null;
    private static OutboundConnectionCache cache = null;
    private static Timer _timer = null;

    private OutboundConnectionCache() {
        _timer = new Timer(true);
        _timer.schedule((TimerTask)new CleanupTask(), 1000L, (long)REFRESHTIME);
        this.chainlist = new HashMap();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.connectionTimeout: " + CONN_TIMEOUT + " ms, " + "com.ibm.websphere.webservices.http.connectionPoolCleanUpTime" + ": " + REFRESHTIME + " ms, " + "com.ibm.websphere.webservices.http.maxConnection" + ": " + MAX_CONN);
        }
    }

    public static int maxConnection() {
        return MAX_CONN;
    }

    public static int connTimeout() {
        return CONN_TIMEOUT;
    }

    public static synchronized OutboundConnectionCache getInstance() {
        if (cache == null) {
            cache = new OutboundConnectionCache();
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnection findConnectionAndInvalidate(WSAddress wSAddress) throws AxisFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findConnectionAndInvalidate()");
        }
        HTTPConnection hTTPConnection = null;
        OutboundConnectionGroup outboundConnectionGroup = null;
        String string = wSAddress.keyValueforPool();
        HashMap hashMap = this.chainlist;
        synchronized (hashMap) {
            outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(string);
            if (outboundConnectionGroup != null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "connTableKeyFound " + string + " true");
                }
                hTTPConnection = outboundConnectionGroup.invalidateConnection(wSAddress);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionCache.findConnectionAndInvalidate()");
        }
        return hTTPConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public HTTPConnection findGroupAndGetConnection(WSAddress wSAddress) throws AxisFault, InterruptedException, Exception {
        Object[] objectArray;
        int n;
        int n2;
        HTTPConnection hTTPConnection;
        block27: {
            OutboundConnectionGroup outboundConnectionGroup;
            block28: {
                block26: {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "OutboundConnectionCache.findGroupAndGetConnection()");
                    }
                    hTTPConnection = null;
                    outboundConnectionGroup = null;
                    String string = wSAddress.keyValueforPool();
                    HashMap hashMap = this.chainlist;
                    // MONITORENTER : hashMap
                    n2 = this.poolSize();
                    n = this.connectionsInUse();
                    if (_tc.isEventEnabled()) {
                        objectArray = new Object[]{String.valueOf(n2), String.valueOf(n), String.valueOf(MAX_CONN)};
                        Tr.event(_tc, "connPoolStatus00", objectArray);
                    }
                    if ((outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(string)) == null) {
                        outboundConnectionGroup = new OutboundConnectionGroup();
                        this.chainlist.put(string, outboundConnectionGroup);
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "outConnGroupCreated " + string);
                        }
                    } else if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "connTableKeyFound " + string + " true");
                    }
                    if (MAX_CONN != 0) break block26;
                    hTTPConnection = outboundConnectionGroup.createConnection(wSAddress);
                    break block27;
                }
                int n3 = outboundConnectionGroup.currPoolSize();
                int n4 = outboundConnectionGroup.totalInUse();
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, outboundConnectionGroup + " has size of " + n3 + " with " + n4 + " objects used.");
                }
                if (n2 >= MAX_CONN) break block28;
                if (n == n2) {
                    hTTPConnection = outboundConnectionGroup.createConnection(wSAddress);
                    break block27;
                } else {
                    if (n >= n2) {
                        String string = NLSProvider.getNLS().getFormattedMessage("connectionPoolIntegrity00", new Object[0], "An integrity problem occurred with the connection pool.");
                        throw new AxisFault(string);
                    }
                    if (n4 > n3) {
                        String string = NLSProvider.getNLS().getFormattedMessage("connectionPoolIntegrity00", new Object[0], "An integrity problem occurred with the connection pool.");
                        throw new AxisFault(string);
                    }
                    if (n4 < n3 || n4 == 0 && n3 == 0) {
                        hTTPConnection = outboundConnectionGroup.getConnection(wSAddress);
                    }
                    if (hTTPConnection == null) {
                        hTTPConnection = outboundConnectionGroup.createConnection(wSAddress);
                    }
                }
                break block27;
            }
            if (n2 != MAX_CONN) {
                String string = NLSProvider.getNLS().getFormattedMessage("connectionPoolIntegrity00", new Object[0], "An integrity problem occurred with the connection pool.");
                throw new AxisFault(string);
            }
            hTTPConnection = outboundConnectionGroup.getConnection(wSAddress);
            long l = 0L;
            long l2 = CONN_TIMEOUT;
            if (hTTPConnection == null && this.purgeUnused()) {
                hTTPConnection = outboundConnectionGroup.createConnection(wSAddress);
            }
            while (hTTPConnection == null) {
                Object[] objectArray2;
                if (CONN_TIMEOUT == 0) {
                    if (_tc.isEventEnabled()) {
                        objectArray2 = new Object[]{Thread.currentThread().toString()};
                        Tr.event(_tc, "connectionWait00", objectArray2);
                    }
                    this.chainlist.wait();
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "connectionNotify01 " + Thread.currentThread().toString());
                    }
                    if ((hTTPConnection = outboundConnectionGroup.getConnection(wSAddress)) == null && this.purgeUnused()) {
                        hTTPConnection = outboundConnectionGroup.createConnection(wSAddress);
                    }
                    if (hTTPConnection == null) continue;
                    break;
                }
                if (_tc.isEventEnabled()) {
                    objectArray2 = new Object[]{Thread.currentThread().toString(), String.valueOf(l2)};
                    Tr.event(_tc, "connectionWait01", objectArray2);
                }
                long l3 = System.currentTimeMillis();
                this.chainlist.wait(l2);
                l = System.currentTimeMillis() - l3;
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "connectionNotify01 currentThread : " + Thread.currentThread().toString());
                }
                if ((hTTPConnection = outboundConnectionGroup.getConnection(wSAddress)) == null && this.purgeUnused()) {
                    hTTPConnection = outboundConnectionGroup.createConnection(wSAddress);
                }
                if (hTTPConnection != null) break;
                if (l2 - l > 0L) continue;
                String string = NLSProvider.getNLS().getFormattedMessage("connectionTimedOut", new Object[0], "The connection wait has timed out.");
                throw new AxisFault(string);
            }
        }
        if (_tc.isEventEnabled()) {
            n2 = this.poolSize();
            n = this.connectionsInUse();
            objectArray = new Object[]{String.valueOf(n2), String.valueOf(n), String.valueOf(MAX_CONN)};
            Tr.event(_tc, "connPoolStatus00", objectArray);
        }
        // MONITOREXIT : hashMap
        if (!_tc.isEntryEnabled()) return hTTPConnection;
        Tr.exit(_tc, "OutboundConnectionCache.findGroupAndGetConnection()");
        return hTTPConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findGroupAndReturnConnection(HTTPConnection hTTPConnection) throws ChainException, ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findGroupAndReturnConnection()");
        }
        String string = hTTPConnection.getTargetAddress().keyValueforPool();
        OutboundConnectionGroup outboundConnectionGroup = null;
        HashMap hashMap = this.chainlist;
        synchronized (hashMap) {
            Object[] objectArray;
            int n;
            int n2;
            if (_tc.isEventEnabled()) {
                n2 = this.poolSize();
                n = this.connectionsInUse();
                objectArray = new Object[]{String.valueOf(n2), String.valueOf(n), String.valueOf(MAX_CONN)};
                Tr.event(_tc, "connPoolStatus00", objectArray);
            }
            if ((outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(string)) == null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "connTableKeyFound " + string + " false");
                }
                return;
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "connTableKeyFound " + string + " true");
            }
            outboundConnectionGroup.returnConnection(hTTPConnection);
            if (_tc.isEventEnabled()) {
                n2 = this.poolSize();
                n = this.connectionsInUse();
                objectArray = new Object[]{String.valueOf(n2), String.valueOf(n), String.valueOf(MAX_CONN)};
                Tr.event(_tc, "connPoolStatus00", objectArray);
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "connectionNotify00");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "OutboundConnectionCache.findGroupAndReturnConnection()");
            }
            this.chainlist.notify();
        }
    }

    private boolean purgeUnused() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "purgeUnused()");
        }
        boolean bl = false;
        Iterator iterator = this.chainlist.keySet().iterator();
        OutboundConnectionGroup outboundConnectionGroup = null;
        boolean bl2 = false;
        while (iterator.hasNext() && !(bl = (outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(iterator.next())).findUnused())) {
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "purgeUnused()");
        }
        return bl;
    }

    protected int poolSize() {
        int n = 0;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "poolSize()");
        }
        Iterator iterator = this.chainlist.keySet().iterator();
        OutboundConnectionGroup outboundConnectionGroup = null;
        while (iterator.hasNext()) {
            outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(iterator.next());
            n += outboundConnectionGroup.currPoolSize();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "poolSize()");
        }
        return n;
    }

    protected int connectionsInUse() {
        int n = 0;
        OutboundConnectionGroup outboundConnectionGroup = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "connectionsInUse()");
        }
        Iterator iterator = this.chainlist.keySet().iterator();
        while (iterator.hasNext()) {
            outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(iterator.next());
            n += outboundConnectionGroup.totalInUse();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "connectionsInUse()");
        }
        return n;
    }

    static {
        CONN_TIMEOUT = Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.connectionTimeout", "300")) * 1000;
        REFRESHTIME = Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.connectionPoolCleanUpTime", "180")) * 1000;
        MAX_CONN = Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.maxConnection", "50"));
    }

    private class CleanupTask
    extends TimerTask {
        private CleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: {
                OutboundConnectionGroup outboundConnectionGroup = null;
                try {
                    if (_tc2.isEntryEnabled()) {
                        Tr.entry(_tc2, "CleanupTask.run()");
                    }
                    HashMap hashMap = OutboundConnectionCache.this.chainlist;
                    synchronized (hashMap) {
                        if (OutboundConnectionCache.this.chainlist.size() > 0) {
                            Iterator iterator = OutboundConnectionCache.this.chainlist.keySet().iterator();
                            Object var4_5 = null;
                            while (iterator.hasNext()) {
                                var4_5 = iterator.next();
                                outboundConnectionGroup = (OutboundConnectionGroup)OutboundConnectionCache.this.chainlist.get(var4_5);
                                outboundConnectionGroup.cleanup();
                                if (!outboundConnectionGroup.isEmpty()) continue;
                                if (_tc2.isDebugEnabled()) {
                                    Tr.debug(_tc2, "OutboundConnectionGroup.isEmpty(): true");
                                }
                                outboundConnectionGroup.release();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.channel.OutboundConnectionCache.run", "151", this);
                    if (!_tc2.isEventEnabled()) break block9;
                    Tr.event(_tc2, "exception01 " + JavaUtils.stackToString(exception));
                }
            }
        }
    }
}

