/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.transport.TransportClientProperties;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import com.ibm.ws.websvcs.transport.policyset.PolicySetUtils;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.http.HttpTransportProperties;

public class DefaultHTTPTransportClientProperties
implements TransportClientProperties {
    protected static final String ANONYMOUS = "anonymous";
    protected static final String PROXY_HOST_NAME = "proxy_host";
    protected static final String PROXY_PORT = "proxy_port";
    private MessageContext localmsgContext;
    protected TransportOutDescription proxySetting = null;
    protected TransportOutDescription proxyOutSetting = null;
    private static final TraceComponent _tc = Tr.register(DefaultHTTPTransportClientProperties.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    protected static final String emptyString = "";
    protected String proxyHost = null;
    protected String nonProxyHosts = null;
    protected String proxyHostName = null;
    protected String proxyPort = null;
    protected String proxyUser = null;
    protected String proxyPassword = null;
    protected String reqContentEncoding = null;
    protected boolean commonValsInitialized = false;
    protected boolean initialized = false;

    public void setProxyHost(String string) {
        this.proxyHost = string == null ? emptyString : string;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setProxyHost: " + this.proxyHost);
        }
    }

    public void setProxyPort(String string) {
        this.proxyPort = string == null ? emptyString : string;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setProxyPort: " + this.proxyPort);
        }
    }

    public void setProxyUser(String string) {
        this.proxyUser = string == null ? emptyString : string;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setProxyUser: " + this.proxyUser);
        }
    }

    public void setProxyPassword(String string) {
        if (string == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setProxyPassword: ");
            }
            this.proxyPassword = emptyString;
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setProxyPassword: ****");
            }
            this.proxyPassword = string;
        }
    }

    public void setNonProxyHosts(String string) {
        this.nonProxyHosts = string == null ? emptyString : string;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setNonProxyHosts: " + this.nonProxyHosts);
        }
    }

    public String getProxyHost() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::getProxyHost: " + this.proxyHost);
        }
        return this.proxyHost;
    }

    public String getNonProxyHosts() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::getNonProxyProxyHosts: " + this.nonProxyHosts);
        }
        return this.nonProxyHosts;
    }

    public String getProxyPort() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::getProxyPort: " + this.proxyPort);
        }
        return this.proxyPort;
    }

    public String getProxyUser() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::getProxyUser: " + this.proxyUser);
        }
        return this.proxyUser;
    }

    public String getProxyPassword() {
        if (JavaUtils.hasValue(this.proxyPassword)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setProxyPassword: ****");
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setProxyPassword: ");
        }
        return this.proxyPassword;
    }

    public String encodeRequestMessage() {
        this.reqContentEncoding = (String)this.localmsgContext.getProperty("com.ibm.websphere.webservices.http.requestContentEncoding");
        if (this.reqContentEncoding == null) {
            this.reqContentEncoding = emptyString;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::encodeRequestMessage: " + this.reqContentEncoding);
        }
        return this.reqContentEncoding;
    }

    public String ucfCallbackTimeout() {
        String string = (String)this.localmsgContext.getProperty("com.ibm.websphere.webservices.UCFSelectionTimeout");
        if (!JavaUtils.hasValue(string)) {
            string = emptyString;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::ucfCallbackTimeout: " + string);
        }
        return string;
    }

    public boolean isProxyListed(MessageContext messageContext) throws AxisFault {
        Object object;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "DefaultHTTPTransportClientProperties::isProxyListed");
        }
        boolean bl = false;
        Parameter parameter = null;
        this.proxyOutSetting = messageContext.getConfigurationContext().getAxisConfiguration().getTransportOut(new QName("http"));
        if (this.proxyOutSetting != null) {
            parameter = this.proxyOutSetting.getParameter("PROXY");
        }
        OMElement oMElement = null;
        if (parameter != null) {
            oMElement = parameter.getParameterElement();
        }
        if (oMElement != null) {
            object = oMElement.getAllAttributes();
            while (object.hasNext()) {
                OMAttribute oMAttribute = (OMAttribute)object.next();
                if (!oMAttribute.getLocalName().equalsIgnoreCase(PROXY_HOST_NAME)) continue;
                bl = true;
            }
        }
        if ((object = (HttpTransportProperties.ProxyProperties)messageContext.getProperty("PROXY")) != null && ((HttpTransportProperties.ProxyProperties)object).getProxyHostName() != null) {
            bl = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "DefaultHTTPTransportClientProperties::isProxyListed: " + bl);
        }
        return bl;
    }

    public void setSSLConfigurationName(String string) {
    }

    public void setSSLClientPropsName(String string) {
    }

    public String getSSLConfigurationName() {
        return emptyString;
    }

    public String getSSLCertificateAliasName() {
        return emptyString;
    }

    public DefaultHTTPTransportClientProperties(MessageContext messageContext) throws AxisFault {
        Properties properties;
        this.localmsgContext = messageContext;
        this.proxySetting = this.localmsgContext.getConfigurationContext().getAxisConfiguration().getTransportOut(new QName("http"));
        Parameter parameter = this.proxySetting.getParameter("http.proxyHost");
        if (parameter != null) {
            this.proxyHost = (String)parameter.getValue();
        }
        if ((parameter = this.proxySetting.getParameter("http.proxyPort")) != null) {
            this.proxyPort = (String)parameter.getValue();
        }
        if ((parameter = this.proxySetting.getParameter("http.proxyUser")) != null) {
            this.proxyUser = (String)parameter.getValue();
        }
        if ((parameter = this.proxySetting.getParameter("http.proxyPassword")) != null) {
            this.proxyPassword = (String)parameter.getValue();
        }
        if ((properties = PolicySetUtils.getHTTPBindings(messageContext.getAxisService())) != null) {
            this.nonProxyHosts = PolicySetUtils.getCustomBindingValue(properties, "http.nonProxyHosts");
        }
        if (this.nonProxyHosts == null) {
            this.nonProxyHosts = System.getProperty("http.nonProxyHosts");
        }
    }

    protected String getCommonValues() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.commonValsInitialized) {
            if (!JavaUtils.hasValue(this.reqContentEncoding)) {
                this.encodeRequestMessage();
            }
            this.commonValsInitialized = true;
        }
        stringBuffer.append("requestContentEncoding=" + this.reqContentEncoding + "\n");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nWebservices Transport Connection HTTP:\n");
        stringBuffer.append("proxyHost=" + this.getProxyHost() + "\n");
        stringBuffer.append("proxyPort=" + this.getProxyPort() + "\n");
        stringBuffer.append("proxyUser=" + this.getProxyUser() + "\n");
        if (JavaUtils.hasValue(this.proxyPassword)) {
            stringBuffer.append("proxyPassword=*****\n");
        } else {
            stringBuffer.append("proxyPassword=" + this.getProxyPassword() + "\n");
        }
        stringBuffer.append("nonProxyHosts=" + this.getNonProxyHosts() + "\n");
        stringBuffer.append(this.getCommonValues());
        return stringBuffer.toString();
    }
}

