/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.transport.SecureTransportClientProperties;
import com.ibm.ws.websvcs.transport.channel.DefaultHTTPTransportClientProperties;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import com.ibm.ws.websvcs.transport.policyset.PolicySetUtils;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;

public class DefaultHTTPSTransportClientProperties
extends DefaultHTTPTransportClientProperties
implements SecureTransportClientProperties {
    private static final TraceComponent _tc = Tr.register(DefaultHTTPSTransportClientProperties.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private String sslCfgName = null;
    private String sslPropsName = null;

    public void setProxyHost(String string) {
        super.setProxyHost(string);
    }

    public void setProxyPort(String string) {
        super.setProxyPort(string);
    }

    public void setProxyUser(String string) {
        super.setProxyUser(string);
    }

    public void setProxyPassword(String string) {
        super.setProxyPassword(string);
    }

    public void setNonProxyHosts(String string) {
        super.setNonProxyHosts(string);
    }

    public String getProxyHost() {
        return super.getProxyHost();
    }

    public String getNonProxyHosts() {
        return super.getNonProxyHosts();
    }

    public String getProxyPort() {
        return super.getProxyPort();
    }

    public String getProxyUser() {
        return super.getProxyUser();
    }

    public String getProxyPassword() {
        return super.getProxyPassword();
    }

    public void setSSLConfigurationName(String string) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPSTransportClientProperties::setSSLConfigurationName: " + string);
        }
        this.sslCfgName = string;
    }

    public void setSSLClientPropsName(String string) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPSTransportClientProperties::setSSLClientPropsName: " + string);
        }
        this.sslPropsName = string;
    }

    public String getSSLConfigurationName() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPSTransportClientProperties::getSSLConfigurationName: " + this.sslCfgName);
        }
        return this.sslCfgName == null ? "" : this.sslCfgName;
    }

    public String getSSLClientPropsName() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPSTransportClientProperties::getSSLClientPropsName: " + this.sslPropsName);
        }
        return this.sslPropsName == null ? "" : this.sslPropsName;
    }

    public DefaultHTTPSTransportClientProperties(MessageContext messageContext) throws AxisFault {
        super(messageContext);
        Properties properties;
        String string = null;
        Parameter parameter = this.proxySetting.getParameter("https.proxyHost");
        if (parameter != null && JavaUtils.hasValue(string = (String)parameter.getValue())) {
            this.proxyHost = string;
        }
        if ((parameter = this.proxySetting.getParameter("https.proxyPort")) != null) {
            string = null;
            string = (String)parameter.getValue();
            if (JavaUtils.hasValue(string)) {
                this.proxyPort = string;
            }
        }
        if ((parameter = this.proxySetting.getParameter("https.proxyUser")) != null) {
            string = null;
            string = (String)parameter.getValue();
            if (JavaUtils.hasValue(string)) {
                this.proxyUser = string;
            }
        }
        if ((parameter = this.proxySetting.getParameter("https.proxyPassword")) != null) {
            string = null;
            string = (String)parameter.getValue();
            if (JavaUtils.hasValue(string)) {
                this.proxyPassword = string;
            }
        }
        if ((properties = PolicySetUtils.getHTTPBindings(messageContext.getAxisService())) != null) {
            this.nonProxyHosts = PolicySetUtils.getCustomBindingValue(properties, "https.nonProxyHosts");
        }
        if (this.nonProxyHosts == null) {
            this.nonProxyHosts = System.getProperty("https.nonProxyHosts");
        }
        if (this.nonProxyHosts == null) {
            this.nonProxyHosts = super.getNonProxyHosts();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nWebservices Transport Connection HTTPS:\n");
        stringBuffer.append("SSLConfigurationName=" + this.getSSLConfigurationName() + "\n");
        stringBuffer.append("proxyHost=" + this.getProxyHost() + "\n");
        stringBuffer.append("proxyPort=" + this.getProxyPort() + "\n");
        stringBuffer.append("proxyUser=" + this.getProxyUser() + "\n");
        if (JavaUtils.hasValue(this.proxyPassword)) {
            stringBuffer.append("proxyPassword=*****\n");
        } else {
            stringBuffer.append("proxyPassword=" + this.getProxyPassword() + "\n");
        }
        stringBuffer.append("nonProxyHosts=" + this.getNonProxyHosts() + "\n");
        stringBuffer.append(this.getCommonValues());
        return stringBuffer.toString();
    }
}

