/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.transport.AsyncResponseContext;
import com.ibm.ws.websvcs.transport.AsyncResponseContextMap;
import com.ibm.ws.websvcs.transport.channel.AsyncInResponseChannel;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import com.ibm.ws.websvcs.transport.http.HttpAsyncResponseContext;
import com.ibm.ws.websvcs.transport.http.HttpReadCallback;
import com.ibm.ws.websvcs.transport.http.HttpRequestImpl;
import com.ibm.ws.websvcs.transport.http.HttpResponseImpl;
import com.ibm.ws.websvcs.transport.http.HttpWriteCallback;
import com.ibm.ws.websvcs.transport.http.UnknownEPRConfigCtxtLoaderPluginMgr;
import com.ibm.ws.websvcs.transport.http.UnknownEPRResolverPluginMgr;
import com.ibm.wsspi.channel.base.InboundApplicationLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;

public class AsyncInResponseConnLink
extends InboundApplicationLink
implements Runnable,
Constants {
    private static final TraceComponent _tc = Tr.register(AsyncInResponseConnLink.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private VirtualConnection _vc = null;
    private HttpInboundServiceContext httpInSC = null;
    private AsyncInResponseChannel asyncRspchannel = null;
    private HttpRequestImpl request = null;
    private HttpResponseImpl response = null;
    private HttpReadCallback readCB = null;
    private HttpWriteCallback writeCB = null;
    private AsyncResponseContextMap aRCMap = null;
    private UnknownEPRResolverPluginMgr resolverPlugin = null;
    private UnknownEPRConfigCtxtLoaderPluginMgr ccLoaderPlugin = null;

    public AsyncInResponseConnLink() {
        this.aRCMap = AsyncResponseContextMap.getInstance();
    }

    public AsyncInResponseConnLink(AsyncInResponseChannel asyncInResponseChannel, VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel ctor... ");
        }
        this.init(asyncInResponseChannel, virtualConnection);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...SOAPAcceptorConnectionLink ctor");
        }
    }

    public void init(AsyncInResponseChannel asyncInResponseChannel, VirtualConnection virtualConnection) {
        this.init(virtualConnection);
        this.request = new HttpRequestImpl();
        this.response = new HttpResponseImpl();
        this.readCB = new HttpReadCallback();
        this.writeCB = new HttpWriteCallback();
        this.asyncRspchannel = asyncInResponseChannel;
        this.aRCMap = AsyncResponseContextMap.getInstance();
        this._vc = virtualConnection;
        this.resolverPlugin = new UnknownEPRResolverPluginMgr();
        this.ccLoaderPlugin = new UnknownEPRConfigCtxtLoaderPluginMgr();
        this.resolverPlugin.discoverUnknownEPRResolverPlugins();
        this.ccLoaderPlugin.discoverUnknownEPRConfigCtxtLoaderPlugins();
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseConnLink.close()...");
        }
        super.close(virtualConnection, exception);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "AsyncInResponseConnLink.close()");
        }
    }

    public void destroy(Exception exception) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseConnLink.destroy()..." + this);
        }
        super.destroy(exception);
        this.httpInSC = null;
        if (this.asyncRspchannel != null) {
            this.asyncRspchannel.releaseConnectionLink(this);
            this.asyncRspchannel = null;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "AsyncInResponseConnLink.destroy()");
        }
    }

    public HttpResponseImpl getResponse() {
        return this.response;
    }

    public HttpRequestImpl getRequest() {
        return this.request;
    }

    public AsyncInResponseChannel getChannel() {
        return this.asyncRspchannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block34: {
            block32: {
                block31: {
                    Exception exception = null;
                    MessageContext messageContext = new MessageContext();
                    boolean bl = true;
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "AsyncInResponseConnLink.run()...");
                    }
                    try {
                        String string = this.request.getRequestURLAsString();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Received URL: " + string);
                        }
                        if (string != null) {
                            AxisService axisService = null;
                            ClassLoader classLoader = null;
                            ConfigurationContext configurationContext = null;
                            AsyncResponseContext asyncResponseContext = this.aRCMap.getContext(string);
                            if (asyncResponseContext != null) {
                                configurationContext = asyncResponseContext.getConfCtxt();
                                axisService = asyncResponseContext.getAxisService();
                            } else {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Response context not in map, calling RM plugin...");
                                }
                                configurationContext = this.ccLoaderPlugin.getConfigurationContextForUnknownEPR(string);
                                classLoader = this.ccLoaderPlugin.getClassLoaderForUnknownEPR(string);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Config Context: " + configurationContext + ", " + "Axis Service: " + axisService + ", " + "ClassLoader: " + classLoader);
                            }
                            if (configurationContext != null && (classLoader != null || axisService != null)) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Handling response...");
                                }
                                messageContext.setConfigurationContext(configurationContext);
                                AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
                                if (this.request.getScheme().equalsIgnoreCase("http")) {
                                    messageContext.setTransportOut(axisConfiguration.getTransportOut(new QName("http")));
                                } else if (this.request.getScheme().equalsIgnoreCase("https")) {
                                    messageContext.setTransportOut(axisConfiguration.getTransportOut(new QName("https")));
                                }
                                if (axisService == null) {
                                    asyncResponseContext = new HttpAsyncResponseContext(axisService, configurationContext, string);
                                    asyncResponseContext.setClassLoader(classLoader);
                                }
                                asyncResponseContext.handleRequest(this.request, this.response);
                                this.handleResponseReceived(HttpConstants.STATUS_OK.getIntCode());
                            } else {
                                bl = false;
                            }
                        } else {
                            bl = false;
                        }
                        if (!bl) {
                            this.handleErrorResponse(400);
                        }
                        if (exception == null) break block31;
                        this.close(this._vc, exception);
                        break block32;
                    }
                    catch (Throwable throwable) {
                        block33: {
                            try {
                                FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink.run", "332", this);
                                Tr.error(_tc, JavaUtils.stackToString(throwable));
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Exception. Setting response status to : 500");
                                }
                                this.handleErrorResponse(throwable, 500);
                                String string = "";
                                if (throwable.getCause() != null) {
                                    string = "caused by \n" + throwable.getCause().getLocalizedMessage();
                                    if (throwable.getCause().getCause() != null) {
                                        string = string + "\n caused by " + throwable.getCause().getCause().getLocalizedMessage();
                                    }
                                    exception = new Exception(throwable.getLocalizedMessage() + " : " + string);
                                } else {
                                    exception = new Exception(throwable.getLocalizedMessage());
                                }
                                if (exception == null) break block33;
                                this.close(this._vc, exception);
                            }
                            catch (Throwable throwable2) {
                                if (exception != null) {
                                    this.close(this._vc, exception);
                                } else if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, " Close is not called in Finally method");
                                }
                                if (_tc.isEntryEnabled()) {
                                    Tr.exit(_tc, "AsyncInResponseConnLink.run()");
                                }
                                throw throwable2;
                            }
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, " Close is not called in Finally method");
                        }
                        if (!_tc.isEntryEnabled()) break block34;
                        Tr.exit(_tc, "AsyncInResponseConnLink.run()");
                    }
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, " Close is not called in Finally method");
                }
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "AsyncInResponseConnLink.run()");
            }
        }
    }

    public void ready(VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseConnLink.ready()...");
        }
        super.init(virtualConnection);
        this.httpInSC = (HttpInboundServiceContext)this.getDeviceLink().getChannelAccessor();
        this.readCB.init(this, this.httpInSC, virtualConnection);
        this.readCB.readRequest();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "AsyncInResponseConnLink.ready()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestReady(VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseConnLink.requestReady()...");
        }
        this.writeCB.init(this, this.httpInSC);
        this.request.init(this.httpInSC, this.readCB.getRequestBodyBuffers(), this.response);
        this.response.init(this, this.httpInSC, this.writeCB);
        try {
            ThreadPool threadPool;
            String string;
            Object var2_2 = null;
            if (var2_2 != null && !(string = Thread.currentThread().getName()).startsWith((threadPool = (ThreadPool)var2_2).getName())) {
                threadPool.execute((Runnable)this, 2);
                return;
            }
            this.run();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink.requestReady", "460", this);
            Tr.error(_tc, "caughtException8", throwable);
            this.handleErrorResponse(throwable, 404);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "AsyncInResponseConnLink.requestReady()");
            }
        }
    }

    public void handleErrorResponse(int n) {
        this.handleErrorResponse(null, n);
    }

    public void handleResponseReceived(int n) {
        try {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "AsyncInResponseConnLink.handleResonseReceived()");
            }
            this.response.setStatusCode(n);
            this.response.setContentType("text/html");
            String string = System.getProperty("com.ibm.websphere.webservices.http.connectionKeepAlive");
            if (JavaUtils.hasValue(string) && string.equalsIgnoreCase("no")) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting Connection to close");
                }
                this.response.setHeader(HttpConstants.HDR_CONNECTION.getName(), HttpConstants.CONN_CLOSE.getName());
            }
            OutputStream outputStream = this.response.getOutputStream();
            outputStream.close();
            this.response.finishResponse();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "AsyncInResponseConnLink.handleResponseReceived(). Clearing the status code");
            }
            this.response.clearStatusCode();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink.handleResponseReceived", "535", this);
            Tr.error(_tc, "caughtException8", throwable);
        }
    }

    public void handleErrorResponse(Throwable throwable, int n) {
        try {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "AsyncInResponseConnLink.handleErrorResponse()");
            }
            this.response.setStatusCode(n);
            this.response.setContentType("text/html");
            OutputStream outputStream = this.response.getOutputStream();
            if (outputStream != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<h2>ERROR</h2>\n");
                stringBuffer.append("<p>System error occurred while processing request URL: " + this.request.getRequestURLAsString() + "\n");
                if (throwable != null) {
                    stringBuffer.append("<p>Exception is: " + throwable + "\n");
                }
                outputStream.write(stringBuffer.toString().getBytes());
                outputStream.close();
                this.response.finishResponse();
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "AsyncInResponseConnLink.handleErrorResponse(). Clearing the status code()");
            }
            this.response.clearStatusCode();
        }
        catch (Throwable throwable2) {
            FFDCFilter.processException(throwable2, "com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink.handleErrorResponse", "593", this);
            Tr.error(_tc, "caughtException8", throwable2);
        }
    }
}

