/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.transport.AsyncResponseContextMap;
import com.ibm.ws.websvcs.transport.channel.AsyncInRespChannelFactory;
import com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.base.InboundApplicationChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;

public class AsyncInResponseChannel
extends InboundApplicationChannel
implements Discriminator {
    private static final TraceComponent _tc = Tr.register(AsyncInResponseChannel.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final String ASYNC_RESP_ACL_NAME = "SOAPACL";
    private static final byte[] ASYNC_RESP_CR_AS_BYTES = "/IBM_WS_SYS_RESPONSESERVLET".getBytes();
    private AsyncInRespChannelFactory httpAsyRpChanFactory = null;
    private AsyncResponseContextMap asyRCMap = null;
    private Class HttpInbDeviceIntf = HttpInboundServiceContext.class;
    private Class inHttpDiscrimDataType = HttpRequestMessage.class;
    private int bufferSize = 8192;
    public static final String NAME = "async-inResponse-channel";

    public AsyncInResponseChannel(ChannelData channelData) {
        super(channelData);
    }

    public AsyncInResponseChannel(AsyncInRespChannelFactory asyncInRespChannelFactory, ChannelData channelData) {
        super(channelData);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel ctor...");
        }
        this.httpAsyRpChanFactory = asyncInRespChannelFactory;
        Integer n = (Integer)channelData.getPropertyBag().get("bufferSize");
        if (n != null) {
            this.bufferSize = n;
            Tr.info(_tc, "bufferSize", Integer.toString(this.bufferSize));
        }
        this.asyRCMap = AsyncResponseContextMap.getInstance();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpAsyncInResponseChannel ctor, bufferSize=" + this.bufferSize);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int discriminate(VirtualConnection virtualConnection, Object object) {
        byte[] byArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.discriminate()... ", new Object[]{virtualConnection});
        }
        int n = 0;
        HttpRequestMessage httpRequestMessage = (HttpRequestMessage)object;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Checking request URI: " + httpRequestMessage.getRequestURI());
        }
        if ((byArray = httpRequestMessage.getRequestURIAsByteArray()).length >= ASYNC_RESP_CR_AS_BYTES.length) {
            n = 1;
            for (int i = 0; n == 1 && i < ASYNC_RESP_CR_AS_BYTES.length; ++i) {
                if (byArray[i] == ASYNC_RESP_CR_AS_BYTES[i]) continue;
                n = 0;
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Discriminate process has yielded the following answer: " + n);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "discriminate");
        }
        return n;
    }

    public void cleanUpState(VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.cleanUpState()...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncInResponseChannel.cleanUpState().");
        }
    }

    public Class getDiscriminatoryDataType() {
        return this.inHttpDiscrimDataType;
    }

    public Channel getChannel() {
        return this;
    }

    public int getWeight() {
        return this.getConfig().getDiscriminatorWeight();
    }

    public Discriminator getDiscriminator() {
        return this;
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        ConnectionLink connectionLink;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.getConnectionLink()...", new Object[]{virtualConnection});
        }
        if ((connectionLink = (ConnectionLink)virtualConnection.getStateMap().get(ASYNC_RESP_ACL_NAME)) == null) {
            connectionLink = this.httpAsyRpChanFactory.getAsyInRspLnk(virtualConnection, this);
            virtualConnection.getStateMap().put(ASYNC_RESP_ACL_NAME, connectionLink);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncInResponseChannel.getConnectionLink()");
        }
        return connectionLink;
    }

    public void releaseConnectionLink(AsyncInResponseConnLink asyncInResponseConnLink) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.releaseConnectionLink()...");
        }
        this.httpAsyRpChanFactory.releaseAsyInRspLnk(asyncInResponseConnLink);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncInResponseChannel.releaseConnectionLink()");
        }
    }

    public void start() throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.start()...");
        }
        if (this.asyRCMap == null) {
            throw new ChannelException("Async Response Context HashMap has not been set.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncInResponseChannel.start()");
        }
    }

    public void stop(long l) throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.stop()...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncInResponseChannel.stop()");
        }
    }

    public void init() throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.init()... " + this.getName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncInResponseChannel.init().");
        }
    }

    public void destroy() throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.destroy()...");
        }
        this.httpAsyRpChanFactory = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncInResponseChannel.destroy().");
        }
    }

    public Class getDeviceInterface() {
        return this.HttpInbDeviceIntf;
    }

    public void update(ChannelData channelData) {
        super.setConfig(channelData);
    }
}

