/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.policyset.Constants;
import com.ibm.wsspi.websvcs.Axis2ServiceConfigPlugin;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.sandesha2.client.SandeshaClientConstants;

public class RMServiceConfigPlugin
implements Axis2ServiceConfigPlugin {
    private static final TraceComponent tc = Tr.register(RMServiceConfigPlugin.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");

    public static boolean isManagedPersistentQOS(AxisConfiguration axisConfiguration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isManagedPersistentQOS", axisConfiguration);
        }
        boolean bl = false;
        String string = null;
        Parameter parameter = axisConfiguration.getParameter(Constants._QUALITY_OF_SERVICE);
        if (parameter != null) {
            string = (String)parameter.getValue();
        }
        if (Constants._MANAGED_PERSISTENT.equals(string)) {
            bl = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isManagedPersistentQOS", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isManagedQOS(AxisConfiguration axisConfiguration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isManagedQOS", axisConfiguration);
        }
        boolean bl = false;
        String string = null;
        Parameter parameter = axisConfiguration.getParameter(Constants._QUALITY_OF_SERVICE);
        if (parameter != null) {
            string = (String)parameter.getValue();
        }
        if (Constants._MANAGED_PERSISTENT.equals(string) || Constants._MANAGED_NON_PERSISTENT.equals(string)) {
            bl = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isManagedQOS", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isUnManagedQOS(AxisConfiguration axisConfiguration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isUnManagedQOS", axisConfiguration);
        }
        boolean bl = false;
        String string = null;
        Parameter parameter = axisConfiguration.getParameter(Constants._QUALITY_OF_SERVICE);
        if (parameter != null) {
            string = (String)parameter.getValue();
        }
        if (Constants._UNMANAGED_NON_PERSISTENT.equals(string)) {
            bl = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isUnManagedQOS", bl);
        }
        return bl;
    }

    public static boolean isInorder(AxisConfiguration axisConfiguration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isInorder", axisConfiguration);
        }
        boolean bl = false;
        String string = null;
        Parameter parameter = axisConfiguration.getParameter(Constants._IN_ORDER_DELIVERY);
        if (parameter != null) {
            string = (String)parameter.getValue();
        }
        if (string != null && "true".equalsIgnoreCase(string)) {
            bl = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isInorder", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isUseMakeConnection(AxisConfiguration axisConfiguration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isUseMakeConnection", axisConfiguration);
        }
        boolean bl = false;
        String string = null;
        Parameter parameter = axisConfiguration.getParameter(Constants._USE_MAKECONNECTION);
        if (parameter != null) {
            string = (String)parameter.getValue();
        }
        if (string != null && "true".equalsIgnoreCase(string)) {
            bl = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isUseMakeConnection", new Boolean(bl));
        }
        return bl;
    }

    public static String getBusName(AxisConfiguration axisConfiguration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getBusName", axisConfiguration);
        }
        String string = null;
        Parameter parameter = axisConfiguration.getParameter(Constants._BUS_NAME);
        if (parameter != null) {
            string = (String)parameter.getValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getBusName", string);
        }
        return string;
    }

    public static String getMessagingEngineName(AxisConfiguration axisConfiguration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessagingEngineName", axisConfiguration);
        }
        String string = null;
        Parameter parameter = axisConfiguration.getParameter(Constants._MESSAGING_ENGINE_NAME);
        if (parameter != null) {
            string = (String)parameter.getValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessagingEngineName", string);
        }
        return string;
    }

    public RMServiceConfigPlugin() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "RMServiceConfigPlugin");
            Tr.exit(tc, "RMServiceConfigPlugin", this);
        }
    }

    public void config(HashMap hashMap) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "config", hashMap);
        }
        AxisService axisService = (AxisService)hashMap.get("com.ibm.wsspi.websvcs.AxisServiceKey");
        this.configureService(axisService);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "config");
        }
    }

    private void disableRMForAllServices(AxisService axisService) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "disableRMForAllServices", axisService);
        }
        this.turnRMOffForService(axisService);
        Iterator iterator = axisService.getAxisConfiguration().getServices().values().iterator();
        while (iterator.hasNext()) {
            this.turnRMOffForService((AxisService)iterator.next());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "disableRMForAllServices", axisService);
        }
    }

    private void turnRMOffForService(AxisService axisService) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "turnRMOffForService", axisService);
        }
        Parameter parameter = new Parameter(SandeshaClientConstants.UNRELIABLE_MESSAGE, "true");
        axisService.addParameter(parameter);
        Parameter parameter2 = new Parameter("DisableResponseAck", null);
        axisService.removeParameter(parameter2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "turnRMOffForService");
        }
    }

    private void configureService(AxisService axisService) throws AxisFault {
        Object object;
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "configureService", axisService);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "service details ", new Object[]{axisService.getBindingName(), axisService.getAxisConfiguration(), axisService.getAxisConfiguration().getKey(), axisService.getClassLoader(), axisService.getKey(), axisService.getServiceDescription(), axisService.getName(), axisService.getTargetNamespace()});
        }
        Parameter parameter = axisService.getParameter("WASAxis2PolicySet");
        AxisConfiguration axisConfiguration = axisService.getAxisConfiguration();
        PolicySetConfiguration policySetConfiguration = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (parameter != null) {
            policySetConfiguration = (PolicySetConfiguration)parameter.getValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved policy set " + policySetConfiguration);
            }
            string = (String)policySetConfiguration.getPolicyTypeConfiguration(Constants._QUALITY_OF_SERVICE);
            string2 = (String)policySetConfiguration.getPolicyTypeConfiguration(Constants._IN_ORDER_DELIVERY);
            string3 = (String)policySetConfiguration.getPolicyTypeConfiguration(Constants._USE_MAKECONNECTION);
            string4 = (String)policySetConfiguration.getPolicyTypeConfiguration(SandeshaClientConstants.RM_SPEC_VERSION);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved Qos " + string + " inorder = " + string2 + " useMakeConnection = " + string3 + " specVersion = " + string4);
            }
        }
        Parameter parameter2 = new Parameter(SandeshaClientConstants.RM_SPEC_VERSION, string4);
        if (axisService != null && axisService.getParameter(SandeshaClientConstants.UNRELIABLE_MESSAGE) != null && Boolean.TRUE.equals(axisService.getParameter(SandeshaClientConstants.UNRELIABLE_MESSAGE).getValue())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "RM already disabled for service " + axisService);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "configureService");
            }
            return;
        }
        if (string == null) {
            this.turnRMOffForService(axisService);
        } else {
            if (axisConfiguration.getParameter(Constants._QUALITY_OF_SERVICE) != null && !axisConfiguration.getParameter(Constants._QUALITY_OF_SERVICE).getValue().equals(string)) {
                this.disableRMForAllServices(axisService);
                AxisFault axisFault = new AxisFault(nls.getFormattedMessage("TEMPORARY_CWSKA9999", new Object[]{"There is a policy set conflict for the parameter " + Constants._QUALITY_OF_SERVICE + "which cannot be set to the values " + axisConfiguration.getParameter(Constants._QUALITY_OF_SERVICE).getValue() + "and " + string + "across services in the same application module."}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "configureService", axisFault);
                }
                throw axisFault;
            }
            axisConfiguration.addParameter(new Parameter(Constants._QUALITY_OF_SERVICE, string));
            if (axisConfiguration.getParameter(Constants._IN_ORDER_DELIVERY) != null && !axisConfiguration.getParameter(Constants._IN_ORDER_DELIVERY).getValue().equals(string2)) {
                this.disableRMForAllServices(axisService);
                AxisFault axisFault = new AxisFault(nls.getFormattedMessage("TEMPORARY_CWSKA9999", new Object[]{"There is a policy set conflict for the parameter " + Constants._IN_ORDER_DELIVERY + "which cannot be set to the values " + axisConfiguration.getParameter(Constants._IN_ORDER_DELIVERY).getValue() + "and " + string2 + "across services in the same application module."}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "configureService", axisFault);
                }
                throw axisFault;
            }
            axisConfiguration.addParameter(new Parameter(Constants._IN_ORDER_DELIVERY, string2));
            if (axisConfiguration.getParameter(Constants._USE_MAKECONNECTION) != null && !axisConfiguration.getParameter(Constants._USE_MAKECONNECTION).getValue().equals(string3)) {
                this.disableRMForAllServices(axisService);
                AxisFault axisFault = new AxisFault(nls.getFormattedMessage("TEMPORARY_CWSKA9999", new Object[]{"There is a policy set conflict for the parameter " + Constants._USE_MAKECONNECTION + "which cannot be set to the values " + axisConfiguration.getParameter(Constants._USE_MAKECONNECTION).getValue() + "and " + string3 + "across services in the same application module."}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "configureService", axisFault);
                }
                throw axisFault;
            }
            axisConfiguration.addParameter(new Parameter(Constants._USE_MAKECONNECTION, string3));
            if (axisConfiguration.getParameter(SandeshaClientConstants.RM_SPEC_VERSION) != null && !axisConfiguration.getParameter(SandeshaClientConstants.RM_SPEC_VERSION).getValue().equals(string4)) {
                this.disableRMForAllServices(axisService);
                AxisFault axisFault = new AxisFault(nls.getFormattedMessage("TEMPORARY_CWSKA9999", new Object[]{"There is a policy set conflict for the parameter " + SandeshaClientConstants.RM_SPEC_VERSION + "which cannot be set to the values " + axisConfiguration.getParameter(SandeshaClientConstants.RM_SPEC_VERSION).getValue() + "and " + string4 + "across services in the same application module."}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "configureService", axisFault);
                }
                throw axisFault;
            }
            axisConfiguration.addParameter(parameter2);
        }
        if (policySetConfiguration != null && axisConfiguration != null) {
            object2 = (String)policySetConfiguration.getPolicyTypeBinding(Constants._BUS_NAME);
            if (string != null && axisConfiguration.getParameter(Constants._BUS_NAME) != null && axisConfiguration.getParameter(Constants._BUS_NAME).getValue() != null && !axisConfiguration.getParameter(Constants._BUS_NAME).getValue().equals(object2)) {
                this.disableRMForAllServices(axisService);
                AxisFault axisFault = new AxisFault(nls.getFormattedMessage("TEMPORARY_CWSKA9999", new Object[]{"There is a policy set conflict for the parameter " + Constants._BUS_NAME + "which cannot be set to the values " + axisConfiguration.getParameter(Constants._BUS_NAME).getValue() + "and " + (String)object2 + "across services in the same application module."}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "configureService", axisFault);
                }
                throw axisFault;
            }
            axisConfiguration.addParameter(new Parameter(Constants._BUS_NAME, object2));
            object = (String)policySetConfiguration.getPolicyTypeBinding(Constants._MESSAGING_ENGINE_NAME);
            if (string != null && axisConfiguration.getParameter(Constants._MESSAGING_ENGINE_NAME) != null && axisConfiguration.getParameter(Constants._MESSAGING_ENGINE_NAME).getValue() != null && !axisConfiguration.getParameter(Constants._MESSAGING_ENGINE_NAME).getValue().equals(object)) {
                this.turnRMOffForService(axisService);
                AxisFault axisFault = new AxisFault(nls.getFormattedMessage("TEMPORARY_CWSKA9999", new Object[]{"There is a policy set conflict for the parameter " + Constants._MESSAGING_ENGINE_NAME + "which cannot be set to the values " + axisConfiguration.getParameter(Constants._MESSAGING_ENGINE_NAME).getValue() + "and " + (String)object + "across services in the same application module."}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "configureService", axisFault);
                }
                throw axisFault;
            }
            axisConfiguration.addParameter(new Parameter(Constants._MESSAGING_ENGINE_NAME, object));
        }
        if ((object2 = axisService.getAxisConfiguration().getParameter("_WSRM_MODULE_")) != null) {
            if (string != null) {
                object = (WSRMModule)((Parameter)object2).getValue();
                ((WSRMModule)object).doInitialization();
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "configureService", "IllegalStateException");
            }
            throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"RMServiceConfigPlugin", "1:521:1.32"}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "configureService");
        }
    }
}

