/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicyTypeLoader;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.policyset.Constants;
import com.ibm.ws.websvcs.rm.policyset.WSRMProvider;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.sandesha2.client.SandeshaClientConstants;

public class RMPolicyTypeLoader
implements PolicyTypeLoader {
    private static final TraceComponent tc = Tr.register(RMPolicyTypeLoader.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private WSRMProvider helper;

    public RMPolicyTypeLoader() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "RMPolicyTypeLoader");
        }
        this.helper = new WSRMProvider();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "RMPolicyTypeLoader", this);
        }
    }

    public String getType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getType");
            Tr.exit(tc, "getType", Constants._TYPE_NAME);
        }
        return Constants._TYPE_NAME;
    }

    public void init(Map map) {
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        this.helper = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void load(ClassLoader classLoader, VariableExpander variableExpander, InputStream inputStream, PolicySetConfiguration policySetConfiguration) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "load", new Object[]{classLoader, variableExpander, inputStream, policySetConfiguration});
        }
        try {
            Properties properties = this.helper.getAttributes(inputStream, null);
            String string = properties.getProperty(Constants._SPEC_LEVEL);
            String string2 = properties.getProperty(Constants._QUALITY_OF_SERVICE);
            String string3 = properties.getProperty(Constants._IN_ORDER_DELIVERY);
            String string4 = properties.getProperty(Constants._USE_MAKECONNECTION);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "spec level=" + string + ", qos=" + string2 + ", inOrder=" + string3 + " useMakeConnection=" + string4);
            }
            if (string.equals(Constants._WSRM_1_0)) {
                policySetConfiguration.setPolicyTypeConfiguration(SandeshaClientConstants.RM_SPEC_VERSION, "Spec_2005_02");
            } else {
                policySetConfiguration.setPolicyTypeConfiguration(SandeshaClientConstants.RM_SPEC_VERSION, "Spec_2007_02");
            }
            policySetConfiguration.setPolicyTypeConfiguration(Constants._QUALITY_OF_SERVICE, string2);
            if (string2.equals(Constants._UNMANAGED_NON_PERSISTENT)) {
                if (WSRMModule.isRunningOnZOs() && !WSRMModule.isRunningInClientJVM()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "load", "IllegalStateException - Running in non-client on zOS");
                    }
                    throw new IllegalStateException(nls.getFormattedMessage("INVALID_PROPERTY_ERROR_CWSKA0352", null, null));
                }
                if (WSRMModule.getClusterName() != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "load", "IllegalStateException - Running in cluster without managed!");
                    }
                    throw new IllegalStateException(nls.getFormattedMessage("TEMPORARY_CWSKA9999", new Object[]{"A clustered environment must use a Web services reliable messaging managed persistent or managed non-persistent quality of service"}, null));
                }
                policySetConfiguration.setPolicyTypeConfiguration("Sandesha2StorageManager", "inmemory");
            } else {
                policySetConfiguration.setPolicyTypeConfiguration("Sandesha2StorageManager", "persistent");
            }
            policySetConfiguration.setPolicyTypeConfiguration(Constants._IN_ORDER_DELIVERY, string3);
            policySetConfiguration.setPolicyTypeConfiguration(Constants._USE_MAKECONNECTION, string4);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.policyset.RMPolicyTypeLoader.load", "1:164:1.17", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "load", exception);
            }
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "load");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/policyset/RMPolicyTypeLoader.java, WAS.rm, WSFP.WSERV1, cf230905.09 1.17");
        }
    }
}

