/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.BindingLoader;
import com.ibm.ws.policyset.runtime.DefaultBinding;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.websvcs.rm.policyset.Constants;
import com.ibm.ws.websvcs.rm.policyset.WSRMProvider;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class RMBindingLoader
implements BindingLoader {
    private static final TraceComponent tc = Tr.register(RMBindingLoader.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private WSRMProvider helper;

    public RMBindingLoader() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "RMBindingLoader");
        }
        this.helper = new WSRMProvider();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "RMBindingLoader", this);
        }
    }

    public String getType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getType");
            Tr.exit(tc, "getType", Constants._TYPE_NAME);
        }
        return Constants._TYPE_NAME;
    }

    public void init(Map map) {
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        this.helper = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void loadDefault(ClassLoader classLoader, VariableExpander variableExpander, InputStream inputStream, DefaultBinding defaultBinding) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "loadDefault", new Object[]{classLoader, variableExpander, inputStream, defaultBinding});
        }
        try {
            if (inputStream != null) {
                Properties properties = this.helper.getBinding(inputStream, null);
                String string = properties.getProperty(Constants._BUS_NAME);
                String string2 = properties.getProperty(Constants._MESSAGING_ENGINE_NAME);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bus, MessagingEngine:", new String[]{string, string2});
                }
                defaultBinding.setDefaultBinding(Constants._BUS_NAME, string);
                defaultBinding.setDefaultBinding(Constants._MESSAGING_ENGINE_NAME, string2);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No default binding file to load");
                }
                defaultBinding.setDefaultBinding(Constants._BUS_NAME, null);
                defaultBinding.setDefaultBinding(Constants._MESSAGING_ENGINE_NAME, null);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.policyset.RMBindingLoader.loadDefault", "1:140:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "loadDefault", exception);
            }
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "loadDefault");
        }
    }

    public void loadCustom(ClassLoader classLoader, ClassLoader classLoader2, VariableExpander variableExpander, InputStream inputStream, DefaultBinding defaultBinding, PolicySetConfiguration policySetConfiguration) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCustom", new Object[]{classLoader, classLoader2, variableExpander, inputStream, defaultBinding, policySetConfiguration});
        }
        String string = null;
        String string2 = null;
        try {
            Object object;
            if (inputStream != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "custom binding found");
                }
                object = this.helper.getBinding(inputStream, null);
                string = ((Properties)object).getProperty(Constants._BUS_NAME);
                string2 = ((Properties)object).getProperty(Constants._MESSAGING_ENGINE_NAME);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using custom {Bus, messagingEngine}: ", new String[]{string, string2});
                }
            }
            if (string == null || string.trim().equals("")) {
                string = (String)defaultBinding.getDefaultBinding(Constants._BUS_NAME);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "using default bus " + string);
                }
            }
            if (string2 == null || string2.trim().equals("")) {
                string2 = (String)defaultBinding.getDefaultBinding(Constants._MESSAGING_ENGINE_NAME);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "using default messaging engine " + string2);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Final {Bus, MesagingEngine}: ", new String[]{string, string2});
            }
            policySetConfiguration.setPolicyTypeBinding(Constants._BUS_NAME, string);
            policySetConfiguration.setPolicyTypeBinding(Constants._MESSAGING_ENGINE_NAME, string2);
            if (string == null || string2 == null) {
                object = (String)policySetConfiguration.getPolicyTypeConfiguration(Constants._QUALITY_OF_SERVICE);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "QOS is ", object);
                }
                if (Constants._MANAGED_PERSISTENT.equals(object) || Constants._MANAGED_NON_PERSISTENT.equals(object)) {
                    IllegalStateException illegalStateException = new IllegalStateException(nls.getFormattedMessage("MISSING_PROPERTY_ERROR_CWSKA0351", null, null));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadCustom", illegalStateException);
                    }
                    throw illegalStateException;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.policyset.RMBindingLoader.loadCustom", "1:215:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "loadCustom", exception);
            }
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCustom");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/policyset/RMBindingLoader.java, WAS.rm, WSFP.WSERV1, cf230905.09 1.16");
        }
    }
}

