/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.mbeans.dao;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.sandesha2.util.SpecSpecificConstants;

public abstract class SequenceData
implements Serializable {
    public static final String UNKNOWN = "UNKNOWN DATA";
    public static final String MANAGED_PERSISTENT_RELIABILITY = "Managed persitent";
    public static final String MANAGED_NON_PERSISTENT_RELIABILITY = "Managed non-persitent";
    public static final String UNMANAGED_RELIABILITY = "Unmanaged non-persitent";
    public final String sequenceID;
    public final String applicationName;
    public final String wsa_namespace;
    public final String wsrm_namespace;
    public final String wsrm_spec_version;
    public final SequenceState sequenceState;
    public final String acksToAddress;
    public final String targetAddress;
    public final String replyToAddress;
    public final List info_completedMessages;
    public final String info_faultData = "NONE";
    public final String info_reliability = "UNKNOWN DATA";
    public final String info_workKey;

    public SequenceData(String string, String string2, String string3, String string4, SequenceState sequenceState, String string5, String string6, String string7, List list, String string8) {
        this.sequenceID = string == null ? UNKNOWN : string;
        this.applicationName = string2;
        this.wsa_namespace = string3;
        this.wsrm_spec_version = string4;
        String string9 = null;
        try {
            string9 = SpecSpecificConstants.getRMNamespaceValue(string4);
        }
        catch (Exception exception) {
            string9 = null;
        }
        this.wsrm_namespace = string9;
        this.sequenceState = sequenceState;
        this.acksToAddress = string5;
        this.targetAddress = string6;
        this.replyToAddress = string7;
        this.info_completedMessages = list != null ? Collections.unmodifiableList(list) : null;
        this.info_workKey = string8;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SequenceData)) {
            return false;
        }
        boolean bl = true;
        SequenceData sequenceData = (SequenceData)object;
        if (!sequenceData.sequenceState.equals(this.sequenceState)) {
            bl = false;
        } else if (!this.sequenceID.equals(sequenceData.sequenceID)) {
            bl = false;
        } else if (!this.applicationName.equals(sequenceData.applicationName)) {
            bl = false;
        } else if (!this.targetAddress.equals(sequenceData.targetAddress)) {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return "Sequence  to " + this.targetAddress + " for application " + this.applicationName + " : " + this.sequenceState;
    }

    public static class SequenceState
    implements Serializable {
        private static final long serialVersionUID = -7857646526398439444L;
        public final int state;
        public final String state_description;
        public final boolean is_error_state;
        public final boolean is_warning_state;

        protected SequenceState(int n, String string, boolean bl, boolean bl2) {
            this.state = n;
            this.state_description = string;
            this.is_error_state = bl;
            this.is_warning_state = bl2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SequenceState)) {
                return false;
            }
            boolean bl = true;
            SequenceState sequenceState = (SequenceState)object;
            if (sequenceState.state != this.state) {
                bl = false;
            } else if (!sequenceState.state_description.equals(this.state_description)) {
                bl = false;
            } else if (sequenceState.is_error_state != this.is_error_state) {
                bl = false;
            } else if (sequenceState.is_warning_state != this.is_warning_state) {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return this.state_description;
        }
    }
}

