/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.mbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.websvcs.rm.mbeans.AbstractWSRMMBean;
import com.ibm.ws.websvcs.rm.storage.controller.ControllableStore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WSRMApplicationMBean
extends AbstractWSRMMBean {
    private static final TraceComponent tc = Tr.register(WSRMApplicationMBean.class, "SIBWSRM", "com.ibm.ws.sib.wsrm.CWSJZMessages");
    public static final String MBEAN_TYPE = "WSRMApplicationMBean";
    public static final String WSRM_CELL_PROPERTY = "cell";
    public static final String WSRM_CLUSTER_PROPERTY = "cluster";
    public static final String WSRM_NODE_PROPERTY = "node";
    public static final String WSRM_SERVER_PROPERTY = "server";
    public static final String WSRM_APP_PROPERTY = "application";
    public static final String WSRM_APP_MODULE_PROPERTY = "application_module";
    private static HashMap registeredMBeans;

    public WSRMApplicationMBean(ControllableStore controllableStore) {
        super(controllableStore, MBEAN_TYPE);
    }

    private static synchronized void eventMBeanRegistered(WSRMApplicationMBean wSRMApplicationMBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventMBeanRegistered", (Object)wSRMApplicationMBean);
        }
        registeredMBeans.put(wSRMApplicationMBean.mbean_name, wSRMApplicationMBean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventMBeanRegistered");
        }
    }

    private static synchronized boolean applicationAlreadyHasMBeanRegistered(WSRMApplicationMBean wSRMApplicationMBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"applicationAlreadyHasMBeanRegistered", (Object)wSRMApplicationMBean);
        }
        boolean bl = false;
        if (registeredMBeans.containsKey(wSRMApplicationMBean.mbean_name)) {
            bl = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"applicationAlreadyHasMBeanRegistered", (Object)new Boolean(bl));
        }
        return bl;
    }

    private static synchronized void eventMBeanDeRegistered(WSRMApplicationMBean wSRMApplicationMBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventMBeanDeRegistered", (Object)wSRMApplicationMBean);
        }
        registeredMBeans.remove(wSRMApplicationMBean.mbean_name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventMBeanDeRegistered");
        }
    }

    public static synchronized void deregisterAllMBeans() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterAllMBeans");
        }
        Collection collection = ((Map)registeredMBeans.clone()).values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                ((WSRMApplicationMBean)iterator.next()).deregister();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.websvcs.rm.mbeans.WSRMApplicationMBean.deregisterAllMBeans", "1:192:1.8");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterAllMBeans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"register");
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!WSRMApplicationMBean.applicationAlreadyHasMBeanRegistered(this)) {
                super.register();
                WSRMApplicationMBean.eventMBeanRegistered(this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"register");
        }
    }

    public void deregister() throws AdminException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregister");
        }
        if (this.isRegistered) {
            super.deregister();
            WSRMApplicationMBean.eventMBeanDeRegistered(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregister");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/sib.wsrm/src/com/ibm/ws/websvcs/rm/mbeans/WSRMApplicationMBean.java, SIB.rm, WSFP.WSERV1, cf230905.09 1.8");
        }
        registeredMBeans = new HashMap();
    }
}

