/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.mbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.websvcs.rm.mbeans.dao.InboundSequenceData;
import com.ibm.ws.websvcs.rm.mbeans.dao.MessageData;
import com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData;
import com.ibm.ws.websvcs.rm.mbeans.dao.SequenceData;
import com.ibm.ws.websvcs.rm.mbeans.dao.StorageManagerDetail;
import com.ibm.ws.websvcs.rm.mbeans.exceptions.WSRMMBeanException;
import com.ibm.ws.websvcs.rm.storage.controller.ControllableStore;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Locale;

public abstract class AbstractWSRMMBean {
    private static final TraceComponent tc = Tr.register(AbstractWSRMMBean.class, "SIBWSRM", "com.ibm.ws.sib.wsrm.CWSJZMessages");
    protected ControllableStore store;
    protected String mbean_name;
    protected String mbean_type;
    protected String mbean_description;
    protected boolean isRegistered = false;

    public AbstractWSRMMBean(ControllableStore controllableStore, String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AbstractWSRMMBean", (Object)new Object[]{controllableStore, string});
        }
        this.store = controllableStore;
        StorageManagerDetail storageManagerDetail = controllableStore.getStorageManagerDetails(null);
        this.mbean_name = storageManagerDetail.storageManagerName;
        this.mbean_type = string;
        this.mbean_description = storageManagerDetail.storageManagerDescription;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AbstractWSRMMBean", (Object)this);
        }
    }

    public synchronized void register() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"register");
        }
        if (!this.isRegistered) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
                    String string = null;
                    String string2 = AbstractWSRMMBean.this.mbean_name;
                    DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(AbstractWSRMMBean.this, AbstractWSRMMBean.this.mbean_name);
                    try {
                        mBeanFactory.activateMBean(AbstractWSRMMBean.this.mbean_type, defaultRuntimeCollaborator, string2, string, AbstractWSRMMBean.this.store.getProperties());
                    }
                    catch (AdminException adminException) {
                        throw new RuntimeException(adminException);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"registerd jmx ", (Object)new Object[]{AbstractWSRMMBean.this, AbstractWSRMMBean.this.mbean_type, defaultRuntimeCollaborator, string2, string});
                    }
                    return null;
                }
            });
            this.isRegistered = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"register");
        }
    }

    public synchronized void deregister() throws AdminException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregister");
        }
        if (this.isRegistered) {
            MBeanFactory mBeanFactory = (MBeanFactory)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return AdminServiceFactory.getMBeanFactory();
                }
            });
            mBeanFactory.deactivateMBean(this.mbean_name);
            this.isRegistered = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregister");
        }
    }

    public String getMBeanID() {
        return this.mbean_name;
    }

    public StorageManagerDetail getStorageManagerDetails() {
        return this.store.getStorageManagerDetails(Locale.getDefault());
    }

    public StorageManagerDetail getStorageManagerDetails(Locale locale) {
        return this.store.getStorageManagerDetails(locale);
    }

    public boolean hasProblemInboundSequences() throws WSRMMBeanException {
        return this.store.getInboundSequences(true, false, null).size() > 0;
    }

    public boolean hasWarningInboundSequences() throws WSRMMBeanException {
        return this.store.getInboundSequences(false, true, null).size() > 0;
    }

    public Collection getAllProblemInboundSequences() throws WSRMMBeanException {
        return this.store.getInboundSequences(true, false, null);
    }

    public Collection getAllWarningInboundSequences() throws WSRMMBeanException {
        return this.store.getInboundSequences(false, true, null);
    }

    public Collection getAllOutboundSequences() throws WSRMMBeanException {
        return this.store.getOutboundSequences(false, false, null);
    }

    public boolean hasProblemOutboundSequences() throws WSRMMBeanException {
        return this.store.getOutboundSequences(true, false, null).size() > 0;
    }

    public boolean hasWarningOutboundSequences() throws WSRMMBeanException {
        return this.store.getOutboundSequences(false, true, null).size() > 0;
    }

    public Collection getAllProblemOutboundSequences() throws WSRMMBeanException {
        return this.store.getOutboundSequences(true, false, null);
    }

    public Collection getAllWarningOutboundSequences() throws WSRMMBeanException {
        return this.store.getOutboundSequences(false, true, null);
    }

    public Collection getAllInboundSequences() throws WSRMMBeanException {
        return this.store.getInboundSequences(false, false, null);
    }

    public Collection getAllOutboundMessagesOnSequence(OutboundSequenceData outboundSequenceData) throws WSRMMBeanException {
        return this.store.getOutboundMessagesOnSequence(outboundSequenceData);
    }

    public Collection getAllInboundMessagesOnSequence(InboundSequenceData inboundSequenceData) throws WSRMMBeanException {
        return this.store.getInboundMessagesOnSequence(inboundSequenceData);
    }

    public void reallocateMessagesOnOutboundSequence(OutboundSequenceData outboundSequenceData, String string) throws WSRMMBeanException {
        this.store.reallocateOutboundMessagesToNewSequence(outboundSequenceData, string);
    }

    public void deleteSequence(SequenceData sequenceData) throws WSRMMBeanException {
        this.store.deleteSequence(sequenceData);
    }

    public void deleteMessage(MessageData messageData) throws WSRMMBeanException {
        this.store.deleteMessage(messageData);
    }

    public void forceDispatchOfMessagesOnInboundSequence(InboundSequenceData inboundSequenceData) throws WSRMMBeanException {
        this.store.forceDispatchOfInboundMessages(inboundSequenceData);
    }

    public SequenceData refreshSequenceData(SequenceData sequenceData) throws WSRMMBeanException {
        return this.store.refreshSequenceData(sequenceData);
    }

    public byte[][] writeMessagesToDisk(SequenceData sequenceData) throws WSRMMBeanException {
        byte[][] byArray = this.store.writeOutstandingSequenceMessagesToBuffer(sequenceData);
        return byArray;
    }

    public void closeSequence(SequenceData sequenceData) throws WSRMMBeanException {
        this.store.closeSequence(sequenceData);
    }

    public void terminateSequence(SequenceData sequenceData) throws WSRMMBeanException {
        this.store.terminateSequence(sequenceData);
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/sib.wsrm/src/com/ibm/ws/websvcs/rm/mbeans/AbstractWSRMMBean.java, SIB.rm, WSFP.WSERV1, cf230905.09 1.17");
        }
    }
}

