/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage.beanmanagers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.wsrm.WSRMConstants;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton;
import java.util.HashMap;
import java.util.List;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.SenderBean;

public class SenderBeanMgrImpl
implements SenderBeanMgr {
    private static final TraceComponent tc = Tr.register(SenderBeanMgrImpl.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private PersistentStorageManagerSingleton _storageManager;

    public SenderBeanMgrImpl(PersistentStorageManagerSingleton persistentStorageManagerSingleton) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SenderBeanMgrImpl", new Object[]{persistentStorageManagerSingleton});
        }
        this._storageManager = persistentStorageManagerSingleton;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SenderBeanMgrImpl", this);
        }
    }

    public boolean delete(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "delete", string);
        }
        this._storageManager.getInUseTransaction().deleteSenderBean(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "delete", Boolean.TRUE);
        }
        return true;
    }

    public SenderBean retrieve(String string) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieve", string);
        }
        String[] stringArray = new String[]{this._storageManager.getWorkKey(), string, this._storageManager.getInUseTransaction().getSequenceToken()};
        HashMap hashMap = this._storageManager.getCommandInvoker().retrieveSenderBean(stringArray);
        SenderBean senderBean = null;
        if (hashMap != null) {
            senderBean = (SenderBean)hashMap.get(WSRMConstants.SENDER_BEAN);
            String string2 = (String)hashMap.get("TOKEN");
            this._storageManager.getInUseTransaction().setSequenceToken(string2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieve", senderBean);
        }
        return senderBean;
    }

    public boolean insert(SenderBean senderBean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", senderBean);
        }
        if (senderBean.getMessageID() == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "insert", "SandeshaStorageException");
            }
            throw new SandeshaStorageException("Key (MessageId) is null. Cant insert.");
        }
        this._storageManager.getInUseTransaction().insertSenderBean(senderBean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insert", Boolean.TRUE);
        }
        return true;
    }

    public List find(String string) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "find", string);
        }
        String[] stringArray = new String[]{this._storageManager.getWorkKey(), string, this._storageManager.getInUseTransaction().getSequenceToken()};
        HashMap hashMap = this._storageManager.getCommandInvoker().findSenderBeansForSequence2(stringArray);
        List list = null;
        if (hashMap == null) {
            list = this._storageManager.getCommandInvoker().findSenderBeansForSequence(stringArray);
        } else {
            list = (List)hashMap.get(WSRMConstants.SENDER_BEAN);
            String string2 = (String)hashMap.get("TOKEN");
            this._storageManager.getInUseTransaction().setSequenceToken(string2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "find", list);
        }
        return list;
    }

    public List find(SenderBean senderBean) throws SandeshaStorageException {
        Object object;
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "find", new Object[]{senderBean});
        }
        Object[] objectArray = new Object[]{this._storageManager.getWorkKey(), senderBean, this._storageManager.getInUseTransaction().getSequenceToken()};
        HashMap hashMap = this._storageManager.getCommandInvoker().findSenderBeansWithLock(objectArray);
        List list = null;
        if (hashMap == null) {
            list = this._storageManager.getCommandInvoker().findSenderBeans(objectArray);
        } else {
            list = (List)hashMap.get(WSRMConstants.SENDER_BEAN);
            object2 = (String)hashMap.get("TOKEN");
            object = (HashMap)hashMap.get("MSG_CONTEXTS");
            this._storageManager.getInUseTransaction().setSequenceToken((String)object2);
            if (object != null) {
                for (String string : ((HashMap)object).keySet()) {
                    this._storageManager.addMappedKey(string, (String)((HashMap)object).get(string));
                }
            }
        }
        object2 = this._storageManager.getInUseTransaction().getDeletedSenderBeans();
        if (object2 != null && list != null && list.size() > 0) {
            object = list.iterator();
            while (object.hasNext()) {
                SenderBean senderBean2 = (SenderBean)object.next();
                if (!object2.contains(senderBean2.getMessageID())) continue;
                object.remove();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "find", list);
        }
        return list;
    }

    public SenderBean getNextMsgToSend(String string) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextMsgToSend", string);
        }
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        hashMap.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
        hashMap.put(WSRMConstants.APP_KEY, this._storageManager.getApplicationInstanceKey());
        hashMap.put("SEQUENCEID", string);
        hashMap.put("TOKEN", this._storageManager.getInUseTransaction().getSequenceToken());
        HashMap hashMap2 = this._storageManager.getCommandInvoker().getNextMessageToSend(hashMap);
        SenderBean senderBean = null;
        if (hashMap2 != null) {
            senderBean = (SenderBean)hashMap2.get(WSRMConstants.SENDER_BEAN);
            String string2 = (String)hashMap2.get("TOKEN");
            this._storageManager.getInUseTransaction().setSequenceToken(string2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextMsgToSend", senderBean);
        }
        return senderBean;
    }

    public boolean update(SenderBean senderBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "update", new Object[]{senderBean, senderBean.getSequenceID(), senderBean.getInternalSequenceID(), senderBean.getMessageID()});
        }
        this._storageManager.getInUseTransaction().updateSenderBean(senderBean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "update", Boolean.TRUE);
        }
        return true;
    }

    public SenderBean findUnique(SenderBean senderBean) throws SandeshaStorageException {
        List list;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findUnique", senderBean);
        }
        if ((list = this.find(senderBean)).size() > 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "findUnique", "IllegalStateException");
            }
            throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"SenderBeanMgrImpl.findUnique", "1:302:1.24"}, null));
        }
        SenderBean senderBean2 = null;
        if (list.size() == 1) {
            senderBean2 = (SenderBean)list.get(0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findUnique", senderBean2);
        }
        return senderBean2;
    }

    public synchronized SenderBean retrieveFromMessageRefKey(String string) {
        throw new IllegalStateException("Internal error: SenderBeanMgrImpl.retrieveFromMessageRefKey");
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/impl/storage/beanmanagers/SenderBeanMgrImpl.java, WAS.rm, WSFP.WSERV1, cf230905.09 1.24");
        }
    }
}

