/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage.beanmanagers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.wsrm.WSRMConstants;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton;
import com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl;
import java.util.HashMap;
import java.util.List;
import org.apache.axis2.context.MessageContext;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beans.RMSBean;

public class RMSBeanMgrImpl
implements RMSBeanMgr {
    private static final TraceComponent tc = Tr.register(RMSBeanMgrImpl.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private PersistentStorageManagerSingleton _storageManager;

    public RMSBeanMgrImpl(PersistentStorageManagerSingleton persistentStorageManagerSingleton) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "RMSBeanMgrImpl", persistentStorageManagerSingleton);
        }
        this._storageManager = persistentStorageManagerSingleton;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "RMSBeanMgrImpl", this);
        }
    }

    public boolean insert(RMSBean rMSBean, MessageContext messageContext) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", new Object[]{rMSBean, rMSBean.getSequenceID(), rMSBean.getInternalSequenceID(), rMSBean.getCreateSeqMsgID()});
        }
        boolean bl = this._storageManager.getInUseTransaction().insertRMSBean(rMSBean, messageContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insert", bl);
        }
        return bl;
    }

    public boolean delete(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "delete", string);
        }
        this._storageManager.getInUseTransaction().deleteRMSBean(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "delete", Boolean.TRUE);
        }
        return true;
    }

    public RMSBean retrieve(String string) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieve", string);
        }
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        hashMap.put(WSRMConstants.RMS_BEAN, string);
        hashMap.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
        hashMap.put("TOKEN", this._storageManager.getInUseTransaction().getSequenceToken());
        HashMap hashMap2 = this._storageManager.getCommandInvoker().retrieveRMSBean(hashMap);
        RMSBean rMSBean = (RMSBean)hashMap2.get(WSRMConstants.RMS_BEAN);
        this._storageManager.getInUseTransaction().setSequenceToken((String)hashMap2.get("TOKEN"));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieve", rMSBean);
        }
        return rMSBean;
    }

    public boolean update(RMSBean rMSBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "update", rMSBean);
        }
        this._storageManager.getInUseTransaction().updateRMSBean(rMSBean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "update", Boolean.TRUE);
        }
        return true;
    }

    public List find(RMSBean rMSBean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "find", new Object[]{rMSBean.getInternalSequenceID(), rMSBean.getSequenceID()});
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put(WSRMConstants.RMS_BEAN, rMSBean);
        hashMap.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
        hashMap.put("TOKEN", this._storageManager.getInUseTransaction().getSequenceToken());
        HashMap hashMap2 = this._storageManager.getCommandInvoker().findRMSBeans(hashMap);
        this._storageManager.getInUseTransaction().setSequenceToken((String)hashMap2.get("TOKEN"));
        List list = (List)hashMap2.get(WSRMConstants.RMS_BEAN);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "find", list);
        }
        return list;
    }

    public RMSBean findUnique(RMSBean rMSBean) throws SandeshaStorageException {
        RMSBean rMSBean2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findUnique", new Object[]{rMSBean.getInternalSequenceID(), rMSBean.getSequenceID()});
        }
        if ((rMSBean2 = this._storageManager.getInUseTransaction().getRMSBean(rMSBean)) == null) {
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            hashMap.put(WSRMConstants.RMS_BEAN, rMSBean);
            hashMap.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
            hashMap.put("TOKEN", this._storageManager.getInUseTransaction().getSequenceToken());
            HashMap hashMap2 = this._storageManager.getCommandInvoker().findUniqueRMSBean(hashMap);
            if (hashMap2 != null) {
                TransactionImpl transactionImpl = this._storageManager.getInUseTransaction();
                transactionImpl.setSequenceToken((String)hashMap2.get("TOKEN"));
                rMSBean2 = (RMSBean)hashMap2.get(WSRMConstants.RMS_BEAN);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findUnique", rMSBean2);
        }
        return rMSBean2;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/impl/storage/beanmanagers/RMSBeanMgrImpl.java, WAS.rm, WSFP.WSERV1, cf230905.09 1.19");
        }
    }
}

