/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage.beanmanagers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.wsrm.WSRMConstants;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;

public class RMDBeanMgrImpl
implements RMDBeanMgr {
    private static final TraceComponent tc = Tr.register(RMDBeanMgrImpl.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private PersistentStorageManagerSingleton _storageManager;

    public RMDBeanMgrImpl(PersistentStorageManagerSingleton persistentStorageManagerSingleton) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "RMDBeanMgrImpl", new Object[]{persistentStorageManagerSingleton});
        }
        this._storageManager = persistentStorageManagerSingleton;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "RMDBeanMgrImpl", this);
        }
    }

    public boolean delete(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "delete", string);
        }
        this._storageManager.getInUseTransaction().deleteRMDBean(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "delete", Boolean.TRUE);
        }
        return true;
    }

    public RMDBean retrieve(String string) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieve", string);
        }
        RMDBean rMDBean = null;
        rMDBean = this._storageManager.getInUseTransaction().getRMDBean(string);
        if (rMDBean == null) {
            String string2 = this._storageManager.getInUseTransaction().getSequenceToken();
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            hashMap.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
            hashMap.put("TOKEN", string2);
            hashMap.put("SEQUENCEID", string);
            HashMap hashMap2 = this._storageManager.getCommandInvoker().retrieveRMDBean(hashMap);
            if (hashMap2 != null) {
                string2 = (String)hashMap2.remove("TOKEN");
                rMDBean = (RMDBean)hashMap2.remove("RMD_BEAN");
                this._storageManager.getInUseTransaction().setSequenceToken(string2);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieve", rMDBean);
        }
        return rMDBean;
    }

    public boolean insert(RMDBean rMDBean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", rMDBean);
        }
        boolean bl = this._storageManager.getInUseTransaction().insertRMDBean(rMDBean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insert", bl);
        }
        return bl;
    }

    public List find(RMDBean rMDBean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "find", rMDBean);
        }
        ArrayList arrayList = null;
        if (rMDBean.getSequenceID() != null && !rMDBean.isPollingMode()) {
            RMDBean rMDBean2 = this.retrieve(rMDBean.getSequenceID());
            arrayList = new ArrayList();
            arrayList.add(rMDBean2);
        } else {
            String string = this._storageManager.getInUseTransaction().getSequenceToken();
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            hashMap.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
            hashMap.put("TOKEN", string);
            hashMap.put("RMD_BEAN", rMDBean);
            HashMap hashMap2 = this._storageManager.getCommandInvoker().findRMDBeans(hashMap);
            string = (String)hashMap2.remove("TOKEN");
            this._storageManager.getInUseTransaction().setSequenceToken(string);
            arrayList = (ArrayList)hashMap2.remove("RMD_BEAN");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "find", arrayList);
        }
        return arrayList;
    }

    public boolean update(RMDBean rMDBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "update", rMDBean);
        }
        this._storageManager.getInUseTransaction().updateRMDBean(rMDBean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "update", Boolean.TRUE);
        }
        return true;
    }

    public RMDBean findUnique(RMDBean rMDBean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findUnique", rMDBean);
        }
        RMDBean rMDBean2 = this.retrieve(rMDBean.getSequenceID());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findUnique", rMDBean2);
        }
        return rMDBean2;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/impl/storage/beanmanagers/RMDBeanMgrImpl.java, WAS.rm, WSFP.WSERV1, cf230905.09 1.17");
        }
    }
}

