/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.HashMap;
import java.util.List;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMSBean;

public class WSReliableMessagingStorageManagerMap {
    private static final TraceComponent tc = Tr.register(WSReliableMessagingStorageManagerMap.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls;
    private static HashMap storageManagerMap;

    private WSReliableMessagingStorageManagerMap() {
    }

    public static synchronized boolean isStorageManagerInMap(String string) {
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isStorageManagerInMap", string);
        }
        boolean bl2 = bl = storageManagerMap.get(string) != null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isStorageManagerInMap", new Boolean(bl));
        }
        return bl;
    }

    public static synchronized StorageManager getStorageManagerAndIncrementUsageCount(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getStorageManagerAndIncrementUsageCount", string);
        }
        StorageManagerWrapper storageManagerWrapper = (StorageManagerWrapper)storageManagerMap.get(string);
        storageManagerWrapper.incrementUsageCount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getStorageManagerAndIncrementUsageCount", storageManagerWrapper.storageManager);
        }
        return storageManagerWrapper.storageManager;
    }

    public static synchronized void putStorageManagerInMap(String string, StorageManager storageManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putStorageManagerInMap", new Object[]{string, storageManager});
        }
        StorageManagerWrapper storageManagerWrapper = new StorageManagerWrapper(storageManager);
        storageManagerMap.put(string, storageManagerWrapper);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "putStorageManagerInMap");
        }
    }

    public static synchronized boolean shutdownStorageManagerInstance(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdownStorageManagerInstance", string);
        }
        boolean bl = false;
        StorageManagerWrapper storageManagerWrapper = (StorageManagerWrapper)storageManagerMap.get(string);
        if (storageManagerWrapper != null && storageManagerWrapper.decrementUsageCount()) {
            bl = true;
            storageManagerMap.remove(string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdownStorageManagerInstance", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized StorageManagerWrapper getOwningStorageManagerForAcksToEPR(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOwningStorageManagerForAcksToEPR", string);
        }
        StorageManagerWrapper storageManagerWrapper = null;
        for (StorageManagerWrapper storageManagerWrapper2 : storageManagerMap.values()) {
            Transaction transaction = null;
            try {
                transaction = storageManagerWrapper2.storageManager.getTransaction();
                RMSBean rMSBean = new RMSBean();
                rMSBean.setAcksToEPR(string);
                List list = storageManagerWrapper2.storageManager.getRMSBeanMgr().find(rMSBean);
                if (list.size() <= 0) continue;
                storageManagerWrapper = storageManagerWrapper2;
                break;
            }
            catch (SandeshaStorageException sandeshaStorageException) {
                FFDCFilter.processException(sandeshaStorageException, "com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManagerMap.getOwningStorageManagerForAcksToEPR", "1:219:1.8");
            }
            finally {
                if (transaction == null || !transaction.isActive()) continue;
                try {
                    transaction.commit();
                }
                catch (SandeshaStorageException sandeshaStorageException) {
                    FFDCFilter.processException(sandeshaStorageException, "com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManagerMap.getOwningStorageManagerForAcksToEPR", "1:236:1.8");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOwningStorageManagerForAcksToEPR", storageManagerWrapper);
        }
        return storageManagerWrapper;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/impl/storage/WSReliableMessagingStorageManagerMap.java, WAS.rm, WSFP.WSERV1, cf230905.09 1.8");
        }
        nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
        storageManagerMap = new HashMap();
    }

    static final class StorageManagerWrapper {
        final StorageManager storageManager;
        final ClassLoader classLoader;
        int usageCount = 0;

        StorageManagerWrapper(StorageManager storageManager) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "StorageManagerWrapper", storageManager);
            }
            this.storageManager = storageManager;
            this.incrementUsageCount();
            this.classLoader = Thread.currentThread().getContextClassLoader();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "StorageManagerWrapper", storageManager);
            }
        }

        synchronized void incrementUsageCount() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "incrementUsageCount");
            }
            ++this.usageCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "incrementUsageCount");
            }
        }

        synchronized boolean decrementUsageCount() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "decrementUsageCount");
            }
            if (this.usageCount > 0) {
                --this.usageCount;
                if (this.usageCount == 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "decrementUsageCount", Boolean.TRUE);
                    }
                    return true;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "decrementUsageCount", Boolean.FALSE);
                }
                return false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "decrementUsageCount", "IllegalStateException");
            }
            throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"StorageManagerWrapper", "1:118:1.8"}, null));
        }
    }
}

