/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManagerMap;
import com.ibm.ws.websvcs.rm.mbeans.WSRMApplicationMBean;
import com.ibm.ws.websvcs.rm.mbeans.dao.StorageManagerDetail;
import com.ibm.ws.websvcs.rm.policyset.RMServiceConfigPlugin;
import java.lang.reflect.Constructor;
import java.util.Locale;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisModule;
import org.apache.sandesha2.polling.PollingManager;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.workers.SandeshaThread;

public abstract class WSReliableMessagingStorageManager
extends StorageManager {
    private static final TraceComponent tc = Tr.register(WSReliableMessagingStorageManager.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private Object _controller;
    private Object _applicationMBean;
    private String _serverClusterName;
    private String _workKey;

    public WSReliableMessagingStorageManager(ConfigurationContext configurationContext, boolean bl) {
        super(configurationContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "WSReliableMessagingStorageManager", new Object[]{configurationContext, new Boolean(bl)});
        }
        if (bl) {
            this.initMbean();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "WSReliableMessagingStorageManager", this);
        }
    }

    void initMbean() {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "initMbean");
            }
            if (!this.isRunningInClientContainer()) {
                try {
                    Thread.currentThread().getContextClassLoader().loadClass("com.ibm.ws.websvcs.rm.storage.controller.ControllableStore");
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController");
                    Constructor<?> constructor = clazz.getConstructor(WSReliableMessagingStorageManager.class);
                    this._controller = constructor.newInstance(this);
                    Class<?> clazz2 = Thread.currentThread().getContextClassLoader().loadClass("com.ibm.ws.websvcs.rm.mbeans.WSRMApplicationMBean");
                    Constructor<?> constructor2 = clazz2.getConstructor(Class.forName("com.ibm.ws.websvcs.rm.storage.controller.ControllableStore"));
                    this._applicationMBean = constructor2.newInstance(this._controller);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManager.initMbean", "1:156:1.30", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Caught exception when loading Mbeans", exception);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initMbean");
        }
    }

    public Object getController() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getController");
            Tr.exit(tc, "getController", this._controller);
        }
        return this._controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWorkKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkKey");
        }
        WSReliableMessagingStorageManager wSReliableMessagingStorageManager = this;
        synchronized (wSReliableMessagingStorageManager) {
            if (this._workKey == null) {
                if (this._serverClusterName == null) {
                    this._serverClusterName = WSRMModule.getClusterName();
                    if (this._serverClusterName == null) {
                        this._serverClusterName = WSRMModule.getServerName();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "serverClusterName=" + this._serverClusterName);
                    }
                }
                this._workKey = this._serverClusterName + "#" + WSRMModule.getApplicationName(this.getContext()) + "#" + WSRMModule.getApplicationModuleName(this.getContext());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkKey", this._workKey);
        }
        return this._workKey;
    }

    public void shutdown() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        if (WSReliableMessagingStorageManagerMap.shutdownStorageManagerInstance(this.getMapKey())) {
            if (this.isStoreBeingUsed() && !this.isRunningInClientContainer() && this.isStoreBeingUsed() && this._applicationMBean != null) {
                WSRMApplicationMBean.deregisterAllMBeans();
            }
            super.shutdown();
            this.shutdownFinished();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    protected void shutdownFinished() {
    }

    public SandeshaThread getInvoker() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvoker");
        }
        SandeshaThread sandeshaThread = this.getApplicationStorageManager().getInvoker();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvoker", sandeshaThread);
        }
        return sandeshaThread;
    }

    public SandeshaThread getSender() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSender");
        }
        SandeshaThread sandeshaThread = this.getApplicationStorageManager().getSender();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSender", sandeshaThread);
        }
        return sandeshaThread;
    }

    public PollingManager getPollingManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPollingManager");
        }
        PollingManager pollingManager = this.getApplicationStorageManager().getPollingManager();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPollingManager", pollingManager);
        }
        return pollingManager;
    }

    public SenderBeanMgr getSenderBeanMgr() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSenderBeanMgr");
        }
        SenderBeanMgr senderBeanMgr = this.getApplicationStorageManager().getSenderBeanMgr();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSenderBeanMgr", senderBeanMgr);
        }
        return senderBeanMgr;
    }

    public InvokerBeanMgr getInvokerBeanMgr() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvokerBeanMgr");
        }
        InvokerBeanMgr invokerBeanMgr = this.getApplicationStorageManager().getInvokerBeanMgr();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvokerBeanMgr", invokerBeanMgr);
        }
        return invokerBeanMgr;
    }

    public void storeMessageContext(String string, MessageContext messageContext) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "storeMessageContext", new Object[]{string, messageContext, messageContext.getConfigurationContext()});
        }
        if (RMServiceConfigPlugin.isInorder(messageContext.getConfigurationContext().getAxisConfiguration())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "disabling jaxWS thread switch for inOrder");
            }
            messageContext.setProperty("serverDisableThreadSwitch", Boolean.TRUE);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "no inOrder");
        }
        this.getApplicationStorageManager().storeMessageContext(string, messageContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "storeMessageContext");
        }
    }

    public void setContext(ConfigurationContext configurationContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setContext", configurationContext);
        }
        this.getApplicationStorageManager().setContext(configurationContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setContext");
        }
    }

    public void registerMBean() {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "registerMBean");
            }
            try {
                if (!this.isRunningInClientContainer() && this.isStoreBeingUsed() && this._applicationMBean != null) {
                    ((WSRMApplicationMBean)this._applicationMBean).register();
                }
            }
            catch (Exception exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Could not register storage manager Mbean due to exception " + exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerMBean");
        }
    }

    public void initStorage(AxisModule axisModule) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initStorage", axisModule);
        }
        this.getApplicationStorageManager().initStorage(axisModule);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initStorage");
        }
    }

    public Transaction getTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransaction");
        }
        Transaction transaction = this.getApplicationStorageManager().getTransaction();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransaction", transaction);
        }
        return transaction;
    }

    public RMSBeanMgr getRMSBeanMgr() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMSBeanMgr");
        }
        RMSBeanMgr rMSBeanMgr = this.getApplicationStorageManager().getRMSBeanMgr();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRMSBeanMgr", rMSBeanMgr);
        }
        return rMSBeanMgr;
    }

    public RMDBeanMgr getRMDBeanMgr() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMDBeanMgr");
        }
        RMDBeanMgr rMDBeanMgr = this.getApplicationStorageManager().getRMDBeanMgr();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRMDBeanMgr", rMDBeanMgr);
        }
        return rMDBeanMgr;
    }

    public void updateMessageContext(String string, MessageContext messageContext) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMessageContext", new Object[]{string, messageContext, messageContext.getConfigurationContext()});
        }
        this.getApplicationStorageManager().updateMessageContext(string, messageContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMessageContext");
        }
    }

    public MessageContext retrieveMessageContext(String string, ConfigurationContext configurationContext) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveMessageContext", new Object[]{string, configurationContext});
        }
        MessageContext messageContext = this.getApplicationStorageManager().retrieveMessageContext(string, configurationContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveMessageContext", messageContext);
        }
        return messageContext;
    }

    public void removeMessageContext(String string) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeMessageContext", string);
        }
        this.getApplicationStorageManager().removeMessageContext(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeMessageContext");
        }
    }

    protected abstract boolean isStoreBeingUsed();

    protected abstract StorageManager getApplicationStorageManager();

    protected abstract String getMapKey();

    public abstract StorageManagerDetail getStorageManagerDetails(Locale var1);

    public boolean isRunningInClientContainer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isRunningInClientContainer");
        }
        boolean bl = WSRMModule.isRunningInClientJVM();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isRunningInClientContainer", new Boolean(bl));
        }
        return bl;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/impl/storage/WSReliableMessagingStorageManager.java, WAS.rm, WSFP.WSERV1, cf230905.09 1.30");
        }
    }
}

