/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.UUID;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.policyset.RMServiceConfigPlugin;
import java.io.Serializable;
import java.util.HashMap;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.ThreadContextMigrator;
import org.apache.sandesha2.storage.SandeshaStorageException;

public class TransactionThreadMigrator
implements ThreadContextMigrator {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceComponent tc = Tr.register(TransactionThreadMigrator.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    public static String TRAN_ENABLED_PROPERTY_STRING;
    private static TransactionThreadMigrator instance;
    private static HashMap threadCtxTable;

    public static synchronized TransactionThreadMigrator getInstance() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (instance == null) {
            new TransactionThreadMigrator();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionThreadMigrator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionThreadMigrator");
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (instance == null) {
                threadCtxTable = new HashMap();
                instance = this;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionThreadMigrator", this);
        }
    }

    private boolean isMessageOutboundRequest(MessageContext messageContext) {
        AxisOperation axisOperation;
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isMessageOutboundRequest", messageContext);
        }
        if (!(bl = this.isMessageOutboundOneWay(messageContext)) && (axisOperation = messageContext.getAxisOperation()) != null) {
            int n = axisOperation.getAxisSpecifMEPConstant();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, n + "");
            }
            if (16 == n || 17 == n) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, n + "=a requesting msg");
                }
                bl = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isMessageOutboundRequest", new Boolean(bl));
        }
        return bl;
    }

    private boolean isMessageOutboundOneWay(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isMessageOutboundOneWay", messageContext);
        }
        boolean bl = false;
        AxisOperation axisOperation = messageContext.getAxisOperation();
        if (axisOperation != null) {
            int n = axisOperation.getAxisSpecifMEPConstant();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, n + "");
            }
            if (14 == n) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, n + "=outbound one way");
                }
                bl = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isMessageOutboundOneWay", new Boolean(bl));
        }
        return bl;
    }

    private boolean isUserRequestTxSend(MessageContext messageContext) {
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isUserRequestTxSend", messageContext);
        }
        Object object = messageContext.getProperty(TRAN_ENABLED_PROPERTY_STRING);
        boolean bl2 = bl = Boolean.TRUE.toString().equals(object) || Boolean.TRUE.equals(object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isUserRequestTxSend", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCurrentThreadTxContextByMsgCtx(MessageContext messageContext, boolean bl, boolean bl2) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "storeCurrentThreadTxContextByMsgCtx", new Object[]{messageContext, new Boolean(bl), new Boolean(bl2)});
        }
        MessageContextID messageContextID = new MessageContextID(messageContext);
        try {
            Serializable serializable;
            ThreadTxContextInformation threadTxContextInformation = new ThreadTxContextInformation(bl2);
            if (bl) {
                if (!threadTxContextInformation.hasStoredTxCtx()) {
                    IllegalStateException illegalStateException = new IllegalStateException(nls.getFormattedMessage("NO_TX_CTX_CWSKA0552", new Object[]{messageContext.getMessageID(), messageContext.getAxisService().getName()}, null));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "storeCurrentThreadTxContextByMsgCtx", illegalStateException);
                    }
                    throw illegalStateException;
                }
                if (!RMServiceConfigPlugin.isManagedQOS(messageContext.getConfigurationContext().getAxisConfiguration())) {
                    serializable = new IllegalStateException(nls.getFormattedMessage("NO_TX_USING_UNMANAGED_CWSKA0553", new Object[]{messageContext.getMessageID(), messageContext.getAxisService().getName()}, null));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "storeCurrentThreadTxContextByMsgCtx", serializable);
                    }
                }
            }
            serializable = threadCtxTable;
            synchronized (serializable) {
                if (threadTxContextInformation.hasStoredTxCtx()) {
                    if (threadCtxTable.containsKey(messageContextID)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "storeCurrentThreadTxContextByMsgCtx", "IllegalStateException");
                        }
                        throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:793:1.25"}, null));
                    }
                    threadCtxTable.put(messageContextID, threadTxContextInformation);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "storeCurrentThreadTxContextByMsgCtx", threadCtxTable);
                    }
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.storeCurrentThreadTxContextByMsgCtx", "1:810:1.25", this);
            AxisFault axisFault = new AxisFault(exception);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "storeCurrentThreadTxContextByMsgCtx", axisFault);
            }
            throw axisFault;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "storeCurrentThreadTxContextByMsgCtx");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadTxContextInformation getTxCtxFromMsgCtx(MessageContext messageContext, boolean bl) throws AxisFault {
        MessageContextID messageContextID;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTxCtxFromMsgCtx", new Object[]{messageContext, new Boolean(bl)});
        }
        if ((messageContextID = MessageContextID.getMsgCtxIDFromMsgCtx(messageContext)) == null && bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getTxCtxFromMsgCtx", "IllegalStateException");
            }
            throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:843:1.25"}, null));
        }
        ThreadTxContextInformation threadTxContextInformation = null;
        HashMap hashMap = threadCtxTable;
        synchronized (hashMap) {
            threadTxContextInformation = (ThreadTxContextInformation)threadCtxTable.get(messageContextID);
            if (threadTxContextInformation == null && bl) {
                AxisFault axisFault = new AxisFault(new IllegalStateException("Stored msgCtx but no valid thread tx ctx"));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getTxCtxFromMsgCtx", new Object[]{axisFault, threadCtxTable, messageContextID});
                }
                throw axisFault;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTxCtxFromMsgCtx", threadTxContextInformation);
        }
        return threadTxContextInformation;
    }

    public void startWSRMTransactionalGet(AxisConfiguration axisConfiguration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startWSRMTransactionalGet", axisConfiguration);
        }
        if (RMServiceConfigPlugin.isManagedQOS(axisConfiguration)) {
            try {
                WebSphereTransactionManager webSphereTransactionManager = TransactionManagerFactory.getTransactionManager();
                if (webSphereTransactionManager.getTransaction() == null) {
                    webSphereTransactionManager.begin();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.startWSRMTransactionalGet", "1:888:1.25", this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startWSRMTransactionalGet");
        }
    }

    public ThreadTxContextInformation startWSRMTransactionalCall(boolean bl) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startWSRMTransactionalCall", new Boolean(bl));
        }
        ThreadTxContextInformation threadTxContextInformation = null;
        if (!bl && !WSRMModule.isRunningInClientJVM()) {
            try {
                threadTxContextInformation = new ThreadTxContextInformation(false);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.startWSRMTransactionalCall", "1:924:1.25", this);
                AxisFault axisFault = new AxisFault(exception);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "startWSRMTransactionalCall", axisFault);
                }
                throw axisFault;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startWSRMTransactionalCall", threadTxContextInformation);
        }
        return threadTxContextInformation;
    }

    public void finishWSRMTransactionalCall(ThreadTxContextInformation threadTxContextInformation) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishWSRMTransactionalCall", threadTxContextInformation);
        }
        if (threadTxContextInformation != null) {
            try {
                threadTxContextInformation.loadStoredTxCtxOntoCurrentThread();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.finishWSRMTransactionalCall", "1:962:1.25", this);
                AxisFault axisFault = new AxisFault(exception);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "finishWSRMTransactionalCall", axisFault);
                }
                throw axisFault;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishWSRMTransactionalCall");
        }
    }

    public void migrateContextToThread(MessageContext messageContext) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void migrateThreadToContext(MessageContext messageContext) throws AxisFault {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "migrateThreadToContext", messageContext);
            }
            if (this.isUserRequestTxSend(messageContext) && WSRMModule.isWSRMEnabledForService(messageContext.getAxisService())) {
                if (this.isMessageOutboundOneWay(messageContext)) {
                    if (!RMServiceConfigPlugin.isManagedQOS(messageContext.getAxisService().getAxisConfiguration())) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "migrateThreadToContext", "IllegalStateException");
                        }
                        throw new IllegalStateException(nls.getFormattedMessage("NO_TX_USING_UNMANAGED_CWSKA0553", new Object[]{messageContext.getMessageID(), messageContext.getAxisService().getName()}, null));
                    }
                    this.storeCurrentThreadTxContextByMsgCtx(messageContext, true, true);
                    break block9;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "migrateThreadToContext", "IllegalStateException");
                    }
                    throw new IllegalStateException(nls.getFormattedMessage("CANNOT_SUPPORT_TX_CWSKA0551", new Object[]{messageContext.getMessageID(), messageContext.getAxisService().getName()}, null));
                }
            }
            if (WSRMModule.isWSRMEnabledForService(messageContext.getAxisService()) && this.isMessageOutboundRequest(messageContext)) {
                this.storeCurrentThreadTxContextByMsgCtx(messageContext, false, false);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "migrateThreadToContext");
        }
    }

    public void startWSRMTransactionalPut(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startWSRMTransactionalPut", messageContext);
        }
        if (this.isMessageOutboundOneWay(messageContext) && this.isUserRequestTxSend(messageContext)) {
            ThreadTxContextInformation threadTxContextInformation = this.getTxCtxFromMsgCtx(messageContext, true);
            try {
                threadTxContextInformation.beginTxWorkUnitIfNecessary();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.startWSRMTransactionalPut", "1:1073:1.25", this);
                AxisFault axisFault = new AxisFault(exception);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "startWSRMTransactionalPut", axisFault);
                }
                throw axisFault;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startWSRMTransactionalPut");
        }
    }

    public void finishWSRMTransactionalPut(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishWSRMTransactionalPut", messageContext);
        }
        if (this.isMessageOutboundOneWay(messageContext) && this.isUserRequestTxSend(messageContext)) {
            ThreadTxContextInformation threadTxContextInformation = this.getTxCtxFromMsgCtx(messageContext, true);
            try {
                threadTxContextInformation.endTxWorkUnit();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.finishWSRMTransactionalPut", "1:1103:1.25", this);
                AxisFault axisFault = new AxisFault(exception);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "finishWSRMTransactionalPut", axisFault);
                }
                throw axisFault;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishWSRMTransactionalPut");
        }
    }

    public void finishWSRMTransactionalGet(AxisConfiguration axisConfiguration) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishWSRMTransactionalGet", axisConfiguration);
        }
        if (RMServiceConfigPlugin.isManagedQOS(axisConfiguration)) {
            try {
                WebSphereTransactionManager webSphereTransactionManager = TransactionManagerFactory.getTransactionManager();
                if (webSphereTransactionManager.getTransaction() != null) {
                    webSphereTransactionManager.commit();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.finishWSRMTransactionalGet", "1:1137:1.25", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "finishWSRMTransactionalGet", exception);
                }
                throw new SandeshaStorageException(exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishWSRMTransactionalGet");
        }
    }

    public void finishWSRMTransactionalGetWithRollback(AxisConfiguration axisConfiguration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishWSRMTransactionalGetWithRollback", axisConfiguration);
        }
        if (RMServiceConfigPlugin.isManagedQOS(axisConfiguration)) {
            try {
                WebSphereTransactionManager webSphereTransactionManager = TransactionManagerFactory.getTransactionManager();
                if (webSphereTransactionManager.getTransaction() != null) {
                    webSphereTransactionManager.rollback();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.finishWSRMTransactionalGetWithRollback", "1:1169:1.25", this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishWSRMTransactionalGetWithRollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupContext(MessageContext messageContext) {
        block17: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanupContext", messageContext);
            }
            if (this.isMessageOutboundOneWay(messageContext) && this.isUserRequestTxSend(messageContext)) {
                MessageContextID messageContextID = MessageContextID.getMsgCtxIDFromMsgCtx(messageContext);
                if (messageContextID != null) {
                    ThreadTxContextInformation threadTxContextInformation = null;
                    HashMap hashMap = threadCtxTable;
                    synchronized (hashMap) {
                        threadTxContextInformation = (ThreadTxContextInformation)threadCtxTable.remove(messageContextID);
                    }
                    if (threadTxContextInformation != null) {
                        messageContextID.eraseMsgCtxIDFromMsgCtx(messageContext);
                        try {
                            threadTxContextInformation.resumeTxCtxForApplication();
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.cleanupContext", "1:1208:1.25", this);
                        }
                    }
                }
            } else if (this.isMessageOutboundRequest(messageContext)) {
                try {
                    ThreadTxContextInformation threadTxContextInformation = this.getTxCtxFromMsgCtx(messageContext, false);
                    if (threadTxContextInformation == null) break block17;
                    threadTxContextInformation.loadStoredTxCtxOntoCurrentThread();
                    HashMap hashMap = threadCtxTable;
                    synchronized (hashMap) {
                        MessageContextID messageContextID = MessageContextID.getMsgCtxIDFromMsgCtx(messageContext);
                        threadCtxTable.remove(messageContextID);
                        messageContextID.eraseMsgCtxIDFromMsgCtx(messageContext);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.cleanupContext", "1:1239:1.25", this);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupContext");
        }
    }

    public void cleanupThread(MessageContext messageContext) {
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/impl/storage/TransactionThreadMigrator.java, WAS.rm, WSFP.WSERV1, cf230905.09 1.25");
        }
        TRAN_ENABLED_PROPERTY_STRING = "enableTransactionalOneWay";
    }

    public static final class ThreadTxContextInformation {
        private static final TraceComponent tc = Tr.register(ThreadTxContextInformation.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
        static final int WORK_WAIT_TIME = 1000;
        private static TransactionManager tranManager = TransactionManagerFactory.getTransactionManager();
        private Transaction applicationTranCtx;
        private boolean blockRequiredIfWorkOutstanding = true;
        private boolean started = false;
        private boolean finished = false;

        ThreadTxContextInformation(boolean bl) throws SystemException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "ThreadTxContextInformation", new Boolean(bl));
            }
            this.suspendAndStoreCurrentTxContext();
            this.blockRequiredIfWorkOutstanding = bl;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "ThreadTxContextInformation", this);
            }
        }

        public String toString() {
            return "[ThreadTxContextInformation \n applicationTranCtx=" + this.applicationTranCtx + "\n blockRequiredIfWorkOutstanding=" + this.blockRequiredIfWorkOutstanding + "\n started=" + this.started + "\n finished=" + this.finished + "]";
        }

        synchronized void suspendAndStoreCurrentTxContext() throws SystemException {
            Transaction transaction;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "suspendAndStoreCurrentTxContext");
            }
            if ((transaction = tranManager.getTransaction()) != null) {
                if (this.applicationTranCtx == null) {
                    this.applicationTranCtx = tranManager.suspend();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "storing tx " + this.applicationTranCtx);
                    }
                } else {
                    if (!this.applicationTranCtx.equals(transaction)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "suspendAndStoreCurrentTxContext", "IllegalStateException");
                        }
                        throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:363:1.25"}, null));
                    }
                    tranManager.suspend();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "suspending tx " + this.applicationTranCtx);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "suspendAndStoreCurrentTxContext");
            }
        }

        synchronized boolean hasStoredTxCtx() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "hasStoredTxCtx");
                Tr.exit(tc, "hasStoredTxCtx", new Boolean(this.applicationTranCtx != null));
            }
            return this.applicationTranCtx != null;
        }

        void setApplicationTranRollbackOnly() throws SystemException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "setApplicationTranRollbackOnly");
            }
            if (this.hasStoredTxCtx()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting application tran " + this.applicationTranCtx + " as rollback only.");
                }
                this.applicationTranCtx.setRollbackOnly();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "setApplicationTranRollbackOnly");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void beginTxWorkUnitIfNecessary() throws SystemException, InvalidTransactionException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "beginTxWorkUnitIfNecessary");
            }
            if (this.started) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "beginTxWorkUnitIfNecessary : work already started");
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "beginTxWorkUnitIfNecessary : work starting");
                }
                this.started = true;
            }
            if (this.finished) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "beginTxWorkUnitIfNecessary", "IllegalStateException - finished");
                }
                throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:445:1.25"}, null));
            }
            try {
                this.loadStoredTxCtxOntoCurrentThread();
            }
            finally {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSRM work started");
                }
                this.notifyAll();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "beginTxWorkUnitIfNecessary");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void endTxWorkUnit() throws SystemException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "endTxWorkUnit");
            }
            if (!this.started) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "endTxWorkUnit", "IllegalStateException - !started");
                }
                throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:482:1.25"}, null));
            }
            if (this.finished) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "endTxWorkUnit", "IllegalStateException - !started");
                }
                throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:490:1.25"}, null));
            }
            this.finished = true;
            try {
                this.suspendAndStoreCurrentTxContext();
            }
            finally {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSRM work finished");
                }
                this.notifyAll();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "endTxWorkUnit");
            }
        }

        synchronized void resumeTxCtxForApplication() throws SystemException, InvalidTransactionException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "resumeTxCtxForApplication");
            }
            if (this.hasStoredTxCtx() && this.blockRequiredIfWorkOutstanding && (!this.started || !this.finished)) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "blocking application for WSRM work to finish: started=" + this.started + ", finsihed=" + this.finished);
                    }
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.started || !this.finished) {
                    this.setApplicationTranRollbackOnly();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "resumeTxCtxForApplication", "IllegalStateException");
                    }
                    throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:554:1.25"}, null));
                }
            }
            this.loadStoredTxCtxOntoCurrentThread();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "resumeTxCtxForApplication");
            }
        }

        void loadStoredTxCtxOntoCurrentThread() throws SystemException, InvalidTransactionException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "loadStoredTxCtxOntoCurrentThread");
            }
            if (this.hasStoredTxCtx()) {
                Transaction transaction = tranManager.getTransaction();
                if (transaction != null) {
                    if (transaction.equals(this.applicationTranCtx)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "loadStoredTxCtxOntoCurrentThread");
                        }
                        return;
                    }
                    this.setApplicationTranRollbackOnly();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadStoredTxCtxOntoCurrentThread", "IllegalStateException");
                    }
                    throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:601:1.25"}, null));
                }
                try {
                    tranManager.resume(this.applicationTranCtx);
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.ThreadTxContextInformation.loadStoredTxCtxOntoCurrentThread", "1:614:1.25", this);
                    this.setApplicationTranRollbackOnly();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadStoredTxCtxOntoCurrentThread", systemException);
                    }
                    throw systemException;
                }
                catch (InvalidTransactionException invalidTransactionException) {
                    FFDCFilter.processException((Throwable)invalidTransactionException, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.ThreadTxContextInformation.loadStoredTxCtxOntoCurrentThread", "1:628:1.25", this);
                    this.setApplicationTranRollbackOnly();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadStoredTxCtxOntoCurrentThread", invalidTransactionException);
                    }
                    throw invalidTransactionException;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "loadStoredTxCtxOntoCurrentThread");
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "no stored tx ctx loaded onto thread");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "loadStoredTxCtxOntoCurrentThread");
            }
        }
    }

    private static final class MessageContextID
    implements Serializable {
        public static final String msgCtxIDPropertyName = "WSRM_MsgCtxID";
        private static final long serialVersionUID = 6519853756580410627L;
        private String uuid;

        public MessageContextID(MessageContext messageContext) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "MessageContextID", messageContext);
            }
            this.uuid = new UUID().toString();
            messageContext.setProperty(msgCtxIDPropertyName, this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "MessageContextID", this);
            }
        }

        public void eraseMsgCtxIDFromMsgCtx(MessageContext messageContext) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "eraseMsgCtxIDFromMsgCtx", messageContext);
            }
            messageContext.setProperty(msgCtxIDPropertyName, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "eraseMsgCtxIDFromMsgCtx", messageContext);
            }
        }

        public static MessageContextID getMsgCtxIDFromMsgCtx(MessageContext messageContext) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getMsgCtxIDFromMsgCtx", messageContext);
            }
            MessageContextID messageContextID = (MessageContextID)messageContext.getProperty(msgCtxIDPropertyName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getMsgCtxIDFromMsgCtx", messageContextID);
            }
            return messageContextID;
        }

        public boolean equals(Object object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "equals", object);
            }
            boolean bl = false;
            if (object instanceof MessageContextID && this.uuid.equals(((MessageContextID)object).uuid)) {
                bl = true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", new Boolean(bl));
            }
            return bl;
        }

        public int hashCode() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "hashCode");
            }
            int n = this.uuid.hashCode();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "hashCode", new Integer(n));
            }
            return n;
        }

        public String toString() {
            return "msgCtxID=" + this.uuid;
        }
    }
}

