/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.wsrm.WSRMConstants;
import com.ibm.ws.sib.wsrm.exceptions.MEXATransactionException;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton;
import com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.workers.SequenceEntry;

public final class TransactionImpl
implements Transaction {
    private static final TraceComponent tc = Tr.register(TransactionImpl.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private PersistentStorageManagerSingleton _storageManager;
    private String _sequenceToken = null;
    private HashMap _sequences = new HashMap();
    private HashMap _modifiedContexts = new HashMap();
    private volatile boolean _isActive = false;
    private boolean _isManagedPersistent = false;
    private boolean _sentMessages = false;
    private boolean _receivedMessages = false;
    private boolean _invokingTransaction = false;
    private InvokerBean _invokerBean;
    private SenderBean _senderBean;
    private long _retransmitInterval = -1L;

    public TransactionImpl(PersistentStorageManagerSingleton persistentStorageManagerSingleton, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionImpl", new Object[]{persistentStorageManagerSingleton, new Boolean(bl)});
        }
        this._isActive = true;
        this._isManagedPersistent = bl;
        this._storageManager = persistentStorageManagerSingleton;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionImpl", this);
        }
    }

    /*
     * Loose catch block
     */
    public void commit() throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        if (this._isActive) {
            block31: {
                Iterator iterator;
                this._isActive = false;
                try {
                    block30: {
                        if (!this._sequences.isEmpty()) {
                            this._sequences.put("TOKEN", this.getSequenceToken());
                            this._sequences.put("PERSISTENT", this._isManagedPersistent);
                            this._sequences.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
                            this._sequences.put(WSRMConstants.APP_KEY, this._storageManager.getApplicationInstanceKey());
                            if (this._retransmitInterval > -1L) {
                                this._sequences.put(WSRMConstants.RETRANSMISSION_INTERVAL, new Long(this._retransmitInterval));
                            }
                            String string = this.getSequenceToken();
                            this.setSequenceToken(null);
                            try {
                                this._storageManager.getCommandInvoker().processTransactionCommit(this._sequences);
                            }
                            catch (MEXATransactionException mEXATransactionException) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Caught XA Exception ", mEXATransactionException);
                                }
                                if (this._invokingTransaction) {
                                    this._storageManager.getCommandInvoker().forceTransactionRollback(string);
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, "commit", mEXATransactionException);
                                }
                                throw mEXATransactionException;
                            }
                        } else if (this._sequenceToken != null) {
                            this._storageManager.getCommandInvoker().processTransactionRollback(this._sequenceToken);
                            this._sequenceToken = null;
                        }
                        if (!this._invokingTransaction) break block30;
                        TransactionThreadMigrator.getInstance().finishWSRMTransactionalGet(this._storageManager.getContext().getAxisConfiguration());
                    }
                    Object var4_5 = null;
                    this._storageManager.removeTransaction();
                    if (this._modifiedContexts == null) break block31;
                    iterator = this._modifiedContexts.values().iterator();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this._storageManager.removeTransaction();
                    if (this._modifiedContexts != null) {
                        Iterator iterator2 = this._modifiedContexts.values().iterator();
                        while (iterator2.hasNext()) {
                            Serializable serializable2222;
                            try {
                                serializable2222 = (MessageContext)iterator2.next();
                                TransactionThreadMigrator.getInstance().finishWSRMTransactionalPut((MessageContext)serializable2222);
                            }
                            catch (AxisFault serializable2222) {
                                FFDCFilter.processException((Throwable)serializable2222, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.commit", "1:309:1.64", this);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "exception received when starting tx ctx " + serializable2222);
                            }
                        }
                    }
                    throw throwable;
                }
                while (iterator.hasNext()) {
                    Serializable serializable3222;
                    try {
                        serializable3222 = (MessageContext)iterator.next();
                        TransactionThreadMigrator.getInstance().finishWSRMTransactionalPut((MessageContext)serializable3222);
                    }
                    catch (AxisFault serializable3222) {
                        FFDCFilter.processException((Throwable)serializable3222, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.commit", "1:309:1.64", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "exception received when starting tx ctx " + serializable3222);
                    }
                }
                {
                    break block31;
                    catch (SandeshaStorageException sandeshaStorageException) {
                        this.rollbackAddedContexts();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "commit", sandeshaStorageException);
                        }
                        throw sandeshaStorageException;
                    }
                    catch (RuntimeException runtimeException) {
                        FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.commit", "1:282:1.64", this);
                        this.rollbackAddedContexts();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "commit", runtimeException);
                        }
                        throw runtimeException;
                    }
                }
            }
            if (this._sentMessages && this._senderBean != null) {
                this.startSender();
                if (!(this._storageManager.getInvoker() == null || this._storageManager.getInvoker().isThreadStarted() && this._storageManager.getInvoker().getSequences().contains(new SequenceEntry(this._senderBean.getSequenceID(), false)))) {
                    this._storageManager.getInvoker().runThreadForSequence(this._storageManager.getContext(), this._senderBean.getSequenceID(), false);
                }
            }
            if (this._sentMessages) {
                this._storageManager.getSender().wakeThread();
            }
            if (!(this._invokerBean == null || this._storageManager.getInvoker().isThreadStarted() && this._storageManager.getInvoker().getSequences().contains(new SequenceEntry(this._invokerBean.getSequenceID(), false)))) {
                this._storageManager.getSender().runThreadForSequence(this._storageManager.getContext(), this._invokerBean.getSequenceID(), false);
                this._storageManager.getInvoker().runThreadForSequence(this._storageManager.getContext(), this._invokerBean.getSequenceID(), false);
            }
            if (this._receivedMessages) {
                this._storageManager.getInvoker().wakeThread();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "commit");
        }
    }

    private void startSender() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startSender", this._senderBean);
        }
        String string = this._senderBean.getSequenceID();
        boolean bl = false;
        if (this._senderBean.getMessageType() != 4 && this._senderBean.getMessageType() != 2 && this._senderBean.getMessageType() != 6 && this._senderBean.getMessageType() != 9) {
            bl = true;
            string = this._senderBean.getInternalSequenceID();
        }
        if (!this._storageManager.getSender().isThreadStarted() || !this._storageManager.getSender().getSequences().contains(new SequenceEntry(string, bl))) {
            this._storageManager.getSender().runThreadForSequence(this._storageManager.getContext(), string, bl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startSender");
        }
    }

    private void rollbackAddedContexts() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackAddedContexts");
        }
        if (this._modifiedContexts != null) {
            for (String string : this._modifiedContexts.keySet()) {
                this._storageManager.removeMessageContextState(string);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackAddedContexts");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SandeshaStorageException {
        block16: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "rollback");
            }
            if (this._isActive) {
                Iterator iterator;
                this._isActive = false;
                try {
                    if (this._sequenceToken != null) {
                        try {
                            this._storageManager.getCommandInvoker().processTransactionRollback(this._sequenceToken);
                        }
                        catch (MEXATransactionException mEXATransactionException) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Caught XA Exception ", mEXATransactionException);
                            }
                            this._storageManager.getCommandInvoker().forceTransactionRollback(this._sequenceToken);
                        }
                        this._sequenceToken = null;
                    }
                    if (this._invokingTransaction) {
                        TransactionThreadMigrator.getInstance().finishWSRMTransactionalGetWithRollback(this._storageManager.getContext().getAxisConfiguration());
                    }
                    Object var3_2 = null;
                    this._storageManager.removeTransaction();
                    this.rollbackAddedContexts();
                    if (this._modifiedContexts == null) break block16;
                    iterator = this._modifiedContexts.values().iterator();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this._storageManager.removeTransaction();
                    this.rollbackAddedContexts();
                    if (this._modifiedContexts != null) {
                        Iterator iterator2 = this._modifiedContexts.values().iterator();
                        while (iterator2.hasNext()) {
                            Serializable serializable2;
                            try {
                                serializable2 = (MessageContext)iterator2.next();
                                TransactionThreadMigrator.getInstance().finishWSRMTransactionalPut((MessageContext)serializable2);
                            }
                            catch (AxisFault serializable2) {
                                FFDCFilter.processException((Throwable)serializable2, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.rollback", "1:452:1.64", this);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "exception received when starting tx ctx " + serializable2);
                            }
                        }
                    }
                    throw throwable;
                }
                while (iterator.hasNext()) {
                    Serializable serializable3;
                    try {
                        serializable3 = (MessageContext)iterator.next();
                        TransactionThreadMigrator.getInstance().finishWSRMTransactionalPut((MessageContext)serializable3);
                    }
                    catch (AxisFault serializable3) {
                        FFDCFilter.processException((Throwable)serializable3, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.rollback", "1:452:1.64", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "exception received when starting tx ctx " + serializable3);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "rollback");
        }
    }

    private static byte[] serializeMessageContext(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeMessageContext", messageContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Serializing msg ctx " + messageContext + " with config ctx " + messageContext.getConfigurationContext());
        }
        SandeshaUtil.removeMustUnderstand(messageContext.getEnvelope());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(messageContext);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.serializeMessageContext", "1:510:1.64");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "serializeMessageContext", "RuntimeException");
            }
            throw new RuntimeException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionImpl", "1:515:1.64"}, null), iOException);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeMessageContext", byArray);
        }
        return byArray;
    }

    void storeMessageContext(String string, MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "storeMessageContext", new Object[]{string, messageContext});
        }
        byte[] byArray = TransactionImpl.serializeMessageContext(messageContext);
        ArrayList arrayList = this.getDeleteMessageContextState(false);
        if (arrayList != null && arrayList.contains(string)) {
            HashMap hashMap;
            arrayList.remove(string);
            if (arrayList.size() == 0) {
                hashMap = (HashMap)this._sequences.get("MSG_CONTEXTS");
                hashMap.remove("DELETE");
            }
            hashMap = this.getUpdateMessageContextState(true);
            hashMap.put(string, byArray);
        } else {
            block8: {
                try {
                    TransactionThreadMigrator.getInstance().startWSRMTransactionalPut(messageContext);
                }
                catch (AxisFault axisFault) {
                    FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.storeMessageContext", "1:566:1.64", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "exception received when starting tx ctx " + axisFault);
                }
            }
            HashMap hashMap = this.getAddMessageContextState(true);
            hashMap.put(string, byArray);
            if (this._modifiedContexts == null) {
                this._modifiedContexts = new HashMap();
            }
            this._modifiedContexts.put(string, messageContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "storeMessageContext");
        }
    }

    private HashMap getAddMessageContextState(boolean bl) {
        HashMap hashMap;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAddMessageContextState", bl);
        }
        if ((hashMap = (HashMap)this._sequences.get("MSG_CONTEXTS")) == null && bl) {
            hashMap = new HashMap();
            this._sequences.put("MSG_CONTEXTS", hashMap);
        }
        HashMap hashMap2 = null;
        if (hashMap != null && (hashMap2 = (HashMap)hashMap.get("ADD")) == null && bl) {
            hashMap2 = new HashMap();
            hashMap.put("ADD", hashMap2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAddMessageContextState", hashMap2);
        }
        return hashMap2;
    }

    void updateMessageContext(String string, MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMessageContext", new Object[]{string, messageContext});
        }
        byte[] byArray = TransactionImpl.serializeMessageContext(messageContext);
        HashMap hashMap = this.getAddMessageContextState(false);
        if (hashMap != null && hashMap.containsKey(string)) {
            hashMap.put(string, byArray);
        } else {
            HashMap hashMap2 = this.getUpdateMessageContextState(true);
            hashMap2.put(string, byArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMessageContext");
        }
    }

    private HashMap getUpdateMessageContextState(boolean bl) {
        HashMap hashMap;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getUpdateMessageContextState", bl);
        }
        if ((hashMap = (HashMap)this._sequences.get("MSG_CONTEXTS")) == null && bl) {
            hashMap = new HashMap();
            this._sequences.put("MSG_CONTEXTS", hashMap);
        }
        HashMap hashMap2 = null;
        if (hashMap != null && (hashMap2 = (HashMap)hashMap.get("UPDATE")) == null && bl) {
            hashMap2 = new HashMap();
            hashMap.put("UPDATE", hashMap2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getUpdateMessageContextState", hashMap2);
        }
        return hashMap2;
    }

    byte[] getMessageContext(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageContext", string);
        }
        byte[] byArray = null;
        HashMap hashMap = this.getAddMessageContextState(false);
        if (hashMap != null && hashMap.containsKey(string)) {
            byArray = (byte[])hashMap.get(string);
        } else {
            HashMap hashMap2 = this.getUpdateMessageContextState(false);
            if (hashMap2 != null && hashMap2.containsKey(string)) {
                byArray = (byte[])hashMap2.get(string);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessageContext", byArray);
        }
        return byArray;
    }

    void deleteMessageContext(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteMessageContext", string);
        }
        ArrayList arrayList = this.getDeleteMessageContextState(true);
        arrayList.add(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteMessageContext");
        }
    }

    private ArrayList getDeleteMessageContextState(boolean bl) {
        HashMap hashMap;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeleteMessageContextState", bl);
        }
        if ((hashMap = (HashMap)this._sequences.get("MSG_CONTEXTS")) == null && bl) {
            hashMap = new HashMap();
            this._sequences.put("MSG_CONTEXTS", hashMap);
        }
        ArrayList arrayList = null;
        if (hashMap != null && (arrayList = (ArrayList)hashMap.get("DELETE")) == null && bl) {
            arrayList = new ArrayList();
            hashMap.put("DELETE", arrayList);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeleteMessageContextState", arrayList);
        }
        return arrayList;
    }

    public void insertSenderBean(SenderBean senderBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertSenderBean", new Object[]{senderBean, senderBean.getSequenceID(), senderBean.getInternalSequenceID()});
        }
        ArrayList<SenderBean> arrayList = null;
        String string = null;
        if (senderBean.getSequenceID() == null && senderBean.getInternalSequenceID() == null) {
            for (String string2 : this._sequences.keySet()) {
                if (!string2.startsWith("Sandesha2InternalSequence")) continue;
                string = string2;
                break;
            }
            senderBean.setInternalSequenceID(string);
        } else {
            string = senderBean.getInternalSequenceID();
            if (string == null) {
                string = senderBean.getSequenceID();
            }
        }
        this._retransmitInterval = this._storageManager.getRetransmissionInterval();
        HashMap hashMap = this.getSequenceAddTranState(string, true);
        arrayList = (ArrayList<SenderBean>)hashMap.get(WSRMConstants.SENDER_BEAN);
        if (arrayList == null) {
            arrayList = new ArrayList<SenderBean>();
            hashMap.put(WSRMConstants.SENDER_BEAN, arrayList);
        }
        arrayList.add(senderBean);
        this._sentMessages = true;
        if (senderBean.getMessageType() != 1) {
            this._senderBean = senderBean;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertSenderBean", senderBean);
        }
    }

    public boolean insertRMDBean(RMDBean rMDBean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertRMDBean", rMDBean);
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put(WSRMConstants.RMS_BEAN, rMDBean);
        hashMap.put("PERSISTENT", this._isManagedPersistent);
        hashMap.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
        hashMap.put("TOKEN", this._sequenceToken);
        HashMap hashMap2 = this._storageManager.getCommandInvoker().insertRMDBean(hashMap);
        Boolean bl = null;
        if (hashMap2 == null) {
            bl = Boolean.TRUE;
        } else {
            bl = (Boolean)hashMap2.get("INSERT_RESULT");
            if (bl.booleanValue()) {
                this.setSequenceToken((String)hashMap2.get("TOKEN"));
            }
        }
        if (bl.booleanValue()) {
            HashMap hashMap3 = this.getSequenceAddTranState(rMDBean.getSequenceID(), true);
            hashMap3.put("RMD_BEAN", rMDBean);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertRMDBean", bl);
        }
        return bl;
    }

    public void updateRMDBean(RMDBean rMDBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRMDBean", rMDBean);
        }
        HashMap hashMap = this.getSequenceAddTranState(rMDBean.getSequenceID(), true);
        hashMap.put("RMD_BEAN", rMDBean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRMDBean");
        }
    }

    public RMDBean getRMDBean(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMDBean", string);
        }
        RMDBean rMDBean = null;
        HashMap hashMap = this.getSequenceAddTranState(string, false);
        if (hashMap != null && hashMap.containsKey("RMD_BEAN")) {
            rMDBean = (RMDBean)hashMap.get("RMD_BEAN");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRMDBean", rMDBean);
        }
        return rMDBean;
    }

    public boolean insertRMSBean(RMSBean rMSBean, MessageContext messageContext) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertRMSBean", rMSBean);
        }
        if (messageContext != null) {
            try {
                TransactionThreadMigrator.getInstance().startWSRMTransactionalPut(messageContext);
            }
            catch (AxisFault axisFault) {
                FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.insertRMSBean", "1:944:1.64", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "insertRMSBean", axisFault);
                }
                throw new SandeshaStorageException(axisFault);
            }
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put(WSRMConstants.RMS_BEAN, rMSBean);
        hashMap.put("PERSISTENT", this._isManagedPersistent);
        hashMap.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
        hashMap.put("TOKEN", this._sequenceToken);
        HashMap hashMap2 = this._storageManager.getCommandInvoker().insertRMSBean(hashMap);
        Boolean bl = null;
        if (hashMap2 == null) {
            bl = Boolean.TRUE;
        } else {
            bl = (Boolean)hashMap2.get("INSERT_RESULT");
            if (bl.booleanValue()) {
                this.setSequenceToken((String)hashMap2.get("TOKEN"));
            }
        }
        if (bl.booleanValue()) {
            HashMap hashMap3 = this.getSequenceAddTranState(rMSBean.getInternalSequenceID(), true);
            hashMap3.put(WSRMConstants.RMS_BEAN, rMSBean);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertRMSBean", bl);
        }
        return bl;
    }

    public void updateRMSBean(RMSBean rMSBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRMSBean", rMSBean);
        }
        HashMap hashMap = this.getSequenceAddTranState(rMSBean.getInternalSequenceID(), true);
        hashMap.put(WSRMConstants.RMS_BEAN, rMSBean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRMSBean");
        }
    }

    public RMSBean getRMSBean(RMSBean rMSBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMSBean", rMSBean);
        }
        RMSBean rMSBean2 = null;
        if (rMSBean.getInternalSequenceID() == null) {
            Iterator iterator = this._sequences.values().iterator();
            while (iterator.hasNext() && rMSBean2 == null) {
                RMSBean rMSBean3;
                HashMap hashMap;
                HashMap hashMap2;
                Object v = iterator.next();
                if (!(v instanceof HashMap) || !(hashMap2 = (HashMap)v).containsKey("ADD") || !(hashMap = (HashMap)hashMap2.get("ADD")).containsKey(WSRMConstants.RMS_BEAN) || !(rMSBean3 = (RMSBean)hashMap.get(WSRMConstants.RMS_BEAN)).getSequenceID().equals(rMSBean.getSequenceID())) continue;
                rMSBean2 = rMSBean3;
            }
        } else {
            HashMap hashMap = this.getSequenceAddTranState(rMSBean.getInternalSequenceID(), false);
            if (hashMap != null && hashMap.containsKey(WSRMConstants.RMS_BEAN)) {
                rMSBean2 = (RMSBean)hashMap.get(WSRMConstants.RMS_BEAN);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRMSBean", rMSBean2);
        }
        return rMSBean2;
    }

    public boolean insertInvokerBean(InvokerBean invokerBean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertInvokerBean", invokerBean);
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put(WSRMConstants.INVOKER_BEAN, invokerBean);
        hashMap.put("PERSISTENT", this._isManagedPersistent);
        hashMap.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
        hashMap.put(WSRMConstants.APP_KEY, this._storageManager.getApplicationInstanceKey());
        hashMap.put("TOKEN", this._sequenceToken);
        Boolean bl = this._storageManager.getCommandInvoker().insertInvokerBean(hashMap);
        if (bl == null) {
            bl = Boolean.TRUE;
        }
        if (bl.booleanValue()) {
            HashMap hashMap2 = this.getSequenceAddTranState(invokerBean.getSequenceID(), true);
            hashMap2.put(WSRMConstants.INVOKER_BEAN, invokerBean);
            this._invokerBean = invokerBean;
        }
        this._receivedMessages = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertInvokerBean", bl);
        }
        return bl;
    }

    public void updateSenderBean(SenderBean senderBean) {
        Object object3;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateSenderBean", senderBean);
        }
        Object object2 = null;
        if (senderBean.getSequenceID() == null && senderBean.getInternalSequenceID() == null) {
            for (Object object3 : this._sequences.keySet()) {
                if (!((String)object3).startsWith("Sandesha2InternalSequence")) continue;
                object2 = object3;
                break;
            }
            senderBean.setInternalSequenceID((String)object2);
        } else {
            object2 = senderBean.getInternalSequenceID();
            if (object2 == null) {
                object2 = senderBean.getSequenceID();
            }
        }
        HashMap hashMap = this.getSequenceUpdateTranState((String)object2, true);
        object3 = (ArrayList)hashMap.get(WSRMConstants.SENDER_BEAN);
        if (object3 == null) {
            object3 = new ArrayList<SenderBean>();
            hashMap.put(WSRMConstants.SENDER_BEAN, object3);
        }
        ((ArrayList)object3).add(senderBean);
        this._sentMessages = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSenderBean");
        }
    }

    private HashMap getSequenceAddTranState(String string, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSequenceAddTranState", new Object[]{string, bl});
        }
        HashMap hashMap = this.getSequenceState(string, bl);
        HashMap hashMap2 = null;
        if (hashMap != null && (hashMap2 = (HashMap)hashMap.get("ADD")) == null && bl) {
            hashMap2 = new HashMap();
            hashMap.put("ADD", hashMap2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSequenceAddTranState", hashMap2);
        }
        return hashMap2;
    }

    private HashMap getSequenceUpdateTranState(String string, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSequenceUpdateTranState", new Object[]{string, bl});
        }
        HashMap hashMap = this.getSequenceState(string, bl);
        HashMap hashMap2 = null;
        if (hashMap != null && (hashMap2 = (HashMap)hashMap.get("UPDATE")) == null && bl) {
            hashMap2 = new HashMap();
            hashMap.put("UPDATE", hashMap2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSequenceUpdateTranState", hashMap2);
        }
        return hashMap2;
    }

    private HashMap getSequenceDeleteTranState(boolean bl) {
        HashMap hashMap;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSequenceDeleteTranState");
        }
        if ((hashMap = (HashMap)this._sequences.get("DELETE")) == null && bl) {
            hashMap = new HashMap();
            this._sequences.put("DELETE", hashMap);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSequenceDeleteTranState", hashMap);
        }
        return hashMap;
    }

    private HashMap getSequenceState(String string, boolean bl) {
        HashMap hashMap;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSequenceState", string);
        }
        if ((hashMap = (HashMap)this._sequences.get(string)) == null && bl) {
            hashMap = new HashMap();
            this._sequences.put(string, hashMap);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSequenceState", hashMap);
        }
        return hashMap;
    }

    public void deleteRMSBean(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteRMSBean", string);
        }
        HashMap hashMap = this.getSequenceDeleteTranState(true);
        hashMap.put(WSRMConstants.RMS_BEAN, string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteRMSBean");
        }
    }

    public void deleteRMDBean(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteRMDBean", string);
        }
        HashMap hashMap = this.getSequenceDeleteTranState(true);
        hashMap.put("RMD_BEAN", string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteRMDBean");
        }
    }

    public void deleteInvokerBean(String string) {
        HashMap hashMap;
        ArrayList<String> arrayList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteInvokerBean", string);
        }
        if ((arrayList = (ArrayList<String>)(hashMap = this.getSequenceDeleteTranState(true)).get(WSRMConstants.INVOKER_BEAN)) == null) {
            arrayList = new ArrayList<String>();
            hashMap.put(WSRMConstants.INVOKER_BEAN, arrayList);
        }
        arrayList.add(string);
        this._invokingTransaction = true;
        TransactionThreadMigrator.getInstance().startWSRMTransactionalGet(this._storageManager.getContext().getAxisConfiguration());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteInvokerBean");
        }
    }

    public void deleteSenderBean(String string) {
        HashMap hashMap;
        ArrayList<String> arrayList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteSenderBean", string);
        }
        if ((arrayList = (ArrayList<String>)(hashMap = this.getSequenceDeleteTranState(true)).get(WSRMConstants.SENDER_BEAN)) == null) {
            arrayList = new ArrayList<String>();
            hashMap.put(WSRMConstants.SENDER_BEAN, arrayList);
        }
        arrayList.add(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteSenderBean");
        }
    }

    public ArrayList getDeletedSenderBeans() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeletedSenderBeans");
        }
        ArrayList arrayList = null;
        HashMap hashMap = this.getSequenceDeleteTranState(false);
        if (hashMap != null) {
            arrayList = (ArrayList)hashMap.get(WSRMConstants.SENDER_BEAN);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeletedSenderBeans", arrayList);
        }
        return arrayList;
    }

    public void setSequenceToken(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setSequenceToken", string);
        }
        this._sequenceToken = string;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setSequenceToken");
        }
    }

    public String getSequenceToken() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSequenceToken");
            Tr.exit(tc, "getSequenceToken", this._sequenceToken);
        }
        return this._sequenceToken;
    }

    public boolean isActive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isActive");
            Tr.exit(tc, "isActive", this._isActive);
        }
        return this._isActive;
    }

    public boolean hasSentMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "hasSentMessages");
        }
        boolean bl = false;
        if (this._senderBean != null && this._senderBean.getMessageType() != 4) {
            bl = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "hasSentMessages", bl);
        }
        return bl;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/impl/storage/TransactionImpl.java, WAS.rm, WSFP.WSERV1, cf230905.09 1.64");
        }
    }
}

