/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.wsrm.MEConnectionProperties;
import com.ibm.ws.sib.wsrm.MEStoreConnection;
import com.ibm.ws.sib.wsrm.MEStoreConnectionFactory;
import com.ibm.ws.sib.wsrm.MEStoreConnectionListener;
import com.ibm.ws.sib.wsrm.WSRMConstants;
import com.ibm.ws.sib.wsrm.exceptions.MEStoreConnectionException;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager;
import com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl;
import com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator;
import com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManager;
import com.ibm.ws.websvcs.rm.impl.storage.beanmanagers.InvokerBeanMgrImpl;
import com.ibm.ws.websvcs.rm.impl.storage.beanmanagers.RMDBeanMgrImpl;
import com.ibm.ws.websvcs.rm.impl.storage.beanmanagers.RMSBeanMgrImpl;
import com.ibm.ws.websvcs.rm.impl.storage.beanmanagers.SenderBeanMgrImpl;
import com.ibm.ws.websvcs.rm.mbeans.dao.StorageManagerDetail;
import com.ibm.ws.websvcs.rm.policyset.RMServiceConfigPlugin;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.polling.PollingManager;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.workers.Invoker;
import org.apache.sandesha2.workers.SandeshaThread;
import org.apache.sandesha2.workers.Sender;

public final class PersistentStorageManagerSingleton
extends WSReliableMessagingStorageManager
implements MEStoreConnectionListener {
    private static final TraceComponent tc = Tr.register(PersistentStorageManagerSingleton.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static boolean txThreadMigratorRegistered;
    private static final int ME_WAIT_INTERVAL = 120;
    private static final int CONNECTION_TIMEOUT = 60000;
    private static final int STORE_KEY_PROCESS_VALUE = 20;
    private RMSBeanMgr _rmsBeanMgr;
    private InvokerBeanMgr _invokerBeanMgr;
    private RMDBeanMgr _rmdBeanMgr;
    private SenderBeanMgr _senderBeanMgr;
    private HashMap _transactions = new HashMap();
    private CommandInvoker _commandInvoker;
    private MEStoreConnection _meStoreConnection;
    private String _busName = null;
    private String _messagingEngineName = null;
    private boolean _connectionOpened = false;
    private volatile boolean _initRequired = true;
    private boolean _persistentStoreChosen = false;
    private volatile boolean _initWasSuccessful = false;
    private boolean _isManagedPersistent = false;
    private SandeshaThread _sender = null;
    private SandeshaThread _invoker = null;
    private PollingManager _pollingManager;
    private HashMap _messageCtxToConfigContextMap = new HashMap();
    private HashMap _storageKeysMap = new HashMap();
    private HashMap _connections = new HashMap();
    private final long _retransmissionInterval;
    private long _removeStaleConnectionsTimeout = System.currentTimeMillis() + 60000L;
    ThreadPool _systemThreadPool = new ThreadPool("System RM Persistent store Threadpool", 1, 1);
    private ClassLoader _classLoader;

    public PersistentStorageManagerSingleton(ConfigurationContext configurationContext) throws SandeshaException {
        super(configurationContext, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "PersistentStorageManagerSingleton", configurationContext);
        }
        this._isManagedPersistent = false;
        if (RMServiceConfigPlugin.isInorder(configurationContext.getAxisConfiguration())) {
            this._invoker = new Invoker();
        }
        SandeshaPolicyBean sandeshaPolicyBean = SandeshaUtil.getPropertyBean(configurationContext.getAxisConfiguration());
        this._retransmissionInterval = sandeshaPolicyBean.getRetransmissionInterval();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "PersistentStorageManagerSingleton", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoreKeyToContext(String string, MessageContext messageContext) {
        Serializable serializable;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addStoreKeyToContext", new Object[]{string, messageContext});
        }
        SerializedStorageEntry serializedStorageEntry = new SerializedStorageEntry();
        serializedStorageEntry.context = messageContext.getConfigurationContext();
        serializedStorageEntry.msgContext = messageContext;
        OperationContext operationContext = messageContext.getOperationContext();
        if (operationContext != null) {
            serializable = null;
            try {
                serializable = operationContext.getMessageContext("In");
            }
            catch (AxisFault axisFault) {
                FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.addStoreKeyToContext", "1:301:1.44.1.18", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "addStoreKeyToContext", axisFault);
                }
                throw new RuntimeException(axisFault);
            }
            if (serializable != null) {
                serializedStorageEntry.inTransportControl = ((MessageContext)serializable).getProperty("RequestResponseTransportControl");
                serializedStorageEntry.inTransportOut = ((MessageContext)serializable).getProperty("TRANSPORT_OUT");
                serializedStorageEntry.inTransportOutInfo = ((MessageContext)serializable).getProperty("OutTransportInfo");
            }
        }
        serializedStorageEntry.transportControl = messageContext.getProperty("RequestResponseTransportControl");
        serializedStorageEntry.transportOut = messageContext.getProperty("TRANSPORT_OUT");
        serializedStorageEntry.transportOutInfo = messageContext.getProperty("OutTransportInfo");
        serializable = this._messageCtxToConfigContextMap;
        synchronized (serializable) {
            this._messageCtxToConfigContextMap.put(string, serializedStorageEntry);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addStoreKeyToContext", serializedStorageEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStoreKeyToContext(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeStoreKeyToContext", new Object[]{string});
        }
        HashMap hashMap = this._messageCtxToConfigContextMap;
        synchronized (hashMap) {
            this._messageCtxToConfigContextMap.remove(string);
        }
        hashMap = this._storageKeysMap;
        synchronized (hashMap) {
            this._storageKeysMap.remove(string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeStoreKeyToContext");
        }
    }

    private synchronized boolean initSuccessful() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initSuccessful");
            Tr.exit(tc, "initSuccessful", this._initWasSuccessful);
        }
        return this._initWasSuccessful;
    }

    private synchronized void setInitSuccessful() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setInitSuccessful");
        }
        this._initWasSuccessful = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setInitSuccessful");
        }
    }

    private void assertInitWasSuccessful() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "assertInitWasSuccessful");
        }
        if (!this.initSuccessful()) {
            Tr.warning(tc, "ME_UNAVAILABLE_CWSKA0109", (Object)new Object[]{this._messagingEngineName, this._busName, WSRMModule.getApplicationName(this.getContext())});
            int n = 120;
            while (!this.initSuccessful() && n > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Sleeping waiting for Messaging Engine " + n);
                }
                --n;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "assertInitWasSuccessful", "ME not started");
            }
            throw new IllegalStateException(nls.getFormattedMessage("ME_UNAVAILABLE_CWSKA0108", new Object[]{this._messagingEngineName, this._busName}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "assertInitWasSuccessful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTxThreadMigratorIfNecessary() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerTxThreadMigratorIfNecessary");
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!txThreadMigratorRegistered) {
                ThreadContextMigratorUtil.addThreadContextMigrator(this.getContext(), "JAXWS-ThreadContextMigrator-List", TransactionThreadMigrator.getInstance());
                txThreadMigratorRegistered = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerTxThreadMigratorIfNecessary");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messagingEngineConnectionClosed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "messagingEngineConnectionClosed");
        }
        PersistentStorageManagerSingleton persistentStorageManagerSingleton = this;
        synchronized (persistentStorageManagerSingleton) {
            this._connectionOpened = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "messagingEngineConnectionClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messagingEngineConnectionOpened() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "messagingEngineConnectionOpened");
        }
        boolean bl = false;
        PersistentStorageManagerSingleton persistentStorageManagerSingleton = this;
        synchronized (persistentStorageManagerSingleton) {
            if (!this._connectionOpened) {
                bl = this._persistentStoreChosen;
                this._connectionOpened = true;
            }
        }
        if (bl) {
            this.initializeStore();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "messagingEngineConnectionOpened");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeStore");
        }
        this._connectionOpened = true;
        TransactionThreadMigrator.ThreadTxContextInformation threadTxContextInformation = null;
        if (this._initRequired) {
            this._initRequired = false;
            try {
                threadTxContextInformation = TransactionThreadMigrator.getInstance().startWSRMTransactionalCall(false);
                List list = this._commandInvoker.loadSequences(this.getWorkKey());
                if (list != null && list.size() > 0) {
                    for (RMSequenceBean rMSequenceBean : list) {
                        String string = rMSequenceBean.getSecurityTokenData();
                        if (string != null) {
                            IBMSecurityManager iBMSecurityManager = (IBMSecurityManager)SandeshaUtil.getSecurityManager(this.getContext());
                            iBMSecurityManager.initSecurityToken(string);
                        }
                        SandeshaUtil.startWorkersForSequence(this.getContext(), rMSequenceBean);
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                        Tr.entry(tc, "run", "Setting the classLoader on the threads");
                                    }
                                    if (PersistentStorageManagerSingleton.this.getInvoker() != null) {
                                        PersistentStorageManagerSingleton.this.getInvoker().setContextClassLoader(PersistentStorageManagerSingleton.this._classLoader);
                                    }
                                    PersistentStorageManagerSingleton.this.getSender().setContextClassLoader(PersistentStorageManagerSingleton.this._classLoader);
                                    PersistentStorageManagerSingleton.this.getPollingManager().setContextClassLoader(PersistentStorageManagerSingleton.this._classLoader);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                        Tr.exit(tc, "run", null);
                                    }
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.initializeStore", "1:529:1.44.1.18", this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                Tr.exit(tc, "initializeStore", "RuntimeException");
                            }
                            throw new RuntimeException(privilegedActionException);
                        }
                    }
                }
            }
            catch (AxisFault axisFault) {
                FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.initializeStore", "1:546:1.44.1.18", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "initializeStore", axisFault);
                }
                throw new RuntimeException(axisFault);
            }
            finally {
                try {
                    TransactionThreadMigrator.getInstance().finishWSRMTransactionalCall(threadTxContextInformation);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.initializeStore", "1:563:1.44.1.18", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "initializeStore", exception);
                    }
                    throw new RuntimeException(exception);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeStore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistentStoreChosen(ClassLoader classLoader) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "persistentStoreChosen", classLoader);
        }
        this._classLoader = classLoader;
        boolean bl = false;
        PersistentStorageManagerSingleton persistentStorageManagerSingleton = this;
        synchronized (persistentStorageManagerSingleton) {
            this._persistentStoreChosen = true;
            bl = this._connectionOpened;
        }
        if (bl) {
            this.initializeStore();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "persistentStoreChosen");
        }
    }

    public void initStorage(AxisModule axisModule) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initStorage", axisModule);
        }
        if (this.isRunningInClientContainer()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initStorage", "no init of storage manager as in client container");
            }
            return;
        }
        if (!RMServiceConfigPlugin.isManagedQOS(this.getContext().getAxisConfiguration())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "non managed QOS - not initializing the storage manager");
            }
        } else if (!this.initSuccessful()) {
            this._isManagedPersistent = RMServiceConfigPlugin.isManagedPersistentQOS(this.getContext().getAxisConfiguration());
            this._busName = RMServiceConfigPlugin.getBusName(this.getContext().getAxisConfiguration());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "busName=", this._busName);
            }
            this._messagingEngineName = RMServiceConfigPlugin.getMessagingEngineName(this.getContext().getAxisConfiguration());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "messagingEngineName=", this._messagingEngineName);
            }
            if (this._busName == null || this._messagingEngineName == null || this._busName.equals("") || this._messagingEngineName.equals("")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bus details were not complete");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "initStorage", "SandeshaStorageException");
                }
                throw new SandeshaStorageException(nls.getFormattedMessage("INCOMPELTE_BINDING_ERROR_CWSKA0102", null, null));
            }
            this._commandInvoker = new CommandInvoker();
            this._rmsBeanMgr = new RMSBeanMgrImpl(this);
            this._invokerBeanMgr = new InvokerBeanMgrImpl(this);
            this._rmdBeanMgr = new RMDBeanMgrImpl(this);
            this._senderBeanMgr = new SenderBeanMgrImpl(this);
            this._systemThreadPool.setGrowAsNeeded(true);
            this._systemThreadPool.setRequestBufferExpansionLimit(Integer.MAX_VALUE);
            final String string = this._busName;
            final String string2 = this._messagingEngineName;
            Runnable runnable = new Runnable(){

                public void run() {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry(tc, "run");
                    }
                    MEStoreConnectionFactory mEStoreConnectionFactory = MEStoreConnectionFactory.getInstance();
                    PersistentStorageManagerSingleton.this._meStoreConnection = mEStoreConnectionFactory.createMEStoreConnection(string, string2, PersistentStorageManagerSingleton.this, PersistentStorageManagerSingleton.this._connections);
                    try {
                        PersistentStorageManagerSingleton.this._meStoreConnection.initialize();
                    }
                    catch (MEStoreConnectionException mEStoreConnectionException) {
                        FFDCFilter.processException((Throwable)mEStoreConnectionException, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.run", "1:690:1.44.1.18", this);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                }
            };
            try {
                this._systemThreadPool.execute(runnable);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.initStorage", "1:708:1.44.1.18", this);
            }
            this.registerMBean();
            this.registerTxThreadMigratorIfNecessary();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "init compelte");
            }
            this.setInitSuccessful();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initStorage");
        }
    }

    protected boolean isStoreBeingUsed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isStoreBeingUsed");
        }
        boolean bl = RMServiceConfigPlugin.isManagedQOS(this.getContext().getAxisConfiguration());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isStoreBeingUsed", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransaction");
        }
        this.assertInitWasSuccessful();
        Thread thread = Thread.currentThread();
        TransactionImpl transactionImpl = null;
        HashMap hashMap = this._transactions;
        synchronized (hashMap) {
            if (this._transactions.get(thread) == null) {
                this.closeStaleConnections();
                transactionImpl = new TransactionImpl(this, this._isManagedPersistent);
                this._transactions.put(thread, transactionImpl);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Warning - possible reused transaction");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransaction", transactionImpl);
        }
        return transactionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStaleConnections() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "closeStaleConnections");
        }
        HashMap hashMap = this._connections;
        synchronized (hashMap) {
            block12: {
                if (this._connections.size() > 1 && System.currentTimeMillis() > this._removeStaleConnectionsTimeout) {
                    block11: {
                        final long l = System.currentTimeMillis();
                        this._removeStaleConnectionsTimeout = l + 60000L;
                        Runnable runnable = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.entry(tc, "run", "Running connection closer thread");
                                }
                                HashMap hashMap = null;
                                HashMap hashMap2 = PersistentStorageManagerSingleton.this._connections;
                                synchronized (hashMap2) {
                                    hashMap = (HashMap)PersistentStorageManagerSingleton.this._connections.clone();
                                }
                                for (Long l3 : hashMap.keySet()) {
                                    MEConnectionProperties mEConnectionProperties = (MEConnectionProperties)hashMap.get(l3);
                                    long l2 = mEConnectionProperties.getLastActivated();
                                    if (l2 + 60000L >= l) continue;
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Closing connection with id " + l3);
                                    }
                                    mEConnectionProperties.getConnection().close();
                                    HashMap hashMap3 = PersistentStorageManagerSingleton.this._connections;
                                    synchronized (hashMap3) {
                                        PersistentStorageManagerSingleton.this._connections.remove(l3);
                                    }
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, "run");
                                }
                            }
                        };
                        try {
                            this._systemThreadPool.execute(runnable);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                            Tr.debug(tc, "Caught exception running closer thread ", interruptedException);
                        }
                    }
                    if (WSRMModule.getClusterName() != null && this._storageKeysMap.size() > 20) {
                        Runnable runnable = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.entry(tc, "run", "Running msgContext remover");
                                }
                                ArrayList arrayList = new ArrayList();
                                HashMap<Object, Object> hashMap = PersistentStorageManagerSingleton.this._storageKeysMap;
                                synchronized (hashMap) {
                                    arrayList.addAll(PersistentStorageManagerSingleton.this._storageKeysMap.keySet());
                                }
                                try {
                                    Object object;
                                    hashMap = new HashMap<Object, Object>();
                                    hashMap.put(WSRMConstants.WORK_KEY, PersistentStorageManagerSingleton.this.getWorkKey());
                                    hashMap.put("MSG_CONTEXTS", arrayList);
                                    List list = PersistentStorageManagerSingleton.this.getCommandInvoker().getDeletedMessageContexts(hashMap);
                                    if (list != null && list.size() > 0) {
                                        for (int i = 0; i < list.size(); ++i) {
                                            object = (String)list.get(i);
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Removing MessageContext with key " + (String)object);
                                            }
                                            PersistentStorageManagerSingleton.this.removeMessageContextState((String)object);
                                        }
                                    }
                                    MEConnectionProperties mEConnectionProperties = null;
                                    object = PersistentStorageManagerSingleton.this._connections;
                                    synchronized (object) {
                                        mEConnectionProperties = (MEConnectionProperties)PersistentStorageManagerSingleton.this._connections.remove(new Long(Thread.currentThread().getId()));
                                    }
                                    if (mEConnectionProperties != null) {
                                        mEConnectionProperties.getConnection().close();
                                    }
                                }
                                catch (MEStoreConnectionException mEStoreConnectionException) {
                                    FFDCFilter.processException((Throwable)mEStoreConnectionException, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.run", "1:904:1.44.1.18", this);
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, "run");
                                }
                            }
                        };
                        try {
                            this._systemThreadPool.execute(runnable);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block12;
                            Tr.debug(tc, "Caught exception running message context deleter ", interruptedException);
                        }
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "closeStaleConnections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnectionsForShutdown() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "closeConnectionsForShutdown");
        }
        HashMap hashMap = this._transactions;
        synchronized (hashMap) {
            Iterator iterator = this._transactions.values().iterator();
            while (iterator.hasNext()) {
                try {
                    ((Transaction)iterator.next()).rollback();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.closeConnectionsForShutdown", "1:953:1.44.1.18", this);
                }
            }
        }
        this.closeConnections();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "closeConnectionsForShutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "closeConnections");
        }
        HashMap hashMap = this._connections;
        synchronized (hashMap) {
            Iterator iterator = this._connections.values().iterator();
            while (iterator.hasNext()) {
                MEConnectionProperties mEConnectionProperties = (MEConnectionProperties)iterator.next();
                mEConnectionProperties.getConnection().close();
                iterator.remove();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "closeConnections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionImpl getInUseTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInUseTransaction");
        }
        this.assertInitWasSuccessful();
        TransactionImpl transactionImpl = null;
        HashMap hashMap = this._transactions;
        synchronized (hashMap) {
            transactionImpl = (TransactionImpl)this._transactions.get(Thread.currentThread());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInUseTransaction", transactionImpl);
        }
        return transactionImpl;
    }

    public String getApplicationInstanceKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationInstanceKey");
        }
        String string = this.getWorkKey() + "#" + WSRMModule.getNodeName() + "#" + WSRMModule.getServerName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationInstanceKey", string);
        }
        return string;
    }

    public RMSBeanMgr getRMSBeanMgr() {
        this.assertInitWasSuccessful();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMSBeanMgr");
            Tr.exit(tc, "getRMSBeanMgr", this._rmsBeanMgr);
        }
        return this._rmsBeanMgr;
    }

    public RMDBeanMgr getRMDBeanMgr() {
        this.assertInitWasSuccessful();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMDBeanMgr");
            Tr.exit(tc, "getRMDBeanMgr", this._rmdBeanMgr);
        }
        return this._rmdBeanMgr;
    }

    public SenderBeanMgr getSenderBeanMgr() {
        this.assertInitWasSuccessful();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSenderBeanMgr");
            Tr.exit(tc, "getSenderBeanMgr", this._senderBeanMgr);
        }
        return this._senderBeanMgr;
    }

    public InvokerBeanMgr getInvokerBeanMgr() {
        this.assertInitWasSuccessful();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvokerBeanMgr");
            Tr.exit(tc, "getInvokerBeanMgr", this._invokerBeanMgr);
        }
        return this._invokerBeanMgr;
    }

    public void storeMessageContext(String string, MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "storeMessageContext", new Object[]{string, messageContext.getEnvelope().getHeader()});
        }
        this.assertInitWasSuccessful();
        if (string == null) {
            string = SandeshaUtil.getUUID();
        }
        this.addStoreKeyToContext(string, messageContext);
        this.getInUseTransaction().storeMessageContext(string, messageContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "storeMessageContext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessageContext(String string, MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMessageContext", new Object[]{string, messageContext.getEnvelope().getHeader()});
        }
        this.assertInitWasSuccessful();
        this.getInUseTransaction().updateMessageContext(string, messageContext);
        HashMap hashMap = this._messageCtxToConfigContextMap;
        synchronized (hashMap) {
            this._messageCtxToConfigContextMap.remove(string);
        }
        this.addStoreKeyToContext(string, messageContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMessageContext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageContext retrieveMessageContext(String string, ConfigurationContext configurationContext) throws SandeshaStorageException {
        Object object;
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveMessageContext", new Object[]{string, configurationContext});
        }
        this.assertInitWasSuccessful();
        MessageContext messageContext = null;
        String string2 = null;
        byte[] byArray = this.getInUseTransaction().getMessageContext(string);
        if (byArray == null) {
            object2 = new String[]{this.getWorkKey(), string};
            object = (List)((Object)this.getCommandInvoker().retrieveMessageContext((String[])object2));
            if (object != null) {
                string2 = (String)object.get(0);
                byArray = (byte[])object.get(1);
            }
            this.addMappedKey(string, string2);
        } else {
            string2 = string;
        }
        if (byArray != null) {
            object2 = null;
            object = this._messageCtxToConfigContextMap;
            synchronized (object) {
                object2 = (SerializedStorageEntry)this._messageCtxToConfigContextMap.get(string2);
            }
            object = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Got entry " + object2);
            }
            if (object2 != null) {
                object = object2.context;
            }
            if (object == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to find configuration context in map, so using one provided");
                }
                object = configurationContext;
            }
            if (object2 == null || object2.msgContext == null) {
                messageContext = this.deserializeMessageContext(byArray, (ConfigurationContext)object);
                OperationContext operationContext = messageContext.getOperationContext();
                if (operationContext != null) {
                    MessageContext messageContext2 = null;
                    try {
                        messageContext2 = operationContext.getMessageContext("In");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found inMsgCtx " + messageContext2);
                        }
                    }
                    catch (AxisFault axisFault) {
                        FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.retrieveMessageContext", "1:1213:1.44.1.18", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "retrieveMessageContext", axisFault);
                        }
                        throw new RuntimeException(axisFault);
                    }
                    if (messageContext2 != null && object2 != null) {
                        messageContext2.setProperty("RequestResponseTransportControl", object2.inTransportControl);
                        messageContext2.setProperty("TRANSPORT_OUT", object2.inTransportOut);
                        messageContext2.setProperty("OutTransportInfo", object2.inTransportOutInfo);
                    }
                }
                if (object2 != null) {
                    messageContext.setProperty("RequestResponseTransportControl", object2.transportControl);
                    messageContext.setProperty("TRANSPORT_OUT", object2.transportOut);
                    messageContext.setProperty("OutTransportInfo", object2.transportOutInfo);
                }
            } else {
                messageContext = object2.msgContext;
                object2.msgContext = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            object2 = null;
            if (messageContext != null && messageContext.getEnvelope().getHeader() != null) {
                object2 = messageContext.getEnvelope().getHeader().toString();
            }
            Tr.exit(tc, "retrieveMessageContext", object2);
        }
        return messageContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMappedKey(String string, String string2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addMappedKey", new Object[]{string, string2});
        }
        HashMap hashMap = this._storageKeysMap;
        synchronized (hashMap) {
            this._storageKeysMap.put(string, string2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addMappedKey");
        }
    }

    private MessageContext deserializeMessageContext(byte[] byArray, ConfigurationContext configurationContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deserializeMessageContext", new Object[]{configurationContext, byArray});
        }
        MessageContext messageContext = null;
        try {
            if (byArray != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                messageContext = (MessageContext)objectInputStream.readObject();
                messageContext.activate(configurationContext);
                byteArrayInputStream.close();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.deserializeMessageContext", "1:1304:1.44.1.18");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "deserializeMessageContext", iOException);
            }
            throw new RuntimeException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionImpl", "1:1309:1.44.1.18"}, null), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.deserializeMessageContext", "1:1318:1.44.1.18");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "deserializeMessageContext", classNotFoundException);
            }
            throw new RuntimeException(classNotFoundException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deserializeMessageContext", messageContext);
        }
        return messageContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTransaction");
        }
        this.assertInitWasSuccessful();
        HashMap hashMap = this._transactions;
        synchronized (hashMap) {
            this._transactions.remove(Thread.currentThread());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTransaction");
        }
    }

    public CommandInvoker getCommandInvoker() {
        this.assertInitWasSuccessful();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandInvoker");
            Tr.exit(tc, "getCommandInvoker", this._commandInvoker);
        }
        return this._commandInvoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MEStoreConnection getConnectionForThread() throws MEStoreConnectionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionForThread");
        }
        MEStoreConnection mEStoreConnection = null;
        HashMap hashMap = this._connections;
        synchronized (hashMap) {
            MEConnectionProperties mEConnectionProperties = (MEConnectionProperties)this._connections.get(new Long(Thread.currentThread().getId()));
            if (mEConnectionProperties == null) {
                try {
                    mEStoreConnection = MEStoreConnectionFactory.getInstance().createMEStoreConnection(this._busName, this._messagingEngineName, this, this._connections);
                    mEStoreConnection.initialize();
                    mEConnectionProperties = new MEConnectionProperties(mEStoreConnection);
                    this._connections.put(new Long(Thread.currentThread().getId()), mEConnectionProperties);
                }
                catch (MEStoreConnectionException mEStoreConnectionException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getConnectionForThread", mEStoreConnectionException);
                    }
                    throw mEStoreConnectionException;
                }
            } else {
                mEStoreConnection = mEConnectionProperties.getConnection();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionForThread", mEStoreConnection);
        }
        return mEStoreConnection;
    }

    public void removeMessageContext(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeMessageContext", string);
        }
        this.assertInitWasSuccessful();
        if (string.startsWith("urn:uuid:")) {
            this.removeStoreKeyToContext(string);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "removeMessageContext", "Ignoring message with key " + string);
            }
            return;
        }
        this.removeMessageContextState(string);
        this.getInUseTransaction().deleteMessageContext(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeMessageContext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessageContextState(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeMessageContextState", string);
        }
        String string2 = null;
        HashMap hashMap = this._storageKeysMap;
        synchronized (hashMap) {
            string2 = (String)this._storageKeysMap.remove(string);
        }
        if (string2 == null) {
            string2 = string;
        }
        this.removeStoreKeyToContext(string2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeMessageContextState");
        }
    }

    protected StorageManager getApplicationStorageManager() {
        throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"PersistentStorageManagerSingleton", "1:1597:1.44.1.18"}, null));
    }

    protected String getMapKey() {
        throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"PersistentStorageManagerSingleton", "1:1604:1.44.1.18"}, null));
    }

    public synchronized StorageManagerDetail getStorageManagerDetails(Locale locale) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getStorageManagerDetails", locale);
        }
        String string = null;
        string = this._isManagedPersistent ? TraceNLS.getFormattedMessage("com.ibm.ws.websvcs.rm.CWSKAMessages", "MANAGED_PERSISTENT_APPLICATION_CWSKA0103", locale, new Object[]{WSRMModule.getApplicationName(this.getContext()) + "," + WSRMModule.getServerName()}, null) : TraceNLS.getFormattedMessage("com.ibm.ws.websvcs.rm.CWSKAMessages", "MANAGED_NONPERSISTENT_APPLICATION_CWSKA0104", locale, new Object[]{WSRMModule.getApplicationName(this.getContext()) + "," + WSRMModule.getServerName()}, null);
        String string2 = null;
        if (this._connectionOpened) {
            string2 = TraceNLS.getFormattedMessage("com.ibm.ws.websvcs.rm.CWSKAMessages", "STORE_STATUS_ME_UP_CWSKA0107", locale, new Object[]{this._messagingEngineName, this._busName}, null);
        } else {
            try {
                if (this._persistentStoreChosen) {
                    this.getConnectionForThread();
                }
            }
            catch (MEStoreConnectionException mEStoreConnectionException) {
                // empty catch block
            }
            string2 = this._connectionOpened ? TraceNLS.getFormattedMessage("com.ibm.ws.websvcs.rm.CWSKAMessages", "STORE_STATUS_ME_UP_CWSKA0107", locale, new Object[]{this._messagingEngineName, this._busName}, null) : TraceNLS.getFormattedMessage("com.ibm.ws.websvcs.rm.CWSKAMessages", "STORE_STATUS_ME_DOWN_CWSKA0106", locale, new Object[]{this._messagingEngineName, this._busName}, null);
        }
        StorageManagerDetail storageManagerDetail = new StorageManagerDetail("meStore##" + this.getApplicationInstanceKey(), string, true, true, this._busName, this._messagingEngineName, this._connectionOpened, string2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getStorageManagerDetails", storageManagerDetail);
        }
        return storageManagerDetail;
    }

    public synchronized SandeshaThread getInvoker() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvoker");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvoker", this._invoker);
        }
        return this._invoker;
    }

    public SandeshaThread getSender() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSender");
        }
        if (this._sender == null) {
            this._sender = new Sender();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSender", this._sender);
        }
        return this._sender;
    }

    public PollingManager getPollingManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPollingManager");
        }
        if (this._pollingManager == null) {
            this._pollingManager = new PollingManager();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPollingManager", this._pollingManager);
        }
        return this._pollingManager;
    }

    long getRetransmissionInterval() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRetransmissionInterval");
            Tr.exit(tc, "getRetransmissionInterval", new Long(this._retransmissionInterval));
        }
        return this._retransmissionInterval;
    }

    public boolean requiresMessageSerialization() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "requiresMessageSerialization");
            Tr.exit(tc, "requiresMessageSerialization", Boolean.TRUE);
        }
        return true;
    }

    public boolean hasUserTransaction(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "hasUserTransaction");
        }
        boolean bl = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "hasUserTransaction", bl);
        }
        return bl;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/impl/storage/PersistentStorageManagerSingleton.java, WAS.rm, WSFP.WSERV1, cf230905.09 1.44.1.18");
        }
    }

    public class CommandInvoker {
        public List findSenderBeansForSequence(String[] stringArray) throws MEStoreConnectionException {
            return (List)((Object)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("8", (Serializable)stringArray));
        }

        public HashMap findSenderBeansForSequence2(String[] stringArray) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("21", (Serializable)stringArray);
        }

        public Serializable retrieveMessageContext(String[] stringArray) throws MEStoreConnectionException {
            return PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("2", (Serializable)stringArray);
        }

        public List findSenderBeans(Object[] objectArray) throws MEStoreConnectionException {
            return (List)((Object)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("4", (Serializable)objectArray));
        }

        public HashMap retrieveSenderBean(String[] stringArray) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("23", (Serializable)stringArray);
        }

        public HashMap getNextMessageToSend(HashMap hashMap) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("22", hashMap);
        }

        public HashMap retrieveRMDBean(HashMap hashMap) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("7", hashMap);
        }

        public boolean checkTransactionStatue(HashMap hashMap) throws MEStoreConnectionException {
            return (Boolean)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("6", hashMap);
        }

        public HashMap retrieveRMSBean(HashMap hashMap) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("9", hashMap);
        }

        public HashMap findRMSBeans(HashMap hashMap) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("10", hashMap);
        }

        public List findInvokerBeans(Object[] objectArray) throws MEStoreConnectionException {
            return (List)((Object)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("11", (Serializable)objectArray));
        }

        public void processTransactionCommit(HashMap hashMap) throws MEStoreConnectionException {
            PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("1", hashMap);
        }

        public void processTransactionRollback(String string) throws MEStoreConnectionException {
            PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("12", (Serializable)((Object)string));
        }

        public List loadSequences(String string) throws MEStoreConnectionException {
            return (List)((Object)PersistentStorageManagerSingleton.this._meStoreConnection.invokeCommand("13", (Serializable)((Object)string)));
        }

        public InvokerBean retrieveInvokerBean(Object[] objectArray) throws MEStoreConnectionException {
            return (InvokerBean)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("14", (Serializable)objectArray);
        }

        public HashMap findRMDBeans(HashMap hashMap) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("15", hashMap);
        }

        public HashMap findUniqueRMSBean(HashMap hashMap) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("16", hashMap);
        }

        public Boolean insertInvokerBean(HashMap hashMap) throws MEStoreConnectionException {
            return (Boolean)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("17", hashMap);
        }

        public HashMap insertRMSBean(HashMap hashMap) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("18", hashMap);
        }

        public HashMap insertRMDBean(HashMap hashMap) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("19", hashMap);
        }

        public HashMap findSenderBeansWithLock(Object[] objectArray) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("20", (Serializable)objectArray);
        }

        public HashMap getNextMessageToSend2(List list) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("22", (Serializable)((Object)list));
        }

        public void forceTransactionRollback(String string) throws MEStoreConnectionException {
            PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("24", (Serializable)((Object)string));
        }

        public List getDeletedMessageContexts(HashMap hashMap) throws MEStoreConnectionException {
            return (List)((Object)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("25", hashMap));
        }
    }

    private class SerializedStorageEntry {
        ConfigurationContext context;
        MessageContext msgContext;
        Object transportControl;
        Object transportOut;
        Object transportOutInfo;
        Object inTransportControl;
        Object inTransportOut;
        Object inTransportOutInfo;

        private SerializedStorageEntry() {
        }

        public String toString() {
            return this.context + " : " + this.transportControl + " : " + this.inTransportControl;
        }
    }
}

