/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManager;
import com.ibm.ws.websvcs.rm.impl.storage.beanmanagers.InvokerBeanMgrImpl;
import com.ibm.ws.websvcs.rm.mbeans.dao.InboundMessageData;
import com.ibm.ws.websvcs.rm.mbeans.dao.InboundSequenceData;
import com.ibm.ws.websvcs.rm.mbeans.dao.MessageData;
import com.ibm.ws.websvcs.rm.mbeans.dao.OutboundMessageData;
import com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData;
import com.ibm.ws.websvcs.rm.mbeans.dao.SequenceData;
import com.ibm.ws.websvcs.rm.mbeans.dao.StorageManagerDetail;
import com.ibm.ws.websvcs.rm.mbeans.exceptions.WSRMMBeanException;
import com.ibm.ws.websvcs.rm.storage.controller.ControllableStore;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMBeanManager;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMBean;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.workers.Invoker;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.MessageNumber;
import org.apache.sandesha2.wsrm.Sequence;

public class ApplicationWSRMStoreController
implements ControllableStore {
    private static final TraceComponent tc = Tr.register(ApplicationWSRMStoreController.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static HashMap serviceClientMap;
    private WSReliableMessagingStorageManager storageManager;
    private Properties props;
    private final int MAX_SLEEP_COUNT = 5;
    private final int SLEEP_TIME = 600;

    public ApplicationWSRMStoreController(WSReliableMessagingStorageManager wSReliableMessagingStorageManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "ApplicationWSRMStoreController", wSReliableMessagingStorageManager);
        }
        this.storageManager = wSReliableMessagingStorageManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ApplicationWSRMStoreController", this);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SequenceData populateSequenceData(String string, boolean bl, RMSequenceBean rMSequenceBean) throws WSRMMBeanException {
        void var4_8;
        block35: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "populateSequenceData", new Object[]{string, bl, rMSequenceBean});
            }
            Object var4_4 = null;
            try {
                void var18_33;
                OutboundSequenceData outboundSequenceData;
                LinkedList<String> linkedList;
                long l;
                long l2;
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                block37: {
                    int n;
                    string7 = null;
                    string7 = bl ? SandeshaUtil.getSequenceIDFromInternalSequenceID(string, this.storageManager) : string;
                    string6 = "UNKNOWN DATA";
                    string5 = "UNKNOWN DATA";
                    RMSequenceBean rMSequenceBean2 = rMSequenceBean;
                    string4 = "UNKNOWN DATA";
                    if (!bl) {
                        if (rMSequenceBean2 == null) {
                            rMSequenceBean2 = SandeshaUtil.getRMDBeanFromSequenceId(this.storageManager, string7);
                        }
                        if (rMSequenceBean2 != null) {
                            string4 = rMSequenceBean2.getReplyToEPR();
                        }
                    } else {
                        if (rMSequenceBean2 == null) {
                            rMSequenceBean2 = SandeshaUtil.getRMSBeanFromInternalSequenceId(this.storageManager, string);
                        }
                        if (rMSequenceBean2 != null) {
                            string4 = rMSequenceBean2.getToEPR();
                        }
                    }
                    if (rMSequenceBean2 == null) break block35;
                    string6 = rMSequenceBean2.getRMVersion();
                    string5 = SpecSpecificConstants.getAddressingNamespace(SpecSpecificConstants.getRMNamespaceValue(string6));
                    string3 = "UNKNOWN DATA";
                    string3 = rMSequenceBean2.getAcksToEPR();
                    string2 = "UNKNOWN DATA";
                    string2 = !bl ? rMSequenceBean2.getToEPR() : rMSequenceBean2.getReplyToEPR();
                    if (!bl) {
                        void var21_42;
                        InboundSequenceData inboundSequenceData;
                        LinkedList<String> linkedList2;
                        long l3;
                        long l4;
                        boolean bl2;
                        long l5;
                        block36: {
                            int n2;
                            RMDBean rMDBean = (RMDBean)rMSequenceBean2;
                            if (rMDBean == null) break block35;
                            l5 = 0L;
                            l5 = rMDBean.getHighestInMessageNumber();
                            bl2 = false;
                            bl2 = SandeshaUtil.getPropertyBean(this.storageManager.getContext().getAxisConfiguration()).isInOrder();
                            l4 = 0L;
                            if (bl2 && (l3 = rMDBean.getNextMsgNoToProcess()) < l5) {
                                l4 = l5 - l3;
                            }
                            l3 = 0L;
                            rMDBean.getLastActivatedTime();
                            linkedList2 = new LinkedList<String>();
                            Range[] rangeArray = rMDBean.getServerCompletedMessages().getRanges();
                            for (n2 = 0; n2 < rangeArray.length; ++n2) {
                                linkedList2.add(rangeArray[n2].toString());
                            }
                            Object var21_37 = null;
                            n2 = rMDBean.isClosed() ? 1 : 0;
                            boolean bl3 = rMDBean.isTerminated();
                            if (bl3) {
                                if (linkedList2.size() != 1) {
                                    SequenceData.SequenceState sequenceState = InboundSequenceData.FAILED_MISSING_MSGS;
                                    break block36;
                                } else {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                        Tr.exit(tc, "populateSequenceData", null);
                                    }
                                    return null;
                                }
                            }
                            if (n2 != 0) {
                                SequenceData.SequenceState sequenceState = InboundSequenceData.CLOSED;
                            } else if (l4 > 0L && bl2) {
                                SequenceData.SequenceState sequenceState = InboundSequenceData.AWAITING_MSG;
                            } else {
                                SequenceData.SequenceState sequenceState = InboundSequenceData.CONNECTED;
                            }
                        }
                        InboundSequenceData inboundSequenceData2 = inboundSequenceData = new InboundSequenceData(string7, WSRMModule.getApplicationName(this.storageManager.getContext()), string5, string6, (SequenceData.SequenceState)var21_42, string3, string4, string2, linkedList2, l4, l5, l3, bl2, null);
                        break block35;
                    }
                    RMSBean rMSBean = (RMSBean)rMSequenceBean2;
                    l2 = 0L;
                    l2 = rMSBean.getHighestOutMessageNumber();
                    l = 0L;
                    long l6 = rMSBean.getNumberOfMessagesAcked();
                    l = l2 - l6;
                    linkedList = new LinkedList<String>();
                    Range[] rangeArray = rMSBean.getClientCompletedMessages().getRanges();
                    for (n = 0; n < rangeArray.length; ++n) {
                        linkedList.add(rangeArray[n].toString());
                    }
                    Object var18_26 = null;
                    n = rMSBean.isClosed() ? 1 : 0;
                    boolean bl4 = rMSBean.isSequenceClosedClient();
                    boolean bl5 = rMSBean.isTerminated();
                    boolean bl6 = rMSBean.isTerminateAdded();
                    if (string7 == null) {
                        SequenceData.SequenceState sequenceState = OutboundSequenceData.ESTABLISHING;
                    } else if ((n != 0 || bl4) && !bl5) {
                        SequenceData.SequenceState sequenceState = OutboundSequenceData.CLOSED;
                    } else if (bl6 && !bl5) {
                        SequenceData.SequenceState sequenceState = OutboundSequenceData.TERMINATING;
                    } else {
                        if (bl5) {
                            if ((long)linkedList.size() != l2) {
                                SequenceData.SequenceState sequenceState = OutboundSequenceData.FAILED;
                                break block37;
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, "populateSequenceData", null);
                                }
                                return null;
                            }
                        }
                        if (l == 0L && l2 > 0L) {
                            SequenceData.SequenceState sequenceState = OutboundSequenceData.ACTIVE;
                        } else {
                            SequenceData.SequenceState sequenceState = OutboundSequenceData.REP_UNAVAILABLE;
                        }
                    }
                }
                OutboundSequenceData outboundSequenceData2 = outboundSequenceData = new OutboundSequenceData(string7, string, WSRMModule.getApplicationName(this.storageManager.getContext()), string5, string6, (SequenceData.SequenceState)var18_33, string3, string4, string2, linkedList, l, l2, null);
            }
            catch (SandeshaException sandeshaException) {
                FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.populateSequenceData", "1:459:1.55", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "populateSequenceData", sandeshaException);
                }
                throw new WSRMMBeanException(sandeshaException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "populateSequenceData", var4_8);
        }
        return var4_8;
    }

    public Properties getProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties");
        }
        if (this.props == null) {
            this.props = new Properties();
            this.props.put("cell", WSRMModule.getCellName());
            String string = WSRMModule.getClusterName();
            if (string != null) {
                this.props.put("cluster", string);
            }
            this.props.put("node", WSRMModule.getNodeName());
            this.props.put("server", WSRMModule.getServerName());
            this.props.put("application", WSRMModule.getApplicationName(this.storageManager.getContext()));
            this.props.put("application_module", WSRMModule.getApplicationModuleName(this.storageManager.getContext()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", this.props);
        }
        return this.props;
    }

    public Collection getOutboundSequences(boolean bl, boolean bl2, String string) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundSequences", new Object[]{new Boolean(bl), new Boolean(bl2), string});
        }
        Transaction transaction = this.createTransaction();
        LinkedList<OutboundSequenceData> linkedList = new LinkedList<OutboundSequenceData>();
        try {
            RMSBeanMgr rMSBeanMgr = this.storageManager.getRMSBeanMgr();
            RMSBean rMSBean = new RMSBean();
            List list = rMSBeanMgr.find(rMSBean);
            for (RMSBean rMSBean2 : list) {
                String string2 = rMSBean2.getInternalSequenceID();
                OutboundSequenceData outboundSequenceData = (OutboundSequenceData)this.populateSequenceData(string2, true, rMSBean2);
                boolean bl3 = true;
                if (outboundSequenceData == null) {
                    bl3 = false;
                }
                if ((bl || bl2) && bl3 && (!outboundSequenceData.sequenceState.is_error_state && bl || !outboundSequenceData.sequenceState.is_warning_state && bl2)) {
                    bl3 = false;
                }
                if (string != null && bl3 && !string.equals(WSRMModule.getApplicationName(this.storageManager.getContext()))) {
                    bl3 = false;
                }
                if (linkedList.size() > 0) {
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext() && bl3) {
                        OutboundSequenceData outboundSequenceData2 = (OutboundSequenceData)iterator.next();
                        if (outboundSequenceData2.sequenceID == null || !outboundSequenceData2.sequenceID.equals(outboundSequenceData.sequenceID) || !outboundSequenceData2.info_internalSeqID.equals(outboundSequenceData.info_internalSeqID)) continue;
                        bl3 = false;
                    }
                }
                if (!bl3) continue;
                linkedList.add(outboundSequenceData);
            }
        }
        catch (SandeshaException sandeshaException) {
            FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.getOutboundSequences", "1:588:1.55", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getOutboundSequences", sandeshaException);
            }
            throw new WSRMMBeanException(sandeshaException);
        }
        finally {
            this.completeTransaction(transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundSequences", linkedList);
        }
        return linkedList;
    }

    public Collection getInboundSequences(boolean bl, boolean bl2, String string) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInboundSequences", new Object[]{new Boolean(bl), new Boolean(bl2), string});
        }
        Transaction transaction = this.createTransaction();
        LinkedList<InboundSequenceData> linkedList = new LinkedList<InboundSequenceData>();
        try {
            RMDBean rMDBean = new RMDBean();
            List list = this.storageManager.getRMDBeanMgr().find(rMDBean);
            for (RMDBean rMDBean2 : list) {
                InboundSequenceData inboundSequenceData = (InboundSequenceData)this.populateSequenceData(rMDBean2.getSequenceID(), false, rMDBean2);
                boolean bl3 = true;
                if (inboundSequenceData == null) {
                    bl3 = false;
                }
                if ((bl || bl2) && bl3 && (!inboundSequenceData.sequenceState.is_error_state && bl || !inboundSequenceData.sequenceState.is_warning_state && bl2)) {
                    bl3 = false;
                }
                if (string != null && bl3 && !string.equals(WSRMModule.getApplicationName(this.storageManager.getContext()))) {
                    bl3 = false;
                }
                if (!bl3) continue;
                linkedList.add(inboundSequenceData);
            }
        }
        catch (SandeshaException sandeshaException) {
            FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.getInboundSequences", "1:668:1.55", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getInboundSequences", sandeshaException);
            }
            throw new WSRMMBeanException(sandeshaException);
        }
        finally {
            this.completeTransaction(transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInboundSequences", linkedList);
        }
        return linkedList;
    }

    public Collection getOutboundMessagesOnSequence(OutboundSequenceData outboundSequenceData) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundMessagesOnSequence", outboundSequenceData);
        }
        Transaction transaction = this.createTransaction();
        LinkedList<OutboundMessageData> linkedList = new LinkedList<OutboundMessageData>();
        try {
            String string = outboundSequenceData.info_internalSeqID;
            TreeSet treeSet = new TreeSet(new SenderBeanComparator());
            treeSet.addAll(this.storageManager.getSenderBeanMgr().find(string));
            this.completeTransaction(transaction);
            transaction = this.createTransaction();
            for (SenderBean senderBean : treeSet) {
                Serializable serializable;
                if (senderBean.getMessageType() != 3) continue;
                String string2 = senderBean.getMessageContextRefKey();
                MessageContext messageContext = this.storageManager.retrieveMessageContext(string2, this.storageManager.getContext());
                this.completeTransaction(transaction);
                transaction = this.createTransaction();
                RMMsgContext rMMsgContext = null;
                try {
                    rMMsgContext = MsgInitializer.initializeMessage(messageContext);
                    if (rMMsgContext.getMessagePart(6) == null) {
                        serializable = SandeshaUtil.getRMSBeanFromSequenceId(this.storageManager, senderBean.getSequenceID());
                        String string3 = SpecSpecificConstants.getRMNamespaceValue(serializable.getRMVersion());
                        Sequence sequence = new Sequence(string3);
                        MessageNumber messageNumber = new MessageNumber(string3);
                        messageNumber.setMessageNumber(senderBean.getMessageNumber());
                        sequence.setMessageNumber(messageNumber);
                        Identifier identifier = new Identifier(string3);
                        String string4 = senderBean.getSequenceID();
                        if (string4 == null) {
                            string4 = "uuid:tempID";
                        }
                        identifier.setIndentifer(string4);
                        sequence.setIdentifier(identifier);
                        rMMsgContext.setMessagePart(6, sequence);
                        rMMsgContext.addSOAPEnvelope();
                    }
                }
                catch (AxisFault axisFault) {
                    FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.getOutboundMessagesOnSequence", "1:760:1.55", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getOutboundMessagesOnSequence", axisFault);
                    }
                    throw new WSRMMBeanException(axisFault);
                }
                serializable = null;
                serializable = !senderBean.isSend() ? OutboundMessageData.AWAITING_SEQUENCE_INITIALIZATION : OutboundMessageData.SENDABLE;
                long l = senderBean.getSentCount();
                linkedList.add(new OutboundMessageData(rMMsgContext, outboundSequenceData.sequenceID, string, senderBean.getMessageNumber(), (MessageData.MessageState)serializable, l));
            }
        }
        catch (SandeshaException sandeshaException) {
            FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.getOutboundMessagesOnSequence", "1:797:1.55", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getOutboundMessagesOnSequence", sandeshaException);
            }
            throw new WSRMMBeanException(sandeshaException);
        }
        finally {
            this.completeTransaction(transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundMessagesOnSequence", linkedList);
        }
        return linkedList;
    }

    public Collection getInboundMessagesOnSequence(InboundSequenceData inboundSequenceData) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInboundMessagesOnSequence", inboundSequenceData);
        }
        Transaction transaction = this.createTransaction();
        LinkedList<InboundMessageData> linkedList = new LinkedList<InboundMessageData>();
        Invoker invoker = null;
        try {
            String string = inboundSequenceData.sequenceID;
            invoker = (Invoker)this.storageManager.getInvoker();
            if (invoker != null) {
                // empty if block
            }
            InvokerBean invokerBean = new InvokerBean();
            invokerBean.setSequenceID(string);
            List list = this.storageManager.getInvokerBeanMgr().find(invokerBean);
            for (InvokerBean invokerBean2 : list) {
                String string2 = invokerBean2.getMessageContextRefKey();
                MessageContext messageContext = this.storageManager.retrieveMessageContext(string2, this.storageManager.getContext());
                RMMsgContext rMMsgContext = null;
                try {
                    rMMsgContext = MsgInitializer.initializeMessage(messageContext);
                }
                catch (AxisFault axisFault) {
                    FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.getInboundMessagesOnSequence", "1:862:1.55", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getInboundMessagesOnSequence", axisFault);
                    }
                    throw new WSRMMBeanException(axisFault);
                }
                MessageData.MessageState messageState = InboundMessageData.AWAITING_DISPATCH_TO_APPLICATION;
                long l = 0L;
                linkedList.add(new InboundMessageData(rMMsgContext, string, string, invokerBean2.getMsgNo(), messageState, l));
            }
        }
        catch (SandeshaException sandeshaException) {
            FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.getInboundMessagesOnSequence", "1:889:1.55", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getInboundMessagesOnSequence", sandeshaException);
            }
            throw new WSRMMBeanException(sandeshaException);
        }
        finally {
            this.completeTransaction(transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInboundMessagesOnSequence", linkedList);
        }
        return linkedList;
    }

    public StorageManagerDetail getStorageManagerDetails(Locale locale) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getStorageManagerDetails");
        }
        StorageManagerDetail storageManagerDetail = this.storageManager.getStorageManagerDetails(locale);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getStorageManagerDetails", storageManagerDetail);
        }
        return storageManagerDetail;
    }

    private Transaction createTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createTransaction");
            Tr.exit(tc, "createTransaction");
        }
        return this.storageManager.getTransaction();
    }

    private void completeTransaction(Transaction transaction) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTransaction", transaction);
        }
        if (transaction != null && transaction.isActive()) {
            try {
                transaction.commit();
            }
            catch (SandeshaStorageException sandeshaStorageException) {
                FFDCFilter.processException((Throwable)sandeshaStorageException, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.completeTransaction", "1:951:1.55", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "completeTransaction", sandeshaStorageException);
                }
                throw new WSRMMBeanException(sandeshaStorageException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTransaction");
        }
    }

    private void rollbackTransaction(Transaction transaction) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackTransaction", transaction);
        }
        if (transaction != null && transaction.isActive()) {
            try {
                transaction.rollback();
            }
            catch (SandeshaStorageException sandeshaStorageException) {
                FFDCFilter.processException((Throwable)sandeshaStorageException, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.rollbackTransaction", "1:979:1.55", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "rollbackTransaction", sandeshaStorageException);
                }
                throw new WSRMMBeanException(sandeshaStorageException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackTransaction");
        }
    }

    private ServiceClient buildServiceClientForSequence(SequenceData sequenceData) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "buildServiceClientForSequence", new Object[]{sequenceData});
        }
        ServiceClient serviceClient = null;
        try {
            String string;
            ConfigurationContext configurationContext = this.storageManager.getContext();
            serviceClient = new ServiceClient(configurationContext, null);
            Options options = serviceClient.getOptions();
            options.setTo(new EndpointReference(sequenceData.targetAddress));
            options.setReplyTo(new EndpointReference(sequenceData.replyToAddress));
            String string2 = null;
            if (sequenceData instanceof InboundSequenceData) {
                string2 = sequenceData.sequenceID;
            } else {
                string2 = ((OutboundSequenceData)sequenceData).info_internalSeqID;
                string = SandeshaUtil.getSequenceKeyFromInternalSequenceID(string2, sequenceData.targetAddress);
                options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, string);
            }
            options.setProperty("Sandesha2InternalSequenceId", string2);
            String string3 = string = sequenceData.wsrm_spec_version;
            options.setProperty(SandeshaClientConstants.RM_SPEC_VERSION, string3);
            options.setProperty("disableAddressingForOutMessages", Boolean.FALSE);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.buildServiceClientForSequence", "1:1037:1.55", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "buildServiceClientForSequence", exception);
            }
            throw new WSRMMBeanException(exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "buildServiceClientForSequence", serviceClient);
        }
        return serviceClient;
    }

    public void deleteSequence(SequenceData sequenceData) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteSequence", sequenceData);
        }
        Transaction transaction = this.createTransaction();
        try {
            String string = null;
            if (sequenceData instanceof OutboundSequenceData) {
                string = ((OutboundSequenceData)sequenceData).info_internalSeqID;
                RMBeanManager rMBeanManager = this.storageManager.getRMSBeanMgr();
                RMBean rMBean = new RMSBean();
                ((RMSBean)rMBean).setInternalSequenceID(string);
                rMBean = rMBeanManager.findUnique((RMSBean)rMBean);
                if (rMBean != null) {
                    this.storageManager.removeMessageContext(((RMSBean)rMBean).getCreateSequenceMsgStoreKey());
                    this.storageManager.removeMessageContext(((RMSBean)rMBean).getReferenceMessageStoreKey());
                    rMBeanManager.delete(((RMSBean)rMBean).getCreateSeqMsgID());
                }
                rMBeanManager = this.storageManager.getSenderBeanMgr();
                rMBean = new SenderBean();
                ((SenderBean)rMBean).setInternalSequenceID(string);
                List list = rMBeanManager.find((SenderBean)rMBean);
                for (int i = 0; i < list.size(); ++i) {
                    SenderBean senderBean = (SenderBean)list.get(i);
                    rMBeanManager.delete(senderBean.getMessageID());
                    this.storageManager.removeMessageContext(senderBean.getMessageContextRefKey());
                }
            } else {
                string = sequenceData.sequenceID;
                RMBeanManager rMBeanManager = this.storageManager.getRMDBeanMgr();
                rMBeanManager.delete(string);
                rMBeanManager = this.storageManager.getInvokerBeanMgr();
                List list = null;
                InvokerBean invokerBean = new InvokerBean();
                invokerBean.setSequenceID(string);
                list = rMBeanManager instanceof InvokerBeanMgrImpl && WSRMModule.getClusterName() != null ? ((InvokerBeanMgrImpl)rMBeanManager).findAll(invokerBean) : rMBeanManager.find(invokerBean);
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        InvokerBean invokerBean2 = (InvokerBean)list.get(i);
                        this.storageManager.removeMessageContext(invokerBean2.getMessageContextRefKey());
                        rMBeanManager.delete(invokerBean2.getMessageContextRefKey());
                    }
                }
            }
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.deleteSequence", "1:1147:1.55", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteSequence", exception);
            }
            throw new WSRMMBeanException(exception);
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                this.rollbackTransaction(transaction);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteSequence");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateSequence(SequenceData sequenceData) throws WSRMMBeanException {
        block24: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "terminateSequence", sequenceData);
            }
            try {
                if (sequenceData instanceof OutboundSequenceData) {
                    ServiceClient serviceClient = this.buildServiceClientForSequence(sequenceData);
                    SandeshaClient.terminateSequence(serviceClient);
                    int n = 0;
                    do {
                        Object object;
                        Transaction transaction = null;
                        List list = null;
                        try {
                            transaction = this.createTransaction();
                            object = new SenderBean();
                            ((SenderBean)object).setInternalSequenceID(((OutboundSequenceData)sequenceData).info_internalSeqID);
                            ((SenderBean)object).setMessageType(7);
                            list = this.storageManager.getSenderBeanMgr().find((SenderBean)object);
                        }
                        finally {
                            if (transaction != null && transaction.isActive()) {
                                transaction.commit();
                            }
                        }
                        if (list.isEmpty()) {
                            serviceClient.cleanup();
                            serviceClient = null;
                            break block24;
                        }
                        object = this;
                        synchronized (object) {
                            try {
                                this.wait(600L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    } while (++n < 5);
                    break block24;
                }
                Transaction transaction = null;
                try {
                    transaction = this.createTransaction();
                    ConfigurationContext configurationContext = this.storageManager.getContext();
                    if (((InboundSequenceData)sequenceData).isInOrder) {
                        TerminateManager.cleanReceivingSideAfterInvocation(sequenceData.sequenceID, this.storageManager);
                    }
                    TerminateManager.cleanReceivingSideOnTerminateMessage(configurationContext, sequenceData.sequenceID, this.storageManager);
                    RMDBean rMDBean = SandeshaUtil.getRMDBeanFromSequenceId(this.storageManager, sequenceData.sequenceID);
                    rMDBean.setTerminated(true);
                    rMDBean.setLastActivatedTime(System.currentTimeMillis());
                    this.storageManager.getRMDBeanMgr().update(rMDBean);
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                    }
                    transaction = null;
                }
                finally {
                    if (transaction != null && transaction.isActive()) {
                        transaction.rollback();
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.terminateSequence", "1:1240:1.55", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "terminateSequence", exception);
                }
                throw new WSRMMBeanException(exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "terminateSequence");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSequence(SequenceData sequenceData) throws WSRMMBeanException {
        block27: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "closeSequence", sequenceData);
            }
            try {
                if (!this.isSequenceClosingAllowed(sequenceData.wsrm_spec_version)) {
                    WSRMMBeanException wSRMMBeanException = new WSRMMBeanException(nls.getFormattedMessage("WRONG_SPEC_WARNING_CWSKA0510", new Object[]{sequenceData.targetAddress}, null));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "closeSequenceInsideOfTransaction", wSRMMBeanException);
                    }
                    throw wSRMMBeanException;
                }
                if (sequenceData instanceof OutboundSequenceData) {
                    ServiceClient serviceClient = this.buildServiceClientForSequence(sequenceData);
                    SandeshaClient.closeSequence(serviceClient);
                    int n = 0;
                    do {
                        Object object;
                        Transaction transaction = null;
                        List list = null;
                        try {
                            transaction = this.createTransaction();
                            object = new SenderBean();
                            ((SenderBean)object).setInternalSequenceID(((OutboundSequenceData)sequenceData).info_internalSeqID);
                            ((SenderBean)object).setMessageType(5);
                            list = this.storageManager.getSenderBeanMgr().find((SenderBean)object);
                        }
                        finally {
                            if (transaction != null && transaction.isActive()) {
                                transaction.commit();
                            }
                        }
                        if (list.isEmpty()) {
                            serviceClient.cleanup();
                            serviceClient = null;
                            break block27;
                        }
                        object = this;
                        synchronized (object) {
                            try {
                                this.wait(600L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    } while (++n < 5);
                    break block27;
                }
                Transaction transaction = null;
                try {
                    transaction = this.createTransaction();
                    String string = sequenceData.sequenceID;
                    RMSBean rMSBean = SandeshaUtil.getRMSBeanFromSequenceId(this.storageManager, string);
                    if (rMSBean == null) {
                        RMDBean rMDBean = SandeshaUtil.getRMDBeanFromSequenceId(this.storageManager, string);
                        rMDBean.setClosed(true);
                        this.storageManager.getRMDBeanMgr().update(rMDBean);
                    } else {
                        rMSBean.setClosed(true);
                        this.storageManager.getRMSBeanMgr().update(rMSBean);
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                    }
                }
                finally {
                    if (transaction != null && transaction.isActive()) {
                        transaction.rollback();
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.closeSequence", "1:1338:1.55", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "closeSequence", exception);
                }
                throw new WSRMMBeanException(exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "closeSequence");
        }
    }

    public byte[][] writeOutstandingSequenceMessagesToBuffer(SequenceData sequenceData) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeOutstandingSequenceMessagesToBuffer", sequenceData);
        }
        Collection collection = null;
        if (sequenceData instanceof InboundSequenceData) {
            collection = this.getInboundMessagesOnSequence((InboundSequenceData)sequenceData);
        } else if (sequenceData instanceof OutboundSequenceData) {
            collection = this.getOutboundMessagesOnSequence((OutboundSequenceData)sequenceData);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "writeOutstandingSequenceMessagesToBuffer", "Sequence ID not found");
            }
            throw new WSRMMBeanException(nls.getFormattedMessage("SEQUENCE_ID_NOT_FOUND_CWSKA0071", new Object[]{sequenceData.sequenceID}, null));
        }
        byte[][] byArrayArray = new byte[collection.size()][];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            MessageData messageData = (MessageData)iterator.next();
            byArrayArray[n] = messageData.info_soap.toString().getBytes();
            ++n;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeOutstandingSequenceMessagesToBuffer", byArrayArray);
        }
        return byArrayArray;
    }

    public void forceDispatchOfInboundMessages(InboundSequenceData inboundSequenceData) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "forceDispatchOfInboundMessages", inboundSequenceData);
        }
        Transaction transaction = null;
        try {
            transaction = this.createTransaction();
            SandeshaClient.forceDispatchOfInboundMessages(this.storageManager.getContext(), inboundSequenceData.sequenceID, true);
            this.completeTransaction(transaction);
            transaction = null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.forceDispatchOfInboundMessages", "1:1415:1.55", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "forceDispatchOfInboundMessages", "WSRMMBeanException");
            }
            throw new WSRMMBeanException(exception);
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                this.rollbackTransaction(transaction);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "forceDispatchOfInboundMessages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutboundSequenceData reallocateOutboundMessagesToNewSequence(OutboundSequenceData outboundSequenceData, String string) throws WSRMMBeanException {
        Serializable serializable;
        Object object;
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reallocateOutboundMessagesToNewSequence", new Object[]{outboundSequenceData, string});
        }
        String string2 = SandeshaUtil.getUUID();
        try {
            block31: {
                if (outboundSequenceData.info_internalSeqID.indexOf(outboundSequenceData.targetAddress) < 0) {
                    throw new WSRMMBeanException(nls.getFormattedMessage("RESPONSE_SEQUENCE_NOT_REALLOC_CWSKA0072", new Object[]{"ApplicationWSRMStoreController", "1:1446:1.55"}, null));
                }
                if (this.isSequenceClosingAllowed(outboundSequenceData.wsrm_spec_version)) {
                    this.closeSequence(outboundSequenceData);
                }
                this.storageManager.getSender().blockForPause();
                object2 = null;
                try {
                    object2 = this.createTransaction();
                    object = outboundSequenceData.info_internalSeqID;
                    serializable = new TreeSet(new SenderBeanComparator());
                    serializable.addAll(this.storageManager.getSenderBeanMgr().find((String)object));
                    if (serializable.isEmpty()) {
                        if (object2 != null && object2.isActive()) {
                            object2.commit();
                        }
                        object2 = null;
                        ServiceClient serviceClient = null;
                        Class<?> clazz = this.getClass();
                        synchronized (clazz) {
                            if (string == null) {
                                string = outboundSequenceData.targetAddress;
                            }
                            if ((serviceClient = (ServiceClient)serviceClientMap.get(string)) == null) {
                                serviceClient = this.buildServiceClientForSequence(outboundSequenceData);
                                serviceClient.getOptions().setTo(new EndpointReference(string));
                                serviceClientMap.put(string, serviceClient);
                            }
                        }
                        SandeshaClient.createSequence(serviceClient, false, string2);
                        break block31;
                    }
                    for (SenderBean senderBean : serializable) {
                        if (senderBean.getMessageType() != 3) continue;
                        senderBean.setSend(false);
                        String string3 = senderBean.getMessageContextRefKey();
                        MessageContext messageContext = this.storageManager.retrieveMessageContext(string3, this.storageManager.getContext());
                        ServiceClient serviceClient = null;
                        if (string == null) {
                            string = outboundSequenceData.targetAddress;
                        }
                        Class<?> clazz = this.getClass();
                        synchronized (clazz) {
                            serviceClient = (ServiceClient)serviceClientMap.get(string);
                            if (serviceClient == null) {
                                serviceClient = this.buildServiceClientForSequence(outboundSequenceData);
                                serviceClient.getOptions().setTo(new EndpointReference(string));
                                serviceClientMap.put(string, serviceClient);
                            }
                        }
                        serviceClient.getOptions().setAction(messageContext.getWSAAction());
                        serviceClient.fireAndForget(messageContext.getEnvelope().getBody().cloneOMElement().getFirstElement());
                        this.storageManager.getSenderBeanMgr().delete(senderBean.getMessageID());
                        this.storageManager.removeMessageContext(string3);
                    }
                    if (object2 != null && object2.isActive()) {
                        object2.commit();
                    }
                    object2 = null;
                }
                finally {
                    if (object2 != null && object2.isActive()) {
                        object2.rollback();
                        object2 = null;
                    }
                    this.storageManager.getSender().finishPause();
                }
            }
            try {
                this.terminateSequence(outboundSequenceData);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.reallocateOutboundMessagesToNewSequence", "1:1561:1.55", this);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.reallocateOutboundMessagesToNewSequence", "1:1573:1.55", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "reallocateOutboundMessagesToNewSequence", exception);
            }
            throw new WSRMMBeanException(exception);
        }
        object2 = SandeshaUtil.getInternalSequenceID(string, string2);
        object = null;
        serializable = null;
        try {
            object = this.createTransaction();
            serializable = (OutboundSequenceData)this.populateSequenceData((String)object2, true, null);
        }
        finally {
            if (object != null && object.isActive()) {
                this.completeTransaction((Transaction)object);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reallocateOutboundMessagesToNewSequence", serializable);
        }
        return serializable;
    }

    /*
     * Unable to fully structure code
     */
    public void deleteMessage(MessageData var1_1) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && ApplicationWSRMStoreController.tc.isEntryEnabled()) {
            Tr.entry(ApplicationWSRMStoreController.tc, "deleteMessage", var1_1);
        }
        if (var1_1 instanceof OutboundMessageData) {
            var2_2 = null;
            try {
                var2_2 = this.createTransaction();
                this.storageManager.getSender().blockForPause();
                var3_4 = var1_1.info_internalSeqID;
                var4_7 = new SenderBean();
                var4_7.setInternalSequenceID(var3_4);
                var4_7.setMessageNumber(var1_1.sequenceMessageNumber);
                var5_10 = this.storageManager.getSenderBeanMgr().findUnique(var4_7);
                var6_13 = var5_10.getMessageContextRefKey();
                this.storageManager.getSenderBeanMgr().delete(var5_10.getMessageID());
                this.storageManager.removeMessageContext(var6_13);
                if (var2_2 == null || !var2_2.isActive()) ** GOTO lbl69
                this.completeTransaction(var2_2);
            }
            catch (Exception var3_5) {
                FFDCFilter.processException((Throwable)var3_5, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.deleteMessage", "1:1638:1.55", this);
                var4_8 = new WSRMMBeanException(var3_5);
                if (TraceComponent.isAnyTracingEnabled() && ApplicationWSRMStoreController.tc.isEntryEnabled()) {
                    Tr.exit(ApplicationWSRMStoreController.tc, "deleteMessage", var4_8);
                }
                throw var4_8;
            }
            finally {
                if (var2_2 != null) {
                    this.rollbackTransaction(var2_2);
                }
                this.storageManager.getSender().finishPause();
            }
        } else {
            var2_3 = var1_1.sequenceID;
            var3_6 = (InboundSequenceData)this.populateSequenceData(var2_3, false, null);
            if (var3_6.isInOrder) {
                var4_9 = this.createTransaction();
                try {
                    this.storageManager.getInvoker().blockForPause();
                    var5_11 = SandeshaUtil.getRMDBeanFromSequenceId(this.storageManager, var2_3);
                    var6_14 = var5_11.getNextMsgNoToProcess();
                    var8_17 = new InvokerBean();
                    var8_17.setSequenceID(var2_3);
                    var8_17.setMsgNo(var1_1.sequenceMessageNumber);
                    var9_18 = this.storageManager.getInvokerBeanMgr().findUnique(var8_17);
                    if (var9_18 != null) {
                        this.storageManager.removeMessageContext(var9_18.getMessageContextRefKey());
                        this.storageManager.getInvokerBeanMgr().delete(var9_18.getMessageContextRefKey());
                    }
                    var5_11.setNextMsgNoToProcess(var1_1.sequenceMessageNumber + 1L);
                    if (var6_14 != var1_1.sequenceMessageNumber) {
                        var5_11.getOutOfOrderRanges().addRange(new Range(1L, var1_1.sequenceMessageNumber));
                    }
                    this.storageManager.getRMDBeanMgr().update(var5_11);
                    if (var4_9 != null) {
                        this.completeTransaction(var4_9);
                        var4_9 = null;
                    }
                }
                catch (Exception var5_12) {
                    FFDCFilter.processException((Throwable)var5_12, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.deleteMessage", "1:1704:1.55", this);
                    var6_15 = new WSRMMBeanException(var5_12);
                    if (TraceComponent.isAnyTracingEnabled() && ApplicationWSRMStoreController.tc.isEntryEnabled()) {
                        Tr.exit(ApplicationWSRMStoreController.tc, "deleteMessage", var6_15);
                    }
                    throw var6_15;
                }
                finally {
                    if (var4_9 != null) {
                        this.rollbackTransaction(var4_9);
                        var4_9 = null;
                    }
                    this.storageManager.getInvoker().finishPause();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && ApplicationWSRMStoreController.tc.isEntryEnabled()) {
            Tr.exit(ApplicationWSRMStoreController.tc, "deleteMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceData refreshSequenceData(SequenceData sequenceData) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshSequenceData", sequenceData);
        }
        Transaction transaction = null;
        SequenceData sequenceData2 = null;
        try {
            transaction = this.createTransaction();
            sequenceData2 = sequenceData instanceof InboundSequenceData ? this.populateSequenceData(sequenceData.sequenceID, false, null) : this.populateSequenceData(((OutboundSequenceData)sequenceData).info_internalSeqID, true, null);
        }
        finally {
            if (transaction != null) {
                this.completeTransaction(transaction);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshSequenceData", sequenceData2);
        }
        return sequenceData2;
    }

    private boolean isSequenceClosingAllowed(String string) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isSequenceClosingAllowed", string);
        }
        boolean bl = SpecSpecificConstants.isSequenceClosingAllowed(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isSequenceClosingAllowed", new Boolean(bl));
        }
        return bl;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/impl/storage/ApplicationWSRMStoreController.java, WAS.rm, WSFP.WSERV1, cf230905.09 1.55");
        }
        serviceClientMap = new HashMap();
    }

    class SenderBeanComparator
    implements Comparator {
        SenderBeanComparator() {
        }

        public int compare(Object object, Object object2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "compare", new Object[]{object, object2});
            }
            if (!(object instanceof SenderBean) || !(object2 instanceof SenderBean)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "compare", "Comparison failed");
                }
                throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"ApplicationWSRMStoreController", "1:195:1.55"}, null));
            }
            SenderBean senderBean = (SenderBean)object;
            SenderBean senderBean2 = (SenderBean)object2;
            int n = 0;
            if (senderBean.getMessageType() == senderBean2.getMessageType() && senderBean2.getMessageType() == 3) {
                int n2 = n = senderBean.getMessageNumber() - senderBean2.getMessageNumber() > 0L ? 1 : -1;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "compare", new Integer(n));
            }
            return n;
        }
    }
}

