/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.wsrm.WSRMConstants;
import com.ibm.ws.sib.wsrm.exceptions.MEStoreConnectionException;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.impl.spi.WSRMSequencePropertiesImpl;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManager;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton;
import com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator;
import com.ibm.ws.websvcs.rm.policyset.RMServiceConfigPlugin;
import com.ibm.wsspi.wsrm.WSRMSequenceManager;
import com.ibm.wsspi.wsrm.WSRMSequenceProperties;
import com.ibm.wsspi.wsrm.exceptions.WSRMErrorException;
import com.ibm.wsspi.wsrm.exceptions.WSRMNotEnabledException;
import com.ibm.wsspi.wsrm.exceptions.WSRMSequenceAlreadyExistsException;
import com.ibm.wsspi.wsrm.exceptions.WSRMSequenceClosedException;
import com.ibm.wsspi.wsrm.exceptions.WSRMSequenceTerminatedException;
import com.ibm.wsspi.wsrm.exceptions.WSRMSequenceUnknownException;
import com.ibm.wsspi.wsrm.exceptions.WSRMTransactionInUseException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.client.dispatch.BaseDispatch;
import org.apache.axis2.jaxws.spi.BindingProvider;
import org.apache.axis2.jaxws.spi.ServiceDelegate;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;

public class WSRMSequenceManagerImpl
implements WSRMSequenceManager {
    private static final TraceComponent tc = Tr.register(WSRMSequenceManagerImpl.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final String GET_DESCRIPTOR_METHOD = "_getDescriptor";
    private static final String GET_PROXY = "getProxy";

    private TransactionThreadMigrator.ThreadTxContextInformation startTran(ServiceClient serviceClient) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startTran");
        }
        TransactionThreadMigrator.ThreadTxContextInformation threadTxContextInformation = null;
        if (RMServiceConfigPlugin.isManagedQOS(serviceClient.getServiceContext().getConfigurationContext().getAxisConfiguration())) {
            try {
                threadTxContextInformation = TransactionThreadMigrator.getInstance().startWSRMTransactionalCall(false);
            }
            catch (AxisFault axisFault) {
                FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.startTran", "1:143:1.42", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "startTran", axisFault);
                }
                throw new WSRMErrorException(axisFault);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startTran", threadTxContextInformation);
        }
        return threadTxContextInformation;
    }

    private void endTran(TransactionThreadMigrator.ThreadTxContextInformation threadTxContextInformation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "endTran", threadTxContextInformation);
        }
        try {
            TransactionThreadMigrator.getInstance().finishWSRMTransactionalCall(threadTxContextInformation);
        }
        catch (AxisFault axisFault) {
            FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.endTran", "1:171:1.42", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "endTran", axisFault);
            }
            throw new WSRMErrorException(axisFault);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "endTran");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSequence(Object object, QName qName, String string) throws WSRMNotEnabledException, WSRMSequenceUnknownException, WSRMSequenceTerminatedException, WSRMSequenceClosedException {
        Options options;
        ServiceClient serviceClient;
        TransactionThreadMigrator.ThreadTxContextInformation threadTxContextInformation;
        block11: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "closeSequence", new Object[]{object, string});
            }
            threadTxContextInformation = null;
            try {
                if (string == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "closeSequence", "NullPointerException - null target uri");
                    }
                    throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0503", null, null));
                }
                serviceClient = this.getServiceClient(object, qName, "closeSequence");
                threadTxContextInformation = this.startTran(serviceClient);
                this.checkIfRMEnabled(serviceClient);
                this.checkSequenceExists(serviceClient, string);
                this.checkForSequenceClosedOrTerminated(serviceClient, string, true);
                options = serviceClient.getOptions();
                options.setTo(new EndpointReference(string));
                options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, WSRMSequenceManagerImpl.getSequenceKey(serviceClient));
                RMSBean rMSBean = WSRMSequenceManagerImpl.getRMSBean(serviceClient, string);
                if (!"Spec_2005_02".equals(rMSBean.getRMVersion())) break block11;
                Tr.warning(tc, "WRONG_SPEC_WARNING_CWSKA0510", (Object)new String[]{string});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "closeSequence");
                }
                this.endTran(threadTxContextInformation);
                return;
            }
            catch (Throwable throwable) {
                this.endTran(threadTxContextInformation);
                throw throwable;
            }
        }
        WSRMSequenceManagerImpl.setRMSpecVersion(serviceClient, WSRMSequenceManagerImpl.getRMSBean(serviceClient, string), options);
        try {
            SandeshaClient.closeSequence(serviceClient);
        }
        catch (SandeshaException sandeshaException) {
            FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.closeSequence", "1:249:1.42", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "closeSequence", sandeshaException);
            }
            throw new WSRMErrorException(sandeshaException);
        }
        this.endTran(threadTxContextInformation);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "closeSequence");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewWSRMSequence(Object object, QName qName, WSRMSequenceProperties wSRMSequenceProperties) throws WSRMNotEnabledException, WSRMSequenceAlreadyExistsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewWSRMSequence", new Object[]{object, wSRMSequenceProperties});
        }
        TransactionThreadMigrator.ThreadTxContextInformation threadTxContextInformation = null;
        try {
            ServiceClient serviceClient = this.getServiceClient(object, qName, "createNewWSRMSequence");
            threadTxContextInformation = this.startTran(serviceClient);
            this.checkIfRMEnabled(serviceClient);
            if (wSRMSequenceProperties == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createNewWSRMSequence", "NullPointerException");
                }
                throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0501", new Object[]{wSRMSequenceProperties, "createNewWSRMSequence"}, null));
            }
            WSRMSequencePropertiesImpl wSRMSequencePropertiesImpl = (WSRMSequencePropertiesImpl)wSRMSequenceProperties;
            if (wSRMSequencePropertiesImpl.getTargetEndpointUri() == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createNewWSRMSequence", "NullPointerException - null target uri");
                }
                throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0503", null, null));
            }
            this.checkSequenceDoesntExists(serviceClient, wSRMSequencePropertiesImpl.getTargetEndpointUri());
            Options options = serviceClient.getOptions();
            options.setTo(new EndpointReference(wSRMSequencePropertiesImpl.getTargetEndpointUri()));
            WSRMSequenceManagerImpl.setRMSpecVersion(serviceClient, null, options);
            if (wSRMSequencePropertiesImpl.getSOAPVersion() == 2) {
                options.setSoapVersionURI("http://www.w3.org/2003/05/soap-envelope");
            } else {
                options.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
            }
            if (wSRMSequencePropertiesImpl.isUsingAsyncTransport()) {
                options.setUseSeparateListener(true);
            }
            options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, WSRMSequenceManagerImpl.getSequenceKey(serviceClient));
            try {
                SandeshaClient.createSequence(serviceClient, wSRMSequencePropertiesImpl.getUseGeneratedOfferedSequenceId(), null);
            }
            catch (SandeshaException sandeshaException) {
                FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.createNewWSRMSequence", "1:340:1.42", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createNewWSRMSequence", sandeshaException);
                }
                throw new WSRMErrorException(sandeshaException);
            }
            this.endTran(threadTxContextInformation);
        }
        catch (Throwable throwable) {
            this.endTran(threadTxContextInformation);
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createNewWSRMSequence");
        }
    }

    public WSRMSequenceProperties createNewWSRMSequenceProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewWSRMSequenceProperties");
        }
        WSRMSequencePropertiesImpl wSRMSequencePropertiesImpl = new WSRMSequencePropertiesImpl();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createNewWSRMSequenceProperties", wSRMSequencePropertiesImpl);
        }
        return wSRMSequencePropertiesImpl;
    }

    /*
     * Exception decompiling
     */
    public void terminateSequence(Object var1_1, QName var2_2, String var3_3) throws WSRMNotEnabledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean waitUntilSequenceCompleted(Object object, QName qName, String string) throws WSRMNotEnabledException, WSRMSequenceUnknownException, WSRMTransactionInUseException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "waitUntilSequenceCompleted", new Object[]{object, qName, string});
        }
        boolean bl = this.waitUntilSequenceCompleted(object, qName, string, -1L);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "waitUntilSequenceCompleted", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean waitUntilSequenceCompleted(Object object, QName qName, String string, long l) throws WSRMNotEnabledException, WSRMSequenceUnknownException, WSRMTransactionInUseException {
        TransactionThreadMigrator.ThreadTxContextInformation threadTxContextInformation;
        block29: {
            RMSBean rMSBean;
            ServiceClient serviceClient;
            block28: {
                block27: {
                    boolean bl;
                    block26: {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.entry(tc, "waitUntilSequenceCompleted", new Object[]{object, qName, string, new Long(l)});
                        }
                        threadTxContextInformation = null;
                        try {
                            serviceClient = this.getServiceClient(object, qName, "waitUntilSequenceCompleted");
                            if (string == null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, "waitUntilSequenceCompleted", "NullPointerException - null target uri");
                                }
                                throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0503", null, null));
                            }
                            threadTxContextInformation = this.startTran(serviceClient);
                            this.checkIfRMEnabled(serviceClient);
                            this.checkSequenceExists(serviceClient, string);
                            this.checkTransactionState(serviceClient, string);
                            bl = l == -1L;
                            rMSBean = WSRMSequenceManagerImpl.getRMSBean(serviceClient, string);
                            if (!rMSBean.isSequenceClosedClient() && !rMSBean.isTerminateAdded()) {
                                l = this.waitForAllMessagesToBeAcked(serviceClient, rMSBean, l);
                            }
                            if (bl || l > 0L) break block26;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                Tr.exit(tc, "waitUntilSequenceCompleted", "Sequence not complete as not all messages acked");
                            }
                            boolean bl2 = false;
                            this.endTran(threadTxContextInformation);
                            return bl2;
                        }
                        catch (Throwable throwable) {
                            this.endTran(threadTxContextInformation);
                            throw throwable;
                        }
                    }
                    long l2 = System.currentTimeMillis();
                    this.terminateSequence(object, qName, string);
                    long l3 = System.currentTimeMillis();
                    if (!bl) {
                        l -= l3 - l2;
                    }
                    if (bl || l > 0L) break block27;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "waitUntilSequenceCompleted", "Sequence timed out terminating sequence");
                    }
                    boolean bl3 = false;
                    this.endTran(threadTxContextInformation);
                    return bl3;
                }
                Options options = serviceClient.getOptions();
                options.setTo(new EndpointReference(string));
                options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, WSRMSequenceManagerImpl.getSequenceKey(serviceClient));
                SandeshaClient.waitUntilSequenceCompleted(serviceClient, l);
                rMSBean = WSRMSequenceManagerImpl.getRMSBean(serviceClient, string);
                if (rMSBean == null || rMSBean.isTerminated()) break block28;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "waitUntilSequenceCompleted", "Sequence not terminated");
                }
                boolean bl = false;
                this.endTran(threadTxContextInformation);
                return bl;
            }
            ConfigurationContext configurationContext = serviceClient.getServiceContext().getConfigurationContext();
            StorageManager storageManager = null;
            Transaction transaction = null;
            try {
                storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
                transaction = storageManager.getTransaction();
                storageManager.getRMSBeanMgr().delete(rMSBean.getCreateSeqMsgID());
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                transaction = null;
                break block29;
            }
            catch (SandeshaException sandeshaException) {
                FFDCFilter.processException(sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.waitUntilSequenceCompleted", "1:612:1.42");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "waitUntilSequenceCompleted", sandeshaException);
                }
                throw new WSRMErrorException(sandeshaException);
            }
            finally {
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
            }
            {
                catch (SandeshaException sandeshaException) {
                    FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.waitUntilSequenceCompleted", "1:629:1.42", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "waitUntilSequenceCompleted", sandeshaException);
                    }
                    throw new WSRMErrorException(sandeshaException);
                }
            }
        }
        this.endTran(threadTxContextInformation);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "waitUntilSequenceCompleted", Boolean.TRUE);
        }
        return true;
    }

    private void checkTransactionState(ServiceClient serviceClient, String string) throws WSRMTransactionInUseException {
        ConfigurationContext configurationContext;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTransactionState", new Object[]{serviceClient, string});
        }
        if (RMServiceConfigPlugin.isManagedQOS((configurationContext = serviceClient.getServiceContext().getConfigurationContext()).getAxisConfiguration())) {
            PersistentStorageManagerSingleton persistentStorageManagerSingleton = null;
            try {
                persistentStorageManagerSingleton = ((PersistentStorageManager)SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration())).getSingletonInstance();
            }
            catch (SandeshaException sandeshaException) {
                FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkTransactionState", "1:683:1.42", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkTransactionState", sandeshaException);
                }
                throw new WSRMErrorException(sandeshaException);
            }
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            hashMap.put(WSRMConstants.WORK_KEY, persistentStorageManagerSingleton.getWorkKey());
            hashMap.put("SEQUENCEID", string);
            boolean bl = false;
            try {
                bl = persistentStorageManagerSingleton.getCommandInvoker().checkTransactionStatue(hashMap);
            }
            catch (MEStoreConnectionException mEStoreConnectionException) {
                FFDCFilter.processException((Throwable)mEStoreConnectionException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkTransactionState", "1:707:1.42", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkTransactionState", mEStoreConnectionException);
                }
                throw new WSRMErrorException(mEStoreConnectionException);
            }
            if (bl) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkTransactionState", "WSRMTransactionInUseException");
                }
                throw new WSRMTransactionInUseException(nls.getFormattedMessage("TRANSACTION_IN_USE_ERROR_CWSKA0504", new String[]{string}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTransactionState");
        }
    }

    private long waitForAllMessagesToBeAcked(ServiceClient serviceClient, RMSBean rMSBean, long l) {
        long l2;
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForAllMessagesToBeAcked", new Object[]{serviceClient, rMSBean, new Long(l)});
        }
        long l3 = rMSBean.getHighestOutMessageNumber();
        long l4 = System.currentTimeMillis();
        boolean bl2 = bl = l == -1L;
        if (l3 > 0L) {
            l2 = System.currentTimeMillis();
            long l5 = l2 + l;
            boolean bl3 = false;
            while (!bl3 && (l2 < l5 || bl)) {
                l2 = System.currentTimeMillis();
                try {
                    RMSBean rMSBean2 = WSRMSequenceManagerImpl.getRMSBean(serviceClient, rMSBean.getToEPR());
                    RangeString rangeString = rMSBean2.getClientCompletedMessages();
                    if (rangeString.isMessageNumberInRanges(l3) && rangeString.getRanges().length == 1) {
                        bl3 = true;
                        continue;
                    }
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Caught an exception " + exception);
                }
            }
        }
        l2 = System.currentTimeMillis();
        if (!bl) {
            l -= l2 - l4;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForAllMessagesToBeAcked", new Long(l));
        }
        return l;
    }

    private ServiceClient getServiceClient(Object object, QName qName, String string) {
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceClient", new Object[]{object, qName, string});
        }
        if (object == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getServiceClient", "NullPointerException");
            }
            throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0501", new Object[]{"clientObject", string}, null));
        }
        ServiceDelegate serviceDelegate = null;
        if (object instanceof BaseDispatch) {
            serviceDelegate = ((BaseDispatch)object).getServiceDelegate();
        } else if (object instanceof BindingProvider) {
            serviceDelegate = ((BindingProvider)object).getServiceDelegate();
        } else {
            Method[] methodArray;
            object2 = object.getClass().getMethods();
            Object object3 = null;
            for (int i = 0; i < ((Method[])object2).length && object3 == null; ++i) {
                methodArray = object2[i];
                if (!methodArray.getName().equals(GET_DESCRIPTOR_METHOD)) continue;
                try {
                    object3 = methodArray.invoke(object, (Object[])null);
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.getServiceClient", "1:829:1.42", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getServiceClient", exception);
                    }
                    throw new WSRMErrorException(nls.getFormattedMessage("UNKNOWN_DISPATCH_TYPE_ERROR_CWSKA0502", new Object[]{object.getClass()}, null));
                }
            }
            Object object4 = null;
            if (object3 != null) {
                methodArray = object3.getClass().getMethods();
                for (int i = 0; i < methodArray.length && object4 == null; ++i) {
                    Method method = methodArray[i];
                    if (!method.getName().equals(GET_PROXY)) continue;
                    try {
                        object4 = method.invoke(object3, (Object[])null);
                        continue;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.getServiceClient", "1:866:1.42", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "getServiceClient", exception);
                        }
                        throw new WSRMErrorException(nls.getFormattedMessage("UNKNOWN_DISPATCH_TYPE_ERROR_CWSKA0502", new Object[]{object.getClass()}, null));
                    }
                }
            }
            if (object4 != null && object4 instanceof BindingProvider) {
                serviceDelegate = ((BindingProvider)object4).getServiceDelegate();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServiceClient", "WSRMErrorException - Unknown dispatch type");
                }
                throw new WSRMErrorException(nls.getFormattedMessage("UNKNOWN_DISPATCH_TYPE_ERROR_CWSKA0502", new Object[]{object.getClass()}, null));
            }
        }
        object2 = serviceDelegate.getServiceClient(qName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceClient", object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getLastWSRMError(Object object, QName qName, String string) throws WSRMNotEnabledException, WSRMSequenceUnknownException, WSRMSequenceTerminatedException, WSRMSequenceClosedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastWSRMError", new Object[]{object, qName, string});
        }
        TransactionThreadMigrator.ThreadTxContextInformation threadTxContextInformation = null;
        try {
            ServiceClient serviceClient = this.getServiceClient(object, qName, "getLastWSRMError");
            if (string == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getLastWSRMError", "NullPointerException - null target uri");
                }
                throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0503", null, null));
            }
            threadTxContextInformation = this.startTran(serviceClient);
            this.checkIfRMEnabled(serviceClient);
            this.checkSequenceExists(serviceClient, string);
            this.checkForSequenceClosedOrTerminated(serviceClient, string, true);
            Options options = serviceClient.getOptions();
            options.setTo(new EndpointReference(string));
            options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, WSRMSequenceManagerImpl.getSequenceKey(serviceClient));
            Exception exception = null;
            try {
                exception = SandeshaClient.getLastSendError(serviceClient);
            }
            catch (SandeshaException sandeshaException) {
                FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.getLastWSRMError", "1:952:1.42", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getLastWSRMError", sandeshaException);
                }
                throw new WSRMErrorException(sandeshaException);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getLastWSRMError", exception);
            }
            Exception exception2 = exception;
            this.endTran(threadTxContextInformation);
            return exception2;
        }
        catch (Throwable throwable) {
            this.endTran(threadTxContextInformation);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastWSRMErrorTimestamp(Object object, QName qName, String string) throws WSRMNotEnabledException, WSRMSequenceUnknownException, WSRMSequenceTerminatedException, WSRMSequenceClosedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastWSRMErrorTimestamp", new Object[]{object, qName, string});
        }
        TransactionThreadMigrator.ThreadTxContextInformation threadTxContextInformation = null;
        try {
            ServiceClient serviceClient = this.getServiceClient(object, qName, "getLastWSRMErrorTimestamp");
            if (string == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getLastWSRMErrorTimestamp", "NullPointerException - null target uri");
                }
                throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0503", null, null));
            }
            threadTxContextInformation = this.startTran(serviceClient);
            this.checkIfRMEnabled(serviceClient);
            this.checkSequenceExists(serviceClient, string);
            this.checkForSequenceClosedOrTerminated(serviceClient, string, true);
            Options options = serviceClient.getOptions();
            options.setTo(new EndpointReference(string));
            options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, WSRMSequenceManagerImpl.getSequenceKey(serviceClient));
            long l = -1L;
            try {
                l = SandeshaClient.getLastSendErrorTimestamp(serviceClient);
            }
            catch (SandeshaException sandeshaException) {
                FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.getLastWSRMErrorTimestamp", "1:1026:1.42", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getLastWSRMErrorTimestamp", sandeshaException);
                }
                throw new WSRMErrorException(sandeshaException);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getLastWSRMErrorTimestamp", new Long(l));
            }
            long l2 = l;
            this.endTran(threadTxContextInformation);
            return l2;
        }
        catch (Throwable throwable) {
            this.endTran(threadTxContextInformation);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAcknowledgementRequest(Object object, QName qName, String string) throws WSRMNotEnabledException, WSRMSequenceUnknownException, WSRMSequenceTerminatedException, WSRMSequenceClosedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendAcknowledgementRequest", new Object[]{object, string});
        }
        TransactionThreadMigrator.ThreadTxContextInformation threadTxContextInformation = null;
        try {
            ServiceClient serviceClient = this.getServiceClient(object, qName, "sendAcknowledgementRequest");
            if (string == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "sendAcknowledgementRequest", "NullPointerException - null target uri");
                }
                throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0503", null, null));
            }
            threadTxContextInformation = this.startTran(serviceClient);
            this.checkIfRMEnabled(serviceClient);
            this.checkSequenceExists(serviceClient, string);
            this.checkForSequenceClosedOrTerminated(serviceClient, string, true);
            Options options = serviceClient.getOptions();
            options.setTo(new EndpointReference(string));
            options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, WSRMSequenceManagerImpl.getSequenceKey(serviceClient));
            WSRMSequenceManagerImpl.setRMSpecVersion(serviceClient, WSRMSequenceManagerImpl.getRMSBean(serviceClient, string), options);
            try {
                SandeshaClient.sendAckRequest(serviceClient);
            }
            catch (SandeshaException sandeshaException) {
                FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.sendAcknowledgementRequest", "1:1091:1.42", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "sendAcknowledgementRequest", sandeshaException);
                }
                throw new WSRMErrorException(sandeshaException);
            }
            this.endTran(threadTxContextInformation);
        }
        catch (Throwable throwable) {
            this.endTran(threadTxContextInformation);
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendAcknowledgementRequest");
        }
    }

    private void checkIfRMEnabled(ServiceClient serviceClient) throws WSRMNotEnabledException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfRMEnabled", serviceClient);
        }
        if (!WSRMModule.isWSRMEnabledForService(serviceClient.getAxisService())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "checkIfRMEnabled", "WSRMNotEnabledException");
            }
            throw new WSRMNotEnabledException(nls.getFormattedMessage("WSRM_NOT_ENABLED_ERROR_CWSKA0505", null, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfRMEnabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSequenceExists(ServiceClient serviceClient, String string) throws WSRMSequenceUnknownException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSequenceExists", new Object[]{serviceClient, string});
        }
        ServiceContext serviceContext = serviceClient.getServiceContext();
        ConfigurationContext configurationContext = serviceContext.getConfigurationContext();
        String string2 = WSRMSequenceManagerImpl.getSequenceKey(serviceClient);
        String string3 = SandeshaUtil.getInternalSequenceID(string, string2);
        StorageManager storageManager = null;
        try {
            storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        }
        catch (SandeshaException sandeshaException) {
            FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkSequenceExists", "1:1171:1.42", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "checkSequenceExists", sandeshaException);
            }
            throw new WSRMErrorException(sandeshaException);
        }
        Transaction transaction = null;
        try {
            transaction = storageManager.getTransaction();
            RMSBean rMSBean = null;
            try {
                rMSBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, string3);
            }
            catch (SandeshaException sandeshaException) {
                FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkSequenceExists", "1:1199:1.42", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkSequenceExists", sandeshaException);
                }
                throw new WSRMErrorException(sandeshaException);
            }
            if (rMSBean == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkSequenceExists", "WSRMSequenceUnknownException");
                }
                throw new WSRMSequenceUnknownException(nls.getFormattedMessage("WSRM_SEQUENCE_UNKNOWN_ERROR_CWSKA0506", new Object[]{string}, null));
            }
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.commit();
                }
                catch (SandeshaStorageException sandeshaStorageException) {
                    FFDCFilter.processException((Throwable)sandeshaStorageException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkSequenceExists", "1:1232:1.42", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkSequenceExists", sandeshaStorageException);
                    }
                    throw new WSRMErrorException(sandeshaStorageException);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSequenceExists");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSequenceDoesntExists(ServiceClient serviceClient, String string) throws WSRMSequenceAlreadyExistsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSequenceDoesntExists", new Object[]{serviceClient, string});
        }
        ServiceContext serviceContext = serviceClient.getServiceContext();
        ConfigurationContext configurationContext = serviceContext.getConfigurationContext();
        String string2 = WSRMSequenceManagerImpl.getSequenceKey(serviceClient);
        String string3 = SandeshaUtil.getInternalSequenceID(string, string2);
        StorageManager storageManager = null;
        try {
            storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        }
        catch (SandeshaException sandeshaException) {
            FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkSequenceDoesntExists", "1:1284:1.42", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "checkSequenceDoesntExists", sandeshaException);
            }
            throw new WSRMErrorException(sandeshaException);
        }
        Transaction transaction = null;
        try {
            transaction = storageManager.getTransaction();
            RMSBean rMSBean = null;
            try {
                rMSBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, string3);
            }
            catch (SandeshaException sandeshaException) {
                FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkSequenceDoesntExists", "1:1310:1.42", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkSequenceDoesntExists", sandeshaException);
                }
                throw new WSRMErrorException(sandeshaException);
            }
            if (rMSBean != null && !rMSBean.isTerminated()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkSequenceDoesntExists", "Sequence already exists");
                }
                throw new WSRMSequenceAlreadyExistsException(nls.getFormattedMessage("WSRM_SEQUENCE_ALREADY_EXISTS_ERROR_CWSKA0509", new Object[]{string}, null));
            }
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.commit();
                }
                catch (SandeshaStorageException sandeshaStorageException) {
                    FFDCFilter.processException((Throwable)sandeshaStorageException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkSequenceDoesntExists", "1:1343:1.42", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkSequenceDoesntExists", "WSRMErrorException");
                    }
                    throw new WSRMErrorException(sandeshaStorageException);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSequenceDoesntExists");
        }
    }

    private void checkForSequenceClosedOrTerminated(ServiceClient serviceClient, String string, boolean bl) throws WSRMSequenceUnknownException, WSRMSequenceTerminatedException, WSRMSequenceClosedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForSequenceClosedOrTerminated", new Object[]{serviceClient, string, bl});
        }
        ServiceContext serviceContext = serviceClient.getServiceContext();
        ConfigurationContext configurationContext = serviceContext.getConfigurationContext();
        String string2 = WSRMSequenceManagerImpl.getSequenceKey(serviceClient);
        String string3 = SandeshaUtil.getInternalSequenceID(string, string2);
        StorageManager storageManager = null;
        try {
            storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        }
        catch (SandeshaException sandeshaException) {
            FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkForSequenceClosedOrTerminated", "1:1400:1.42", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "checkForSequenceClosedOrTerminated", sandeshaException);
            }
            throw new WSRMErrorException(sandeshaException);
        }
        Transaction transaction = null;
        try {
            transaction = storageManager.getTransaction();
            if (WSRMSequenceManagerImpl.isSequenceTerminatedOrTimedOutOrClosed(string3, storageManager, string, bl)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkForSequenceClosedOrTerminated", "WSRMSequenceTerminatedException");
                }
                throw new WSRMSequenceTerminatedException(nls.getFormattedMessage("WSRM_SEQUENCE_TERMINATED_ERROR_CWSKA0507", new Object[]{string}, null));
            }
        }
        catch (SandeshaException sandeshaException) {
            FFDCFilter.processException((Throwable)sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkForSequenceClosedOrTerminated", "1:1431:1.42", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "checkForSequenceClosedOrTerminated", "WSRMErrorException");
            }
            throw new WSRMErrorException(sandeshaException);
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.commit();
                }
                catch (SandeshaStorageException sandeshaStorageException) {
                    FFDCFilter.processException((Throwable)sandeshaStorageException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkForSequenceClosedOrTerminated", "1:1451:1.42", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkForSequenceClosedOrTerminated", sandeshaStorageException);
                    }
                    throw new WSRMErrorException(sandeshaStorageException);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForSequenceClosedOrTerminated");
        }
    }

    private static boolean isSequenceTerminatedOrTimedOutOrClosed(String string, StorageManager storageManager, String string2, boolean bl) throws WSRMSequenceUnknownException, SandeshaException, WSRMSequenceClosedException {
        RMSBean rMSBean;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isSequenceTerminatedOrTimedOutOrClosed", new Object[]{string});
        }
        if ((rMSBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, string)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isSequenceTerminatedOrTimedOutOrClosed", "WSRMSequenceUnknownException");
            }
            throw new WSRMSequenceUnknownException(nls.getFormattedMessage("WSRM_SEQUENCE_UNKNOWN_ERROR_CWSKA0506", new Object[]{string2}, null));
        }
        if (rMSBean.isTerminateAdded()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isSequenceTerminatedOrTimedOutOrClosed", "Sequence terminated " + Boolean.TRUE);
            }
            return true;
        }
        if (rMSBean.isTimedOut()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isSequenceTerminatedOrTimedOutOrClosed", "Sequence timedout " + Boolean.TRUE);
            }
            return true;
        }
        if (bl && rMSBean.isClosed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isSequenceTerminatedOrTimedOutOrClosed", "Sequence closed");
            }
            throw new WSRMSequenceClosedException(nls.getFormattedMessage("WSRM_SEQUENCE_CLOSED_ERROR_CWSKA0508", new Object[]{string2}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isSequenceTerminatedOrTimedOutOrClosed", Boolean.FALSE);
        }
        return false;
    }

    private static final void setRMSpecVersion(ServiceClient serviceClient, RMSBean rMSBean, Options options) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setRMSpecVersion", new Object[]{serviceClient, rMSBean, options});
        }
        AxisService axisService = serviceClient.getServiceContext().getAxisService();
        if (rMSBean != null) {
            options.setProperty(SandeshaClientConstants.RM_SPEC_VERSION, rMSBean.getRMVersion());
        } else if (axisService.getAxisConfiguration().getParameter(SandeshaClientConstants.RM_SPEC_VERSION) != null) {
            options.setProperty(SandeshaClientConstants.RM_SPEC_VERSION, axisService.getAxisConfiguration().getParameter(SandeshaClientConstants.RM_SPEC_VERSION).getValue());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setRMSpecVersion");
        }
    }

    private static final RMSBean getRMSBean(ServiceClient serviceClient, String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMSBean");
        }
        ConfigurationContext configurationContext = serviceClient.getServiceContext().getConfigurationContext();
        RMSBean rMSBean = null;
        StorageManager storageManager = null;
        Transaction transaction = null;
        try {
            storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
            transaction = storageManager.getTransaction();
            String string2 = WSRMSequenceManagerImpl.getSequenceKey(serviceClient);
            String string3 = SandeshaUtil.getInternalSequenceID(string, string2);
            rMSBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, string3);
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = null;
        }
        catch (SandeshaException sandeshaException) {
            FFDCFilter.processException(sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.getRMSBean", "1:1595:1.42");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRMSBean", sandeshaException);
            }
            throw new WSRMErrorException(sandeshaException);
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                try {
                    transaction.rollback();
                }
                catch (SandeshaException sandeshaException) {
                    FFDCFilter.processException(sandeshaException, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.getRMSBean", "1:1608:1.42");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getRMSBean", sandeshaException);
                    }
                    throw new WSRMErrorException(sandeshaException);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRMSBean", rMSBean);
        }
        return rMSBean;
    }

    private static String getSequenceKey(ServiceClient serviceClient) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSequenceKey", serviceClient);
        }
        ServiceContext serviceContext = serviceClient.getServiceContext();
        ConfigurationContext configurationContext = serviceContext.getConfigurationContext();
        Parameter parameter = configurationContext.getAxisConfiguration().getParameter(SandeshaClientConstants.SEQUENCE_KEY);
        String string = null;
        if (parameter != null) {
            string = (String)parameter.getValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSequenceKey", string);
        }
        return string;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/impl/spi/WSRMSequenceManagerImpl.java, WAS.rm, WSFP.WSERV1, cf230905.09 1.42");
        }
    }
}

