/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.Base64;
import com.ibm.ws.websvcs.rm.impl.security.IBMSecurityToken;
import com.ibm.ws.wssecurity.sc.util.SecureConversation;
import com.ibm.ws.wssecurity.sc.util.SecureConversationHandle;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisModule;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;

public class IBMSecurityManager
extends SecurityManager {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceComponent tc = Tr.register(IBMSecurityManager.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private OMFactory factory;
    private OMNamespace secNamespace;
    private SecureConversation theConversation;

    public IBMSecurityManager(ConfigurationContext configurationContext) throws Exception {
        super(configurationContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "IBMSecurityManager", configurationContext);
        }
        try {
            this.factory = OMAbstractFactory.getOMFactory();
            this.secNamespace = this.factory.createOMNamespace("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
            this.theConversation = SecureConversationHandle.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.IBMSecurityManager", "1:112:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "IBMSecurityManager", exception);
            }
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "IBMSecurityManager");
        }
    }

    public void initSecurity(AxisModule axisModule) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initSecurity");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initSecurity");
        }
    }

    public SecurityToken getSecurityToken(MessageContext messageContext) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityToken(MessageContext)");
        }
        IBMSecurityToken iBMSecurityToken = null;
        try {
            SecurityContextToken securityContextToken = this.theConversation.getSCToken(messageContext);
            byte[] byArray = this.theConversation.getWSSPropertyMapByteArray(messageContext);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Security token: " + securityContextToken + ", data: " + byArray);
            }
            if (securityContextToken != null) {
                iBMSecurityToken = new IBMSecurityToken(securityContextToken.getIdentifier(), byArray);
            }
        }
        catch (SoapSecurityException soapSecurityException) {
            FFDCFilter.processException((Throwable)soapSecurityException, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.getSecurityToken", "1:163:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityToken", soapSecurityException);
            }
            throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{soapSecurityException}, null), soapSecurityException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityToken", iBMSecurityToken);
        }
        return iBMSecurityToken;
    }

    public SecurityToken getSecurityToken(OMElement oMElement, MessageContext messageContext) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityToken(OMElement,MessageContext)");
        }
        IBMSecurityToken iBMSecurityToken = null;
        try {
            SecurityContextToken securityContextToken = this.theConversation.getSCTokenBySecurityTokenReference(oMElement, messageContext);
            byte[] byArray = this.theConversation.getWSSPropertyMapByteArray(messageContext);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Security token: " + securityContextToken + ", data: " + byArray);
            }
            iBMSecurityToken = new IBMSecurityToken(securityContextToken.getIdentifier(), byArray);
        }
        catch (SoapSecurityException soapSecurityException) {
            FFDCFilter.processException((Throwable)soapSecurityException, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.getSecurityToken", "1:198:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityToken", soapSecurityException);
            }
            throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{soapSecurityException}, null), soapSecurityException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityToken", iBMSecurityToken);
        }
        return iBMSecurityToken;
    }

    public void initSecurityToken(String string) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initSecurityToken", string);
        }
        try {
            SecurityStringDataConverter securityStringDataConverter = new SecurityStringDataConverter(string);
            this.theConversation.restoreSCToken(securityStringDataConverter.tokenBytes);
        }
        catch (SoapSecurityException soapSecurityException) {
            FFDCFilter.processException((Throwable)soapSecurityException, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.initSecurityToken", "1:271:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initSecutiryToken", soapSecurityException);
            }
            throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{soapSecurityException}, null), soapSecurityException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.initSecurityToken", "1:283:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initSecutiryToken", exception);
            }
            throw new SandeshaException(nls.getFormattedMessage("INTERNAL_RM_ERROR_CWSKA0002", new Object[]{"IBMSecurityManager", "1:287:1.16", exception}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initSecurityToken");
        }
    }

    public SecurityToken recoverSecurityToken(String string) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "recoverSecurityToken");
        }
        IBMSecurityToken iBMSecurityToken = null;
        try {
            SecurityStringDataConverter securityStringDataConverter = new SecurityStringDataConverter(string);
            SecurityContextToken securityContextToken = this.theConversation.getSCTokenFromBytes(securityStringDataConverter.tokenBytes);
            iBMSecurityToken = new IBMSecurityToken(securityContextToken.getIdentifier(), securityStringDataConverter.dataBytes);
        }
        catch (SoapSecurityException soapSecurityException) {
            FFDCFilter.processException((Throwable)soapSecurityException, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.recoverSecurityToken", "1:311:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "recoverSecurityToken", soapSecurityException);
            }
            throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{soapSecurityException}, null), soapSecurityException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.recoverSecurityToken", "1:323:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "recoverSecurityToken", exception);
            }
            throw new SandeshaException(nls.getFormattedMessage("INTERNAL_RM_ERROR_CWSKA0002", new Object[]{"IBMSecurityManager", "1:327:1.16", exception}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "recoverSecurityToken", iBMSecurityToken);
        }
        return iBMSecurityToken;
    }

    public void checkProofOfPossession(SecurityToken securityToken, OMElement oMElement, MessageContext messageContext) throws SandeshaException {
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "checkProofOfPossession", securityToken);
            }
            try {
                String string = ((IBMSecurityToken)securityToken).getUUID();
                List list = this.theConversation.getSignedParts(string, messageContext);
                if (list != null && list.contains(oMElement)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Message part was signed");
                    }
                    break block10;
                }
                List list2 = this.theConversation.getEncryptedParts(string, messageContext);
                if (list2 != null && list2.contains(oMElement)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Message part was encrypted");
                    }
                    break block10;
                }
                QName qName = oMElement.getQName();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkProofOfPossession", "No proof of possession " + qName);
                }
                throw new SandeshaException(nls.getFormattedMessage("MSGPART_NOT_SECURED_CWSKA0022", new Object[]{qName}, null));
            }
            catch (SoapSecurityException soapSecurityException) {
                FFDCFilter.processException((Throwable)soapSecurityException, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.checkProofOfPossession", "1:370:1.16", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkProofOfPossession", soapSecurityException);
                }
                throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{soapSecurityException}, null), soapSecurityException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkProofOfPossession(signed)");
        }
    }

    public OMElement createSecurityTokenReference(SecurityToken securityToken, MessageContext messageContext) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createSecurityTokenReference", securityToken);
        }
        OMElement oMElement = null;
        try {
            IBMSecurityToken iBMSecurityToken = (IBMSecurityToken)securityToken;
            SecurityContextToken securityContextToken = this.theConversation.getSCToken(iBMSecurityToken.getUUID());
            String string = securityContextToken.getIdentifier();
            String string2 = securityContextToken.getValueType().getLocalPart();
            oMElement = this.factory.createOMElement("SecurityTokenReference", this.secNamespace);
            OMElement oMElement2 = this.factory.createOMElement("Reference", this.secNamespace);
            OMAttribute oMAttribute = this.factory.createOMAttribute("URI", null, string);
            OMAttribute oMAttribute2 = this.factory.createOMAttribute("ValueType", null, string2);
            oMElement.addChild(oMElement2);
            oMElement2.addAttribute(oMAttribute);
            oMElement2.addAttribute(oMAttribute2);
        }
        catch (SoapSecurityException soapSecurityException) {
            FFDCFilter.processException((Throwable)soapSecurityException, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.createSecurityTokenReference", "1:407:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createSecurityTokenReference", soapSecurityException);
            }
            throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{soapSecurityException}, null), soapSecurityException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createSecurityTokenReference", oMElement);
        }
        return oMElement;
    }

    public String getTokenRecoveryData(SecurityToken securityToken) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenRecoveryData", securityToken);
        }
        String string = null;
        try {
            IBMSecurityToken iBMSecurityToken = (IBMSecurityToken)securityToken;
            string = (IBMSecurityManager)this.new SecurityStringDataConverter((IBMSecurityToken)iBMSecurityToken).tokenString;
        }
        catch (SoapSecurityException soapSecurityException) {
            FFDCFilter.processException((Throwable)soapSecurityException, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.getTokenRecoveryData", "1:435:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getTokenRecoveryData", soapSecurityException);
            }
            throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{soapSecurityException}, null), soapSecurityException);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.getTokenRecoveryData", "1:447:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getTokenRecoveryData", iOException);
            }
            throw new SandeshaException(nls.getFormattedMessage("INTERNAL_RM_ERROR_CWSKA0002", new Object[]{"IBMSecurityManager", "1:451:1.16", iOException}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenRecoveryData");
        }
        return string;
    }

    public void applySecurityToken(SecurityToken securityToken, MessageContext messageContext) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "applySecurityToken", new Object[]{securityToken, messageContext});
        }
        try {
            IBMSecurityToken iBMSecurityToken = (IBMSecurityToken)securityToken;
            byte[] byArray = iBMSecurityToken.getSecurityHashMapData();
            this.theConversation.getWSSPropertyMapFromByteArray(byArray, messageContext);
        }
        catch (SoapSecurityException soapSecurityException) {
            FFDCFilter.processException((Throwable)soapSecurityException, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.applySecurityToken", "1:477:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "applySecurityToken", soapSecurityException);
            }
            throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{soapSecurityException}, null), soapSecurityException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "applySecurityToken");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/impl/security/IBMSecurityManager.java, WAS.rm, WSFP.WSERV1, cf230905.09 1.16");
        }
    }

    private class SecurityStringDataConverter {
        final byte[] tokenBytes;
        final byte[] dataBytes;
        final String tokenString;

        SecurityStringDataConverter(String string) throws IOException, ClassNotFoundException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "SecurityStringDataConverter", string);
            }
            this.tokenString = string;
            byte[] byArray = Base64.decode(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this.tokenBytes = (byte[])objectInputStream.readObject();
            this.dataBytes = (byte[])objectInputStream.readObject();
            objectInputStream.close();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "SecurityStringDataConverter", new Object[]{this.tokenBytes, this.dataBytes});
            }
        }

        SecurityStringDataConverter(IBMSecurityToken iBMSecurityToken) throws IOException, SoapSecurityException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "SecurityStringDataConverter", iBMSecurityToken);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            this.tokenBytes = IBMSecurityManager.this.theConversation.getSCTokenBytes(iBMSecurityToken.getUUID());
            this.dataBytes = iBMSecurityToken.getSecurityHashMapData();
            objectOutputStream.writeObject(this.tokenBytes);
            objectOutputStream.writeObject(this.dataBytes);
            objectOutputStream.flush();
            objectOutputStream.close();
            this.tokenString = Base64.encode(byteArrayOutputStream.toByteArray());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "SecurityStringDataConverter", this.tokenString);
            }
        }
    }
}

