/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.Work;
import com.ibm.ws.asynchbeans.AsynchBeansService;
import com.ibm.ws.asynchbeans.AsynchContextDescriptor;
import com.ibm.ws.asynchbeans.ExecutionContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.sandesha2.context.ContextManager;

public class WSRMContextManager
implements ContextManager {
    private static final TraceComponent tc = Tr.register(WSRMContextManager.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private AsynchBeansService service;
    private AsynchContextDescriptor descriptor;
    private Set excludes;
    private ClassLoader classLoader;

    public WSRMContextManager(ConfigurationContext configurationContext) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "WSRMContextManager");
            }
            try {
                this.service = (AsynchBeansService)WsServiceRegistry.getService(this, AsynchBeansService.class);
                this.descriptor = this.service.createContextDescriptor(true, new String[0]);
                this.excludes = new HashSet();
                this.excludes.add("JTA");
                this.classLoader = Thread.currentThread().getContextClassLoader();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Class loader found", this.classLoader);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.websvcs.rm.context.WSRMContextManager.<init>", "1:86:1.4");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Caught exception", exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "WSRMContextManager");
        }
    }

    public Serializable storeContext() {
        byte[] byArray;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "storeContext");
            }
            byArray = null;
            if (this.service != null) {
                try {
                    ExecutionContext executionContext = this.service.createExecutionContext(this.descriptor, this.excludes);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    objectOutputStream.writeObject(executionContext);
                    objectOutputStream.close();
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.websvcs.rm.context.WSRMContextManager.storeContext", "1:113:1.4");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Caught exception", exception);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "storeContext", byArray);
        }
        return byArray;
    }

    public Runnable wrapWithContext(final Runnable runnable, Serializable serializable) {
        Runnable runnable2;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "wrapWithContext", serializable);
            }
            runnable2 = runnable;
            if (serializable != null) {
                try {
                    byte[] byArray = (byte[])serializable;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    final ExecutionContext executionContext = (ExecutionContext)objectInputStream.readObject();
                    final Work work = new Work(){

                        public void release() {
                        }

                        public void run() {
                            AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                        Tr.entry(tc, "run");
                                    }
                                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Class loader found " + classLoader + " replacing with " + WSRMContextManager.this.classLoader);
                                    }
                                    Thread.currentThread().setContextClassLoader(WSRMContextManager.this.classLoader);
                                    runnable.run();
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Replacing class loader " + classLoader);
                                    }
                                    Thread.currentThread().setContextClassLoader(classLoader);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                        Tr.exit(tc, "run");
                                    }
                                    return null;
                                }
                            });
                        }
                    };
                    runnable2 = new Runnable(){

                        public void run() {
                            block4: {
                                try {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Starting user code under saved context");
                                    }
                                    executionContext.go(null, WSRMContextManager.this.descriptor, work);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Finished user code under saved context");
                                    }
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.rm.context.WSRMContextManager.wrapWithContext", "1:186:1.4");
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                                    Tr.debug(tc, "Caught exception from user code", throwable);
                                }
                            }
                        }
                    };
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.websvcs.rm.context.WSRMContextManager.storeContext", "1:196:1.4");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Caught exception", exception);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "wrapWithContext");
        }
        return runnable2;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)WSERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/context/WSRMContextManager.java, WAS.rm, WSFP.WSERV1, cf230905.09 1.4");
        }
    }
}

