/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmStack;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmTx;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl;
import com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper;
import com.ibm.ws.pmi.reqmetrics.PmiRmCallContext;
import com.ibm.ws.pmi.reqmetrics.PmiRmConfigData;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtx;
import com.ibm.ws.pmi.reqmetrics.PmiRmUtil;
import com.ibm.ws.pmi.reqmetrics.wsHandlers.WsFilterCfg;
import com.ibm.ws.pmi.reqmetrics.wsHandlers.WsFilterValue;
import com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsHandlerBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;

public class ReqMetricsServerHandler
extends ReqMetricsHandlerBase {
    private static final TraceComponent tc = Tr.register(ReqMetricsServerHandler.class.getName(), "pmi.rm", "com.ibm.ws.websvcs.pmi.reqmetrics");
    private static final String SOURCE_FILE = "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsServerHandler";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    public static final int PORT_ID = 0;
    public static final int OP_ID = 1;
    public static final int TRANSPORT_ID = 2;
    public static final int NAMESPACE_ID = 3;
    public static final int INPUT_MESSAGE_ID = 4;
    public static final int METHOD_INFO_OFFSET = 0;
    public static final String RM_SRV_START = "REQMETRICS_WS_SERVER_START";
    public static final int num_webservices_ctx_names = 5;
    private static final String WSDL_PORT = "WsdlPort";
    private static final String WSDL_LOC = "WsdlLocation";

    public ReqMetricsServerHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ReqMetricsServerHandler is initialized");
        }
    }

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        try {
            String string = messageContext.getAxisOperation().getMessageExchangePattern();
            int n = messageContext.getFLOW();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Message Exchange Pattern " + string);
                Tr.debug(tc, "FLOW                     " + n);
            }
            if ("http://www.w3.org/2004/08/wsdl/in-only".equals(string) || "http://www.w3.org/2006/01/wsdl/in-only".equals(string)) {
                if (this.impl.isComponentEnabled(3)) {
                    Tr.info(tc, "Request Metrics does not instrument one-way webservice(JAX-WS) request");
                }
                return Handler.InvocationResponse.CONTINUE;
            }
            if (messageContext.getFLOW() == 1) {
                this.handleRequest(messageContext);
            } else if (messageContext.getFLOW() == 2) {
                this.handleResponse(messageContext);
            } else if (messageContext.getFLOW() == 4) {
                this.handleFault(messageContext);
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            Tr.error(tc, "During the invocation of Request Metrics Server Handler, the following exception was encountered: " + exception.toString() + "\n" + stringWriter.toString());
            throw new AxisFault("An error occurred during the request in the Request Metrics server Handler.", exception);
        }
    }

    public boolean handleRequest(MessageContext messageContext) {
        boolean bl;
        block31: {
            block33: {
                block32: {
                    if (this.impl == null) {
                        Tr.error(tc, "PMRM0022E");
                        return true;
                    }
                    if (!this.impl.isEnabled()) break block32;
                    if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)3)) break block33;
                }
                return true;
            }
            boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
            if (bl) {
                Tr.entry(tc, "handleRequest");
            }
            try {
                int n;
                Object object;
                String[] stringArray;
                PmiRmThreadCtx pmiRmThreadCtx = this.impl.getThreadContext();
                ReqMetricsServerHandler reqMetricsServerHandler = this;
                PmiRmConfigData pmiRmConfigData = reqMetricsServerHandler.impl.getConfig();
                String[] stringArray2 = null;
                byte[] byArray = null;
                Object var7_8 = null;
                boolean bl3 = false;
                boolean bl4 = true;
                PmiRmArmTx pmiRmArmTx = PmiRmArmStack.peekTransaction();
                if (pmiRmArmTx != null) {
                    if (bl) {
                        Tr.debug(tc, "handleRequest: peekTransaction returns a PmiRmArmTx");
                    }
                    if (pmiRmArmTx instanceof PmiRmCallContext) {
                        stringArray = (String[])pmiRmArmTx;
                        object = stringArray.getCorrelator();
                        if (bl) {
                            Tr.debug(tc, "PmiRmCorrelator is " + object.formatAsParent());
                        }
                        bl3 = true;
                        byArray = pmiRmArmTx.getCorrelatorBytes();
                    } else {
                        if (bl) {
                            Tr.debug(tc, "The parent correlator is not a PmiRmCallContext");
                        }
                        bl3 = true;
                        byArray = pmiRmArmTx.getCorrelatorBytes();
                    }
                }
                if (!bl3) {
                    if (bl) {
                        Tr.debug(tc, "handleRequest: do not have correlator on the stack, check incoming correlator");
                    }
                    stringArray = this.getCorrelatorsFromContext(messageContext);
                    boolean bl5 = true;
                    if (stringArray[0] == null && stringArray[1] == null) {
                        stringArray2 = this.getContextValues(messageContext);
                        bl5 = this.isFilterPassed(stringArray2, pmiRmConfigData);
                    }
                    this.impl.setInboundCorrelators((Object)pmiRmThreadCtx, 3, stringArray, bl5);
                    n = pmiRmThreadCtx.getInboundCorrelatorType();
                    if (n == 1) {
                        bl4 = false;
                    } else {
                        if (n == 2) {
                            if (bl) {
                                Tr.exit(tc, "handleRequest: request not pass filter at upstream, stop instrumentation now");
                            }
                            return true;
                        }
                        bl4 = true;
                    }
                    if (bl) {
                        Tr.debug(tc, "handleRequest: pushIncomingCorrelators return status=" + n + ", hasIncomingCorrelator=" + bl4);
                    }
                }
                if (!pmiRmThreadCtx.getTrace()) {
                    return true;
                }
                if (!this.impl.isComponentEnabled(3) && (bl3 || bl4)) {
                    if (bl) {
                        Tr.exit(tc, "handleRequest: Web Sevices component is not enabled for request metrics instrumentation. Do not create sub-transaction");
                    }
                    return true;
                }
                boolean bl6 = this.isTraceEnabled(byArray);
                if (!bl6 && !this.impl.isLogEnabled()) {
                    if (bl) {
                        Tr.exit(tc, "handleRequest: stop tracing because this transaction is not enabled for ARM and log tracing");
                    }
                    return true;
                }
                if (stringArray2 == null) {
                    stringArray2 = this.getContextValues(messageContext);
                }
                object = this.getTranName(stringArray2);
                this.impl.reqStart(pmiRmThreadCtx, 3, bl6, (String)object, stringArray2);
                if (bl6) {
                    n = PmiRmArmWrapper.getStartHandle((PmiRmThreadCtx)pmiRmThreadCtx);
                    if (bl) {
                        Tr.debug(tc, "calling MessageContext.setProperty for startHandler=" + n);
                    }
                    messageContext.setProperty(RM_SRV_START, new Integer(n));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsServerHandler.handleRequest", FFDC_ID_1);
                Tr.warning(tc, "PMRM0108E", exception.toString());
                if (!bl) break block31;
                exception.printStackTrace();
            }
        }
        if (bl) {
            Tr.exit(tc, "handleRequest");
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        boolean bl;
        block7: {
            block6: {
                if (this.impl == null) {
                    Tr.error(tc, "PMRM0022E");
                    return true;
                }
                if (!this.impl.isEnabled()) break block6;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)3)) break block7;
            }
            return true;
        }
        boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "handleResponse");
        }
        this.tranEnd(messageContext, 0);
        if (bl) {
            Tr.exit(tc, "handleResponse");
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        boolean bl;
        block7: {
            block6: {
                if (this.impl == null) {
                    Tr.error(tc, "PMRM0022E");
                    return true;
                }
                if (!this.impl.isEnabled()) break block6;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)3)) break block7;
            }
            return true;
        }
        boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "handleFault");
        }
        this.tranEnd(messageContext, 2);
        if (bl) {
            Tr.exit(tc, "handleFault");
        }
        return true;
    }

    public void handleClosure(MessageContext messageContext) {
        boolean bl;
        block7: {
            block6: {
                if (this.impl == null) {
                    Tr.error(tc, "PMRM0022E");
                    return;
                }
                if (!this.impl.isEnabled()) break block6;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)3)) break block7;
            }
            return;
        }
        boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "handleClosure");
        }
        this.tranEnd(messageContext, 0);
        if (bl) {
            Tr.exit(tc, "handleClosure");
        }
    }

    private void tranEnd(MessageContext messageContext, int n) {
        block11: {
            Tr.entry(tc, "tranEnd");
            try {
                PmiRmArmTx pmiRmArmTx;
                PmiRmThreadCtx pmiRmThreadCtx = this.impl.getThreadContext();
                if (!this.impl.isComponentEnabled(3)) {
                    if (pmiRmThreadCtx.getInboundComponent() != 3) {
                        return;
                    }
                    if (!pmiRmThreadCtx.isInboundInstrumented()) {
                        return;
                    }
                }
                if ((pmiRmArmTx = PmiRmArmWrapper.peekArmTransaction((PmiRmThreadCtx)pmiRmThreadCtx)) == null) {
                    Tr.error(tc, "PMRM0030E");
                    Tr.exit(tc, "tranEnd");
                    return;
                }
                boolean bl = false;
                Integer n2 = (Integer)messageContext.getProperty(RM_SRV_START);
                if (n2 != null) {
                    int n3;
                    int n4 = n2;
                    if (n4 != (n3 = PmiRmArmWrapper.getStartHandle((PmiRmThreadCtx)pmiRmThreadCtx))) {
                        Tr.warning(tc, "PMRM0213W", "tranEnd");
                    } else {
                        bl = true;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "tranEnd: armStartCalled=" + bl);
                }
                Properties properties = null;
                if (bl) {
                    // empty if block
                }
                this.impl.reqStop((Object)pmiRmThreadCtx, bl, n, properties);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsServerHandler.tranEnd", FFDC_ID_2);
                Tr.warning(tc, "PMRM0108E", exception.toString());
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "tranEnd");
    }

    private String getTranName(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTranName");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("wsprovider:");
        stringBuffer.append(stringArray[0]);
        if (stringArray[1] == null) {
            stringBuffer.append(".");
        } else {
            stringBuffer.append(".").append(stringArray[1]);
        }
        stringBuffer.append("?transport=").append(stringArray[2]);
        if (stringArray[3] == null) {
            stringBuffer.append("&namespace=");
        } else {
            stringBuffer.append("&namespace=").append(stringArray[3]);
        }
        stringBuffer.append("&input=").append(stringArray[4]);
        String string = stringBuffer.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTranName returns " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTranName");
        }
        return string;
    }

    private String[] getContextValues(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getContextValues");
        }
        String[] stringArray = new String[5];
        if (messageContext == null) {
            return stringArray;
        }
        AxisService axisService = messageContext.getAxisService();
        Parameter parameter = axisService.getParameter(WSDL_PORT);
        QName qName = messageContext.getAxisOperation().getName();
        if (parameter == null) {
            stringArray[0] = "";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ReqMetricsServerHandler.getContextValues: portQName is null");
            }
        } else {
            stringArray[0] = (String)parameter.getValue();
        }
        if (qName == null) {
            stringArray[1] = "";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ReqMetricsServerHandler.getContextValues: operationName is null");
            }
        } else {
            stringArray[1] = qName.getLocalPart();
        }
        stringArray[2] = messageContext.getIncomingTransportName();
        stringArray[3] = axisService.getTargetNamespace();
        AxisMessage axisMessage = messageContext.getAxisOperation().getMessage("In");
        if (axisMessage == null) {
            stringArray[4] = "";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ReqMetricsServerHandler.getContextValues: inputMsg is null");
            }
        } else {
            stringArray[4] = axisMessage.getName();
        }
        return stringArray;
    }

    protected Properties getMetricsData(MessageContext messageContext, int n, boolean bl) {
        Properties properties;
        block13: {
            Object object;
            Object object2;
            Parameter parameter;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.entry(tc, "getMetricsData: level=" + n);
            }
            if (messageContext == null) {
                return null;
            }
            AxisService axisService = messageContext.getAxisService();
            properties = new Properties();
            if (n >= 2) {
                parameter = axisService.getParameter(WSDL_PORT);
                if (parameter != null) {
                    properties.put("WS_PORT_NM", parameter.getValue());
                } else {
                    properties.put("WS_PORT_NM", "");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getMetricsData: WSDLPort QName is null");
                    }
                }
                object2 = messageContext.getAxisOperation().getName();
                properties.put("WS_OP_NM", ((QName)object2).getLocalPart());
                properties.put("WS_TRAN_NM", messageContext.getIncomingTransportName());
                properties.put("WS_TGT_NS", axisService.getTargetNamespace());
                object = messageContext.getAxisOperation().getMessage("In");
                if (object != null) {
                    properties.put("WS_IN_MSG_NM", ((AxisMessage)object).getName());
                } else {
                    properties.put("WS_IN_MSG_NM", "");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getMetricsData: inputMsg QName is null");
                    }
                }
            }
            if (n == 3) {
                parameter = axisService.getParameter(WSDL_LOC);
                properties.put("WS_WSDL_LOC", parameter != null ? parameter.getValue() : null);
                if (bl) {
                    try {
                        object2 = messageContext.getEnvelope();
                        object = object2.getBody();
                        properties.put("WS_SOAP_BD", object);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsServerHandler.getMetricsData", FFDC_ID_4);
                        Tr.warning(tc, "PMRM0108E", exception.toString());
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                        exception.printStackTrace();
                    }
                }
            }
        }
        return properties;
    }

    private String[] getCorrelatorsFromContext(MessageContext messageContext) {
        try {
            boolean bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
            SOAPEnvelope sOAPEnvelope = messageContext.getEnvelope();
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            String string = null;
            String string2 = null;
            if (sOAPHeader != null) {
                QName qName = new QName("", "rm_correlator", "");
                Iterator iterator = sOAPHeader.extractHeaderBlocks("reqmetricsURI");
                boolean bl2 = false;
                QName qName2 = null;
                String string3 = null;
                while (iterator.hasNext()) {
                    SOAPHeaderBlock sOAPHeaderBlock;
                    if (bl) {
                        Tr.debug(tc, "ReqMetricsServerHandler.getCorrelatorsFromContext: find a header element");
                    }
                    if ((string3 = (qName2 = (sOAPHeaderBlock = (SOAPHeaderBlock)iterator.next()).getQName()).getLocalPart()).indexOf("arm_correlator") != -1 || string3.indexOf("correlator") != -1) {
                        string = sOAPHeaderBlock.getText();
                        string2 = sOAPHeaderBlock.getAttributeValue(qName);
                        bl2 = true;
                    }
                    if (bl2 && bl) {
                        Tr.debug(tc, "getCorrelatorsFromContext armCorStr=" + string + ", rmCorStr=" + string2);
                    }
                    if (!bl2) continue;
                    break;
                }
            }
            return new String[]{string, string2};
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsServerHandler.getCorrelatorsFromContext", FFDC_ID_5, this);
            exception.printStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                exception.printStackTrace();
            }
            return new String[]{null, null};
        }
    }

    private boolean isFilterPassed(String[] stringArray, PmiRmConfigData pmiRmConfigData) {
        WsFilterCfg wsFilterCfg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFilterPassed");
        }
        if (!(wsFilterCfg = (WsFilterCfg)pmiRmConfigData.getWSFilterConfig()).isEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFilterPassed returns true because this filter is not enabled");
            }
            return true;
        }
        for (int i = 0; i < wsFilterCfg.getParsedValues().length; ++i) {
            WsFilterValue wsFilterValue = wsFilterCfg.getParsedValues()[i];
            if (!wsFilterValue.isEnabled() || !PmiRmUtil.isStrMatched((String)wsFilterValue.getPort(), (String)stringArray[0]) || !PmiRmUtil.isStrMatched((String)wsFilterValue.getOperation(), (String)stringArray[1]) || !PmiRmUtil.isStrMatched((String)wsFilterValue.getNameSpace(), (String)stringArray[3])) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFilterPassed returns true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFilterPassed returns false");
        }
        return false;
    }

    public Properties getTranDetailProps(PmiRmThreadCtx pmiRmThreadCtx, int n, MessageContext messageContext, boolean bl) {
        int n2 = this.impl.getTranDetailLevel((Object)pmiRmThreadCtx, 3);
        if (n2 < 2 || messageContext == null) {
            return null;
        }
        return this.getContextInfo(pmiRmThreadCtx, messageContext);
    }
}

