/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmTx;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmTxFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl;
import com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper;
import com.ibm.ws.pmi.reqmetrics.PmiRmCallContext;
import com.ibm.ws.pmi.reqmetrics.PmiRmCorrelator;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtx;
import com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsHandlerBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;

public class ReqMetricsClientHandler
extends ReqMetricsHandlerBase {
    private static final TraceComponent tc = Tr.register(ReqMetricsClientHandler.class.getName(), "pmi.rm", "com.ibm.ws.websvcs.pmi.reqmetrics");
    private static final String SOURCE_FILE = "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsClientHandler";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    public static final String PORT_NAME = "wsdlPort";
    public static final String OP_NAME = "opName";
    public static final String TRANSPORT_NAME = "transportName";
    public static final String TARGET_ENDPOINRT = "targetEndpoint";
    public static final String PARAM_NAMES = "paramNames";
    public static final String SERVICE_REF_NAME = "serviceReferenceName";
    public static final String RESPONSE_MSG = "responseMessage";
    public static final int PORT_ID = 0;
    public static final int OP_ID = 1;
    public static final int TRANSPORT_ID = 2;
    public static final int PARAMS_ID = 3;
    public static final String RM_CLNT_START = "REQMETRICS_WS_CLIENT_START";
    private static final boolean trDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
    private static final String TGT_ENDPT_ADDR = "javax.xml.ws.service.endpoint.address";
    private static final String WSDL_SVC_NM = "WSDL_SERVICE_QNAME";
    private static final String WSDL_PORT = "WSDL_PORT";

    public ReqMetricsClientHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ReqMetricsClientHandler is initialized");
        }
    }

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        try {
            if (this.impl == null) {
                return Handler.InvocationResponse.CONTINUE;
            }
            String string = messageContext.getAxisOperation().getMessageExchangePattern();
            int n = messageContext.getFLOW();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Message Exchange Pattern " + string);
                Tr.debug(tc, "FLOW                     " + n);
            }
            if ("http://www.w3.org/2004/08/wsdl/out-only".equals(string) || "http://www.w3.org/2006/01/wsdl/out-only".equals(string)) {
                if (this.impl.isComponentEnabled(4)) {
                    Tr.info(tc, "Request Metrics does not instrument one-way webservice(JAX-WS) requests");
                }
                return Handler.InvocationResponse.CONTINUE;
            }
            if (messageContext.getFLOW() == 2) {
                this.handleRequest(messageContext);
            } else if (messageContext.getFLOW() == 1) {
                this.handleResponse(messageContext);
            } else if (messageContext.getFLOW() == 3) {
                this.handleFault(messageContext);
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            Tr.error(tc, "During the invocation of Request Metrics Client Handler, the following exception was encountered: " + exception.toString() + "\n" + stringWriter.toString());
            throw new AxisFault("An error occurred during the request in the Request Metrics client Handler.", exception);
        }
    }

    public boolean handleRequest(MessageContext messageContext) {
        block26: {
            block28: {
                block27: {
                    if (this.impl == null) {
                        this.impl = PmiReqMetricsImpl.getInstance();
                        if (this.impl == null) {
                            Tr.error(tc, "PMRM0022E");
                            return true;
                        }
                    }
                    if (trDebug) {
                        Tr.entry(tc, "handleRequest");
                    }
                    if (!this.impl.isReallyEnabled()) break block27;
                    if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)4)) break block28;
                }
                return true;
            }
            if (trDebug) {
                Tr.debug(tc, "handleRequest");
            }
            PmiRmArmTx pmiRmArmTx = null;
            PmiRmThreadCtx pmiRmThreadCtx = null;
            try {
                String[] stringArray;
                Object object;
                Object object2;
                Object object3;
                pmiRmThreadCtx = this.impl.getThreadContext();
                if (!this.impl.isComponentEnabled(4)) {
                    if (trDebug) {
                        Tr.debug(tc, "handleRequest: Web Sevices component is not enabled for request metrics instrumentation. Do not create sub-transaction");
                    }
                } else {
                    if (!pmiRmThreadCtx.getTrace()) {
                        return true;
                    }
                    object3 = PmiRmArmWrapper.getArmCorrelator((PmiRmThreadCtx)pmiRmThreadCtx);
                    boolean bl = this.isTraceEnabled((byte[])object3);
                    if (bl || this.impl.isLogEnabled()) {
                        object2 = this.getTranName(messageContext);
                        object = pmiRmThreadCtx.getConfig();
                        if (object == null) {
                            ReqMetricsClientHandler reqMetricsClientHandler = this;
                            object = reqMetricsClientHandler.impl.getConfig();
                        }
                        stringArray = null;
                        if (object.isTraceDebugEnabled() && object.isARMEnabled() && this.impl.getArmType() == PmiRmArmTxFactory.ARM4_TYPE) {
                            stringArray = this.getContextValues(messageContext);
                        }
                        this.impl.updateBegin((Object)pmiRmThreadCtx, 4, bl, "Web Services Requestor", (String)object2, stringArray);
                        if (!bl) {
                            int n = PmiRmArmWrapper.getStartHandle((PmiRmThreadCtx)pmiRmThreadCtx);
                            messageContext.getOperationContext().setProperty(RM_CLNT_START, new Integer(n));
                            if (trDebug) {
                                Tr.debug(tc, "calling MessageContext.setProperty for startHandle=" + n);
                            }
                        }
                    }
                }
                pmiRmArmTx = PmiRmArmWrapper.peekArmTransaction((PmiRmThreadCtx)pmiRmThreadCtx);
                object3 = null;
                PmiRmCorrelator pmiRmCorrelator = null;
                if (pmiRmArmTx == null) {
                    Tr.warning(tc, "PMRM0210W", "handleRequest");
                    return true;
                }
                if (trDebug) {
                    Tr.debug(tc, "handleRequest: find a correlator on stack");
                }
                if (pmiRmArmTx instanceof PmiRmCallContext) {
                    if (trDebug) {
                        Tr.debug(tc, "handleRequest: get PmiRmCallContext");
                    }
                    object3 = (PmiRmCallContext)pmiRmArmTx;
                    pmiRmCorrelator = object3.getCorrelator();
                } else if (trDebug) {
                    Tr.debug(tc, "handleRequest: get armTx");
                }
                object2 = pmiRmArmTx.getCorrelatorBytes();
                this.impl.getArmWrapper();
                object = PmiRmArmWrapper.toHexString((byte[])object2);
                stringArray = PmiRmCorrelator.getStringFromPmiRmCorrelator((PmiRmCorrelator)pmiRmCorrelator);
                if (object == null && stringArray == null) {
                    Tr.warning(tc, "both ARM and request metrics correlators are null");
                    Tr.exit(tc, "handleRequest");
                    return true;
                }
                this.addCorrelatorsToSoapHeader(messageContext, (String)object, (String)stringArray);
                ReqMetricsClientHandler reqMetricsClientHandler = this;
                this.updateHttpHeader(messageContext, reqMetricsClientHandler.impl.getConfig().getArmCorrelatorHeaderName(), "DoNotTraceLowerProtocol");
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsClientHandler.handleRequest", FFDC_ID_1);
                Tr.warning(tc, "PMRM0108E", exception.toString());
                if (!trDebug) break block26;
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "handleRequest");
        return true;
    }

    private void addCorrelatorsToSoapHeader(MessageContext messageContext, String string, String string2) {
        block7: {
            try {
                if (trDebug) {
                    Tr.entry(tc, "addCorrelatorsToSoapHeader");
                }
                SOAPEnvelope sOAPEnvelope = messageContext.getEnvelope();
                SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
                SOAP12Factory sOAP12Factory = new SOAP12Factory();
                if (sOAPHeader == null) {
                    sOAPHeader = sOAP12Factory.createSOAPHeader();
                }
                OMFactory oMFactory = OMAbstractFactory.getOMFactory();
                OMNamespace oMNamespace = oMFactory.createOMNamespace("http://websphere.ibm.com", "reqmetrics");
                SOAPHeaderBlock sOAPHeaderBlock = sOAPHeader.addHeaderBlock("arm_correlator", oMNamespace);
                sOAPHeaderBlock.setText(string);
                sOAPHeaderBlock.setRole("reqmetricsURI");
                if (string2 != null) {
                    OMNamespace oMNamespace2 = sOAPHeaderBlock.declareNamespace("", "");
                    sOAPHeaderBlock.addAttribute("rm_correlator", string2, oMNamespace2);
                    QName qName = new QName("", "rm_correlator", "");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "addCorrelatorsToSoapHeader: add rm cor attribute=" + sOAPHeaderBlock.getAttributeValue(qName));
                    }
                }
                if (trDebug) {
                    Tr.exit(tc, "addCorrelatorsToSoapHeader: add arm cor value=" + sOAPHeaderBlock.getText());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsClientHandler.addCorrelatorsToSoapHeader", FFDC_ID_5, this);
                exception.printStackTrace();
                if (!trDebug) break block7;
                exception.printStackTrace();
            }
        }
    }

    private void updateHttpHeader(MessageContext messageContext, String string, String string2) {
        HashMap<String, String> hashMap;
        if (trDebug) {
            Tr.entry(tc, "updateHttpHeader");
        }
        if ((hashMap = (HashMap<String, String>)messageContext.getProperty("com.ibm.websphere.webservices.requestTransportProperties")) == null) {
            hashMap = new HashMap<String, String>();
            if (trDebug) {
                Tr.debug(tc, "updateHttpHeader: no HashMap is found, create a new one");
            }
        } else if (trDebug) {
            Tr.debug(tc, "updateHttpHeader: HashMap is found, use the existing one");
        }
        if (trDebug) {
            Tr.debug(tc, "updateHttpHeader: requestheaders.put name=" + string + ", value=" + string2);
        }
        hashMap.put(string, string2);
        messageContext.setProperty("com.ibm.websphere.webservices.requestTransportProperties", hashMap);
        if (trDebug) {
            Tr.exit(tc, "udpateHttpHeader");
        }
    }

    public boolean handleResponse(MessageContext messageContext) {
        block6: {
            block5: {
                if (this.impl == null || !this.impl.isEnabled()) break block5;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)4) && this.impl.isComponentEnabled(4)) break block6;
            }
            return true;
        }
        if (trDebug) {
            Tr.entry(tc, "handleResponse");
        }
        this.tranEnd(messageContext, 0);
        if (trDebug) {
            Tr.exit(tc, "handleResponse");
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        block6: {
            block5: {
                if (this.impl == null || !this.impl.isEnabled()) break block5;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)4) && this.impl.isComponentEnabled(4)) break block6;
            }
            return true;
        }
        if (trDebug) {
            Tr.entry(tc, "handleFault");
        }
        this.tranEnd(messageContext, 2);
        if (trDebug) {
            Tr.exit(tc, "handleFault");
        }
        return true;
    }

    public void handleClosure(MessageContext messageContext) {
        block5: {
            block4: {
                if (this.impl == null || !this.impl.isEnabled()) break block4;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)4) && this.impl.isComponentEnabled(4)) break block5;
            }
            return;
        }
        if (trDebug) {
            Tr.debug(tc, "handleClosure");
        }
        this.tranEnd(messageContext, 0);
    }

    private void tranEnd(MessageContext messageContext, int n) {
        block10: {
            if (trDebug) {
                Tr.entry(tc, "tranEnd");
            }
            try {
                PmiRmThreadCtx pmiRmThreadCtx = this.impl.getThreadContext();
                if (!pmiRmThreadCtx.getTrace()) {
                    return;
                }
                boolean bl = false;
                Integer n2 = (Integer)messageContext.getOperationContext().getProperty(RM_CLNT_START);
                if (trDebug) {
                    Tr.debug(tc, "HandleObj from MessageContext  " + messageContext + "  handle   " + n2);
                }
                if (n2 != null) {
                    int n3;
                    int n4 = n2;
                    if (n4 != (n3 = PmiRmArmWrapper.getStartHandle((PmiRmThreadCtx)pmiRmThreadCtx))) {
                        Tr.warning(tc, "PMRM0213W", "tranEnd");
                    } else {
                        bl = true;
                    }
                }
                Properties properties = null;
                if (bl) {
                    properties = this.getContextInfo(pmiRmThreadCtx, messageContext);
                }
                this.impl.updateEnd((Object)pmiRmThreadCtx, bl, n, properties);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsClientHandler.tranEnd", FFDC_ID_2);
                Tr.warning(tc, "PMRM0108E", exception.toString());
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                exception.printStackTrace();
            }
        }
        if (trDebug) {
            Tr.exit(tc, "tranEnd");
        }
    }

    protected Properties getMetricsData(MessageContext messageContext, int n, boolean bl) {
        Properties properties;
        block11: {
            Object object;
            Object object2;
            Object object3;
            String string;
            if (trDebug) {
                Tr.debug(tc, "getMetricsData: level=" + n);
            }
            properties = new Properties();
            if (n >= 2) {
                string = "";
                object3 = this.getOperation(messageContext.getEnvelope());
                object2 = new StringBuffer();
                if (((Object[])object3).length > 0) {
                    string = object3[0].toString();
                    for (int i = 1; i < ((Object[])object3).length; ++i) {
                        ((StringBuffer)object2).append(object3[i].toString());
                        if (i >= ((Object)object3).length - 1) continue;
                        ((StringBuffer)object2).append(",");
                    }
                }
                object = messageContext.getAxisService().getParameter(WSDL_PORT);
                String string2 = messageContext.getTransportOut().getName().getLocalPart();
                if (object != null) {
                    properties.put("WS_PORT_NM", ((Parameter)object).getValue().toString());
                } else {
                    properties.put("WS_PORT_NM", "");
                }
                properties.put("WS_OP_NM", string);
                properties.put("WS_TRAN_NM", string2);
                properties.put("WS_PRM_Q_NM_LST", ((StringBuffer)object2).toString());
            }
            if (n == 3) {
                string = (String)messageContext.getOptions().getProperties().get(TGT_ENDPT_ADDR);
                object3 = messageContext.getAxisService().getParameter(WSDL_SVC_NM);
                properties.put("WS_TGT_E_ADR", string);
                if (object3 != null) {
                    properties.put("WS_SVC_REF_NM", ((Parameter)object3).getValue().toString());
                }
                if (bl) {
                    try {
                        object2 = messageContext.getEnvelope();
                        object = object2.getBody();
                        properties.put("WS_RESP_MSG", object);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsClientHandler.getMetricsData", FFDC_ID_4);
                        Tr.warning(tc, "PMRM0108E", exception.toString());
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                        exception.printStackTrace();
                    }
                }
            }
        }
        return properties;
    }

    protected String getTranName(MessageContext messageContext) {
        Parameter parameter = messageContext.getAxisService().getParameter(WSDL_PORT);
        String string = messageContext.getTransportOut().getName().getLocalPart();
        String string2 = "";
        Object[] objectArray = this.getOperation(messageContext.getEnvelope());
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray.length > 0) {
            string2 = objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i].toString());
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("wsrequestor:");
        if (parameter != null) {
            stringBuffer2.append(parameter.getValue());
        } else {
            if (trDebug) {
                Tr.debug(tc, "getTranName, portQName is null");
            }
            stringBuffer2.append("");
        }
        if (string2 == null) {
            stringBuffer2.append(".");
        } else {
            stringBuffer2.append(".").append(string2);
        }
        stringBuffer2.append("?transport=").append(string);
        stringBuffer2.append("&parameters=").append(stringBuffer.toString());
        String string3 = stringBuffer2.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTranName returns " + string3);
        }
        return string3;
    }

    protected String[] getContextValues(MessageContext messageContext) {
        String[] stringArray = new String[4];
        AxisService axisService = messageContext.getAxisService();
        Parameter parameter = axisService.getParameter(WSDL_PORT);
        Object[] objectArray = this.getOperation(messageContext.getEnvelope());
        if (objectArray.length > 0) {
            stringArray[1] = objectArray[0].toString();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i].toString());
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(",");
            }
            stringArray[3] = stringBuffer.toString();
        }
        stringArray[0] = parameter != null ? (String)parameter.getValue() : "";
        stringArray[2] = messageContext.getTransportOut().getName().getLocalPart();
        return stringArray;
    }

    public Properties getTranDetailProps(PmiRmThreadCtx pmiRmThreadCtx, int n, MessageContext messageContext, boolean bl) {
        int n2 = this.impl.getTranDetailLevel((Object)pmiRmThreadCtx, 4);
        if (n2 < 2 || messageContext == null) {
            return null;
        }
        return this.getContextInfo(pmiRmThreadCtx, messageContext);
    }

    private Object[] getOperation(SOAPEnvelope sOAPEnvelope) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            OMElement oMElement = sOAPBody.getFirstElement();
            arrayList.add(oMElement.getLocalName());
            Iterator iterator = oMElement.getChildElements();
            while (iterator.hasNext()) {
                OMElement oMElement2 = (OMElement)iterator.next();
                arrayList.add(oMElement2.getLocalName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList.toArray();
    }
}

