/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.pmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.pmi.MessagePMIContext;
import com.ibm.ws.websvcs.pmi.PMIGlobalHandler;
import com.ibm.ws.websvcs.resources.NLSProvider;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.engine.Handler;

public class PMITransportGeneratorHandler
extends PMIGlobalHandler
implements Constants {
    private static final TraceComponent _tc = Tr.register(PMITransportGeneratorHandler.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invoke");
        }
        try {
            if (messageContext.isServerSide()) {
                OperationContext operationContext = messageContext.getOperationContext();
                MessageContext messageContext2 = operationContext.getMessageContext("In");
                if (messageContext2 != null) {
                    MessagePMIContext messagePMIContext = (MessagePMIContext)messageContext2.getProperty(MessagePMIContext.propertyName);
                    if (messagePMIContext != null) {
                        if (messageContext.isProcessingFault()) {
                            messagePMIContext.close(messageContext);
                            Tr.error(_tc, "Fault returned from request.");
                        } else {
                            messagePMIContext.onServerReturnReply(messageContext);
                        }
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "The inbound Message Context could not be retrieved.");
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.pmi.PMITransportGeneratorHandler.invoke", "84", this);
            Object[] objectArray = new Object[]{exception};
            String string = NLSProvider.getNLS().getFormattedMessage("pmiHandlerFail00", objectArray, "Error occurred while attempting to invoke the PMI Handler: {0}");
            Tr.error(_tc, "pmiHandlerFail00", objectArray);
            throw new AxisFault(string, exception);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "invoke");
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

