/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.pmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.pmi.MessagePMIContext;
import com.ibm.ws.websvcs.pmi.PMIGlobalHandler;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Handler;

public class PMITransportConsumerHandler
extends PMIGlobalHandler
implements Constants {
    private static final TraceComponent _tc = Tr.register(PMITransportConsumerHandler.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private boolean init = false;
    private WASAxis2Service service = null;

    private synchronized void initialize() throws Exception {
        if (this.init) {
            return;
        }
        this.init = true;
        try {
            this.service = (WASAxis2Service)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return WsServiceRegistry.getService(this, WASAxis2Service.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    public PMITransportConsumerHandler() {
        this.inboundHandler = true;
    }

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invoke");
        }
        try {
            AxisService axisService;
            this.initialize();
            if (messageContext.isServerSide() && (axisService = messageContext.getAxisService()) != null) {
                ServerModuleMetaData serverModuleMetaData = (ServerModuleMetaData)this.service.getModuleMetaData();
                String string = Axis2Utils.getPortComponentName(axisService);
                if (serverModuleMetaData != null && string != null) {
                    WebServicesPerf webServicesPerf = serverModuleMetaData.getPMIServicesModule();
                    if (webServicesPerf != null) {
                        MessagePMIContext messagePMIContext = new MessagePMIContext(messageContext, webServicesPerf, string);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Initializing PMI recording media for service: " + string);
                        }
                        messagePMIContext.onServerReceiveRequest(messageContext);
                        messageContext.setProperty(MessagePMIContext.propertyName, messagePMIContext);
                    }
                } else if (_tc.isDebugEnabled()) {
                    if (serverModuleMetaData == null) {
                        Tr.debug(_tc, "Server Module Metadata was null.");
                    }
                    if (string == null) {
                        Tr.debug(_tc, "Port Component Name was null.");
                    }
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.pmi.PMITransportConsumerHandler.invoke", "115", this);
            Object[] objectArray = new Object[]{exception};
            String string = NLSProvider.getNLS().getFormattedMessage("pmiHandlerFail00", objectArray, "Error occurred while attempting to invoke the PMI Handler: {0}");
            Tr.error(_tc, "pmiHandlerFail00", objectArray);
            throw new AxisFault(string, exception);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "invoke");
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

