/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.pmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.ws.websvcs.Constants;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.InOnlyAxisOperation;

class MessagePMIContext
implements Constants {
    private static final TraceComponent _tc = Tr.register(MessagePMIContext.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    public static final String propertyName = MessagePMIContext.class.getName();
    private final WebServicesPerf.ServicePerf pmiServiceModule;
    private final WebServicesPerf wsPerf;
    private long receivedRequestTime = 0L;
    private long sentRequestTime = 0L;
    private long receivedReplyTime = 0L;
    private long sentReplyTime = 0L;
    private long requestPayloadSize = 0L;
    private long responsePayloadSize = 0L;
    private final long STATE_RECEIVE_REQUEST = 0L;
    private final long STATE_SEND_REQUEST = 1L;
    private final long STATE_RECEIVE_REPLY = 2L;
    private final long STATE_SEND_REPLY = 3L;
    private final long STATE_DONE = 4L;
    private final long NO_TIME = -1L;
    private long next_state = 0L;

    MessagePMIContext(MessageContext messageContext, WebServicesPerf webServicesPerf, String string) {
        this.wsPerf = webServicesPerf;
        this.pmiServiceModule = this.wsPerf.getService(string);
    }

    void onServerReceiveRequest(MessageContext messageContext) {
        this.receivedRequestTime = this.doRequestResponseTime() || this.doResponseTime() ? System.currentTimeMillis() : 0L;
        if (this.doReceivedRequestCount()) {
            this.pmiServiceModule.onServerReceiveRequest();
        }
        this.requestPayloadSize = this.getRequestLength(messageContext);
        this.next_state = 1L;
    }

    void onServerForwardRequestToPort() {
        if (this.doRequestResponseTime() || this.doDispatchResponseTime()) {
            this.sentRequestTime = System.currentTimeMillis();
            if (this.doRequestResponseTime()) {
                this.pmiServiceModule.onServerForwardRequestToPort(this.sentRequestTime - this.receivedRequestTime);
            } else {
                this.pmiServiceModule.onServerForwardRequestToPort(-1L);
            }
        } else {
            this.sentRequestTime = 0L;
            this.pmiServiceModule.onServerForwardRequestToPort(-1L);
        }
        this.next_state = 2L;
    }

    void onServerReceiveReplyFromPort(MessageContext messageContext) {
        if (this.doDispatchResponseTime() || this.doReplyResponseTime()) {
            this.receivedReplyTime = System.currentTimeMillis();
            if (this.doDispatchResponseTime()) {
                this.pmiServiceModule.onServerReceiveReplyFromPort(this.receivedReplyTime - this.sentRequestTime);
            }
        } else {
            this.receivedReplyTime = 0L;
        }
        this.responsePayloadSize = this.getResponseLength(messageContext);
        this.next_state = 3L;
    }

    void onServerReturnReply(MessageContext messageContext) {
        this.sentReplyTime = this.doReplyResponseTime() || this.doResponseTime() ? System.currentTimeMillis() : 0L;
        this.pmiServiceModule.onServerReturnReply(this.doProcessedRequestCount(), this.requestPayloadSize, this.responsePayloadSize, this.receivedReplyTime > 0L ? this.sentReplyTime - this.receivedReplyTime : -1L, this.sentReplyTime > 0L ? this.sentReplyTime - this.receivedRequestTime : -1L);
        this.next_state = 4L;
    }

    void close(MessageContext messageContext) {
        this.sentReplyTime = this.doReplyResponseTime() || this.doResponseTime() ? System.currentTimeMillis() : 0L;
        if (this.next_state == 3L && messageContext != null && (this.isMepInOnly(messageContext.getAxisOperation().getMessageExchangePattern()) || messageContext.getAxisOperation() instanceof InOnlyAxisOperation)) {
            this.pmiServiceModule.onServerReturnReply(this.doProcessedRequestCount(), this.requestPayloadSize, -1L, -1L, this.sentReplyTime - this.receivedRequestTime);
        } else if (this.next_state != 4L) {
            this.pmiServiceModule.onServerReturnReply(false, this.requestPayloadSize, this.responsePayloadSize, this.receivedReplyTime > 0L ? this.sentReplyTime - this.receivedReplyTime : -1L, this.sentReplyTime - this.receivedRequestTime);
        }
        this.next_state = 4L;
    }

    private long getRequestLength(MessageContext messageContext) {
        long l;
        if (this.doPayloadSize() || this.doRequestPayloadSize()) {
            if (messageContext == null || messageContext.getEnvelope() == null) {
                l = -1L;
                Tr.error(_tc, "MsgContext or Envelope was null on request!");
            } else {
                l = messageContext.getEnvelope().toString().getBytes().length;
            }
        } else {
            l = 0L;
        }
        return l;
    }

    private long getResponseLength(MessageContext messageContext) {
        long l;
        if (this.doPayloadSize() || this.doReplyPayloadSize()) {
            if (messageContext == null || messageContext.getEnvelope() == null) {
                l = -1L;
                Tr.error(_tc, "MsgContext or Envelope was null on reply!");
            } else {
                l = messageContext.getEnvelope().toString().getBytes().length;
            }
        } else {
            l = 0L;
        }
        return l;
    }

    private boolean isMepInOnly(String string) {
        return string.equals("http://www.w3.org/2004/08/wsdl/robust-in-only") || string.equals("http://www.w3.org/2004/08/wsdl/in-only") || string.equals("http://www.w3.org/2004/08/wsdl/robust-in-only") || string.equals("http://www.w3.org/2004/08/wsdl/in-only");
    }

    public final boolean doResponseTime() {
        return this.pmiServiceModule.isStatisticEnabled(14);
    }

    public final boolean doRequestResponseTime() {
        return this.pmiServiceModule.isStatisticEnabled(15);
    }

    public final boolean doDispatchResponseTime() {
        return this.pmiServiceModule.isStatisticEnabled(16);
    }

    public final boolean doReplyResponseTime() {
        return this.pmiServiceModule.isStatisticEnabled(17);
    }

    public final boolean doPayloadSize() {
        return this.pmiServiceModule.isStatisticEnabled(18);
    }

    public final boolean doRequestPayloadSize() {
        return this.pmiServiceModule.isStatisticEnabled(19);
    }

    public final boolean doReplyPayloadSize() {
        return this.pmiServiceModule.isStatisticEnabled(20);
    }

    public final boolean doReceivedRequestCount() {
        return this.pmiServiceModule.isStatisticEnabled(11);
    }

    public final boolean doDispatchedRequestCount() {
        return this.pmiServiceModule.isStatisticEnabled(12);
    }

    public final boolean doProcessedRequestCount() {
        return this.pmiServiceModule.isStatisticEnabled(13);
    }
}

