/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.extension;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.servlet.ServletMapping;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.http.WASAxis2Servlet;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.webcontainer.extension.WebExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;

public class WASAxis2ExtensionProcessor
extends WebExtensionProcessor
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAxis2ExtensionProcessor.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private ConfigurationContext configContext = null;
    private Map urlServiceMap = null;

    public WASAxis2ExtensionProcessor(IServletContext iServletContext, ConfigurationContext configurationContext) throws Exception {
        super(iServletContext);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2ExtensionProcessor ctor");
        }
        this.configContext = configurationContext;
        this.urlServiceMap = new HashMap();
        this.createServletConfigs();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WASAxis2ExtensionProcessor ctor");
        }
    }

    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
    }

    private void createServletConfigs() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createServletConfigs, module=" + this.extensionContext.getWebAppConfig().getModuleName());
        }
        try {
            AxisConfiguration axisConfiguration = this.configContext.getAxisConfiguration();
            Iterator iterator = axisConfiguration.getServiceGroups();
            while (iterator.hasNext()) {
                AxisServiceGroup axisServiceGroup = (AxisServiceGroup)iterator.next();
                Iterator iterator2 = axisServiceGroup.getServices();
                while (iterator2.hasNext()) {
                    Object object;
                    AxisService axisService = (AxisService)iterator2.next();
                    String string = Axis2Utils.getServiceImplClass(axisService);
                    if (string == null) {
                        Object[] objectArray = new Object[]{axisService.getName()};
                        object = NLSProvider.getNLS().getFormattedMessage("axisSvcNotContainImpl00", objectArray, "''AxisService'' {0} does not contain an implementation class name.");
                        throw new DeploymentException((String)object);
                    }
                    boolean bl = false;
                    object = this.locateServlet(string);
                    if (object == null) {
                        bl = true;
                        object = this.createServlet(string, WASAxis2Servlet.class.getName());
                    } else {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Found an existing servlet with name=" + object.getServletName());
                            Tr.debug(_tc, "Implementation class=" + object.getClassName());
                        }
                        object.setClassName(WASAxis2Servlet.class.getName());
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Set implementation class to: " + object.getClassName());
                        }
                    }
                    this.checkServletMappings((IServletConfig)object, axisService, bl);
                }
            }
            this.configContext.setProperty("com.ibm.ws.websvcs.URL_SERVICES_MAPPINGS", this.urlServiceMap);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "URL to Services Map: " + this.urlServiceMap);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.extension.WASAxis2ExtensionProcessor.createServletConfigs", "157", this);
            Object[] objectArray = new Object[]{exception};
            Tr.error(_tc, "processWebModFail00", objectArray);
            throw exception;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createServletConfigs");
        }
    }

    private IServletConfig locateServlet(String string) throws Exception {
        WebAppConfig webAppConfig = this.extensionContext.getWebAppConfig();
        Iterator iterator = webAppConfig.getServletInfos();
        while (iterator.hasNext()) {
            IServletConfig iServletConfig = (IServletConfig)iterator.next();
            String string2 = iServletConfig.getServletName();
            if (!string2.equals(string)) continue;
            return iServletConfig;
        }
        return null;
    }

    private IServletConfig createServlet(String string, String string2) throws Exception {
        IServletConfig iServletConfig = this.createConfig(string);
        iServletConfig.setServletName(string);
        iServletConfig.setClassName(string2);
        iServletConfig.setDisplayName("Web services servlet");
        iServletConfig.setServletContext(this.extensionContext);
        iServletConfig.setStartUpWeight(new Integer(1));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Created new servlet, name=" + iServletConfig.getServletName() + ", class=" + iServletConfig.getClassName());
        }
        return iServletConfig;
    }

    private void checkServletMappings(IServletConfig iServletConfig, AxisService axisService, boolean bl) throws Exception {
        List list;
        Object[] objectArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "checkServletMappings, servlet=" + iServletConfig.getServletName() + ", service=" + axisService.getName());
        }
        IServletWrapper iServletWrapper = null;
        WebAppConfig webAppConfig = this.extensionContext.getWebAppConfig();
        if (bl) {
            iServletWrapper = this.extensionContext.createServletWrapper(iServletConfig);
        }
        String string = null;
        List list2 = iServletConfig.getMappings();
        if (list2 != null && list2.size() > 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Servlet [" + iServletConfig.getServletName() + "] has " + Integer.toString(list2.size()) + " mappings.");
            }
            if (list2.size() > 1) {
                Object[] objectArray2 = new Object[]{iServletConfig.getServletName()};
                String string2 = NLSProvider.getNLS().getFormattedMessage("servletMapNum00", objectArray2, "Servlet {0} contains more than one servlet mapping, which is a violation of JSR 109.");
                throw new ServletException(string2);
            }
            if (list2.size() == 1) {
                objectArray = (Object[])list2.get(0);
                string = objectArray.getUrlPattern();
                if (string.equals("/*") || string.equals("*")) {
                    Object[] objectArray3 = new Object[]{iServletConfig.getServletName()};
                    String string3 = NLSProvider.getNLS().getFormattedMessage("illegalUrlPattern00", objectArray3, "Servlet {0} cannot specify \"*\" as a URL pattern.");
                    throw new ServletException(string3);
                }
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
                Axis2Utils.setURLPattern(axisService, string);
                this.addMapping(iServletConfig, webAppConfig, iServletWrapper, "*.xsd");
                this.addMapping(iServletConfig, webAppConfig, iServletWrapper, "*.wsdl");
                this.addMapping(iServletConfig, webAppConfig, iServletWrapper, string + "/wsdl" + "/*");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Servlet [" + iServletConfig.getServletName() + "] already has a servlet mapping.");
                    Tr.debug(_tc, "Set URL pattern [" + string + "] on AxisService [" + axisService.getName() + "].");
                }
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Servlet [" + iServletConfig.getServletName() + "] contains no servlet mappings.");
            }
            if ((string = Axis2Utils.getURLPattern(axisService)) == null) {
                Object[] objectArray4 = new Object[]{axisService.getName(), "com.ibm.ws.websvcs.AxisServiceUrlPattern"};
                String string4 = NLSProvider.getNLS().getFormattedMessage("axisSvcNotHaveParam00", objectArray4, "Internal Error: ''AxisService'' {0} does not contain parameter {1}.");
                throw new DeploymentException(string4);
            }
            this.addMapping(iServletConfig, webAppConfig, iServletWrapper, string);
            this.addMapping(iServletConfig, webAppConfig, iServletWrapper, string + "/wsdl" + "/*");
            this.addMapping(iServletConfig, webAppConfig, iServletWrapper, "*.xsd");
            this.addMapping(iServletConfig, webAppConfig, iServletWrapper, "*.wsdl");
        }
        if (string != null) {
            this.urlServiceMap.put(string, axisService);
        }
        objectArray = new Object[]{string, iServletConfig.getServletName(), this.extensionContext.getWebAppConfig().getModuleName()};
        Tr.info(_tc, "urlPattern00", objectArray);
        if (_tc.isDebugEnabled() && (list = iServletConfig.getMappings()) != null) {
            Tr.debug(_tc, "Servlet [" + iServletConfig.getServletName() + "] has the following mappings:");
            for (int i = 0; i < list.size(); ++i) {
                ServletMapping servletMapping = (ServletMapping)list.get(i);
                Tr.debug(_tc, "[" + Integer.toString(i) + "]: " + servletMapping.toString());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "checkServletMappings");
        }
    }

    private void addMapping(IServletConfig iServletConfig, WebAppConfig webAppConfig, IServletWrapper iServletWrapper, String string) throws Exception {
        if (iServletWrapper != null) {
            this.extensionContext.addMappingTarget(string, iServletWrapper);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Added mapping target [" + string + "] for servletWrapper of servlet [" + iServletConfig.getServletName() + "].");
            }
        }
        if (webAppConfig.getServletInfo(iServletConfig.getServletName()) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Added mapping [" + string + "] for user-defined servlet [" + iServletConfig.getServletName() + "].");
            }
            webAppConfig.addServletMapping(iServletConfig.getServletName(), string);
        } else {
            iServletConfig.addMapping(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Added mapping [" + string + "] for servlet [" + iServletConfig.getServletName() + "].");
            }
        }
    }
}

