/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.dispatcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;

public class URLPatternBasedDispatcher
extends AbstractDispatcher
implements Constants {
    private static final TraceComponent _tc = Tr.register(URLPatternBasedDispatcher.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static String sessUrlRewritePrefix = ";jsessionid=";
    private static final String SESSION_ID_NAME = "SessionRewriteIdentifier";
    private final String dispatcherName = "URLPatternBasedDispatcher";
    private String className = this.getClass().getName();

    public static String stripThruContextRoot(String string, String string2) {
        String string3;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "urlPattern: " + string);
        }
        int n = string.indexOf(":");
        if ((n = string.indexOf(":", n + 1)) >= 0 && (string3 = string.substring(n + 1)).indexOf(string2) >= 0) {
            string = string3;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Updated urlPattern (skipped the host name): " + string);
            }
        }
        return string;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        if (messageContext.getAxisService() != null) {
            return messageContext.getAxisService();
        }
        EndpointReference endpointReference = messageContext.getTo();
        String string = (String)messageContext.getProperty("com.ibm.ws.websvcs.MsgContext_ContextRoot");
        if (endpointReference != null && string != null) {
            String string2 = null;
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Request URL is: " + endpointReference.getAddress());
                }
                string2 = endpointReference.getAddress();
                int n = (string2 = URLPatternBasedDispatcher.stripThruContextRoot(string2, string)).indexOf(string);
                if (n >= 0) {
                    string2 = string2.substring(n + string.length());
                }
                string2 = this.checkForSessionId(string2);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for AxisService with URL pattern: " + string2);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, this.className + ".findService", "93", this);
                return null;
            }
            AxisService axisService = null;
            Map map = (Map)messageContext.getConfigurationContext().getProperty("com.ibm.ws.websvcs.URL_SERVICES_MAPPINGS");
            if (map != null && (axisService = (AxisService)map.get(string2)) != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found AxisService (cache): " + axisService.getName());
                }
                return axisService;
            }
            AxisConfiguration axisConfiguration = messageContext.getConfigurationContext().getAxisConfiguration();
            Iterator iterator = axisConfiguration.getServiceGroups();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    AxisServiceGroup axisServiceGroup = (AxisServiceGroup)iterator.next();
                    Iterator iterator2 = axisServiceGroup.getServices();
                    if (iterator2 == null) continue;
                    while (iterator2.hasNext()) {
                        axisService = (AxisService)iterator2.next();
                        String string3 = Axis2Utils.getURLPattern(axisService);
                        if (string3 == null || !string3.equals(string2) && !string3.equals("/*")) continue;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Found AxisService: " + axisService.getName());
                        }
                        return axisService;
                    }
                }
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "URLPatternBasedDispatcher didn't find matching AxisService...");
            }
        }
        return null;
    }

    public AxisOperation findOperation(AxisService axisService, MessageContext messageContext) throws AxisFault {
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription("URLPatternBasedDispatcher"));
    }

    public String checkForSessionId(String string) {
        int n = string.indexOf(sessUrlRewritePrefix);
        if (n > 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found session identifier: " + sessUrlRewritePrefix);
            }
            string = string.substring(0, n);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Returning url pattern after removing session info: " + string);
        }
        return string;
    }

    static {
        if (WebContainer.getWebContainerProperties().get(SESSION_ID_NAME) != null) {
            sessUrlRewritePrefix = ";" + WebContainer.getWebContainerProperties().get(SESSION_ID_NAME) + "=";
        }
    }
}

