/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ClassDataObjectFields;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.collector.WASAnnotationCollector;
import com.ibm.ws.websvcs.annotations.generator.WASAnnotationInputBuilder;
import com.ibm.ws.websvcs.deploy.CacheRootDirectoryTLS;
import com.ibm.ws.websvcs.deployment.ArchiveFileLocator;
import com.ibm.ws.websvcs.deployment.CachedFileLocator;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.FileExplorerFactory;
import com.ibm.ws.websvcs.deployment.WASAxis2DescriptionBuilder;
import com.ibm.ws.websvcs.desc.JAXWSEndpointDescriptorImpl;
import com.ibm.ws.websvcs.desc.JAXWSServiceDescriptorImpl;
import com.ibm.ws.websvcs.desc.MDQServiceDescriptorImpl;
import com.ibm.ws.websvcs.desc.WSClientServiceDescriptorDBC;
import com.ibm.ws.websvcs.desc.WSClientServiceDescriptorImpl;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.utils.WSAnnotatedClassCacheBean;
import com.ibm.ws.websvcs.utils.WSClassDataObjectFilter;
import com.ibm.ws.websvcs.utils.WebServicesModuleCache;
import com.ibm.ws.websvcs.utils.WebServicesModuleCacheMgr;
import com.ibm.ws.websvcs.wsdl.ModuleWSDLLocator;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Service;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionWSDL;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.WebServiceClientAnnot;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSModuleDescriptorImpl
implements WSModuleDescriptor,
Constants {
    private ModuleFile moduleFile;
    private boolean servicesBuilt;
    private boolean serviceRefsBuilt;
    private ArrayList serviceDescList;
    private ArrayList serviceRefList;
    private ArrayList serverModuleFiles;
    private ArrayList clientModuleFiles;
    private List<ClassDataObject> warCDOs;
    private List<ClassDataObject> ejbCDOs;
    private ClassLoader classLoader;
    private boolean cdosInitialized;
    private boolean ejbsInitialized;
    private WebServicesModuleCache cache;
    private Map<String, ArchiveFileLocator> archiveFileLocatorMap;
    private HashMap<String, DescriptionBuilderComposite> dbcMap;
    private boolean dbcMapInitialized;
    private boolean isSystemAppModule = false;
    private FileExplorer fileExplorer;
    private static final TraceComponent _tc = Tr.register(WSModuleDescriptorImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    WSModuleDescriptorImpl(ModuleFile moduleFile) {
        this.moduleFile = moduleFile;
        this.servicesBuilt = false;
        this.serviceRefsBuilt = false;
        this.serviceDescList = new ArrayList();
        this.serviceRefList = new ArrayList();
        this.cdosInitialized = false;
        this.ejbsInitialized = false;
        this.dbcMapInitialized = false;
        this.initializeClassLoader();
        this.initCache();
        this.warCDOs = null;
        this.ejbCDOs = null;
        if (moduleFile.getEARFile() != null && (moduleFile.getEARFile().containsFile("META-INF/ibm-application-sa.props") || moduleFile.getEARFile().containsFile("META-INF/ibm-application-sa2.props"))) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "WSModuleDescriptorImpl instance created for system application module: " + moduleFile.getName() + " : " + moduleFile.getEARFile().getName());
            }
            this.isSystemAppModule = true;
        }
    }

    @Override
    public boolean containsJAXRPCWebServices() {
        return false;
    }

    @Override
    public boolean containsJAXWSWebServices() {
        if (this.isSystemAppModule) {
            return false;
        }
        if (this.cache.exists() && this.cache.getAnnotatedClassList().size() > 0) {
            return true;
        }
        if (this.getWARCDOs() != null && !this.getWARCDOs().isEmpty()) {
            return true;
        }
        return this.getEJBCDOs() != null && !this.getEJBCDOs().isEmpty();
    }

    @Override
    public boolean containsWebServices() {
        if (this.isSystemAppModule) {
            return false;
        }
        if (this.containsJAXWSWebServices()) {
            return true;
        }
        return this.containsJAXRPCWebServices();
    }

    @Override
    public String getModuleName() {
        return this.moduleFile.getName();
    }

    @Override
    public Iterator getServices() {
        if (!this.isSystemAppModule && !this.servicesBuilt) {
            this.buildServices();
        }
        return this.serviceDescList.iterator();
    }

    @Override
    public Iterator getServiceRefs() {
        if (!this.isSystemAppModule && !this.serviceRefsBuilt) {
            this.buildServiceRefs();
        }
        return this.serviceRefList.iterator();
    }

    @Override
    public boolean isEJBJar() {
        return this.moduleFile.isEJBJarFile();
    }

    @Override
    public boolean isWARFile() {
        return this.moduleFile.isWARFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildServices() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildServices");
        }
        if (this.containsJAXWSWebServices()) {
            try {
                WASAxis2DescriptionBuilder wASAxis2DescriptionBuilder;
                AxisServiceGroup axisServiceGroup;
                Object object;
                if (this.moduleFile.containsFile("WEB-INF/ibmservices.xml")) {
                    object = new Object[]{this.moduleFile.getName()};
                    Tr.error(_tc, "ibmSvcsFile00", object);
                }
                this.initDBCMap();
                if (this.dbcMap != null && !this.dbcMap.isEmpty() && (axisServiceGroup = (wASAxis2DescriptionBuilder = new WASAxis2DescriptionBuilder(this.classLoader)).buildAxisServiceGroup((List<ServiceDescription>)(object = DescriptionFactory.createServiceDescriptionFromDBCMap(this.dbcMap)))) != null) {
                    this.updateEndpointURLS(axisServiceGroup);
                    this.buildServiceList(axisServiceGroup, (List<ServiceDescription>)object);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl.buildServices", "159", this);
                Object[] objectArray = new Object[]{throwable};
                Tr.error(_tc, "buildSvcDescFail00", objectArray);
            }
            finally {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting web services temp cache directory to null on thread local storage");
                }
                CacheRootDirectoryTLS.set(null);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildServices");
        }
        this.servicesBuilt = true;
    }

    private List<ClassDataObject> getWARCDOs() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getWARCDOs");
        }
        if (!this.cdosInitialized) {
            this.warCDOs = this.getClassDataObjects(this.warCDOs);
            this.cdosInitialized = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getWARCDOs");
        }
        return this.warCDOs;
    }

    private List<ClassDataObject> getClassDataObjects(List<ClassDataObject> list) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getClassDataObjects");
        }
        WASAnnotationCollector wASAnnotationCollector = new WASAnnotationCollector();
        wASAnnotationCollector.setClassLoader(this.classLoader);
        list = new ArrayList<ClassDataObject>();
        if (this.cache.exists()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Loading JAXWS metadata from cache");
            }
            try {
                List<FileLocator> list2 = this.buildLocators(this.cache.getAnnotatedClassList());
                list = wASAnnotationCollector.collectCachedList(list2);
            }
            catch (Exception exception) {
                List<FileLocator> list3 = this.getLocatorsFromModule();
                if (list3 != null && !list3.isEmpty()) {
                    list = wASAnnotationCollector.collect(list3);
                }
            }
        } else {
            List<FileLocator> list4 = this.getLocatorsFromModule();
            if (list4 != null && !list4.isEmpty()) {
                list = wASAnnotationCollector.collect(list4);
            }
        }
        if (this.fileExplorer != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Performing cleanup on FileExplorer instance");
            }
            this.fileExplorer.cleanUp();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getClassDataObjects");
        }
        return list;
    }

    private List<FileLocator> getLocatorsFromModule() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getLocatorsFromModule");
        }
        this.fileExplorer = FileExplorerFactory.getFileExplorer(this.moduleFile);
        List<FileLocator> list = null;
        if (this.fileExplorer != null) {
            list = this.fileExplorer.explore();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getLocatorsFromModule");
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEndpointURLS(AxisServiceGroup axisServiceGroup) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateEndpointURLS");
        }
        if (this.moduleFile.containsFile("WEB-INF/web.xml")) {
            try {
                XMLStreamReader xMLStreamReader;
                StAXOMBuilder stAXOMBuilder;
                InputStream inputStream = this.classLoader.getResourceAsStream("WEB-INF/web.xml");
                if (inputStream != null && (stAXOMBuilder = new StAXOMBuilder(xMLStreamReader = StAXUtils.createNetworkDetachedXMLStreamReader(inputStream))) != null) {
                    OMElement oMElement = stAXOMBuilder.getDocumentElement();
                    Iterator iterator = axisServiceGroup.getServices();
                    while (iterator.hasNext()) {
                        AxisService axisService = (AxisService)iterator.next();
                        this.checkForUserMapping(axisService, oMElement);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl.updateEndpointURLS", "243", this);
                Object[] objectArray = new Object[]{exception};
                Tr.error(_tc, "buildOMStrucFail00", objectArray);
            }
            finally {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "updateEndpointURLS");
                }
            }
        }
    }

    private void checkForUserMapping(AxisService axisService, OMElement oMElement) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "checkForUserMapping");
        }
        Iterator iterator = oMElement.getChildrenWithName(new QName("servlet-mapping"));
        while (iterator.hasNext()) {
            OMElement oMElement2;
            OMElement oMElement3 = (OMElement)iterator.next();
            OMElement oMElement4 = oMElement3.getFirstChildWithName(new QName("servlet-name"));
            if (oMElement4 == null) continue;
            String string = oMElement4.getText();
            String string2 = Axis2Utils.getServiceImplClass(axisService);
            if (string2 == null || string == null) continue;
            string = string.trim();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Checking for custom user mapping for implementation class: " + string2 + " in servlet: " + string);
            }
            if (!string.equals(string2)) continue;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found matching servlet and implementation class name: " + string);
            }
            if ((oMElement2 = oMElement3.getFirstChildWithName(new QName("url-pattern"))) == null) continue;
            String string3 = oMElement2.getText();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "For implementation class: " + string2 + " in servlet: " + string + " found URL pattern: " + string3);
            }
            if (string3 == null || string3.equals("")) continue;
            try {
                Axis2Utils.setURLPattern(axisService, string3);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl.checkForUserMapping", "276", this);
                Object[] objectArray = new Object[]{exception};
                Tr.error(_tc, "setAxisSvcEndptFail00", objectArray);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "checkForUserMapping");
        }
    }

    private void buildServiceRefs() {
        List<ClassDataObject> list;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildServiceRefs");
        }
        if ((list = (list = this.getWARCDOs()) == null || list.isEmpty() ? this.getEJBCDOs() : WSClassDataObjectFilter.filterCDOList(list, ClassDataObjectFields.WEBSERVICECLIENT)) != null && !list.isEmpty()) {
            for (ClassDataObject classDataObject : list) {
                Object object;
                WebServiceClientAnnot webServiceClientAnnot = (WebServiceClientAnnot)classDataObject.getEntry(ClassDataObjectFields.WEBSERVICECLIENT);
                String string = (String)classDataObject.getEntry(ClassDataObjectFields.CLASS_NAME);
                String string2 = webServiceClientAnnot.wsdlLocation();
                String string3 = webServiceClientAnnot.targetNamespace();
                String string4 = webServiceClientAnnot.name();
                try {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object object2;
                    if (string2 != null && !string2.equals("")) {
                        Object object3;
                        object2 = WSDLFactory.newInstance();
                        object = ((WSDLFactory)object2).newWSDLReader();
                        object.setFeature("javax.wsdl.verbose", false);
                        string2 = this.checkForRedirect(string2, string);
                        objectArray2 = this.getWsdlLocator(string2);
                        if (objectArray2 != null) {
                            Object[] objectArray3;
                            objectArray = object.readWSDL((WSDLLocator)objectArray2);
                            object3 = objectArray.getService(new QName(string3, string4));
                            if (object3 != null) {
                                objectArray3 = new WSClientServiceDescriptorImpl((Service)object3);
                                Tr.debug(_tc, "@WebServiceClient annotation processed: " + objectArray3.getQName().getLocalPart());
                                this.serviceRefList.add(objectArray3);
                                continue;
                            }
                            objectArray3 = new Object[]{string, string4, string2};
                            Tr.error(_tc, "srvcNameNotFoundWsdl00", objectArray3);
                            continue;
                        }
                        objectArray = new Object[]{string2, string};
                        object3 = NLSProvider.getNLS().getFormattedMessage("createServiceClientError01", objectArray, "The WSDL {0} referenced by the @WebServiceClient annotation in the class {1} could not be loaded.");
                        Tr.warning(_tc, (String)object3);
                        continue;
                    }
                    this.initDBCMap();
                    if (this.dbcMap == null || this.dbcMap.isEmpty()) continue;
                    object2 = string.replaceAll("/", ".");
                    object = this.dbcMap.get(object2);
                    if (object != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "@WebServiceClient annotation with no no WSDL processed: " + string);
                        }
                        this.serviceRefList.add(new WSClientServiceDescriptorDBC((DescriptionBuilderComposite)object, this.dbcMap));
                        continue;
                    }
                    objectArray2 = new Object[]{string};
                    objectArray = NLSProvider.getNLS().getFormattedMessage("createServiceClientError00", objectArray2, "The Web service client {0} could not be processed.");
                    Tr.warning(_tc, (String)objectArray);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl.buildServiceRefs", "350", this);
                    object = new Object[]{string, throwable};
                    Tr.error(_tc, "useWSCAnnoDataFail00", object);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildServiceRefs");
        }
        this.serviceRefsBuilt = true;
    }

    private void buildServiceList(AxisServiceGroup axisServiceGroup, List<ServiceDescription> list) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildServiceList");
        }
        HashMap<QName, JAXWSServiceDescriptorImpl> hashMap = new HashMap<QName, JAXWSServiceDescriptorImpl>();
        HashMap<QName, Object> hashMap2 = new HashMap<QName, Object>();
        for (ServiceDescription serviceDescription : list) {
            for (EndpointDescription endpointDescription : serviceDescription.getEndpointDescriptions_AsCollection()) {
                Object object;
                AxisService axisService = endpointDescription.getAxisService();
                if (axisService == null) continue;
                if (Axis2Utils.getWSDLDefinition(axisService) != null && this.wsdlIsFullySpecified(endpointDescription)) {
                    object = new JAXWSEndpointDescriptorImpl(Axis2Utils.getWSDLPort(axisService), axisService, null);
                    QName qName = ((JAXWSEndpointDescriptorImpl)object).getServiceQName();
                    JAXWSServiceDescriptorImpl jAXWSServiceDescriptorImpl = (JAXWSServiceDescriptorImpl)hashMap.get(qName);
                    if (jAXWSServiceDescriptorImpl != null) {
                        ((JAXWSEndpointDescriptorImpl)object).setParent(jAXWSServiceDescriptorImpl);
                        jAXWSServiceDescriptorImpl.addEndpoint((WSEndpointDescriptor)object);
                    } else {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Building JAXWSServiceDescriptorImpl for service: " + Axis2Utils.getServiceQName(axisService));
                        }
                        jAXWSServiceDescriptorImpl = new JAXWSServiceDescriptorImpl(axisService, Axis2Utils.getWSDLService(axisService), this);
                        ((JAXWSEndpointDescriptorImpl)object).setParent(jAXWSServiceDescriptorImpl);
                        jAXWSServiceDescriptorImpl.addEndpoint((WSEndpointDescriptor)object);
                        hashMap.put(qName, jAXWSServiceDescriptorImpl);
                    }
                    this.serviceDescList.add(jAXWSServiceDescriptorImpl);
                    continue;
                }
                if (hashMap2.get(serviceDescription.getServiceQName()) == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Building MDQServiceDescriptorImpl from ServiceDescription hierarchy for service: " + serviceDescription.getServiceQName());
                    }
                    object = new MDQServiceDescriptorImpl(this, serviceDescription);
                    hashMap2.put(serviceDescription.getServiceQName(), object);
                    this.serviceDescList.add(object);
                    continue;
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Already built WSServiceDescriptor list from ServiceDescription hierarchy for service: " + serviceDescription.getServiceQName());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildServiceList");
        }
    }

    private ModuleWSDLLocator getWsdlLocator(String string) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getWsdlLocator");
        }
        if (string != null) {
            InputStream inputStream = null;
            LoadStrategy loadStrategy = this.moduleFile.getLoadStrategy();
            if (Axis2Utils.isAbsolutePath(string)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for @WebServiceClient absolute WSDL location " + string);
                }
                try {
                    inputStream = loadStrategy.getResourceInputStream(string);
                    if (inputStream == null) {
                        throw new Exception();
                    }
                }
                catch (Throwable throwable) {
                    try {
                        URL uRL = new URL(string);
                        inputStream = uRL.openStream();
                        if (inputStream == null) {
                            throw new Exception();
                        }
                    }
                    catch (Throwable throwable2) {
                        try {
                            URL uRL;
                            File file = new File(string);
                            if (file != null && (uRL = file.toURL()) != null) {
                                inputStream = uRL.openStream();
                            }
                        }
                        catch (Throwable throwable3) {}
                    }
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for @WebServiceClient relative WSDL location " + string);
                }
                try {
                    inputStream = this.classLoader.getResourceAsStream(string);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                ModuleWSDLLocator moduleWSDLLocator = new ModuleWSDLLocator(string, inputStream, loadStrategy);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getWsdlLocator");
                }
                return moduleWSDLLocator;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getWsdlLocator");
        }
        return null;
    }

    private void initializeClassLoader() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "intializeClassLoader");
        }
        if ((this.moduleFile.isWARFile() || this.moduleFile.isEJBJarFile()) && this.moduleFile.getArchiveClassLoader() != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Module archive classloader already initialized: " + this.moduleFile.getName());
            }
            this.classLoader = this.moduleFile.getArchiveClassLoader();
        } else if ((this.moduleFile.isWARFile() || this.moduleFile.isEJBJarFile()) && this.moduleFile.getArchiveClassLoader() == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Initializing module archive classloader");
            }
            try {
                this.moduleFile.getOptions().setUseJavaReflection(true);
                this.classLoader = this.moduleFile.getArchiveClassLoader();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl.initializeClassLoader", "578", this);
                Tr.warning(_tc, "An error was encountered retrieving the classloader for the module " + this.moduleFile.getName() + ". This may cause unpredictable " + "results");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "intializeClassLoader");
        }
    }

    private String checkForRedirect(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "checkForRedirect");
        }
        if (string.endsWith("?wsdl") || string.endsWith("/wsdl")) {
            try {
                URL uRL;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Attempting to redirect client WSDL location " + string);
                }
                if ((uRL = new URL(string)) != null) {
                    InputStream inputStream;
                    URLConnection uRLConnection = uRL.openConnection();
                    if (uRLConnection != null && (inputStream = uRLConnection.getInputStream()) != null) {
                        inputStream.close();
                        uRL = uRLConnection.getURL();
                        string = uRL.toString();
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Redirected client WSDL location to " + string);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl.checkForRedirect", "617", this);
                Tr.warning(_tc, "The WSDL document " + string + " specified by the " + "@WebServiceClient annotation in the class " + string2 + " could " + "not be located.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "checkForRedirect");
        }
        return string;
    }

    private void initCache() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initCache");
        }
        String string = Axis2Utils.getApplicationName(this.moduleFile);
        String string2 = this.moduleFile.getName();
        String string3 = string + File.separator + string2 + File.separator;
        this.cache = WebServicesModuleCacheMgr.getModuleCache(string3);
        this.cache.load();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initCache");
        }
    }

    private List<FileLocator> buildLocators(List<WSAnnotatedClassCacheBean> list) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildLocators");
        }
        ArrayList<FileLocator> arrayList = new ArrayList<FileLocator>();
        for (WSAnnotatedClassCacheBean wSAnnotatedClassCacheBean : list) {
            String string = wSAnnotatedClassCacheBean.getClassName();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Constructed FileLocator from cache: " + string);
            }
            try {
                URL uRL = this.classLoader.getResource(string);
                if (uRL == null) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found URL for: " + string);
                }
                CachedFileLocator cachedFileLocator = new CachedFileLocator(uRL, string);
                arrayList.add(cachedFileLocator);
            }
            catch (Exception exception) {
                Tr.warning(_tc, "The following problem occurred when trying to load application metadata from cache: " + exception.toString() + ". The application metadata " + "will now be loaded from the web module.");
                throw exception;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildLocators");
        }
        return arrayList;
    }

    private void initDBCMap() throws Exception {
        if (!this.dbcMapInitialized) {
            if (this.getWARCDOs() != null && this.getWARCDOs().size() > 0) {
                WASAnnotationInputBuilder wASAnnotationInputBuilder = new WASAnnotationInputBuilder(this.warCDOs, this.classLoader, this.moduleFile);
                this.dbcMap = wASAnnotationInputBuilder.buildInputs();
            } else if (this.getEJBCDOs() != null && this.getEJBCDOs().size() > 0) {
                WASAnnotationInputBuilder wASAnnotationInputBuilder = new WASAnnotationInputBuilder(this.ejbCDOs, this.classLoader, this.moduleFile);
                this.dbcMap = wASAnnotationInputBuilder.buildInputs();
            }
        }
        this.dbcMapInitialized = true;
    }

    private List<ClassDataObject> getEJBCDOs() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getEJBCDOs");
        }
        if (!this.ejbsInitialized) {
            if (this.moduleFile.isEJBJarFile()) {
                this.ejbCDOs = this.getClassDataObjects(this.ejbCDOs);
                ClassDataObjectFields[] classDataObjectFieldsArray = new ClassDataObjectFields[]{ClassDataObjectFields.WEBSERVICECLIENT, ClassDataObjectFields.WEBSERVICE};
                this.ejbCDOs = WSClassDataObjectFilter.filterCDOList(this.ejbCDOs, classDataObjectFieldsArray);
            }
            this.ejbsInitialized = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEJBCDOs");
        }
        return this.ejbCDOs;
    }

    private boolean wsdlIsFullySpecified(EndpointDescription endpointDescription) {
        if (endpointDescription instanceof EndpointDescriptionWSDL) {
            return ((EndpointDescriptionWSDL)((Object)endpointDescription)).isWSDLFullySpecified();
        }
        return true;
    }
}

