/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ws.websvcs.desc.WSClientEndpointDescriptorDBC;
import com.ibm.wsspi.websvcs.desc.WSClientEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientServiceDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSClientServiceDescriptorDBC
implements WSClientServiceDescriptor {
    private List<WSClientEndpointDescriptor> endpointList;
    private DescriptionBuilderComposite dbc;
    private QName serviceQName;
    private Map<String, DescriptionBuilderComposite> dbcMap;
    private boolean qNameSet;

    WSClientServiceDescriptorDBC(DescriptionBuilderComposite descriptionBuilderComposite, Map<String, DescriptionBuilderComposite> map) {
        this.dbc = descriptionBuilderComposite;
        this.qNameSet = false;
        this.dbcMap = map;
        this.setQName(descriptionBuilderComposite.getWebServiceClientAnnot().name(), descriptionBuilderComposite.getWebServiceClientAnnot().targetNamespace());
    }

    @Override
    public Iterator getEndpoints() {
        if (this.endpointList == null) {
            this.buildEndpoints();
        }
        return this.endpointList.iterator();
    }

    @Override
    public QName getQName() {
        if (!this.qNameSet) {
            this.buildEndpoints();
        }
        return this.serviceQName;
    }

    private void setQName(String string, String string2) {
        if (string != null && string2 != null) {
            this.serviceQName = new QName(string2, string);
            this.qNameSet = true;
        }
    }

    private void buildEndpoints() {
        List<MethodDescriptionComposite> list = this.dbc.getMethodDescriptionsList();
        this.endpointList = new ArrayList<WSClientEndpointDescriptor>();
        if (list != null) {
            for (MethodDescriptionComposite methodDescriptionComposite : list) {
                String string = methodDescriptionComposite.getReturnType();
                DescriptionBuilderComposite descriptionBuilderComposite = this.dbcMap.get(string);
                if (descriptionBuilderComposite == null || descriptionBuilderComposite.getWebServiceAnnot() == null || !descriptionBuilderComposite.isInterface()) continue;
                String string2 = methodDescriptionComposite.getWebEndpointAnnot() != null ? methodDescriptionComposite.getWebEndpointAnnot().name() : null;
                WSClientEndpointDescriptorDBC wSClientEndpointDescriptorDBC = new WSClientEndpointDescriptorDBC(descriptionBuilderComposite, string2);
                this.endpointList.add(wSClientEndpointDescriptorDBC);
                if (this.qNameSet) continue;
                this.setQName(descriptionBuilderComposite.getWebServiceAnnot().serviceName(), descriptionBuilderComposite.getWebServiceAnnot().targetNamespace());
            }
        }
    }
}

