/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.desc.MDQEndpointDescriptorImpl;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;

public class MDQServiceDescriptorImpl
implements WSServiceDescriptor {
    private WSModuleDescriptor parent;
    private ServiceDescription serviceDescription;
    private List<WSEndpointDescriptor> endpointDescriptors;
    private boolean endpointsBuilt;
    private static final TraceComponent _tc = Tr.register(MDQServiceDescriptorImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public MDQServiceDescriptorImpl(WSModuleDescriptor wSModuleDescriptor, ServiceDescription serviceDescription) {
        this.parent = wSModuleDescriptor;
        this.serviceDescription = serviceDescription;
        this.endpointsBuilt = false;
        this.endpointDescriptors = new ArrayList<WSEndpointDescriptor>();
    }

    public boolean deployedWithWSDL() {
        if (this.serviceDescription instanceof ServiceDescriptionWSDL) {
            ServiceDescriptionWSDL serviceDescriptionWSDL = (ServiceDescriptionWSDL)((Object)this.serviceDescription);
            return serviceDescriptionWSDL.getWSDLDefinition() != null;
        }
        return false;
    }

    public Iterator getEndpoints() {
        if (!this.endpointsBuilt) {
            this.buildEndpoints();
            this.endpointsBuilt = true;
        }
        return this.endpointDescriptors.iterator();
    }

    public String getName() {
        return this.serviceDescription.getServiceQName() != null ? this.serviceDescription.getServiceQName().getLocalPart() : null;
    }

    public WSModuleDescriptor getParent() {
        return this.parent;
    }

    public QName getQName() {
        return this.serviceDescription.getServiceQName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getWSDLDefinition() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getWSDLDefinition");
        }
        try {
            if (this.serviceDescription instanceof ServiceDescriptionWSDL) {
                ServiceDescriptionWSDL serviceDescriptionWSDL = (ServiceDescriptionWSDL)((Object)this.serviceDescription);
                if (serviceDescriptionWSDL.getWSDLDefinition() != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getWSDLDefinition returning definition");
                    }
                    Definition definition = serviceDescriptionWSDL.getWSDLDefinition();
                    return definition;
                }
                if (serviceDescriptionWSDL.getGeneratedWsdlWrapper() != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getWSDLDefinition returning generated definition");
                    }
                    Definition definition = serviceDescriptionWSDL.getGeneratedWsdlWrapper().getDefinition();
                    return definition;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getWSDLDefinition returning null");
                }
                Definition definition = null;
                return definition;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getWSDLDefinition not instance of ServiceDescriptionWSDL");
            }
            Definition definition = null;
            return definition;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getWSDLDefinition");
            }
        }
    }

    public String getWSDLLocationBaseName() {
        if (this.serviceDescription instanceof ServiceDescriptionWSDL) {
            ServiceDescriptionWSDL serviceDescriptionWSDL = (ServiceDescriptionWSDL)((Object)this.serviceDescription);
            if (serviceDescriptionWSDL.getWSDLLocation() != null && serviceDescriptionWSDL.getWSDLLocation().getPath() != null) {
                URL uRL = serviceDescriptionWSDL.getWSDLLocation();
                String string = uRL.getPath();
                if (string.indexOf("/") != -1) {
                    string = string.substring(string.lastIndexOf("/"), string.length());
                    return string;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public URI getWSDLLocationURI() {
        if (this.serviceDescription instanceof ServiceDescriptionWSDL) {
            ServiceDescriptionWSDL serviceDescriptionWSDL = (ServiceDescriptionWSDL)((Object)this.serviceDescription);
            if (serviceDescriptionWSDL.getWSDLLocation() != null) {
                try {
                    return serviceDescriptionWSDL.getWSDLLocation().toURI();
                }
                catch (Throwable throwable) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Could not get WSDL location URI due to the following error: " + throwable.toString());
                    }
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public boolean isJAXRPCService() {
        return false;
    }

    public boolean isJAXWSService() {
        return true;
    }

    private void buildEndpoints() {
        for (EndpointDescription endpointDescription : this.serviceDescription.getEndpointDescriptions_AsCollection()) {
            Object object;
            if (_tc.isDebugEnabled()) {
                object = endpointDescription.getAxisService() != null ? Axis2Utils.getServiceImplClass(endpointDescription.getAxisService()) : null;
                Tr.debug(_tc, "Building MDQEndpointDescriptorImpl for port: " + endpointDescription.getPortQName() + " service impl class: " + (String)object);
            }
            object = new MDQEndpointDescriptorImpl(this, endpointDescription);
            this.endpointDescriptors.add((WSEndpointDescriptor)object);
        }
    }
}

