/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.desc.MDQOperationDescriptorImpl;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSOperationDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;

public class MDQEndpointDescriptorImpl
implements WSEndpointDescriptor {
    private WSServiceDescriptor parent;
    private EndpointDescription endpointDescription;
    private List<WSOperationDescriptor> operationDescriptors;
    private boolean operationsBuilt;
    private static final TraceComponent _tc = Tr.register(MDQEndpointDescriptorImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public MDQEndpointDescriptorImpl(WSServiceDescriptor wSServiceDescriptor, EndpointDescription endpointDescription) {
        this.parent = wSServiceDescriptor;
        this.endpointDescription = endpointDescription;
        this.operationDescriptors = new ArrayList<WSOperationDescriptor>();
        this.operationsBuilt = false;
    }

    public String getName() {
        return this.endpointDescription.getPortQName() != null ? this.endpointDescription.getPortQName().getLocalPart() : null;
    }

    public Iterator getOperations() {
        if (!this.operationsBuilt) {
            this.buildOperations();
            this.operationsBuilt = true;
        }
        return this.operationDescriptors.iterator();
    }

    public WSServiceDescriptor getParent() {
        return this.parent;
    }

    public QName getQName() {
        return this.endpointDescription.getPortQName();
    }

    public String getURLPattern() {
        AxisService axisService = this.endpointDescription.getAxisService();
        if (axisService != null) {
            return Axis2Utils.getURLPattern(axisService);
        }
        return null;
    }

    private void buildOperations() {
        OperationDescription[] operationDescriptionArray;
        EndpointInterfaceDescription endpointInterfaceDescription = this.endpointDescription.getEndpointInterfaceDescription();
        if (endpointInterfaceDescription != null && (operationDescriptionArray = endpointInterfaceDescription.getOperations()) != null && operationDescriptionArray.length > 0) {
            for (OperationDescription operationDescription : operationDescriptionArray) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Building WSOperationDescriptor for method: " + operationDescription.getOperationName());
                }
                MDQOperationDescriptorImpl mDQOperationDescriptorImpl = new MDQOperationDescriptorImpl(operationDescription.getOperationName());
                this.operationDescriptors.add(mDQOperationDescriptorImpl);
            }
        }
    }
}

