/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.desc.JAXWSOperationDescriptorImpl;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisService;

public class JAXWSEndpointDescriptorImpl
implements WSEndpointDescriptor,
Constants {
    private Port port;
    private WSServiceDescriptor parent;
    private ArrayList opList;
    private boolean opsBuilt;
    private String urlPattern;
    private Definition definition;
    private QName serviceQName;
    private static final TraceComponent _tc = Tr.register(JAXWSEndpointDescriptorImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    JAXWSEndpointDescriptorImpl(Port port, AxisService axisService, WSServiceDescriptor wSServiceDescriptor) {
        this.port = port;
        AxisService axisService2 = axisService;
        this.parent = wSServiceDescriptor;
        this.opsBuilt = false;
        this.opList = new ArrayList();
        this.setServiceQName(axisService2);
        this.setDefinition(axisService2);
        this.setURLPattern(axisService2);
    }

    public String getName() {
        return this.port.getName();
    }

    public void setDefinition(AxisService axisService) {
        this.definition = Axis2Utils.getWSDLDefinition(axisService);
    }

    public QName getQName() {
        QName qName = new QName(this.definition.getTargetNamespace(), this.getName());
        return qName;
    }

    public void setServiceQName(AxisService axisService) {
        this.serviceQName = Axis2Utils.getServiceQName(axisService);
    }

    public QName getServiceQName() {
        return this.serviceQName;
    }

    public Iterator getOperations() {
        if (!this.opsBuilt) {
            this.buildOperations();
        }
        return this.opList.iterator();
    }

    public void setParent(WSServiceDescriptor wSServiceDescriptor) {
        this.parent = wSServiceDescriptor;
    }

    public WSServiceDescriptor getParent() {
        return this.parent;
    }

    public void setURLPattern(AxisService axisService) {
        this.urlPattern = Axis2Utils.getURLPattern(axisService);
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    private void buildOperations() {
        Binding binding = this.port.getBinding();
        PortType portType = binding.getPortType();
        List list = portType.getOperations();
        for (Operation operation : list) {
            JAXWSOperationDescriptorImpl jAXWSOperationDescriptorImpl = new JAXWSOperationDescriptorImpl(operation);
            this.opList.add(jAXWSOperationDescriptorImpl);
        }
        this.opsBuilt = true;
    }
}

