/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.schema.resolver.WASURIResolver;
import com.ibm.ws.websvcs.wsdl.ModuleWSDLLocator;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

public class WASServiceBuilder
extends DescriptionBuilder
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASServiceBuilder.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private AxisConfiguration axisCfg;
    private ClassLoader classLoader;
    private LoadStrategy loadStrategy;

    public WASServiceBuilder(InputStream inputStream, AxisConfiguration axisConfiguration, ClassLoader classLoader, LoadStrategy loadStrategy) {
        this.descriptionStream = inputStream;
        this.axisConfig = axisConfiguration;
        this.axisCfg = axisConfiguration;
        this.classLoader = classLoader;
        this.loadStrategy = loadStrategy;
    }

    public AxisServiceGroup populateService() throws DeploymentException, XMLStreamException, AxisFault, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "populateService");
        }
        AxisServiceGroup axisServiceGroup = new AxisServiceGroup();
        try {
            OMElement oMElement = this.buildOM();
            if (!oMElement.getQName().toString().equals("serviceGroup")) {
                String string = NLSProvider.getNLS().getFormattedMessage("svcGrpReq00", new Object[0], "The required <serviceGroup> element in the ibmservices.xml file was not found.");
                throw new DeploymentException(string);
            }
            Iterator iterator = oMElement.getChildrenWithName(new QName("service"));
            while (iterator.hasNext()) {
                OMElement oMElement2 = (OMElement)iterator.next();
                AxisService axisService = new AxisService();
                axisService.setClassLoader(this.classLoader);
                this.processService(oMElement2, axisService);
                if (axisService == null) continue;
                axisService.setParent(axisServiceGroup);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding service to service group: " + axisService.getName());
                }
                axisServiceGroup.addService(axisService);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.deployment.WASServiceBuilder.populateService", "129", this);
            Object[] objectArray = new Object[]{throwable};
            String string = NLSProvider.getNLS().getFormattedMessage("loadSvsConfDataFail00", objectArray, "Error occurred while attempting to load configuration data: {0}");
            Tr.error(_tc, "loadSvsConfDataFail00", objectArray);
            throw new DeploymentException(string, throwable);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "populateService");
            }
        }
        return axisServiceGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processService(OMElement oMElement, AxisService axisService) throws XMLStreamException, DeploymentException, AxisFault, Exception {
        block14: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "processService");
            }
            try {
                Object object;
                Object object2;
                axisService.setName(oMElement.getAttributeValue(new QName("name")));
                Iterator iterator = oMElement.getChildrenWithName(new QName("parameter"));
                this.processParameters(iterator, axisService, axisService.getParent());
                if (!this.paramFound(oMElement.getChildrenWithName(new QName("parameter")), "WSDL_LOCATION") || !this.paramFound(oMElement.getChildrenWithName(new QName("parameter")), "ServiceClass")) break block14;
                OMElement oMElement2 = oMElement.getFirstChildWithName(new QName("description"));
                if (oMElement2 != null) {
                    object2 = oMElement2.getFirstElement();
                    if (object2 != null) {
                        object = new StringWriter();
                        object2.build();
                        object2.serialize((Writer)object);
                        ((StringWriter)object).flush();
                        axisService.setServiceDescription(((StringWriter)object).toString());
                    } else {
                        axisService.setServiceDescription(oMElement2.getText());
                    }
                } else {
                    object2 = oMElement.getAttribute(new QName("name"));
                    if (object2 != null) {
                        axisService.setServiceDescription(object2.getAttributeValue());
                    }
                }
                object2 = oMElement.getChildrenWithName(new QName("module"));
                this.processModuleRefs((Iterator)object2, axisService);
                object = this.getWSDLLocation(oMElement.getChildrenWithName(new QName("parameter")));
                InputStream inputStream = this.loadStrategy.getInputStream((String)object);
                if (inputStream != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Opened WSDL file [" + (String)object + "] for reading...");
                    }
                    WSDL11ToAxisServiceBuilder wSDL11ToAxisServiceBuilder = new WSDL11ToAxisServiceBuilder(inputStream, axisService);
                    ModuleWSDLLocator moduleWSDLLocator = new ModuleWSDLLocator((String)object, inputStream, this.loadStrategy);
                    WASURIResolver wASURIResolver = new WASURIResolver(this.loadStrategy);
                    wSDL11ToAxisServiceBuilder.setCustomWSLD4JResolver(moduleWSDLLocator);
                    wSDL11ToAxisServiceBuilder.setCustomResolver(wASURIResolver);
                    axisService = wSDL11ToAxisServiceBuilder.populateService();
                    axisService.addParameter(new Parameter("WsdlService", axisService.getName()));
                    this.setOperationMessageReceivers(axisService.getOperations());
                    axisService.setWsdlFound(true);
                    Parameter parameter = new Parameter("com.ibm.ws.websvcs.AxisServiceUrlPattern", "/" + axisService.getName());
                    axisService.addParameter(parameter);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Set com.ibm.ws.websvcs.AxisServiceUrlPattern parameter on AxisService [" + axisService.getName() + "], value: " + (String)parameter.getValue());
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Finished building AxisService [" + axisService.getName() + "].");
                    }
                    break block14;
                }
                Object[] objectArray = new Object[]{object};
                String string = NLSProvider.getNLS().getFormattedMessage("findWsdlFileFail00", objectArray, "The WSDL file {0} specified in the ibmservices.xml was not found.");
                throw new DeploymentException(string);
            }
            finally {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "processService");
                }
            }
        }
    }

    protected void processModuleRefs(Iterator iterator, AxisService axisService) throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processModuleRefs");
        }
        try {
            while (iterator.hasNext()) {
                OMElement oMElement = (OMElement)iterator.next();
                OMAttribute oMAttribute = oMElement.getAttribute(new QName("ref"));
                if (oMAttribute == null) continue;
                String string = oMAttribute.getAttributeValue();
                if (this.axisCfg.getModule(new QName(string)) == null) {
                    String string2 = NLSProvider.getNLS().getFormattedMessage("modNotExistAxisConf", new Object[0], "The ibmservices.xml refers to a module that does not exist in the global Axis2 configuration. ");
                    throw new DeploymentException(string2);
                }
                axisService.addModuleref(new QName(string));
            }
        }
        catch (AxisFault axisFault) {
            FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.deployment.WASServiceBuilder.processModuleRefs", "285", this);
            throw new DeploymentException(axisFault);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "processModuleRefs");
            }
        }
    }

    private boolean paramFound(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            OMElement oMElement = (OMElement)iterator.next();
            String string2 = oMElement.getAttributeValue(new QName("name"));
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWSDLLocation(Iterator iterator) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getWSDLLocation");
        }
        try {
            while (iterator.hasNext()) {
                OMElement oMElement = (OMElement)iterator.next();
                String string = oMElement.getAttributeValue(new QName("name"));
                if (!string.equals("WSDL_LOCATION")) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Obtained " + string + " property value: " + oMElement.getText());
                }
                String string2 = oMElement.getText();
                return string2;
            }
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getWSDLLocation");
            }
        }
        return null;
    }

    private void setOperationMessageReceivers(Iterator iterator) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setOperationMessageReceivers");
        }
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            axisOperation.setMessageReceiver(new JAXWSMessageReceiver());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setOperationMessageReceivers");
        }
    }
}

