/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.TransportGuaranteeType;
import org.eclipse.jst.j2ee.webapplication.UserDataConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.jst.j2ee.webapplication.internal.impl.SecurityConstraintImpl;
import org.eclipse.jst.j2ee.webapplication.internal.impl.UserDataConstraintImpl;
import org.eclipse.jst.j2ee.webapplication.internal.impl.WebResourceCollectionImpl;

public class WASAxis2URISecurityConstrainer
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAxis2URISecurityConstrainer.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private ConfigurationContext configContext = null;
    private WebApp webapp = null;

    public WASAxis2URISecurityConstrainer(ConfigurationContext configurationContext, WebApp webApp) {
        this.configContext = configurationContext;
        this.webapp = webApp;
    }

    public void constrainURIs() throws DeploymentException {
        Object object;
        Object[] objectArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2URISecurityConstrainer.constrainURIs()...");
        }
        try {
            Set set = this.getUserConstrainedURIs();
            objectArray = this.getServiceURIs();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "WebApp: " + this.webapp);
                Tr.debug(_tc, "User defined constrained URIs: " + set);
                Tr.debug(_tc, "URIs defined by services to constrain: " + objectArray);
            }
            object = this.getRemainingURIsToConstrain(set, (Set)objectArray);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Remaining URIs to constrain: " + object);
            }
            if (object.size() == 0) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "All URIs constrained by web.xml, returning.");
                }
                return;
            }
            this.constrainURIs((Set)object);
        }
        catch (Throwable throwable) {
            objectArray = new Object[]{throwable};
            object = NLSProvider.getNLS().getFormattedMessage("caughtException", objectArray, "Caught unexpected exception: {0}");
            Tr.error(_tc, "caughtException", objectArray);
            throw new DeploymentException((String)object);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "...WASAxis2URISecurityConstrainer.constrainURIs()");
            }
        }
    }

    private Set getServiceURIs() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2URISecurityConstrainer.getServiceURIs()...");
        }
        HashSet<String> hashSet = new HashSet<String>();
        AxisConfiguration axisConfiguration = this.configContext.getAxisConfiguration();
        Iterator iterator = axisConfiguration.getServiceGroups();
        while (iterator.hasNext()) {
            AxisServiceGroup axisServiceGroup = (AxisServiceGroup)iterator.next();
            Iterator iterator2 = axisServiceGroup.getServices();
            while (iterator2.hasNext()) {
                AxisService axisService = (AxisService)iterator2.next();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "ServiceName: " + Axis2Utils.getServiceName(axisService));
                }
                if (!Axis2Utils.isServiceConstrained(axisService)) continue;
                String string = Axis2Utils.getURLPattern(axisService);
                hashSet.add(string);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Service needs URI constrained: " + string);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WASAxis2URISecurityConstrainer.getServiceURIs()");
        }
        return hashSet;
    }

    private Set getUserConstrainedURIs() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2URISecurityConstrainer.getConstraintUserDefinedURIs()...");
        }
        HashSet hashSet = new HashSet();
        if (this.webapp == null) {
            return hashSet;
        }
        EList eList = this.webapp.getConstraints();
        for (SecurityConstraint securityConstraint : eList) {
            EList eList2 = securityConstraint.getWebResourceCollections();
            for (WebResourceCollection webResourceCollection : eList2) {
                EList eList3 = webResourceCollection.getUrlPattern();
                hashSet.addAll(eList3);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "URI list added: " + eList3);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WASAxis2URISecurityConstrainer.getConstraintUserDefinedURIs()");
        }
        return hashSet;
    }

    private Set getRemainingURIsToConstrain(Set set, Set set2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2URISecurityConstrainer.getRemainingURIsToConstrain()...");
        }
        if (set.size() == 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "No user constrained uris, constrain all.");
            }
            return set2;
        }
        HashSet hashSet = new HashSet(set2);
        for (String string : set) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "User defined URI: " + string);
            }
            if (string.endsWith("*")) {
                string = string.substring(0, string.length() - 1);
                for (String string2 : set2) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Service URI: " + string2);
                    }
                    if (!string2.startsWith(string)) continue;
                    hashSet.remove(string2);
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Removed service URI from set.");
                }
                if (!string.endsWith("/")) continue;
                string = string.substring(0, string.length() - 1);
                hashSet.remove(string);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Removed URI from set: " + string);
                continue;
            }
            hashSet.remove(string);
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "Removed URI from set: " + string);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WASAxis2URISecurityConstrainer.getRemainingURIsToConstrain()");
        }
        return hashSet;
    }

    private void constrainURIs(Set set) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2URISecurityConstrainer.constrainURIs()...");
        }
        SecurityConstraintImpl securityConstraintImpl = new SecurityConstraintImpl();
        WebResourceCollectionImpl webResourceCollectionImpl = new WebResourceCollectionImpl();
        UserDataConstraintImpl userDataConstraintImpl = new UserDataConstraintImpl();
        for (String string : set) {
            webResourceCollectionImpl.getUrlPattern().add(string + "/*");
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "URI now constrained: " + string + "/*");
        }
        userDataConstraintImpl.setTransportGuarantee(TransportGuaranteeType.CONFIDENTIAL_LITERAL);
        webResourceCollectionImpl.getHttpMethod().add(HTTPMethodTypeEnum.GET_LITERAL);
        webResourceCollectionImpl.getHttpMethod().add(HTTPMethodTypeEnum.POST_LITERAL);
        securityConstraintImpl.getWebResourceCollections().add(webResourceCollectionImpl);
        securityConstraintImpl.setUserDataConstraint((UserDataConstraint)userDataConstraintImpl);
        securityConstraintImpl.setWebApp(this.webapp);
        this.webapp.getConstraints().add(securityConstraintImpl);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WASAxis2URISecurityConstrainer.constrainURIs()");
        }
    }
}

