/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;

public class WASAxis2PolicySetConfigurator
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAxis2PolicySetConfigurator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private ClassLoader appClassLoader = null;
    private ClassLoader sysClassLoader = null;
    private PolicySetAttachments psa = null;

    public WASAxis2PolicySetConfigurator(ClassLoader classLoader, ClassLoader classLoader2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2PolicySetBuilder ctr");
        }
        this.appClassLoader = classLoader;
        this.sysClassLoader = classLoader2;
        if (_tc.isDebugEnabled() && (classLoader == null || classLoader2 == null)) {
            Tr.debug(_tc, "One of the constructor parameters does not have a value");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WASAxis2PolicySetBuilder ctr");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associatePolicySets(ConfigurationContext configurationContext, Axis2ServiceConfigPluginManager axis2ServiceConfigPluginManager) throws DeploymentException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "associatePolicySets");
        }
        try {
            AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
            if (axisConfiguration == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Axis Configuration does not exist. Exiting.");
                }
                return;
            }
            String string = null;
            if (Axis2Utils.getApplicationName(axisConfiguration) != null) {
                string = Axis2Utils.getApplicationName(axisConfiguration);
            }
            String string2 = null;
            if (Axis2Utils.getModuleName(axisConfiguration) != null) {
                string2 = Axis2Utils.getModuleName(axisConfiguration);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Adding Policy Sets for " + string + "/" + string2);
            }
            Iterator iterator = null;
            if (axisConfiguration.getServices() == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "AxisConfiguration did not have any services set on it. Exiting.");
                }
                return;
            }
            iterator = axisConfiguration.getServices().keySet().iterator();
            while (iterator.hasNext()) {
                AxisService axisService = axisConfiguration.getService((String)iterator.next());
                this.associatePolicySets(axisService, axis2ServiceConfigPluginManager);
            }
            this.psa = null;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "associatePolicySets");
            }
        }
    }

    public void associatePolicySets(AxisService axisService, Axis2ServiceConfigPluginManager axis2ServiceConfigPluginManager) throws DeploymentException, Exception {
        if (axisService == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Service is null. Continuing.");
            }
            return;
        }
        if (Axis2Utils.getPolicySet(axisService) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Axis Service already has policy set associated with it. Continuing.");
            }
            return;
        }
        QName qName = Axis2Utils.getServiceQName(axisService);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "*** Associating policy set for service: " + qName + " ***");
        }
        String string = null;
        if (axisService.getAxisConfiguration() != null) {
            string = Axis2Utils.getApplicationName(axisService.getAxisConfiguration());
        }
        String string2 = null;
        if (axisService.getAxisConfiguration() != null) {
            string2 = Axis2Utils.getModuleName(axisService.getAxisConfiguration());
        }
        String string3 = "WebService:/";
        if (string2 != null) {
            string3 = string3 + string2 + ":";
        }
        if (qName != null) {
            string3 = string3 + qName.toString();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Base Policy Set resource key: " + string3);
        }
        try {
            PolicySetAttachments policySetAttachments = this.getPolicySetAttachments(string, axis2ServiceConfigPluginManager.isServerSide());
            if (policySetAttachments != null) {
                Object object;
                PolicySetConfiguration policySetConfiguration = null;
                String string4 = Axis2Utils.getPortName(axisService);
                if (string4 != null) {
                    object = axisService.getOperations();
                    while (object.hasNext()) {
                        AxisOperation axisOperation = (AxisOperation)object.next();
                        QName qName2 = axisOperation.getName();
                        String string5 = string3 + "/" + string4 + "/" + qName2.getLocalPart();
                        policySetConfiguration = policySetAttachments.getPolicySet(string5, this.appClassLoader, this.sysClassLoader);
                        if (policySetConfiguration != null) {
                            Axis2Utils.setPolicySet(axisOperation, policySetConfiguration);
                        }
                        if (!_tc.isDebugEnabled()) continue;
                        if (policySetConfiguration != null) {
                            Tr.debug(_tc, "    Policy Set loaded for operation " + qName2 + " using key '" + string5 + "'.");
                            continue;
                        }
                        Tr.debug(_tc, "    Policy set could not be loaded for operation " + qName2 + ".");
                    }
                }
                if ((policySetConfiguration = policySetAttachments.getPolicySet(string3, this.appClassLoader, this.sysClassLoader)) != null) {
                    Axis2Utils.setPolicySet(axisService, policySetConfiguration);
                }
                if (_tc.isDebugEnabled()) {
                    if (policySetConfiguration != null) {
                        Tr.debug(_tc, "  Policy Set loaded for service " + qName + " using key '" + string3 + "'.");
                    } else {
                        Tr.debug(_tc, "  Policy set could not be loaded for service " + qName + ".");
                    }
                }
                object = new HashMap();
                ((HashMap)object).put("com.ibm.wsspi.websvcs.AxisServiceKey", axisService);
                axis2ServiceConfigPluginManager.runConfig((HashMap)object);
            }
        }
        catch (DeploymentException deploymentException) {
            FFDCFilter.processException((Throwable)deploymentException, "com.ibm.ws.websvcs.deployment.WASAxis2PolicySetConfigurator.associatePolicySets", "259", this);
            Object[] objectArray = new Object[]{qName, deploymentException};
            Tr.error(_tc, "loadPolicySetFail00", objectArray);
            throw deploymentException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.deployment.WASAxis2PolicySetConfigurator.associatePolicySets", "269", this);
            Object[] objectArray = new Object[]{qName, exception};
            Tr.error(_tc, "loadPolicySetFail00", objectArray);
            throw exception;
        }
    }

    private PolicySetAttachments getPolicySetAttachments(String string, boolean bl) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getPolicySetAttachments");
            Tr.debug(_tc, "serverSide=" + bl + ", appName=" + string);
        }
        PolicySetUtil policySetUtil = PolicySetUtil.getInstance(this.sysClassLoader);
        if (bl) {
            if (this.psa != null) {
                return this.psa;
            }
            this.psa = policySetUtil.getAttachments(string);
        } else {
            this.psa = policySetUtil.getClientAttachments(string);
        }
        if (_tc.isDebugEnabled()) {
            if (this.psa == null) {
                Tr.debug(_tc, "Application " + string + " does not" + " have any policy sets associated with it.");
            } else {
                Tr.debug(_tc, "Retrieved Policy Sets for application " + string + ".");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getPolicySetAttachments");
        }
        return this.psa;
    }
}

