/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.collector.WASAnnotationCollector;
import com.ibm.ws.websvcs.annotations.generator.WASAnnotationInputBuilder;
import com.ibm.ws.websvcs.deployment.ArchiveFileLocator;
import com.ibm.ws.websvcs.deployment.CachedFileLocator;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.FileExplorerFactory;
import com.ibm.ws.websvcs.deployment.WASAxis2DescriptionBuilder;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.WSAnnotatedClassCacheBean;
import com.ibm.ws.websvcs.utils.WebServicesModuleCache;
import com.ibm.ws.websvcs.utils.WebServicesModuleCacheMgr;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.webapplication.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAxis2MetaDataProcessor
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAxis2MetaDataProcessor.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private ConfigurationContext configContext;
    private WASAxis2Service runtimeService;
    private DeployedObject dObj;
    private String applicationName;
    private String moduleName;
    private boolean cacheNeeded;
    private WebServicesModuleCache cache;
    private Map<String, ArchiveFileLocator> archiveFileLocatorMap;
    private ClassLoader deployedObjectClassLoader;

    public WASAxis2MetaDataProcessor(DeployedObject deployedObject) {
        this.dObj = deployedObject;
        this.deployedObjectClassLoader = deployedObject.getClassLoader();
    }

    public ConfigurationContext processApplicationMetaData() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processApplicationMetaData");
        }
        try {
            this.getRuntimeService();
            this.setAppAndModuleName();
            this.initCache();
            if (this.cache.exists() && this.cache.getAnnotatedClassList().isEmpty()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found cache for module " + this.moduleName + ", but " + "the module contains no annotations.");
                }
                return null;
            }
            AxisServiceGroup axisServiceGroup = this.processWARMetadata();
            if (axisServiceGroup != null) {
                this.finishRuntimeConfiguration(this.configContext.getAxisConfiguration(), axisServiceGroup);
            } else if (!this.cache.exists() && axisServiceGroup == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Saving an empty class cache file");
                }
                this.cache.save();
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "processApplicationMetaData");
            }
            return this.configContext;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{this.moduleName, exception};
            String string = NLSProvider.getNLS().getFormattedMessage("loadConfigContextFail00", objectArray, "Error occurred while attempting to create ConfigurationContext for application module{0}: {1}");
            Tr.error(_tc, string);
            throw exception;
        }
    }

    private void setAppAndModuleName() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setAppAndModuleName");
        }
        ModuleMetaData moduleMetaData = (ModuleMetaData)this.dObj.getMetaData();
        this.applicationName = moduleMetaData.getApplicationMetaData().getName();
        this.moduleName = this.dObj.getName();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setAppAndModuleName");
        }
    }

    private void getRuntimeService() throws Exception, DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRuntimeService");
        }
        this.runtimeService = (WASAxis2Service)WsServiceRegistry.getService(this, WASAxis2Service.class);
        if (this.runtimeService == null) {
            throw new DeploymentException("WASAxis2Service not available. Module processing will be aborted");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getRuntimeService");
        }
    }

    private AxisServiceGroup processWARMetadata() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processWARMetadata");
        }
        try {
            HashMap<String, DescriptionBuilderComposite> hashMap;
            Object object = null;
            List<ClassDataObject> list = this.getClassDataObjects();
            if (list.size() > 0) {
                this.loadConfiguration();
                this.setWebAppName();
                hashMap = this.buildAnnotationDBCInputs(list);
                if (hashMap != null && !hashMap.isEmpty()) {
                    List<ServiceDescription> list2 = DescriptionFactory.createServiceDescriptionFromDBCMap(hashMap);
                    object = this.buildAxisServices(list, list2);
                }
            }
            hashMap = object;
            return hashMap;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "processWARMetadata");
            }
        }
    }

    private void loadConfiguration() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadConfiguration");
        }
        this.configContext = this.runtimeService.loadAxis2ConfigurationContext(this.applicationName, this.moduleName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadConfiguration");
        }
    }

    private AxisServiceGroup buildAxisServices(List<ClassDataObject> list, List<ServiceDescription> list2) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildAxisServices");
        }
        WASAxis2DescriptionBuilder wASAxis2DescriptionBuilder = new WASAxis2DescriptionBuilder(this.deployedObjectClassLoader);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildAxisServices");
        }
        return wASAxis2DescriptionBuilder.buildAxisServiceGroup(list2);
    }

    private List<FileLocator> getFileLocators() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getFileLocators");
        }
        if (this.dObj.getModuleFile() instanceof WARFile) {
            if (this.cache.exists()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found existing annotated class cache file for module: " + this.moduleName);
                }
                List<WSAnnotatedClassCacheBean> list = this.cache.getAnnotatedClassList();
                try {
                    List<FileLocator> list2 = this.buildLocators(list);
                    this.cacheNeeded = false;
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getFileLocators");
                    }
                    return list2;
                }
                catch (Exception exception) {
                    return this.getLocatorsFromModule();
                }
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Did not find existing annotated class cache file for module: " + this.moduleName);
            }
            return this.getLocatorsFromModule();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getFileLocators");
        }
        return null;
    }

    private List<FileLocator> getLocatorsFromModule() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getLocatorsFromModule");
        }
        FileExplorer fileExplorer = FileExplorerFactory.getFileExplorer(this.dObj.getModuleFile());
        this.cacheNeeded = true;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getLocatorsFromModule");
        }
        List<FileLocator> list = fileExplorer.explore();
        return list;
    }

    private List<ClassDataObject> getClassDataObjects() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getClassDataObjects");
        }
        List<FileLocator> list = this.getFileLocators();
        WASAnnotationCollector wASAnnotationCollector = new WASAnnotationCollector();
        wASAnnotationCollector.setClassLoader(this.deployedObjectClassLoader);
        List<ClassDataObject> list2 = this.cacheNeeded ? wASAnnotationCollector.collect(list) : wASAnnotationCollector.collectCachedList(list);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getClassDataObjects");
        }
        return list2;
    }

    private HashMap<String, DescriptionBuilderComposite> buildAnnotationDBCInputs(List<ClassDataObject> list) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildAnnotationDBCInputs");
        }
        WASAnnotationInputBuilder wASAnnotationInputBuilder = new WASAnnotationInputBuilder(list, this.deployedObjectClassLoader, this.dObj.getModuleFile());
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildAnnotationDBCInputs");
        }
        return wASAnnotationInputBuilder.buildInputs();
    }

    private void setWebAppName() {
        WebApp webApp;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setWebAppName");
        }
        if ((webApp = (WebApp)this.dObj.getDeploymentDescriptor()).getDisplayName() == null || webApp.getDisplayName().equals("")) {
            webApp.setDisplayName(this.moduleName);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setWebAppName");
        }
    }

    private void finishRuntimeConfiguration(AxisConfiguration axisConfiguration, AxisServiceGroup axisServiceGroup) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "finishRuntimeConfiguration");
        }
        if (!axisServiceGroup.getServices().hasNext()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The AxisServiceGroup for the module: " + this.moduleName + " has no services and will not be added to the AxisConfiguration");
            }
        } else {
            axisConfiguration.addServiceGroup(axisServiceGroup);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "finishRuntimeConfiguration");
        }
    }

    private List<FileLocator> buildLocators(List<WSAnnotatedClassCacheBean> list) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildLocators");
        }
        ArrayList<FileLocator> arrayList = new ArrayList<FileLocator>();
        for (WSAnnotatedClassCacheBean wSAnnotatedClassCacheBean : list) {
            String string = wSAnnotatedClassCacheBean.getClassName();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Constructed FileLocator from cache: " + string + " with " + "container path: " + wSAnnotatedClassCacheBean.getContainerPath());
            }
            URL uRL = null;
            try {
                CachedFileLocator cachedFileLocator;
                boolean bl = false;
                Enumeration<URL> enumeration = this.deployedObjectClassLoader.getResources(string);
                ArrayList<URL> arrayList2 = new ArrayList<URL>();
                while (enumeration.hasMoreElements()) {
                    arrayList2.add(enumeration.nextElement());
                }
                if (arrayList2.size() == 1) {
                    bl = true;
                    cachedFileLocator = new CachedFileLocator((URL)arrayList2.get(0), string);
                    arrayList.add(cachedFileLocator);
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Found the following cached class file: " + ((URL)arrayList2.get(0)).toString());
                    continue;
                }
                if (arrayList2.size() <= 1) continue;
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext() && !bl) {
                    URL uRL2 = (URL)iterator.next();
                    if (uRL2 == null || wSAnnotatedClassCacheBean.getContainerPath() != null && uRL2.toString().indexOf(wSAnnotatedClassCacheBean.getContainerPath()) == -1) continue;
                    uRL = uRL2;
                    bl = true;
                    cachedFileLocator = new CachedFileLocator(uRL, string);
                    arrayList.add(cachedFileLocator);
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Found the following cached class file: " + uRL.toString());
                }
            }
            catch (Exception exception) {
                Tr.warning(_tc, "The following problem occurred when trying to load application metadata from cache: " + exception.toString() + ". The application metadata " + "will now be loaded from the web module.");
                throw exception;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildLocators");
        }
        return arrayList;
    }

    private void initCache() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initCache");
        }
        String string = this.applicationName + File.separator + this.moduleName + File.separator;
        this.cache = WebServicesModuleCacheMgr.getModuleCache(string);
        this.cache.load();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initCache");
        }
    }
}

