/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAxis2DescriptionBuilder
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAxis2DescriptionBuilder.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private AxisServiceGroup serviceGroup;
    private ClassLoader classLoader;

    public WASAxis2DescriptionBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public AxisServiceGroup buildAxisServiceGroup(List<ServiceDescription> list) {
        if (list != null && !list.isEmpty()) {
            this.serviceGroup = new AxisServiceGroup();
            for (ServiceDescription serviceDescription : list) {
                try {
                    this.retrieveAxisServices(serviceDescription);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.deployment.WASAxis2DescriptionBuilder.buildAxisServiceGroup", "75", this);
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    throwable.printStackTrace(printWriter);
                    Tr.error(_tc, throwable.toString() + "\n" + stringWriter.toString());
                }
            }
            return this.serviceGroup;
        }
        return null;
    }

    private void retrieveAxisServices(ServiceDescription serviceDescription) throws Exception {
        EndpointDescription[] endpointDescriptionArray = serviceDescription.getEndpointDescriptions();
        if (endpointDescriptionArray != null) {
            for (int i = 0; i < endpointDescriptionArray.length; ++i) {
                EndpointDescription endpointDescription = endpointDescriptionArray[i];
                AxisService axisService = endpointDescription.getAxisService();
                this.setServiceURLPattern(axisService);
                this.setOperationInfo(axisService);
                axisService.setClassLoader(this.classLoader);
                this.addStackTraceParam(axisService);
                this.serviceGroup.addService(axisService);
            }
        }
    }

    private void setServiceURLPattern(AxisService axisService) throws AxisFault {
        QName qName = Axis2Utils.getServiceQName(axisService);
        if (qName != null) {
            String string = qName.getLocalPart();
            Axis2Utils.setURLPattern(axisService, "/" + string);
        }
    }

    private void setOperationInfo(AxisService axisService) {
        Iterator iterator = axisService.getOperations();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            axisOperation.setMessageReceiver(new JAXWSMessageReceiver());
            this.addStackTraceParam(axisOperation);
        }
    }

    private void addStackTraceParam(AxisDescription axisDescription) {
        try {
            Parameter parameter = new Parameter();
            parameter.setName("sendStacktraceDetailsWithFaults");
            parameter.setValue(Boolean.FALSE.toString());
            axisDescription.addParameter(parameter);
        }
        catch (AxisFault axisFault) {
            Tr.warning(_tc, "Problem occurrred adding parameter to a configuration object.");
        }
    }
}

