/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.deployment.ACMPluginConfig;
import com.ibm.ws.websvcs.deployment.QOSModuleConfig;
import com.ibm.ws.websvcs.deployment.TCMPluginConfig;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.PluginUtils;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Flow;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigrator;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigratorUtil;
import org.apache.axis2.modules.Module;
import org.apache.axis2.util.ThreadContextMigrator;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class WASAxis2ConfigurationBuilder
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAxis2ConfigurationBuilder.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private DeploymentEngine de;
    private ArrayList clientModuleFiles = null;
    private ArrayList serverModuleFiles = null;
    private ArrayList clientTCMPlugins = null;
    private ArrayList serverTCMPlugins = null;
    private ArrayList clientACMPlugins = null;
    private ArrayList serverACMPlugins = null;

    public WASAxis2ConfigurationBuilder() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2ConfigurationBuilder ctor");
        }
        this.clientModuleFiles = new ArrayList();
        this.serverModuleFiles = new ArrayList();
        this.clientTCMPlugins = new ArrayList();
        this.serverTCMPlugins = new ArrayList();
        this.clientACMPlugins = new ArrayList();
        this.serverACMPlugins = new ArrayList();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WASAxis2ConfigurationBuilder ctor");
        }
    }

    public WASAxis2ConfigurationBuilder(ArrayList arrayList, ArrayList arrayList2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2ConfigurationBuilder ctor");
        }
        this.serverModuleFiles = arrayList;
        this.clientModuleFiles = arrayList2;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WASAxis2ConfigurationBuilder ctor");
        }
    }

    public WASAxis2ConfigurationBuilder(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, ArrayList arrayList6) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2ConfigurationBuilder ctor");
        }
        this.serverModuleFiles = arrayList;
        this.clientModuleFiles = arrayList2;
        this.serverTCMPlugins = arrayList3;
        this.clientTCMPlugins = arrayList4;
        this.serverACMPlugins = arrayList5;
        this.clientACMPlugins = arrayList6;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WASAxis2ConfigurationBuilder ctor");
        }
    }

    public AxisConfiguration loadAxisServerConfiguration() throws Exception {
        return this.loadAxisCfg("META-INF/config/ibmaxis2.xml");
    }

    public AxisConfiguration loadAxisClientConfiguration() throws Exception {
        return this.loadAxisCfg("META-INF/config/ibmaxis2.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAxisServerModules(AxisConfiguration axisConfiguration, ConfigurationContext configurationContext) throws DeploymentException {
        ArrayList arrayList = this.serverModuleFiles;
        synchronized (arrayList) {
            try {
                if (this.serverModuleFiles.isEmpty()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Need to discover AxisModules for server");
                    }
                    this.discoverAxisModules(axisConfiguration, this.serverModuleFiles, "com.ibm.wsfp.main.ibmaxis2-qos-module-server");
                    this.loadAxisModules(this.serverModuleFiles, axisConfiguration);
                    this.initModules(axisConfiguration, configurationContext);
                    this.engageModules(axisConfiguration);
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Already discovered AxisModules for server");
                    }
                    this.loadAxisModules(this.serverModuleFiles, axisConfiguration);
                    this.initModules(axisConfiguration, configurationContext);
                    this.engageModules(axisConfiguration);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.loadAxisServerModules", "197", this);
                Object[] objectArray = new Object[]{exception};
                String string = NLSProvider.getNLS().getFormattedMessage("qosModLoadFail00", objectArray, "Error occurred while attempting to load QoS(Quality of Service) modules on the server: {0}");
                throw new DeploymentException(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAxisClientModules(AxisConfiguration axisConfiguration, ConfigurationContext configurationContext) throws DeploymentException {
        ArrayList arrayList = this.clientModuleFiles;
        synchronized (arrayList) {
            try {
                if (this.clientModuleFiles.isEmpty()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Need to discover AxisModules for client");
                    }
                    this.discoverAxisModules(axisConfiguration, this.clientModuleFiles, "com.ibm.wsfp.main.ibmaxis2-qos-module-client");
                    this.discoverAxisModules(axisConfiguration, this.clientModuleFiles, "com.ibm.wsfp.thinclient.ibmaxis2-qos-module-client");
                    this.loadAxisModules(this.clientModuleFiles, axisConfiguration);
                    this.initModules(axisConfiguration, configurationContext);
                    this.engageModules(axisConfiguration);
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Already discovered AxisModules for client");
                    }
                    this.loadAxisModules(this.clientModuleFiles, axisConfiguration);
                    this.initModules(axisConfiguration, configurationContext);
                    this.engageModules(axisConfiguration);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.loadAxisClientModules", "245", this);
                Object[] objectArray = new Object[]{exception};
                String string = NLSProvider.getNLS().getFormattedMessage("qosModLoadClientFail00", objectArray, "Error occurred while attempting to load QoS(Quality of Service) modules on the client: {0}");
                throw new DeploymentException(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAxisServerTCMPlugins(ConfigurationContext configurationContext) throws DeploymentException {
        ArrayList arrayList = this.serverTCMPlugins;
        synchronized (arrayList) {
            if (this.serverTCMPlugins.isEmpty()) {
                this.discoverTCMPlugins("com.ibm.wsfp.main.ibmaxis2-thread-ctx-migrator-server", this.serverTCMPlugins);
                this.registerTCMPlugins(this.serverTCMPlugins, configurationContext);
            } else {
                this.registerTCMPlugins(this.serverTCMPlugins, configurationContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAxisClientTCMPlugins(ConfigurationContext configurationContext) throws DeploymentException {
        ArrayList arrayList = this.clientTCMPlugins;
        synchronized (arrayList) {
            if (this.clientTCMPlugins.isEmpty()) {
                this.discoverTCMPlugins("com.ibm.wsfp.main.ibmaxis2-thread-ctx-migrator-client", this.clientTCMPlugins);
                this.discoverTCMPlugins("com.ibm.wsfp.thinclient.ibmaxis2-thread-ctx-migrator-client", this.clientTCMPlugins);
                this.registerTCMPlugins(this.clientTCMPlugins, configurationContext);
            } else {
                this.registerTCMPlugins(this.clientTCMPlugins, configurationContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAxisServerACMPlugins(ConfigurationContext configurationContext) throws DeploymentException {
        ArrayList arrayList = this.serverACMPlugins;
        synchronized (arrayList) {
            if (this.serverACMPlugins.isEmpty()) {
                this.discoverACMPlugins("com.ibm.wsfp.main.ibmaxis2-app-ctx-migrator-server", this.serverACMPlugins);
                this.registerACMPlugins(this.serverACMPlugins, configurationContext);
            } else {
                this.registerACMPlugins(this.serverACMPlugins, configurationContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAxisClientACMPlugins(ConfigurationContext configurationContext) throws DeploymentException {
        ArrayList arrayList = this.clientACMPlugins;
        synchronized (arrayList) {
            if (this.clientACMPlugins.isEmpty()) {
                this.discoverACMPlugins("com.ibm.wsfp.main.ibmaxis2-app-ctx-migrator-client", this.clientACMPlugins);
                this.discoverACMPlugins("com.ibm.wsfp.thinclient.ibmaxis2-app-ctx-migrator-client", this.clientACMPlugins);
                this.registerACMPlugins(this.clientACMPlugins, configurationContext);
            } else {
                this.registerACMPlugins(this.clientACMPlugins, configurationContext);
            }
        }
    }

    protected AxisConfiguration loadAxisCfg(String string) throws Exception {
        ClassLoader classLoader;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadAxisCfg, cfgFile=" + string);
        }
        ClassLoader classLoader2 = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        AxisConfiguration axisConfiguration = new AxisConfiguration();
        try {
            Object object;
            Object object2;
            URL uRL;
            block28: {
                block27: {
                    classLoader = ExtClassLoader.getInstance();
                    uRL = null;
                    try {
                        uRL = classLoader.getResource(string);
                    }
                    catch (Throwable throwable) {
                        object2 = new StringWriter();
                        object = new PrintWriter((Writer)object2);
                        throwable.printStackTrace((PrintWriter)object);
                        if (!_tc.isDebugEnabled()) break block27;
                        Tr.debug(_tc, "Failed to load config file URL using ExtClassLoader due to the following error: \n" + ((StringWriter)object2).toString());
                    }
                }
                if (uRL != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Loaded config file URL using ExtClassLoader: " + uRL.toString());
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Config file not loaded using ExtClassLoader, using thread classloader: " + classLoader2);
                    }
                    try {
                        uRL = classLoader2.getResource(string);
                    }
                    catch (Throwable throwable) {
                        object2 = new StringWriter();
                        object = new PrintWriter((Writer)object2);
                        throwable.printStackTrace((PrintWriter)object);
                        if (!_tc.isDebugEnabled()) break block28;
                        Tr.debug(_tc, "Failed to load config file URL using Thread's classloader due to the following error: \n" + ((StringWriter)object2).toString());
                    }
                }
            }
            if (uRL != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Loaded config file URL using Thread's classloader: " + uRL.toString());
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Config file not loaded with either classloader");
            }
            InputStream inputStream = null;
            if (uRL != null) {
                inputStream = uRL.openStream();
            }
            if (inputStream != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found Axis2 configuration file: " + uRL.toString());
                }
                object2 = this;
                AccessController.doPrivileged(new PrivilegedAction((WASAxis2ConfigurationBuilder)object2){
                    final /* synthetic */ WASAxis2ConfigurationBuilder val$builder;
                    {
                        this.val$builder = wASAxis2ConfigurationBuilder2;
                    }

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$builder.getClass().getClassLoader());
                        return null;
                    }
                });
                if (_tc.isDebugEnabled()) {
                    object = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                    Tr.debug(_tc, "Setting temporary ContextClassLoader: " + object.toString());
                }
                this.de = new DeploymentEngine();
                if (_tc.isDebugEnabled()) {
                    WSLauncher.debug = true;
                    object = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                    Tr.debug(_tc, "About to call populateAxisConfiguration(), classloader=" + object.toString());
                }
                axisConfiguration = this.de.populateAxisConfiguration(inputStream);
                object = axisConfiguration.getPhasesInfo();
                axisConfiguration.setInPhasesUptoAndIncludingPostDispatch(((PhasesInfo)object).getGlobalInflow());
                axisConfiguration.setInFaultPhases(((PhasesInfo)object).getIN_FaultPhases());
                axisConfiguration.setGlobalOutPhase(((PhasesInfo)object).getGlobalOutPhaseList());
                axisConfiguration.setOutFaultPhases(((PhasesInfo)object).getOUT_FaultPhases());
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Created AxisConfiguration: " + axisConfiguration.toString());
                }
            }
            classLoader = classLoader2;
        }
        catch (Exception exception) {
            try {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.loadAxisCfg", "359", this);
                Object[] objectArray = new Object[]{string, exception};
                String string2 = NLSProvider.getNLS().getFormattedMessage("loadAxisGlobConfFail00", objectArray, "Error occurred while attempting to load Axis2 global configuration file {0}: {1}");
                Tr.error(_tc, "loadAxisGlobConfFail00", objectArray);
                throw new Exception(string2);
            }
            catch (Throwable throwable) {
                ClassLoader classLoader3 = classLoader2;
                AccessController.doPrivileged(new PrivilegedAction(classLoader3){
                    final /* synthetic */ ClassLoader val$finalOldCCL;
                    {
                        this.val$finalOldCCL = classLoader;
                    }

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$finalOldCCL);
                        return null;
                    }
                });
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Restored ContextClassLoader: " + AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Thread.currentThread().getContextClassLoader().toString();
                        }
                    }));
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "loadAxisCfg");
                }
                throw throwable;
            }
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Restored ContextClassLoader: " + AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadAxisCfg");
        }
        return axisConfiguration;
    }

    protected void discoverAxisModules(AxisConfiguration axisConfiguration, ArrayList arrayList, String string) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "discoverAxisModules, epid=" + string);
        }
        try {
            IExtension[] iExtensionArray = PluginUtils.getDeclaredExtensions(string);
            if (iExtensionArray != null) {
                QOSModuleConfig qOSModuleConfig = null;
                for (int i = 0; i < iExtensionArray.length; ++i) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Processing extension " + iExtensionArray[i].getUniqueIdentifier());
                    }
                    URL uRL = null;
                    String string2 = null;
                    IConfigurationElement[] iConfigurationElementArray = iExtensionArray[i].getConfigurationElements();
                    for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                        if (iConfigurationElementArray[j].getName().equals("filename")) {
                            final String string3 = iConfigurationElementArray[j].getValue();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Extension specified filename: " + string3);
                            }
                            if (string3 == null || string3.equals("")) continue;
                            final Bundle bundle = Platform.getBundle(iExtensionArray[i].getNamespace());
                            uRL = bundle != null ? (URL)AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    return bundle.getResource(string3);
                                }
                            }) : (URL)AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    return Thread.currentThread().getContextClassLoader().getResource(string3);
                                }
                            });
                            if (uRL == null) {
                                if (!_tc.isDebugEnabled()) continue;
                                Object[] objectArray = new Object[]{string3};
                                Tr.error(_tc, "modConfLoadFail00", objectArray);
                                continue;
                            }
                            if (!_tc.isDebugEnabled()) continue;
                            Tr.debug(_tc, "Module file URL: " + uRL.toString());
                            continue;
                        }
                        if (!iConfigurationElementArray[j].getName().equals("global")) continue;
                        string2 = iConfigurationElementArray[j].getValue();
                    }
                    qOSModuleConfig = new QOSModuleConfig();
                    qOSModuleConfig.setURL(uRL);
                    if (string2 == null || string2.equalsIgnoreCase("true")) {
                        qOSModuleConfig.setEngageGlobally(true);
                    } else {
                        qOSModuleConfig.setEngageGlobally(false);
                    }
                    qOSModuleConfig.setClassLoader(this.getClass().getClassLoader());
                    arrayList.add(qOSModuleConfig);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.discoverAxisModules", "597", this);
            Object[] objectArray = new Object[]{exception};
            String string4 = NLSProvider.getNLS().getFormattedMessage("searchModConfFail00", objectArray, "Error occurred while attempting to discover the module configuration files: {0}");
            Tr.error(_tc, "searchModConfFail00", objectArray);
            throw new Exception(string4);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "discoverAxisModules");
            }
        }
    }

    private static void setAxisModuleName(AxisModule axisModule, OMElement oMElement) {
        OMAttribute oMAttribute = oMElement.getAttribute(new QName("name"));
        if (oMAttribute != null) {
            axisModule.setName(new QName(oMAttribute.getAttributeValue()));
        }
    }

    private void addModule(AxisModule axisModule, AxisConfiguration axisConfiguration, QOSModuleConfig qOSModuleConfig) throws AxisFault {
        Flow flow = axisModule.getInFlow();
        ClassLoader classLoader = axisModule.getModuleClassLoader();
        try {
            Flow flow2;
            Flow flow3;
            Flow flow4;
            if (flow != null) {
                Utils.addFlowHandlers(flow, classLoader);
            }
            if ((flow4 = axisModule.getOutFlow()) != null) {
                Utils.addFlowHandlers(flow4, classLoader);
            }
            if ((flow3 = axisModule.getFaultInFlow()) != null) {
                Utils.addFlowHandlers(flow3, classLoader);
            }
            if ((flow2 = axisModule.getFaultOutFlow()) != null) {
                Utils.addFlowHandlers(flow2, classLoader);
            }
            axisConfiguration.addModule(axisModule);
            if (qOSModuleConfig.isEngagedGlobally()) {
                axisConfiguration.engageModule(axisModule, axisConfiguration);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "QOS engaged globally: " + axisModule.getName().toString());
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "QOS found but not engaged globally: " + axisModule.getName().toString());
            }
        }
        catch (AxisFault axisFault) {
            FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.addModule", "588", this);
            Object[] objectArray = new Object[]{axisFault};
            Tr.error(_tc, "addAxisModFail00", objectArray);
            throw axisFault;
        }
    }

    private void engageModules(AxisConfiguration axisConfiguration) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "engageModules");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "About to engage global modules...");
        }
        this.de.engageModules();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "The following modules were engaged globally:");
            for (QName qName : axisConfiguration.getEngagedModules()) {
                Tr.debug(_tc, "   " + qName.toString());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "engageModules");
        }
    }

    private void initModules(AxisConfiguration axisConfiguration, ConfigurationContext configurationContext) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initModules");
        }
        Object[] objectArray = axisConfiguration.getModules().keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            QName qName = (QName)objectArray[i];
            AxisModule axisModule = axisConfiguration.getModule(qName);
            Module module = axisModule.getModule();
            if (module == null) continue;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "About to init module: " + axisModule.getName().toString());
            }
            module.init(configurationContext, axisModule);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initModules");
        }
    }

    private void loadAxisModules(ArrayList arrayList, AxisConfiguration axisConfiguration) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadAxisModules");
        }
        InputStream inputStream = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            QOSModuleConfig qOSModuleConfig = (QOSModuleConfig)arrayList.get(i);
            URL uRL = qOSModuleConfig.getURL();
            if (uRL != null) {
                Object object;
                try {
                    inputStream = uRL.openStream();
                    AxisModule axisModule = new AxisModule();
                    axisModule.setModuleClassLoader(qOSModuleConfig.getClassLoader());
                    object = new ModuleBuilder(inputStream, axisModule, axisConfiguration);
                    WASAxis2ConfigurationBuilder.setAxisModuleName(axisModule, ((DescriptionBuilder)object).buildOM());
                    object = null;
                    inputStream.close();
                    inputStream = uRL.openStream();
                    ModuleBuilder moduleBuilder = new ModuleBuilder(inputStream, axisModule, axisConfiguration);
                    moduleBuilder.populateModule();
                    this.addModule(axisModule, axisConfiguration, qOSModuleConfig);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.loadAxisModules", "684", this);
                    object = new Object[]{exception};
                    Tr.error(_tc, "loadModConfFileFail00", object);
                }
                continue;
            }
            Tr.warning(_tc, "badUrlModLoadFail00");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadAxisModules");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverTCMPlugins(String string, ArrayList arrayList) throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "discoverTCMPlugins, epid=" + string);
        }
        try {
            IExtension[] iExtensionArray = PluginUtils.getDeclaredExtensions(string);
            if (iExtensionArray != null) {
                for (int i = 0; i < iExtensionArray.length; ++i) {
                    IConfigurationElement[] iConfigurationElementArray = iExtensionArray[i].getConfigurationElements();
                    for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                        Object object;
                        Object[] objectArray;
                        if (!iConfigurationElementArray[j].getName().equals("plugin")) continue;
                        final IConfigurationElement iConfigurationElement = iConfigurationElementArray[j];
                        Object object2 = AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                try {
                                    return iConfigurationElement.createExecutableExtension("class");
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.discoverTCMPlugins", "829", this);
                                    Object[] objectArray = new Object[]{exception};
                                    Tr.error(_tc, "threadContextMigratorFail00", objectArray);
                                    return null;
                                }
                            }
                        });
                        String string2 = iConfigurationElementArray[j].getAttribute("id");
                        if (string2 == null || string2.equals("")) {
                            objectArray = NLSProvider.getNLS().getFormattedMessage("tcmExtNoValue00", new Object[0], "The [id] attribute of the plugin element for the ''ThreadContextMigrator'' extension has no value.");
                            throw new DeploymentException((String)objectArray);
                        }
                        if (object2 instanceof ThreadContextMigrator) {
                            objectArray = (ThreadContextMigrator)object2;
                            object = new TCMPluginConfig((ThreadContextMigrator)objectArray, string2);
                            arrayList.add(object);
                            continue;
                        }
                        objectArray = new Object[]{iConfigurationElementArray[j].getAttribute("class")};
                        object = NLSProvider.getNLS().getFormattedMessage("invalidTCMInterface00", objectArray, "Invalid class {0} did not implement the ThreadContextMigrator interface.");
                        throw new DeploymentException((String)object);
                    }
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.discoverTCMPlugins", "872", this);
            Object[] objectArray = new Object[]{exception};
            Tr.error(_tc, "threadContextMigratorFail00", objectArray);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "discoverTCMPlugins, epid=" + string);
            }
        }
    }

    private void registerTCMPlugins(ArrayList arrayList, ConfigurationContext configurationContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "registerTCMPlugins");
        }
        if (!arrayList.isEmpty()) {
            for (TCMPluginConfig tCMPluginConfig : arrayList) {
                ThreadContextMigratorUtil.addThreadContextMigrator(configurationContext, tCMPluginConfig.getPluginID(), tCMPluginConfig.getMigrator());
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "The ThreadContextMigrator: " + tCMPluginConfig.getMigrator().getClass() + " has been registered with the ConfigurationContext");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "registerTCMPlugins");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverACMPlugins(String string, ArrayList arrayList) throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "discoverACMPlugins, epid=" + string);
        }
        try {
            IExtension[] iExtensionArray = PluginUtils.getDeclaredExtensions(string);
            if (iExtensionArray != null) {
                for (int i = 0; i < iExtensionArray.length; ++i) {
                    IConfigurationElement[] iConfigurationElementArray = iExtensionArray[i].getConfigurationElements();
                    for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                        Object object;
                        Object[] objectArray;
                        if (!iConfigurationElementArray[j].getName().equals("plugin")) continue;
                        final IConfigurationElement iConfigurationElement = iConfigurationElementArray[j];
                        Object object2 = AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                try {
                                    return iConfigurationElement.createExecutableExtension("class");
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.discoverACMPlugins", "941", this);
                                    Object[] objectArray = new Object[]{exception};
                                    Tr.error(_tc, "applicationContextMigratorFail00", objectArray);
                                    return null;
                                }
                            }
                        });
                        String string2 = iConfigurationElementArray[j].getAttribute("id");
                        if (string2 == null || string2.equals("")) {
                            objectArray = NLSProvider.getNLS().getFormattedMessage("acmExtNoValue00", new Object[0], "The [id] attribute of the plugin element for the ''ApplicationContextMigrator'' extension has no value.");
                            throw new DeploymentException((String)objectArray);
                        }
                        if (object2 instanceof ApplicationContextMigrator) {
                            objectArray = (ApplicationContextMigrator)object2;
                            object = new ACMPluginConfig((ApplicationContextMigrator)objectArray, string2);
                            arrayList.add(object);
                            continue;
                        }
                        objectArray = new Object[]{iConfigurationElementArray[j].getAttribute("class")};
                        object = NLSProvider.getNLS().getFormattedMessage("invalidACMInterface00", objectArray, "Invalid class {0} did not implement the ApplicationContextMigrator interface.");
                        throw new DeploymentException((String)object);
                    }
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.discoverACMPlugins", "992", this);
            Object[] objectArray = new Object[]{exception};
            Tr.error(_tc, "applicationContextMigratorFail00", objectArray);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "discoverACMPlugins, epid=" + string);
            }
        }
    }

    private void registerACMPlugins(ArrayList arrayList, ConfigurationContext configurationContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "registerACMPlugins");
        }
        if (!arrayList.isEmpty()) {
            for (ACMPluginConfig aCMPluginConfig : arrayList) {
                ApplicationContextMigratorUtil.addApplicationContextMigrator(configurationContext, aCMPluginConfig.getPluginID(), aCMPluginConfig.getMigrator());
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "The ApplicationContextMigrator: " + aCMPluginConfig.getMigrator().getClass() + " has been registered with the ConfigurationContext");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "registerACMPlugins");
        }
    }
}

