/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.FileExplorerUtils;
import com.ibm.ws.websvcs.deployment.ModuleFileExplorer;
import com.ibm.ws.websvcs.deployment.ModuleFileLocator;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WARFileExplorer
extends ModuleFileExplorer
implements FileExplorer,
Constants {
    private static final TraceComponent _tc = Tr.register(WARFileExplorer.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private WARFile warFile;
    private boolean wasOpened = false;
    private List<Archive> archiveList;
    private List<String> classesFound;
    private String appName;

    public WARFileExplorer(WARFile wARFile) {
        this.warFile = wARFile;
        this.archiveList = new ArrayList<Archive>();
        this.classesFound = new LinkedList<String>();
        this.appName = Axis2Utils.getApplicationName(wARFile);
    }

    @Override
    public List<FileLocator> explore() {
        Object object;
        ArrayList<FileLocator> arrayList = new ArrayList<FileLocator>();
        if (!FileExplorerUtils.isExtracted(this.warFile)) {
            object = this.warFile;
            this.warFile = (WARFile)FileExplorerUtils.extractModuleFile(this.warFile, this);
            if (this.warFile == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "A null WARFile was returned after extracting... resetting to original WARFile object");
                }
                this.warFile = object;
            } else {
                this.wasOpened = true;
            }
        }
        object = this.warFile.getFiles();
        Iterator iterator = object.iterator();
        LinkedList<Archive> linkedList = new LinkedList<Archive>();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (file.isArchive() && file.getName().contains(".jar") && file.getDirectoryURI().contains("WEB-INF/lib")) {
                linkedList.add((Archive)file);
                continue;
            }
            String object2 = this.getQualifiedClassName(file.getURI());
            if (object2 != null) {
                this.classesFound.add(object2);
            }
            super.queryFile(file, "WEB-INF/classes", arrayList);
        }
        for (Archive archive : linkedList) {
            this.exploreJar(archive, arrayList);
        }
        return arrayList;
    }

    String getQualifiedClassName(String string) {
        if (string.startsWith("WEB-INF/classes")) {
            int n = "WEB-INF/classes".length() + 1;
            if (string.length() > n) {
                string = string.substring(n, string.length());
            }
        }
        return string;
    }

    private void exploreJar(Archive archive, List<FileLocator> list) {
        List list2 = archive.getLoadStrategy().collectFiles();
        this.archiveList.add(archive);
        for (File file : list2) {
            String string = file.getURI();
            if (string.length() <= 6 || !string.endsWith(".class")) continue;
            if (!this.classesFound.contains(string)) {
                ModuleFileLocator moduleFileLocator = new ModuleFileLocator(file, string, this.warFile.getName());
                list.add(moduleFileLocator);
                continue;
            }
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "The class file: " + string + " in the " + archive.getName() + " archive within the " + this.warFile.getName() + " WAR was already found " + "in the WEB-INF/classes directory and will not be read from the archive");
        }
    }

    @Override
    public void cleanUp() {
        if (this.wasOpened) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Closing WAR file: " + this.warFile.getName());
            }
            this.warFile.close();
            for (Archive archive : this.archiveList) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Closing nested archive: " + archive.getName());
                }
                archive.close();
            }
            Axis2Utils.deleteExtractedApp(this.appName, this.warFile.getName());
        }
    }

    public class WARSaveFilter
    implements SaveFilter {
        public boolean shouldSave(String string, Archive archive) {
            if (string.endsWith(".class")) {
                return true;
            }
            if (string.endsWith(".jar")) {
                return true;
            }
            return string.endsWith(".xml");
        }
    }
}

