/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.deploy.CacheRootDirectoryTLS;
import com.ibm.ws.websvcs.deployment.EJBJARFileExplorer;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.WARFileExplorer;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.io.File;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;

public class FileExplorerUtils {
    private static final TraceComponent _tc = Tr.register(FileExplorerUtils.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    public static final String APP_EXTRACT_DIR = "installExtract";

    public static CommonarchiveFactory getCommonArchiveFactory() {
        CommonarchiveFactory commonarchiveFactory = null;
        try {
            commonarchiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("commonarchive.xmi").getEFactoryInstance();
            return commonarchiveFactory;
        }
        catch (Throwable throwable) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Could not get CommonarchiveFactory using registry due to the error: " + throwable.toString() + ". Using known archive factory");
            }
            commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            return commonarchiveFactory;
        }
    }

    public static boolean isExtracted(ModuleFile moduleFile) {
        if (moduleFile.getLoadStrategy().isDirectory()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The module file: " + moduleFile.getName() + " has been " + "extracted to the installed apps directory");
            }
            return true;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "The module file: " + moduleFile.getName() + " has not been " + "extracted to the installed apps directory");
        }
        return false;
    }

    public static synchronized ModuleFile extractModuleFile(ModuleFile moduleFile, FileExplorer fileExplorer) {
        String string = FileExplorerUtils.getExtractLocation(moduleFile);
        boolean bl = false;
        SaveFilter saveFilter = moduleFile.getSaveFilter();
        if (string != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Temporarily extracting module file: " + moduleFile.getName() + " to " + "location: " + string + " to create FileLocators.");
            }
            try {
                Object object;
                if (fileExplorer instanceof WARFileExplorer) {
                    object = (WARFileExplorer)fileExplorer;
                    moduleFile.setSaveFilter(new WARFileExplorer.WARSaveFilter((WARFileExplorer)object));
                    bl = true;
                } else if (fileExplorer instanceof EJBJARFileExplorer) {
                    object = (EJBJARFileExplorer)fileExplorer;
                    moduleFile.setSaveFilter((EJBJARFileExplorer)object.new EJBJARFileExplorer.EJBSaveFilter());
                }
                object = new File(string);
                if (((File)object).isDirectory()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Module: " + moduleFile.getName() + " has already been " + "extracted to the temp workspace... opening from that location");
                    }
                    CommonarchiveFactory commonarchiveFactory = FileExplorerUtils.getCommonArchiveFactory();
                    ArchiveOptions archiveOptions = new ArchiveOptions();
                    archiveOptions.setUseJavaReflection(true);
                    archiveOptions.setIsReadOnly(true);
                    moduleFile.setSaveFilter(saveFilter);
                    if (bl) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Opening WAR file: " + moduleFile.getName());
                        }
                        moduleFile = commonarchiveFactory.openWARFile(archiveOptions, string);
                    } else {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Opening EJB JAR file: " + moduleFile.getName());
                        }
                        moduleFile = commonarchiveFactory.openEJBJarFile(archiveOptions, string);
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Module: " + moduleFile.getName() + " has not been " + "extracted to the temp workspace... extracting then opening " + "from that location");
                    }
                    moduleFile.extractTo(string, 0);
                    CommonarchiveFactory commonarchiveFactory = FileExplorerUtils.getCommonArchiveFactory();
                    ArchiveOptions archiveOptions = new ArchiveOptions();
                    archiveOptions.setUseJavaReflection(true);
                    archiveOptions.setIsReadOnly(true);
                    moduleFile.setSaveFilter(saveFilter);
                    if (bl) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Opening WAR file: " + moduleFile.getName());
                        }
                        moduleFile = commonarchiveFactory.openWARFile(archiveOptions, string);
                    } else {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Opening EBJ JAR file: " + moduleFile.getName());
                        }
                        moduleFile = commonarchiveFactory.openEJBJarFile(archiveOptions, string);
                    }
                }
                return moduleFile;
            }
            catch (Throwable throwable) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Module file: " + moduleFile.getName() + " could not be extracted " + "to temporary location to create FileLocators: " + throwable.toString());
                }
                return null;
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Module file: " + moduleFile.getName() + " needed to be extracted " + "to temporary location but the temporary location could not be found");
        }
        return null;
    }

    private static String getExtractLocation(ModuleFile moduleFile) {
        String string = File.separator;
        String string2 = null;
        string2 = CacheRootDirectoryTLS.get() == null ? Axis2Utils.getCacheDirectory() + Axis2Utils.getApplicationName(moduleFile) + string + moduleFile.getName() : CacheRootDirectoryTLS.get();
        string2 = string2 + string + APP_EXTRACT_DIR + string;
        string2 = moduleFile.getContainer() != null ? string2 + moduleFile.getContainer().getName() + string + moduleFile.getName() + string : string2 + moduleFile.getName() + string;
        return string2;
    }
}

