/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.deployment.EJBJARFileExplorer;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.WARFileExplorer;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;

public class FileExplorerFactory
implements Constants {
    private static final TraceComponent _tc = Tr.register(FileExplorerFactory.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public static FileExplorer getFileExplorer(ModuleFile moduleFile) {
        if (moduleFile.isWARFile()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Retrieving a WARFileExplorer for module: " + moduleFile.getName());
            }
            return new WARFileExplorer((WARFile)moduleFile);
        }
        if (moduleFile.isEJBJarFile()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Retrieving an EJBJARFileExplorer for module: " + moduleFile.getName());
            }
            return new EJBJARFileExplorer((EJBJarFile)moduleFile);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "No FileExplorer for module: " + moduleFile.getName());
        }
        return null;
    }
}

