/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.FileExplorerUtils;
import com.ibm.ws.websvcs.deployment.ModuleFileExplorer;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBJARFileExplorer
extends ModuleFileExplorer
implements FileExplorer,
Constants {
    private static final TraceComponent _tc = Tr.register(EJBJARFileExplorer.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private EJBJarFile ejbJar;
    private boolean wasOpened = false;
    private String appName;

    public EJBJARFileExplorer(EJBJarFile eJBJarFile) {
        this.ejbJar = eJBJarFile;
        this.appName = Axis2Utils.getApplicationName(eJBJarFile);
    }

    @Override
    public List<FileLocator> explore() {
        Object object;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "explore");
        }
        ArrayList<FileLocator> arrayList = new ArrayList<FileLocator>();
        if (!FileExplorerUtils.isExtracted(this.ejbJar)) {
            object = this.ejbJar;
            this.ejbJar = (EJBJarFile)FileExplorerUtils.extractModuleFile(this.ejbJar, this);
            if (this.ejbJar == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "A null EJBJarFile was returned after extracting... resetting to original EJBJarFile object");
                }
                this.ejbJar = object;
            } else {
                this.wasOpened = true;
            }
        }
        object = this.ejbJar.getFiles();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (file.isArchive()) continue;
            super.queryFile(file, null, arrayList);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "explore");
        }
        return arrayList;
    }

    @Override
    public void cleanUp() {
        if (this.wasOpened) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Closing EJB Jar: " + this.ejbJar.getName());
            }
            this.ejbJar.close();
            Axis2Utils.deleteExtractedApp(this.appName, this.ejbJar.getName());
        }
    }

    public class EJBSaveFilter
    implements SaveFilter {
        public boolean shouldSave(String string, Archive archive) {
            if (string.endsWith(".class")) {
                return true;
            }
            return string.endsWith(".xml");
        }
    }
}

